<?php
/*
Plugin Name: Feedback Champuru
Version: 0.1.3
Plugin URI: 
Description: Champuru!
Author: wokamoto
Author URI: http://dogmap.jp/
Text Domain: feedback-champuru
Domain Path: /languages/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2010 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

//**********************************************************************************
// Feedback Champuru
//**********************************************************************************
class FeedbackChampuru {
	private $plugin_name   = 'feedback-champuru';
	private $plugin_ver    = '0.1.3';

	private $topsy_api     = 'http://otter.topsy.com/trackbacks.json?url=%s&tracktype=tweet&perpage=50';
	private $hatena_api    = 'http://b.hatena.ne.jp/entry/json/?url=%s';
	private $delicious_api = 'http://feeds.delicious.com/v2/json/url/%s';

	private $cache_expired = 30;			// Request cache expired (minutes)
	private $comment_type  = '';

	private $feedbacks     = array('tweet', 'hatena', 'delicious');

	private $comment_id    = 0;

	/**********************************************************
	* Constructor
	***********************************************************/
	public function __construct() {
		$this->feedbacks = apply_filters('feedback-champuru/feedback_types', $this->feedbacks);

		add_filter('comments_array', array(&$this, 'comments_champuru'), 10, 2);
		add_filter('get_comments_number', array(&$this, 'get_comments_number'), 10, 2);
		add_filter('comment_class', array(&$this, 'comment_class'), 10, 4);
		add_filter('get_avatar', array(&$this, 'get_avatar'), 10, 5);
		add_filter('comment_reply_link', array(&$this, 'comment_reply_link'), 10, 4);

		add_filter('post_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('page_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('tag_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('category_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('preview_post_link', array(&$this, 'percent_encode_capital_letter'));
		add_filter('get_the_guid', array(&$this, 'percent_encode_capital_letter'));
	}

	// Get post_meta
	private function _get_post_meta($post_id, $key) {
		return maybe_unserialize(get_post_meta($post_id, $key, true));
	}

	// Add or Update post_meta
	private function _update_post_meta($post_id, $key, $val) {
		if (is_array($val))
			$val = maybe_serialize($val);
		return (
			add_post_meta($post_id, $key, $val, true) or
			update_post_meta($post_id, $key, $val)
			);
	}

	/**********************************************************
	* Champuru!
	***********************************************************/
	public function comments_champuru($comments, $post_id){
		$permalink = get_permalink($post_id);
		foreach ($this->feedbacks as $type) {
			$comments = array_merge($comments ,	$this->_get_feedback($type, $post_id, $permalink));
		}
		usort($comments, array($this, '_comments_cmp'));

		return $comments;
	}

	private function _comments_cmp($a, $b){
	    if ($a->comment_date == $b->comment_date)
	        return 0;
	    return (strtotime($a->comment_date) < strtotime($b->comment_date)) ? -1 : 1;
	}

	public function comment_build($type, $post_id, $author = '', $author_url = '', $datetime = 0, $content = '', $photo_url = ''){
		return (object) array(
			"comment_ID" => $type . '-' . $this->comment_id++ ,
			"comment_post_ID" => (string) $post_id ,
			"comment_author" => $author ,
			"comment_author_email" => $photo_url ,
			"comment_author_url" => $author_url ,
			"comment_author_IP" => "" ,
			"comment_date" => date('Y-m-d H:i:s', $datetime) ,
			"comment_date_gmt" => gmdate('Y-m-d H:i:s', $datetime) ,
			"comment_content" => $content ,
			"comment_karma" => "0" ,
			"comment_approved" => "1" ,
			"comment_agent" => "" ,
			"comment_type" => apply_filters('feedback-champuru/comment_type', $this->comment_type, $type) ,
			"comment_parent" => "0" ,
			"user_id" => "0" ,
			);
	}

	public function percent_encode_capital_letter($uri) {
		return preg_replace_callback('/(%[0-9a-f]{2}?)+/', create_function('$matches','return strtoupper($matches[0]);'), $uri);
	}

	private function _get_feedback($type, $post_id, $permalink){
		$comments_array = array();
		$permalink = $this->percent_encode_capital_letter($permalink);

		switch ($type){
		case 'tweet':
			$comments_array = $this->_get_topsy($type, $post_id, $permalink);
			break;
		case 'hatena':
			$comments_array = $this->_get_hatena($type, $post_id, $permalink);
			break;
		case 'delicious':
			$comments_array = $this->_get_delicious($type, $post_id, $permalink);
			break;
		default:
			$comments_array = apply_filters('feedback-champuru/get_feedback', $comments_array, $type, $post_id, $permalink);
			break;
		}

		return apply_filters('feedback-champuru/comments_array', $comments_array, $type);
	}

	private function _get_topsy($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->topsy_api, urlencode($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			$list = (isset($json->response) ? $json->response->list : array());
			foreach ((array) $list as $item){
//				$author     = esc_attr($item->author->name);
				$author     = preg_replace('/^http:\/\/topsy\.com\/twitter\/([^\?]*)\?.*$/i', '$1', esc_attr($item->author->topsy_author_url));
//				$author_url = esc_attr((isset($item->author->url) && !empty($item->author->url)) ? $item->author->url : 'http://twitter.com/' . $author);
				$author_url = esc_attr('http://topsy.com/' . str_replace('http://', '', $permalink));
				$datetime   = (int) $item->date;
				$content    = esc_attr($item->content);
				$photo_url  = esc_attr($item->author->photo_url);

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	private function _get_hatena($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->hatena_api, urlencode($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			$list = (isset($json->bookmarks) ? $json->bookmarks : array());
			foreach ((array) $list as $item){
				$author     = esc_attr($item->user);
//				$author_url = 'http://b.hatena.ne.jp/' . $author;
				$author_url = esc_attr('http://b.hatena.ne.jp/entry/' . str_replace('http://', '', $permalink));
				$datetime   = strtotime(str_replace('/', '-', $item->timestamp));
				$content    = esc_attr($item->comment);
				$photo_url  = 'http://www.hatena.ne.jp/users/' . substr($author, 0, 2) . '/' . $author . '/profile_l.gif';

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	private function _get_delicious($type, $post_id, $permalink){
		$cache = $this->_get_post_meta($post_id, '_feedback_'.$type);
		if ( isset($cache["expired"]) && $cache["expired"] > time() )
			return $cache["comments"];
		if ( !is_singular() )
			return ( isset($cache["comments"]) ? $cache["comments"] : array() );

		$comments = array();
		$ret = wp_remote_get(sprintf($this->delicious_api, md5($permalink)));
		if (is_array($ret) && isset($ret["body"]) && !empty($ret["body"])){
			$json = json_decode($ret["body"]);
			foreach ((array) $json as $item){
				$author     = esc_attr($item->a);
//				$author_url = 'http://delicious.com/'.$author;
				$author_url = esc_attr('http://delicious.com/url/' . md5($permalink));
				$datetime   = strtotime($item->dt);
				$content    = esc_attr($item->n);
				$photo_url  = '';

				$content    = apply_filters('feedback-champuru/content', $content, $type, $author, $author_url, $datetime, $photo_url, $item);

				if ( $content )
					$comments[] = $this->comment_build($type, $post_id, $author, $author_url, $datetime, $content, $photo_url);
			}
		}
		$comments = (count($comments) > 0 ? $comments : (isset($cache["comments"]) ? $cache["comments"] : $comments));

		$cache = array(
			"expired" => time() + apply_filters('feedback-champuru/cache_expired', $this->cache_expired * 60) ,
			"comments" => $comments ,
			);
		$this->_update_post_meta($post_id, '_feedback_'.$type, $cache );

		return $comments;
	}

	/**********************************************************
	* get comments number
	***********************************************************/
	public function get_comments_number($count, $post_id = ''){
		$comments = $this->comments_champuru(array(), $post_id);
		return $count + count($comments);
	}

	/**********************************************************
	* comment class
	***********************************************************/
	public function comment_class($classes, $class = '', $comment_id = '', $post_id = ''){
		$comment_id = (is_null($comment_id) || empty($comment_id))
			? get_comment_ID()
			: (!is_null($comment_id) ? $comment_id : '');

		if (!empty($comment_id) && !preg_match('/^[\d]+$/', $comment_id))
			$classes[] = esc_attr(preg_replace('/^([^\-]*)\-[\d]+$/', '$1', $comment_id));
		return $classes;
	}

	/**********************************************************
	* get avatar
	***********************************************************/
	public function get_avatar($avatar, $id_or_email = '', $size = '96', $default = '', $alt = false){
		global $pagenow, $comment;

		if($pagenow == 'options-discussion.php')
			return $avatar;
		if (!isset($comment))
			return $avatar;

		$type_pattern = '/^('.implode('|',$this->feedbacks).')\-/i';
		if (preg_match('/^http:\/\//i', $comment->comment_author_email)) {
			$img_src = $comment->comment_author_email;
		} elseif (preg_match($type_pattern, $comment->comment_ID, $matches)) {
			$img_src = site_url(str_replace(ABSPATH, '', dirname(__FILE__))) . '/images/' .
				$matches[1] . ( $size <= 24 ? '_16.png' : '_32.png' );
		} else {
			$img_src = '';
		}

		if (!empty($img_src)) {
			$avatar = preg_replace(
				  '/^(.*<img [^>]* src=[\'"])http:\/\/[^\'"]+([\'"][^>]*\/>.*)$/i'
				, "$1{$img_src}$2"
				, $avatar);
		}

		return $avatar;
	}

	/**********************************************************
	* comment reply link
	***********************************************************/
	public function comment_reply_link($link, $args = '', $comment = '', $post = ''){
		return (preg_match('/^[\d]+$/', $comment->comment_ID) ? $link : '');
	}
}

new FeedbackChampuru();
?>
