<?php
load_theme_textdomain('spanner', dirname(__FILE__));

if (! defined('KTAI_ADMIN_MODE')) {
	add_filter('ktai_raw_content', 'ks_convert_kana');
}

define ('KTAI_ALWAYS_RELAY_PAGE', true);

function spanner_kill_wp_logo($logo, $ext) {
	return '';
}
add_filter('ktai_login_logo', 'spanner_kill_wp_logo', 10, 2);
add_filter('ktai_die_logo', 'spanner_kill_wp_logo', 10, 2);

function ks_image_link_default($image_inline) {
	return false;
}
add_filter('ktai_image_inline_setting', 'ks_image_link_default');

function spanner_image_to_link($html, $orig, $src) {
	$html = preg_replace('/^\[/', '&lt;', $html);
	$html = preg_replace('/\]$/', '&gt;', $html);
	$html = str_replace('<img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" />', __('IMAGE:', 'ktai_style'), $html);
	return $html;
}
add_filter('ktai_image_to_link', 'spanner_image_to_link', 10, 3);

function spanner_posts_nav_link($before = '<div>', $after = '</div>') {
	if (is_single() || is_page() || is_attachment()) {
		return;
	}
	global $wp_query;
	$max_num_pages = $wp_query->max_num_pages;
	$paged = get_query_var('paged') ? get_query_var('paged') : 1;
	$sep = '<br />';

	//only have sep if there's both prev and next results

	$per_page = get_option('posts_per_page');
	$sep = preg_replace('/&([^#])(?![a-z]{1,8};)/', '&amp;$1', $sep);

	if ( $max_num_pages > 1 ) {
		$leftover = $wp_query->found_posts % $per_page;
		if ($leftover < 1) {
			$leftover = $per_page;
		}
		echo $before;
		if ($paged == $max_num_pages -1) {
			ks_pict_number(9, true);
 			ks_next_posts_link(sprintf(__ngettext('Next %d post', 'Next %d posts', $leftover, 'spanner'), $leftover), '9');
		} elseif ($paged < $max_num_pages -1) {
			ks_pict_number(9, true);
 			ks_next_posts_link(sprintf(__ngettext('Next %d post', 'Next %d posts', $leftover, 'spanner'), $per_page), '9');
		}
		if ($paged <= $max_num_pages -1 && $paged >= 2) {
			echo $sep;
		}
		if ($paged >= 2 && $paged <= $max_num_pages) {
			ks_pict_number(7, true);
			ks_previous_posts_link(sprintf(__ngettext('Prev %d post', 'Prev %d posts', $per_page, 'spanner'), $per_page), '7');
		}
		if ($paged >= 3) {
			echo $sep . ks_pict_number(0),
		 '<a href="' . KtaiStyle::strip_host(clean_url(get_pagenum_link(1))) . '" accesskey="0">',
			sprintf(__ngettext('First %d post', 'First %d posts', $per_page, 'spanner'), $per_page),
			'</a>';
		}
		if ($paged < $max_num_pages -1) {
			echo $sep . ks_pict_number(8), '<a href="' . KtaiStyle::strip_host(clean_url(get_pagenum_link($max_num_pages))) . '" accesskey="8">',
			sprintf(__ngettext('Last %d post', 'Last %d posts', $leftover, 'spanner'), $leftover), 
			'</a>';
		}		
		echo $after;
	}
	return;
}

function spanner_category() {
	$categories = get_the_category();
	if (count($categories)) {
		$cat_links = array();
		foreach ($categories as $c) {
			$cat_links[] = attribute_escape($c->cat_name);
		}
		echo implode(', ', $cat_links);
	}
	return;
}

function spanner_split_page_navi($navi, $prev, $num, $next) {
	$prev = preg_replace('!>(.*?)</a> \| $!', '>' . ($num -1) . '</a>', $prev);
	$next = preg_replace('!^ \| <a(.*?)>(.*?)</a>!', '<a$1>' . ($num +1) . '</a>', $next);
	return sprintf(__('&lt;Move page: %1$s %2$d %3$s &gt;', 'spanner'), $prev, $num, $next);
}
add_filter('ktai_split_page_navi', 'spanner_split_page_navi', 10, 4);
?>