<?php ks_header();
global $ks_settings, $wp_query, $paged;
if ( current_user_can( 'publish_posts' ) ) {
	require_once dirname( __FILE__ ) . '/post-form.php';
}
if (have_posts()) :
	$page_html = ($paged > 1) ? (' ' . sprintf(__('Page %s', 'p2'), $paged)) : '';
	?><h2><?php 
	if ( is_home() || is_front_page() ) {
		echo __('Recent Updates', 'p2'), $page_html;
	} elseif ( is_author() ) {
		printf(_c('Updates from %s|name', 'p2'), attribute_escape(ks_p2_get_archive_author()) );
	} elseif ( is_taxonomy('mentions') ) {
		printf(_c('Posts Mentioning %s|name', 'p2'), attribute_escape(ks_p2_get_mention_name()) );
	} else {
		printf(_c('Updates from %s|month', 'p2'), get_the_time(__('F, Y', 'p2')) );
	}
	?></h2>
<!--start paging[<hr />,]-->
	<dl>
	<?php for ($count = $ks_settings['ol_count']; have_posts() ; $count++) :
		the_post();
		?><hr /><?php
		include dirname(__FILE__) . '/entry.php';
		endfor; ?>
	</dl>
	<?php if ($wp_query->max_num_pages >= 2) : ?>
	<hr /><div align="center"><?php 
		ks_posts_nav_link(array(
			'prev_label' => __('&larr;&nbsp;Newer&nbsp;Posts', 'p2'),
			'next_label' => __('Older&nbsp;Posts&nbsp;&rarr;', 'p2'),
		));
		ks_posts_nav_dropdown(array('before' => '<br />', 'min_pages' => 3));
	?></div>
	<?php endif;
else: ?>
	<h2><?php _e('No posts found!', 'p2'); ?></h2>
<?php endif;
ks_footer(); ?>