<?php 
$need_password = ks_check_password(__('Enter your password to view comments.'));
if ($need_password && ! is_user_logged_in()) {
	echo (ks_is_comments_list() ? $need_password : '');
	return;
}

global $wp_query;
if (! ks_is_comment_post()) :
	if (count($comments)) : 
		?><dl><?php 
		wp_list_comments(array(
			'walker' => new KS_Walker_Comment, 
			'avatar_size' => KS_P2_AVATAR_SIZE, 
			'callback' => 'ks_comment_content',
			'end-callback' => 'ks_end_comment',
			'style' => 'dl',
		), $comments);
		?></dl><?php 
		if (get_option('page_comments') && $wp_query->max_num_comment_pages >= 2) {
			?><div align="center"><p><?php 
			previous_comments_link(__('<img localsrc="7" alt="&laquo; ">Older Comments', 'ktai_style') . '<br />');
			next_comments_link(__('Newer Comments<img localsrc="8" alt=" &raquo;">', 'ktai_style'));
			?></p></div><?php 
		}
	endif;
else:
	$login_url = ks_get_login_url(KTAI_NOT_ECHO, ks_comments_post_url());
	if (! comments_open()) { ?>
		<p><?php _e('Sorry, the comment form is closed at this time.'); ?></p>
	<?php } elseif ( get_option('comment_registration') && ! is_user_logged_in() ) {
		if ( $login_url ) { ?>
			<p><?php printf(__('You must be <a href="%s">logged in</a> to post a comment.'), attribute_escape($login_url) ); ?></p>
		<?php } else { ?>
			<p><?php _e("Can't post a comment from mobile phones. You must logged in from PC to make a comment.", 'ktai_style'); ?></p>
		<?php }
	} else {
		$replytocom = isset($_GET['replytocom']) ? abs(intval($_GET['replytocom'])) : NULL;
		if ($replytocom) {
			$comment = get_comment($replytocom);
			if (! $comment || $comment->comment_approved != 1) {
				return;
			}
			?><div><?php ks_comment_content(); ?></div><?php 
		} else {
			echo get_avatar(get_the_author_email(), KS_P2_AVATAR_SIZE);
			?><img localsrc="68" alt="" /><?php the_author(); ?><br />
			<img localsrc="46" alt="@ " /><font color="#666666"><?php ks_time(); ?></font>
			<div><?php ks_excerpt(); ?></div><?php 
		}
		global $ks_commentdata;
		if (isset($ks_commentdata['message']) && $ks_commentdata['message']) {
			$comment_author       = $ks_commentdata['author'];
			$comment_author_email = $ks_commentdata['email'];
			$comment_author_url   = $ks_commentdata['url'];
			$comment_content      = $ks_commentdata['content'];
			?><p><font color="red">
			<?php echo implode("<br />", array_map('wp_specialchars', explode("\n", $ks_commentdata['message']))); ?>
			</font></p> 
		<?php }
		ks_require_term_id_form(ks_plugin_url(KTAI_NOT_ECHO) . 'comments-post.php');
		ks_fix_encoding_form();
		_e('Reply', 'p2');
		if (ks_option('ks_allow_pictograms')) {
			_e('(Pictograms Available)', 'ktai_style');
		} ?><br />
		<textarea name="comment" cols="100%" rows="4"><?php echo wp_specialchars($comment_content); ?></textarea><br /><?php 
		if ( is_user_logged_in() ) {
			ks_session_id_form(); ?>
			<p><?php printf(__('Logged in as %s.', 'ktai_style'), wp_specialchars($user_identity));
			?> [<a href="<?php echo attribute_escape(ks_get_logout_url()); ?>"><?php _e('Log out &rarr;', 'p2'); ?></a>]<br /><?php
			if ( !ks_cookie_available() ) {
				?><small><?php _e('Note: Ater posting a comment, you are automatically logged out.', 'ktai_style'); ?></small><br /><?php 
			}
		} else {
			if ( $login_url ) {
				?><div align="right"><img localsrc="120" alt="" /><?php printf(__('<a href="%s">Log in</a> and post a comment.', 'ktai_style'), attribute_escape($login_url) ); ?></div><?php 
			} 
			?><p><?php _e('Name (required)', 'p2'); ?><br />
			<input type="text" name="author" value="<?php echo attribute_escape($comment_author); ?>" size="12" /><br />
			<?php _e('Email (required)', 'p2'); ?><br />
			<input type="text" name="email" istyle="3" mode="alphabet" value="<?php echo attribute_escape($comment_author_email); ?>" /><br />
			<?php _e('Web Site', 'p2'); ?><br />
			<input type="text" name="url" istyle="3" mode="alphabet" value="<?php echo attribute_escape($comment_author_url); ?>" /><br />
		<?php } // is_user_logged_in()
		ks_inline_error_submit(__('Post Comment', 'p2'));
		comment_id_fields();
		ks_do_comment_form_action(); ?>
		</p></form>
		<?php if (ks_is_required_term_id()) { ?>
			<div><?php _e('NOTE: If submit comments, your terminal ID will be sent.', 'ktai_style'); ?></div>
		<?php }
		if (! is_user_logged_in() && ks_cookie_available()) { ?>
			<div><?php _e('NOTE: Your name, e-mail and URL will be stored o your phone. (If cookie is ON)', 'ktai_style'); ?></div>
		<?php }
	} // comments_open, comment_registration
endif; // $need_password, ks_is_comments_list, ks_is_comments_post