<?php 
load_theme_textdomain('monobook', dirname(__FILE__));

define ('MONOBOOK_TAB', '<table border="1" style="margin:0.5em 6px -1px 6px;"><tr style="margin:0;">');
define ('MONOBOOK_TAB_EACH', '<td style="background-color:white;font-size:smaller;border-color:gray;">');
define ('MONOBOOK_BOX', '<table border="1" style="width:98%%;"><tr><td style="background:%s;border-color:gray;" >');

function monobook_image_inline_tab($menu, $before, $after, $color) {
	return str_replace(__('Images:', 'ktai_style') . ' ', '', $menu);
}
add_filter('ktai_switch_inline_images', 'monobook_image_inline_tab', 10, 4);

function monobook_tab($tab) {
	if (! $tab) {
		return NULL;
	}
	if (is_string($tab)) {
		$tab = array($tab);
	}
	$tab_joined = implode('|' , $tab);
	if ( !ks_ext_css_available() || false !== strpos($tab_joined, '<form') ) {
		$output = MONOBOOK_TAB;
		foreach ($tab as $t) {
			if ($t) {
				$output .= MONOBOOK_TAB_EACH . $t . '</td>';
			}
		}
		$output .= '</tr></table>';
	} else {
		if (is_ktai() == 'KDDI') {
			$output = '<div class="tabsingle">' . $tab_joined . '</div>';
		} else {
			$output = '<div class="tab">';
			foreach ($tab as $t) {
				if ($t) {
					$output .= '<span>' . $t . '</span>';
				}
			}
			$output .= '</div>';
		}
	}
	return $output;
}

function monobook_box($echo = true, $tab = array()) {
	if (ks_ext_css_available()) {
		$output = monobook_tab($tab) . '<div class="box">';
	} else {
		$output = '<br />' . monobook_tab($tab) . sprintf(MONOBOOK_BOX, 'white');
	}
	if ($echo) {
		echo $output;
	}
	return $output;
}

function monobook_box_end($echo = true) {
	if (ks_ext_css_available()) {
		$output = '</div>';
	} else {
		$output = '</td></tr></table>';
	}
	if ($echo) {
		echo $output;
	}
	return $output;
}

function monobook_cbox($echo = true) {
	if (ks_ext_css_available()) {
		$output = '<div class="cbox">';
	} else {
		$output = '<br />' . sprintf(MONOBOOK_BOX, 'white');
	}
	if ($echo) {
		echo $output;
	}
	return $output;
}

function monobook_discussion($echo = true, $tab = array()) {
	if (ks_ext_css_available()) {
		$output = monobook_tab($tab) . '<div class="discussion">';
	} else {
		$output = '<br />' . monobook_tab($tab) . sprintf(MONOBOOK_BOX, '#f0f0ff');
	}
	if ($echo) {
		echo $output;
	}
	return $output;
}

function monobook_category($echo = true) {
	if (ks_ext_css_available()) {
		$output = '<div class="category">';
	} else {
		$output = '<br />' . sprintf(MONOBOOK_BOX, '#f8f8f8');
	}
	if ($echo) {
		echo $output;
	}
	return $output;
}

function monobook_comment_type_text() {
	$type = get_comment_type();
	switch( $type ) {
		case 'trackback' :
			return __( 'Trackback' );
		case 'pingback' :
			return __( 'Pingback' );
		default :
			return _x( 'Comment', 'noun' );
	}
}

function monobook_comments_number( $post, $zero = false, $one = false, $more = false, $secret = false ) {
	$number = apply_filters('get_comments_number', $post->comment_count);

	if ( post_password_required($post) ) {
		$output = __('Unknown comments', 'monobook');
	} elseif ( $number > 1 ) {
		$output = str_replace('%', number_format_i18n($number), ( false === $more ) ? __('% comments', 'ktai_style') : $more);
	} elseif ( $number == 0 ) {
		$output = ( false === $zero ) ? __('No comments', 'ktai_style') : $zero;
	} else { // must be one
		$output = ( false === $one ) ? __('1 comment', 'ktai_style') : $one;
	}
	return apply_filters('comments_number', $output, $number);
}
?>