<?php if (! ks_is_comments()) {
	return;
}

function ks_comment_content() {
	global $comment, $ks_settings;
	?><a name="comment-<?php comment_ID(); ?>"><?php 
	printf(__('%1$s posted by %2$s @ %3$s', 'monobook'), monobook_comment_type_text(), ks_comment_author_link(KTAI_NOT_ECHO), ks_get_comment_datetime());
	?></a>
	<?php edit_comment_link('<font color="' . $ks_settings['edit_color'] . '">' . __('Edit') . '</font>', '<img localsrc="104" alt="" />'); ?><br />
	<?php if ($comment->comment_approved == '0') { ?>
		<em><font color="red"><?php _e('Your comment is awaiting moderation.', 'ktai_style'); ?></font></em><br />
	<?php }
	comment_text();
}

function ks_list_comments($comment, $args, $depth) {
	global $ks_settings;
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);
	if ($depth > 1) {
		?><hr /><?php 
	}
	ks_comment_content();
	comment_reply_link(array_merge(
		array('before' => '<div>', 'after' => '</div>', 'reply_text' => '<img localsrc="149" alt="" />' . __('Reply'), 'login_text' => '<img localsrc="120" alt="" />' . __('Log in to Reply')), 
		$args, 
		array('depth' => $depth, 'max_depth' => $args['max_depth'])
	));
}

function ks_end_comments($comment, $args, $depth) {
}

global $ks_settings;
if (ks_is_comments_list()) :
	$tab = array(
		ks_back_to_post(array('icon' => '', 'label' => __('article', 'monobook'), 'echo' => false)), 
		strip_tags(ks_comments_link('icon=&echo=0')), 
		ks_comments_post_link('icon=&echo=0')
	);
	monobook_discussion(true, $tab);
	$need_password = ks_check_password(__('Enter your password to view comments.'));
	if ($need_password && ! $user_ID) {
		echo $need_password . '</div>';
		return;
	}
	?><h3 style="margin:0;"><?php 
	printf(__('Comments for <a href="%1$s"><span style="%2$s">%3$s</span></a>', 'ktai_style'), get_permalink(), 'color:black;' ,get_the_title());
	?></h3><hr />
	<?php $walker = function_exists('wp_list_comments') ? new KS_Walker_Comment : NULL;
	if (ks_option('ks_separate_comments') && ! get_option('page_comments')) {
		$sep_comments = ks_separete_comments($comments);
		$label = array('comment' => __('Comments'), 'pings' => __('Pings', 'ktai_style'));
	} else {
		$sep_comments[] = $comments;
		$label = array();
	}
	foreach ($sep_comments as $type => $_comments) :
		if (isset($label[$type])) {
			echo '<h3>' . $label[$type] . '</h3><hr />';
		}
		if (count($_comments)) :
			if ($walker) :
				wp_list_comments(array('walker' => $walker, 'callback' => 'ks_list_comments', 'end-callback' => 'ks_end_comments', 'style' => 'div', 'avatar_size' => 0), $_comments);
				if (get_option('page_comments')) :
					previous_comments_link(__('<img localsrc="7" alt="&laquo; ">Older Comments', 'ktai_style')); ?><br /><?php 
					next_comments_link(__('Newer Comments<img localsrc="8" alt=" &raquo;">', 'ktai_style'));
				endif; // can't use brace
			else : // $walker
				foreach ($_comments as $comment) : 
					?><a name="comment-<?php comment_ID(); ?>">
					<?php if (! ks_option('ks_separate_comments')) { ?>
						<font size="-1" color="<?php echo $ks_settings['comment_color']; ?>">[<?php 
						comment_type(__('Comment'), __('Trackback'), __('Pingback')); ?>]</font>
					<?php } ?>
					</a> <?php ks_comment_content();
				endforeach;
			endif; // $walker
		else : // If there are no comments yet
			echo ($type != 'pings') ? 
				__('No comments yet.') : 
				__('No pings yet.', 'ktai_style');
		endif;
	endforeach;
	monobook_box_end();
elseif (ks_is_comment_post()) :
	$tab = array(
		ks_back_to_post(array('icon' => '', 'label' => __('article', 'monobook'), 'echo' => false)), 
		ks_comments_link('icon=&echo=0'), 
		__('Post comments', 'ktai_style')
	);
	monobook_discussion(true, $tab);
	$need_password = ks_check_password(__('Enter your password to post a comment.', 'ktai_style'));
	if ($need_password && ! $user_ID) {
		echo $need_password . '</div>';
		return;
	}
	$login_url = ks_get_login_url(KTAI_NOT_ECHO, ks_comments_post_url());
	?><h3 style="margin:0;"><?php 
	printf(__('Comments for <a href="%1$s"><span style="%2$s">%3$s</span></a>', 'ktai_style'), get_permalink(), 'color:black;', get_the_title());
	?></h3><hr />
	<?php if (! comments_open()) {
		_e('Sorry, the comment form is closed at this time.');
	} elseif ( get_option('comment_registration') && ! $user_ID ) {
		if ( $login_url ) { 
			printf(__('You must be <a href="%s">logged in</a> to post a comment.'), attribute_escape($login_url) );
		} else { 
			_e("Can't post a comment from mobile phones. You must logged in from PC to make a comment.", 'ktai_style');
		}
	} else {
		$replytocom = isset($_GET['replytocom']) ? abs(intval($_GET['replytocom'])) : NULL;
		if ($replytocom) {
			$comment = get_comment($replytocom);
			if (! $comment || $comment->comment_approved != 1) {
				return;
			}
			ks_comment_content(); 
			m?><h3 style="margin:0;"><?php _e('Reply to the above comment', 'ktai_style'); ?></h3><?php 
		}
		global $ks_commentdata;
		if (isset($ks_commentdata['message']) && $ks_commentdata['message']) {
			$comment_author       = $ks_commentdata['author'];
			$comment_author_email = $ks_commentdata['email'];
			$comment_author_url   = $ks_commentdata['url'];
			$comment_content      = $ks_commentdata['content'];
			?><font color="red">
			<?php echo implode("<br />", array_map('wp_specialchars', explode("\n", $ks_commentdata['message']))); ?>
			</font>
		<?php }
		ks_require_term_id_form(ks_plugin_url(KTAI_NOT_ECHO) . 'comments-post.php');
		ks_fix_encoding_form();
		if ( $user_ID ) {
			ks_session_id_form(); ?>
			<p><?php printf(__('Logged in as %s.', 'ktai_style'), wp_specialchars($user_identity));
			?> [<a href="<?php echo attribute_escape(ks_get_logout_url()); ?>"><?php _e('Log out'); ?></a>]<br />
			<font size="-1"><?php _e('Note: Ater posting a comment, you are automatically logged out.', 'ktai_style'); ?></font><br />
		<?php } else {
			if ( $login_url) { ?>
				<div align="right"><img localsrc="120" alt="" /><?php printf(__('<a href="%s">Log in</a> and post a comment.', 'ktai_style'), attribute_escape($login_url) ); ?></div>
			<?php } ?>
			<p><?php _e('Name'); if ($req) _e('(required)'); ?><br />
			<input type="text" name="author" value="<?php echo attribute_escape($comment_author); ?>" size="12" /><br />
			<?php _e('Mail (will not be published)', 'ktai_style'); if ($req) _e('(required)'); ?><br />
			<input type="text" name="email" istyle="3" mode="alphabet" value="<?php echo attribute_escape($comment_author_email); ?>" /><br />
			<?php _e('Website'); ?><br />
			<input type="text" name="url" istyle="3" mode="alphabet" value="<?php echo attribute_escape($comment_author_url); ?>" /><br />
		<?php } // $user_ID
		_e('Comment', 'ktai_style');
		if (ks_option('ks_allow_pictograms')) {
			_e('(Pictograms Available)', 'ktai_style');
		} ?><br />
		<textarea name="comment" cols="100%" rows="4"><?php echo wp_specialchars($comment_content); ?></textarea><br />
		<?php ks_inline_error_submit(__('Say It!'));
		if (function_exists('comment_id_fields')) {
			comment_id_fields();
		} else { ?>
			<input type="hidden" name="comment_post_ID" value="<?php echo intval($id); ?>" />
		<?php } 
		ks_do_comment_form_action(); ?>
		</p></form>
		<?php if (ks_is_required_term_id()) { ?>
			<div><?php _e('NOTE: If submit comments, your terminal ID will be sent.', 'ktai_style'); ?></div>
		<?php }
		if (! $user_ID && ks_cookie_available()) { ?>
			<div><?php _e('NOTE: Your name, e-mail and URL will be stored o your phone. (If cookie is ON)', 'ktai_style'); ?></div>
		<?php }
		monobook_box_end();
	} // comments_open, comment_registration
endif; // $need_password, ks_is_comments_list, ks_is_comments_post