<?php
/* ==================================================
 *   KtaiStyle_Admin class
   ================================================== */

class KtaiStyle_Admin {
	public    $base;
	protected $sid;
	protected $next_id;
	protected $user_login;
	protected $user_agent;
	protected $term_ID;
	protected $sub_ID;
	protected $data;
	private $session_lifetime;
	private $session_renewtime;
	const SESSION_NAME = 'ksid';

function __construct() {
	global $Ktai_Style;
	$this->base = $Ktai_Style;
	$this->session_lifetime = $this->base->get('cookie_available') ? 86400 : 3600;
	$this->session_renewtime = $this->session_lifetime / 2;
	add_filter('get_edit_post_link', array($this, 'fix_edit_post_link'), 10, 3);
	add_filter('get_edit_comment_link', array($this, 'fix_edit_comment_link'));
}

/* ==================================================
 * @param	none
 * @return	string  $user_login
 */
public function get_current_user() {
	return $this->user_login;
}

/* ==================================================
 * @param	string  $key
 * @return	mix     $param
 */
public function get($key) {
	return isset($this->$key) ? $this->$key : NULL;
}

/* ==================================================
 * @param	string  $key;
 * @return	mix     $data
 */
public function get_data($key) {
	return isset($this->data[$key]) ? stripslashes($this->data[$key]) : NULL;
}

/* ==================================================
 * @param	string  $key
 * @param   mix     $value
 * @return	mix     $value
 */
public function set_data($key, $value) {
	return $this->data[$key] = $value;
}

/* ==================================================
 * @param	none
 * @return	mix     $result
 */
public function save_data() {
	global $wpdb;
	if (! $this->sid) {
		return false;
	}
	$result = $wpdb->update($wpdb->prefix . 'ktaisession', array('data' => serialize($this->data)), array('sid' => $this->sid));
	return $result;
}

/* ==================================================
 * @param	none
 * @return	string  $sid
 */
public function get_sid() {
	global $Ktai_Style;
	$sid = NULL;
	if ($Ktai_Style->get('cookie_available')) {
		$sid = isset($_COOKIE[self::SESSION_NAME]) ? $_COOKIE[self::SESSION_NAME] : NULL;
	} elseif (isset($_POST[self::SESSION_NAME])) {
		$sid = $_POST[self::SESSION_NAME];
	} elseif (isset($_GET[self::SESSION_NAME])) {
		$sid = $_GET[self::SESSION_NAME];
	}
	if (! is_string($sid) && ! is_numeric($sid)) {
		$sid = NULL;
	}
	return $sid;
}

/* ==================================================
 * @param	none
 * @return	string  $sid
 */
private function make_sid() {
	return str_replace(array('+', '/', '='), array('_', '.', ''), base64_encode(sha1(uniqid(mt_rand(), true), true)));
}

/* ==================================================
 * @param	string  $user_login
 * @param	string  $sid
 * @param	mix     $data
 * @return	string  $sid
 */
public function set_session($user_login, $sid = NULL, $data = NULL) {
	global $wpdb;
	$sid      = $sid ? $sid : $this->make_sid();
	$expires  = time() + $this->session_lifetime;
	$ua_hash  = $this->base->get('user_agent') ? sha1($this->base->get('user_agent')) : '';
	$tid_hash = $this->base->get('term_ID') ? sha1($this->base->get('term_ID')) : '';
	$sub_hash = $this->base->get('sub_ID') ? sha1($this->base->get('sub_ID')) : '';
	$result = $wpdb->insert($wpdb->prefix . 'ktaisession', array(
		'sid'        => $sid,
		'expires'    => date('Y-m-d H:i:s', $expires),
		'user_login' => $user_login,
		'user_agent' => $ua_hash,
		'term_id'    => $tid_hash,
		'sub_id'     => $sub_hash,
		'data'       => ($data ? serialize($data) : ''),
		));
	if (! $result) {
		return NULL;
	}
	$this->sid        = $sid;
	$this->next_id    = NULL;
	$this->expires    = $expires;
	$this->user_login = $user_login;
	$this->user_agent = $ua_hash;
	$this->term_ID    = $tid_hash;
	$this->sub_ID     = $sub_hash;
	$this->data       = $data;
	if ( $this->base->get('cookie_available') ) {
		setcookie(self::SESSION_NAME, $sid, $expires, COOKIEPATH, COOKIE_DOMAIN);
		if ( COOKIEPATH != SITECOOKIEPATH ) {
			setcookie(self::SESSION_NAME, $sid, $expires, SITECOOKIEPATH, COOKIE_DOMAIN);
		}
	}
	return $sid;
}

/* ==================================================
 * @param	none
 * @return	string  $new_sid
 */
public function renew_session() {
	global $wpdb;
	if ($this->next_id) {
		$sid = $this->next_id;
		$sql = $wpdb->prepare("SELECT * FROM `{$wpdb->prefix}ktaisession` WHERE next_id = %s", $sid);
		$result = $wpdb->get_row($sql);
		if ($result) {
			$this->sid        = $sid;
			$this->next_id    = $result->next_id;
			$this->expires    = strtotime($result->expires);
			$this->user_login = $result->user_login;
			$this->user_agent = $result->user_agent;
			$this->term_ID    = $result->term_id;
			$this->sub_ID     = $result->sub_id;
			$this->data       = unserialize($result->data);
			if ( $this->base->get('cookie_available') ) {
				setcookie(self::SESSION_NAME, $sid, $expires, COOKIEPATH, COOKIE_DOMAIN);
				if ( COOKIEPATH != SITECOOKIEPATH ) {
					setcookie(self::SESSION_NAME, $sid, $expires, SITECOOKIEPATH, COOKIE_DOMAIN);
		}
			}
			return $sid;
		}
		$this->next_id = NULL;
	}
	if ($this->sid && time() + $this->session_renewtime > $this->expires) {
		$new_sid    = $this->make_sid();
		$sql = $wpdb->prepare("UPDATE `{$wpdb->prefix}ktaisession` SET next_id = %s WHERE sid = %s AND next_id IS NULL LIMIT 1", $new_sid, $this->sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return $this->set_session($this->user_login, $new_sid, $this->data);
		}
	}
	return false;
}

/* ==================================================
 * @param	string  $sid
 * @return	boolean $is_succeeded
 */
public function unset_session($sid) {
	global $wpdb;
	if ($sid) {
		setcookie(self::SESSION_NAME, '', time() - 31536000, ADMIN_COOKIE_PATH, COOKIE_DOMAIN); // erase cookie;
		$sql = $wpdb->prepare("DELETE FROM `{$wpdb->prefix}ktaisession` WHERE sid = %s LIMIT 1", $sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return true;
		}
	}
	return false;
}

/* ==================================================
 * @param	string  $sid
 * @return	boolean $is_succeeded
 */
public function unset_prev_session($sid) {
	global $wpdb;
	if ($sid) {
		$sql = $wpdb->prepare("DELETE FROM `{$wpdb->prefix}ktaisession` WHERE next_id = %s  LIMIT 1", $sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return true;
		}
	}
	return false;
}

/* ==================================================
 * @param	none
 * @return	boolean $is_succeeded
 */
public function garbage_sessions() {
	global $wpdb;
	$sql = $wpdb->prepare("DELETE FROM `{$wpdb->prefix}ktaisession` WHERE expires < %s", date('Y-m-d H:i:s', time()));
	$result = $wpdb->query($sql);
	if ($result) {
		return true;
	}
	return false;
}

/* ==================================================
 * @param	none
 * @return	string   $user_login
 */
public function check_session() {
	global $wpdb;
	$sid = self::get_sid();
	if (empty($sid)) {
		return false;
	}
	self::garbage_sessions();
	$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM `{$wpdb->prefix}ktaisession` WHERE sid = %s", $sid));

	if (! $result || strcmp(sha1($_SERVER['HTTP_USER_AGENT']), $result->user_agent) != 0) {
		return false;
	}

	// restore the session
	if (isset($this)) {
		$this->sid        = $sid;
		$this->next_id    = $result->next_id;
		$this->expires    = strtotime($result->expires);
		$this->user_login = $result->user_login;
		$this->user_agent = $result->user_agent;
		$this->term_ID    = $result->term_id;
		$this->sub_ID     = $result->sub_id;
		$data = unserialize($result->data);
		$this->data       = ($data ? $data : NULL);
	}
	return $result->user_login;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function redirect($redirect_to) {
	if (preg_match('#^' . preg_quote(KtaiStyle::ADMIN_DIR, '#') . '/#', $redirect_to)) {
		$redirect_to = $this->base->get('plugin_url') . $redirect_to;
	}
	wp_redirect($redirect_to);
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function safe_redirect($redirect_to) {
	if (preg_match('#^' . preg_quote(KtaiStyle::ADMIN_DIR, '#') . '/#', $redirect_to)) {
		$redirect_to = $this->base->get('plugin_url') . $redirect_to;
	}
	wp_safe_redirect($redirect_to);
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function shrink_redirect_to($uri) {
	$plugin_dir_pat = preg_quote(preg_replace('!^https?://[^/]*/!', '', $this->base->get('plugin_url')), '!');
	$redirect_to = preg_replace("!^.*?$plugin_dir_pat!", '', $uri);
	return $redirect_to;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function auth_redirect() {
	if (! $this->check_session()) {
		$uri = $_SERVER['REQUEST_URI'];
		$uri = preg_replace('!^.*' . preg_quote($this->base->strip_host($this->base->get('plugin_url')), '!') . '!', '', $uri);
		wp_redirect($this->base->get('plugin_url') . 'login.php?redirect_to=' . urlencode($uri));
		exit();
	}
}

/* ==================================================
 * @param	none
 * @return	object  $this
 */
public function store_referer() {
	if ($_SERVER['REQUEST_METHOD'] == 'GET') {
		$current = $_SERVER['REQUEST_URI'];
		$orig_referer = $this->get_data('referer');
		if ($orig_referer) {
			if (strcmp($orig_referer, $current) === 0) {
				return $this; // dont store
			}
			$this->set_data('orig_referer', $orig_referer);
		}
		$this->set_data('referer', $current);
	}
	return $this;
}

/* ==================================================
 * @param	none
 * @return	string  $referer
 */
public function get_referer() {
	return wp_get_referer();
/*	$referer = '';
	$current = $_SERVER['REQUEST_URI'];
	if (isset($this->data['referer'])) {
		$referer = $this->get_data('referer');
		if (strcmp($referer, $current) == 0 && isset($this->data['orig_referer'])) {
			$referer = $this->get_data('orig_referer');
		}
	}
	if (strcmp($referer, $current) == 0) {
		$referer = false;
	}
	return $referer;
 */
}

/* ==================================================
 * @param	string  $action
 * @return	none
 */
public function nonce_ays($action) {
	global $pagenow;

	if ( $this->get_referer() ) {
		$adminurl = clean_url($this->get_referer());
	} else {
		$adminurl = $this->base->strip_host($this->base->get('plugin_url')) . KtaiStyle::ADMIN_DIR . '/';
	}
	
	$title = $this->base->encode_for_ktai(__('WordPress Confirmation', 'ktai_style'));
	list ($desc, $allow_proceed) = $this->explain_nonce($action);
	if ($allow_proceed) {
		$no  = __('No');
		$yes = __('Yes');
	} else {
		$no  = __('Back', 'ktai_style');
	}
	// Remove extra layer of slashes.
	$_POST = stripslashes_deep($_POST);
	if ($_POST) {
		$q = http_build_query($_POST);
		$q = explode( ini_get('arg_separator.output'), $q);
		$html .= '<form method="post" action="' . clean_url($pagenow) . '"><input type="hidden" name="' . self::SESSION_NAME . '" value="' . attribute_escape($this->sid) . '" />';
		foreach ( (array) $q as $a ) {
			$v = substr(strstr($a, '='), 1);
			$k = substr($a, 0, -(strlen($v)+1));
			$html .= '<input type="hidden" name="' . attribute_escape(urldecode($k)) . '" value="' . attribute_escape(urldecode($v)) . '" />';
		}
		$add_html = '<input type="hidden" name="_wpnonce" value="' . wp_create_nonce($action) . '" /><p>' . wp_specialchars($desc) . '<br /><a href="' . $adminurl . '">' . $no . '</a>' . ($allow_proceed ? ' <input type="submit" value="' . $yes . '" />' : '') . '</div></form>';
	} else {
		$add_html = '<p>' . wp_specialchars($desc) . '<br /><a href="' . $adminurl . '">' . $no. '</a>' . ($allow_proceed ? ' <a href="' . clean_url(add_query_arg('_wpnonce', wp_create_nonce($action), $_SERVER['REQUEST_URI'])) . '">' . $yes . '</a>' : '') . ' </p>';
	}
	$html .= $this->base->encode_for_ktai($add_html);
	$this->base->ks_die($html, $title, false, true);
}

/* ==================================================
 * @param	string  $action
 * @return	string  $desc
 * @return	boolean $allow_proceed
 */
private function explain_nonce($action) {
	global $Ktai_Style;
	remove_filter('the_title', array($Ktai_Style->shrinkage, 'shrink_title'), 90);
	if ( $action === -1 || ! preg_match('/([a-z]+)-([a-z]+)(_(.+))?/', $action, $matches) ) {
		return;
	}
	$verb = $matches[1];
	$noun = $matches[2];
	$trans = array();
	$trans['change']['cats'] = array(__('Are you sure you want to change categories of this post: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['unapprove']['comment'] = array(__('Are you sure you want to unapprove the comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['approve']['comment'] = array(__('Are you sure you want to approve the comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['delete']['comment'] = array(__('Are you sure you want to delete the comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['delete']['post'] = array(__('Are you sure you want to delete this post: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['delete']['page'] = array(__('Are you sure you want to delete this page: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['bulk']['spamdelete'] = array(__('Are you sure you want to delete all spam?', 'ktai_style'));

	if ( isset($trans[$verb][$noun]) ) {
		if (! empty($trans[$verb][$noun][1]) ) {
			$lookup = $trans[$verb][$noun][1];
			$object = $matches[4];
			if ('use_id' != $lookup) {
				$object = call_user_func($lookup, $object);
			}
			$desc = sprintf($trans[$verb][$noun][0], $object);
		} else {
			$desc = $trans[$verb][$noun][0];
		}
		$allow_proceed = true;
	} else {
		$desc = wp_explain_nonce($action);
		$allow_proceed = false;
	}
	return array($desc, $allow_proceed);
}

/* ==================================================
 * @param	string  $uri
 * @param	int     $id
 * @param	string  $context
 * @return	string  $uri
 */
public function fix_edit_post_link($uri, $id, $context = NULL) {
	if (is_null($context)) {
		$uri = str_replace('&amp;', '&', $uri);
	}
	return preg_replace('!^' . preg_quote(admin_url()) . '!', $this->base->get('plugin_url') . KtaiStyle::ADMIN_DIR . '/', $uri);
}

/* ==================================================
 * @param	string  $uri
 * @return	string  $uri
 */
public function fix_edit_comment_link($uri) {
	return preg_replace('|^' . preg_quote(admin_url()) . '|', $this->base->get('plugin_url') . KtaiStyle::ADMIN_DIR . '/', $uri);
}

// ===== End of class ====================
}
?>