<?php
/* ==================================================
 *   Ktai Themes
   ================================================== */

if ( !defined('ABSPATH')) {
	exit;
}

class KtaiThemes {
	private $theme;
	private $theme_root;
	private $theme_root_uri;
	private $template_dir;
	private $template_uri;
	private $screenshot;
	public static $target = array('mova', 'foma', 'ezweb', 'sb_pdc', 'sb_3g', 'willcom', 'emobile', 'touch');
	const OPTION_PREFIX = 'ks_theme';
	const BUILT_IN_THEMES_DIR = 'themes';
	const USER_THEMES_DIR ='ktai-themes';
	const SAME_THEME_AS_COMMON = '*';
	const SCREENSHOT_BASENAME = 'screenshot';

public function __construct($dir = false) {
	global $Ktai_Style;
	if ( !$dir ) {
		$dir = $Ktai_Style->ktai->get('theme');
		if ( !$this->valid_theme_dir($dir) ) {
			$dir = ks_option('ks_theme');
		}
		$this->get_theme_info($dir);
	}
}

/* ==================================================
 * @param	string  $key
 * @return	mixed   $value
 */
public function get($key) {
	return $this->$key;
}

/* ==================================================
 * @param	string  $dir
 * @return	boolena $valid
 */
public function valid_theme_dir($dir) {
	$valid = false;
	if ( !empty($dir) 
	&& $dir !== self::SAME_THEME_AS_COMMON 
	&& ! preg_match('![^-_/a-zA-Z0-9]!', $dir)
	&& strpos($dir, '../') === false) {
		$valid = true;
	}
	return $valid;
}

/* ==================================================
 * @param	string  $path
 * @return	boolena $valid
 */
public function valid_theme($path) {
	$valid = false;
	if ( is_dir($path) ) {
		$path = trailingslashit($path);
		if (file_exists($path . 'index.php') 
		&&  file_exists($path . 'style.css')) {
			$valid = true;
		}
	}
	return $valid;
}

/* ==================================================
 * @param	string  $dir
 * @return	boolena $valid
 */
public function complete_theme_dir($dir) {
	if (strpos($dir, '/') !== false) {
		$path = WP_CONTENT_DIR . '/' . $dir;
	} else {
		$path = dirname(dirname(__FILE__)) . '/' . self::BUILT_IN_THEMES_DIR . '/' . $dir;
	}
	return $path;
}

/* ==================================================
 * @param	string  $dir
 * @param	string  $target
 * @return	none
 * @since	2.0.0
 */
public function set_theme($dir, $target = false) {
	if ( empty($target) ) {
		$option = self::OPTION_PREFIX;
	} elseif ( in_array($target, self::$target) ) {
		$option = self::OPTION_PREFIX . '_' . $target;
	} else {
		return;
	}
	if ( empty($dir) ) {
		delete_option($option);
	} elseif ($target == 'touch' && $dir == self::SAME_THEME_AS_COMMON) {
		update_option(self::OPTION_PREFIX . '_touch',  self::SAME_THEME_AS_COMMON);
	} elseif (self::valid_theme_dir($dir)) {
		$path = self::complete_theme_dir($dir);
		if (self::valid_theme($path)) {
			update_option($option, $dir);
		}
	}
}

/* ==================================================
 * @param	string  $theme_dir
 * @return	none
 */
public function get_theme_info($dir) {
	global $Ktai_Style;
	if (strpos($dir, '/') !== false) {
		$path_item = explode('/', $dir);
		$this->theme = array_pop($path_item);
		if (! $this->theme) {
			$this->theme = array_pop($path_item);
		}
		$this->theme_root = WP_CONTENT_DIR . '/' . implode('/', $path_item); // no trailing slash
		$this->theme_root_uri = content_url() . '/' . implode('/', $path_item); // no trailing slash
	} else {
		$this->theme = $dir;
		$this->theme_root = dirname(dirname(__FILE__)) . '/' . self::BUILT_IN_THEMES_DIR;
		$this->theme_root_uri = $Ktai_Style->get('plugin_url') . self::BUILT_IN_THEMES_DIR;
	}
	$this->template_dir = $this->theme_root . "/{$this->theme}/"; // trailing slash
	if ( !$this->valid_theme_dir($this->theme) 
	|| !$this->valid_theme($this->template_dir)) {
		$this->theme = 'default';
		$this->get_theme_info($this->theme);
		$this->template_dir = dirname(dirname(__FILE__)) . '/' . self::BUILT_IN_THEMES_DIR . "/{$this->theme}/";
	}
	$this->template_uri = $this->theme_root_uri . "/{$this->theme}/"; // trailing slash
	if (file_exists($this->template_dir . self::SCREENSHOT_BASENAME . '.png')) {
		$this->screenshot = $this->template_uri . self::SCREENSHOT_BASENAME . '.png';
	} elseif (file_exists($this->template_dir . self::SCREENSHOT_BASENAME . '.jpg')) {
		$this->screenshot = $this->template_uri . self::SCREENSHOT_BASENAME . '.jpg';
	} elseif (file_exists($this->template_dir . self::SCREENSHOT_BASENAME . '.gif')) {
		$this->screenshot = $this->template_uri . self::SCREENSHOT_BASENAME . '.gif';
	}
}

/* ==================================================
 * @param	none
 * @return	none
 * @since	2.0.0
 */
public function bypass_admin_404() {
	global $Ktai_Style;
	// redirect to dashboard or login screen if accessed to non-existing URLs
	if (isset($Ktai_Style->admin)) {
		if (preg_match('!^' . ks_plugin_url(KTAI_NOT_ECHO) . KTAI_ADMIN_DIR . '/!',  $_SERVER['REQUEST_URI'])) {
			$sid = $this->admin->get_sid();
			if ($sid) {
				$url = $this->admin->add_sid(ks_admin_url(KTAI_NOT_ECHO));
			} else {
				$url = ks_get_login_url();
			}
			wp_redirect($url);
			exit();
		}
	} elseif (preg_match('!wp-admin/!',  $_SERVER['REQUEST_URI'])) { // cannot use is_admin()
		exit(); // shut out access to non-existing admin screen
	}
}

/* ==================================================
 * @param	none
 * @return	none
 * @since	2.0.0
 */
public function load_theme_function() {
	if ( file_exists($this->template_dir . 'functions.php') ) {
		include($this->template_dir . 'functions.php');
	}
}

/* ==================================================
 * @param	none
 * @return	none
 * @since	2.0.0
 */
public function comments_template($file) {
	$comment_template = $this->template_dir . 'comments.php';
	if (file_exists($comment_template)) {
		return $comment_template;
	}
	$default_comment_template = dirname(dirname(__FILE__)) . '/' . self::BUILT_IN_THEMES_DIR . '/default/comments.php';
	if (file_exists($default_comment_template)) {
		return $default_comment_template;
	} else {
		return $file; // returns template for current PC theme
	}
}

/* ==================================================
 * @param	none
 * @return	string  $template
 * based on wp-includes/template-loader.php of WP 2.2.3
 */
public function load_template() {
	if ( is_404() && $template = $this->query_template('404')) {
		return $template;
	} elseif (isset($_GET['menu'])) {
		if ($template = $this->menu_template($_GET['menu'])) {
			return $template;
		}
	} elseif (is_search() && $template = $this->query_template('search')) {
		return $template;
	} elseif (is_home() && $template = $this->get_home_template()) {
		return $template;
	} elseif (is_attachment() && $template = $this->get_attachment_template()) {
		return $template;
	} elseif (is_single() && $template = $this->query_template('single')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_page() && $template = $this->get_page_template()) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_category() && $template = $this->get_category_template()) {
		return $template;
	} elseif (function_exists('is_tag') && is_tag() && $template = $this->get_tag_template()) {
		return $template;
	} elseif (is_author() && $template = $this->query_template('author')) {
		return $template;
	} elseif (is_date() && $template = $this->query_template('date')) {
		return $template;
	} elseif (is_archive() && $template = $this->query_template('archive')) {
		return $template;
	} elseif (is_paged() && $template = $this->query_template('paged')) {
		return $template;
	} elseif (file_exists($this->get('template_dir') . 'index.php')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $this->get('template_dir') . 'index.php';
	}
	return NULL;
}

/* ==================================================
 * @param	string  $type
 * @return	string  $template
 * based on get_query_template() at wp-includes/theme.php of WP 2.2.3
 */
private function query_template($type) {
	$template = '';
	if (file_exists($this->get('template_dir') . "{$type}.php")) {
		$template = $this->get('template_dir') . "{$type}.php";
	}
	return apply_filters("{$type}_template", $template);
}

/* ==================================================
 * @param	string  $type
 * @return	string  $template
 * based on get_query_template() at wp-includes/theme.php of WP 2.2.3
 */
private function menu_template($type) {
	if (! preg_match('/^[_a-z0-9]+$/', $type)) {
		return NULL;
	}
	$template = '';
	if (file_exists($this->get('template_dir') . "menu_{$type}.php")) {
		$template = $this->get('template_dir') . "menu_{$type}.php";
	} else {
		$default_menu['comments'] = true;
		$default_menu['months']   = true;
		$default_menu['years']   = true;
		$default_menu['cats']     = true;
		$default_menu['tags']     = true;
		$default_menu['pages']    = true;
		$default_menu['links']    = true;
		if (! $default_menu[$type]) {
			return NULL;
		} elseif (file_exists(dirname(dirname(__FILE__)) . '/' . self::BUILT_IN_THEMES_DIR . "/default/menu_{$type}.php")) {
			$template = dirname(dirname(__FILE__))  . '/' . self::BUILT_IN_THEMES_DIR . "/default/menu_{$type}.php";
		}
	}
	return apply_filters("menu_{$type}_template", $template);
}

/* ==================================================
 * @param	none
 * @return	string  $template
 * based on get_category_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_category_template() {
	$template = '';
	if (file_exists($this->get('template_dir') . 'category-' . get_query_var('cat') . '.php')) {
		$template = $this->get('template_dir') . 'category-' . get_query_var('cat') . '.php';
	} elseif (file_exists($this->get('template_dir') . 'category.php')) {
		$template = $this->get('template_dir') . 'category.php';
	}
	return apply_filters('category_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string  $template
 * based on get_tag_template() at wp-includes/theme.php of WP 2.3.1
 */
private function get_tag_template() {
	$template = '';
	if (file_exists($this->get('template_dir') . 'tag-' . get_query_var('tag') . '.php')) {
		$template = $this->get('template_dir') . 'tag-' . get_query_var('tag') . '.php';
	} elseif (file_exists($this->get('template_dir') . 'tag.php')) {
		$template = $this->get('template_dir') . 'tag.php';
	}
	return apply_filters('tag_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 * based on get_home_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_home_template() {
	$template = '';
	if (file_exists($this->get('template_dir') . 'home.php')) {
		$template = $this->get('template_dir') . 'home.php';
	} elseif (file_exists($this->get('template_dir') . 'index.php')) {
		$template = $this->get('template_dir') . 'index.php';
	}
	return apply_filters('home_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 * based on get_page_template() at wp-includes/theme.php of WP 2.3.3
 */
private function get_page_template() {
	global $wp_query;

	$id = (int) $wp_query->post->ID;
	$template = get_post_meta($id, '_wp_page_template', true);

	if ('default' == $template) {
		$template = '';
	}
	if (! empty($template) && file_exists($this->get('template_dir') . $template)) {
		$template = $this->get('template_dir') . $template;
	} elseif (file_exists($this->get('template_dir') . 'page.php')) {
		$template = $this->get('template_dir') . 'page.php';
	} else {
		$template = '';
	}
	return apply_filters('page_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string  $template
 * based on get_attachment_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_attachment_template() {
	global $posts;
	$type = explode('/', $posts[0]->post_mime_type);
	if ($template = $this->query_template($type[0]) )
		return $template;
	elseif ($template = $this->query_template($type[1]) )
		return $template;
	elseif ($template = $this->query_template("$type[0]_$type[1]") )
		return $template;
	else
		return $this->query_template('attachment');
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_header() {
	do_action('get_header');
	if (file_exists($this->get('template_dir') . 'header.php')) {
		load_template($this->get('template_dir') . 'header.php');
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_footer() {
	do_action('get_footer');
	if (file_exists($this->get('template_dir') . 'footer.php')) {
		load_template($this->get('template_dir') . 'footer.php');
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	array  $themes
 * @since	0.97
 */
public static function installed_themes() {
	$theme_data = get_theme_data(dirname(dirname(__FILE__)) . '/' . self::BUILT_IN_THEMES_DIR . '/default/style.css');
	if (isset($theme_data['Name'])) {
		$themes['default'] = $theme_data['Name'] . ' (' . $theme_data['Version'] . ')';
	} else {
		$theme['default'] = 'Default';
	}
	foreach (glob(dirname(dirname(__FILE__)) . '/' . self::BUILT_IN_THEMES_DIR . '/*', GLOB_ONLYDIR) as $d) {
		if ( !self::valid_theme($d) ) {
			continue;
		}
		if (preg_match('!/([-_.+a-zA-Z0-9]+)/?$!', $d, $filename) && $filename[1] != 'default') {
			$theme_data = get_theme_data($d . '/style.css');
			$themes[$filename[1]] = $theme_data['Name'] . ' (' . $theme_data['Version'] . ')';
		}
	}
	if ( !file_exists(WP_CONTENT_DIR . '/' . self::USER_THEMES_DIR) ) {
		return $themes;
	}
	foreach (glob(WP_CONTENT_DIR . '/' . self::USER_THEMES_DIR . '/*', GLOB_ONLYDIR) as $d) {
		if ( !self::valid_theme($d) ) {
			continue;
		}
		if ( preg_match('!/([-_.+a-zA-Z0-9]+)/?$!', $d, $filename) && !in_array($filename[1], $themes) ) {
			$theme_data = get_theme_data($d . '/style.css');
			$themes[self::USER_THEMES_DIR . '/' . $filename[1]] = $theme_data['Name'] . ' (' . $theme_data['Version'] . ')';
		}
	}
	return $themes;
}

// ===== End of class ====================
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_header() {
	global $Ktai_Style;
	$Ktai_Style->theme->get_header();
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_footer() {
	global $Ktai_Style;
	$Ktai_Style->theme->get_footer();
	return;
}

/* ==================================================
 * @param	boolean $echo
 * @return	string  $theme
 * @since	2.0.0
 */
function ks_get_theme($echo = false) {
	global $Ktai_Style;
	$theme = apply_filters('ktai_theme', $Ktai_Style->theme->get('theme'));
	if ($echo) {
		echo $theme;
	}
	return $theme;
}

/* ==================================================
 * @param	boolean $echo
 * @return	string  $theme
 * @since	2.0.0
 */
function ks_get_theme_directory($echo = false) {
	global $Ktai_Style;
	$theme_dir = $Ktai_Style->theme->get('template_dir');
	$theme = $Ktai_Style->theme->get('theme');
	$theme_root = $Ktai_Style->theme->get('theme_root');
	$theme_dir = apply_filters('ktai_theme_directory', $theme_dir, $theme, $theme_root );
	if ($template_dir) {
		echo $template_dir;
	}
	return $template_dir;
}

/* ==================================================
 * @param	boolean $echo
 * @return	string  $url (with tailing slash)
 */
function ks_theme_url($echo = true) {
	global $Ktai_Style;
	$theme_url = $Ktai_Style->theme->get('template_uri');
	$theme = $Ktai_Style->theme->get('theme');
	$theme_root = $Ktai_Style->theme->get('theme_root');
	$theme_url = apply_filters('ktai_theme_url', $theme_url, $theme, $theme_root );
	if ($echo) {
		echo $theme_url;
	}
	return $theme_url;
}

?>