<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS.

   ***** DO NOT EDIT THIS FILE WITH WORDPRESS ADMIN PANEL *****
*/

/* ==================================================
 *   KtaiService_Softbank class
   ================================================== */

class KtaiService_Softbank extends KtaiServices {
	// http://creation.mb.softbank.jp/web/web_ip.html
	// Last Update: 2007-10-09
	static public $networks = array(
		'123.108.236.0/24', 
		'123.108.237.0/27', 
		'202.179.204.0/24', 
		'202.253.96.224/27', 
		'210.146.7.192/26', 
		'210.146.60.192/26', 
		'210.151.9.128/26', 
		'210.169.130.112/28', 
		'210.175.1.128/25', 
		'210.228.189.0/24', 
		'211.8.159.128/25', 
	);
	// http://creation.mb.softbank.jp/download.php?docid=103 (members only)
	static public $pics = array(
		'se001' => "\xf9\x41", // j̎q
		'se002' => "\xf9\x42", // ̎q
		'se003' => "\xf9\x43", // e (LX}[N)
		'se004' => "\xf9\x44", // 
		'se005' => "\xf9\x45", // ꂳ
		'se006' => "\xf9\x46", // m
		'se007' => "\xf9\x47", // u[c
		'se008' => "\xf9\x48", // J
		'se009' => "\xf9\x49", // db
		'se00a' => "\xf9\x4a", // gѓdb
		'se00b' => "\xf9\x4b", // FAX
		'se00c' => "\xf9\x4c", // p\R
		'se00d' => "\xf9\x4d", // p`
		'se00e' => "\xf9\x4e", // GOOD!
		'se00f' => "\xf9\x4f", // No.1!
		'se010' => "\xf9\x50", // O[
		'se011' => "\xf9\x51", // `L
		'se012' => "\xf9\x52", // p[
		'se013' => "\xf9\x53", // XL[
		'se014' => "\xf9\x54", // St
		'se015' => "\xf9\x55", // ejX
		'se016' => "\xf9\x56", // 싅
		'se017' => "\xf9\x57", // T[tB
		'se018' => "\xf9\x58", // TbJ[
		'se019' => "\xf9\x59", // 
		'se01a' => "\xf9\x5a", // 
		'se01b' => "\xf9\x5b", // 
		'se01c' => "\xf9\x5c", // bg
		'se01d' => "\xf9\x5d", // s@
		'se01e' => "\xf9\x5e", // d
		'se01f' => "\xf9\x5f", // V
		'se020' => "\xf9\x60", // nei
		'se021' => "\xf9\x61", // rbN
		'se022' => "\xf9\x62", // n[g}[N
		'se023' => "\xf9\x63", // n[guCN
		'se024' => "\xf9\x64", // 1
		'se025' => "\xf9\x65", // 2
		'se026' => "\xf9\x66", // v
		'se027' => "\xf9\x67", // 4
		'se028' => "\xf9\x68", // 5
		'se029' => "\xf9\x69", // 6
		'se02a' => "\xf9\x6a", // 7
		'se02b' => "\xf9\x6b", // 8
		'se02c' => "\xf9\x6c", // 9
		'se02d' => "\xf9\x6d", // 10
		'se02e' => "\xf9\x6e", // 11
		'se02f' => "\xf9\x6f", // 12
		'se030' => "\xf9\x70", // Ԍ
		'se031' => "\xf9\x71", // Gu
		'se032' => "\xf9\x72", // o
		'se033' => "\xf9\x73", // NX}X
		'se034' => "\xf9\x74", // w
		'se035' => "\xf9\x75", // 
		'se036' => "\xf9\x76", // 
		'se037' => "\xf9\x77", // 
		'se038' => "\xf9\x78", // r
		'se039' => "\xf9\x79", // w
		'se03a' => "\xf9\x7a", // K\X^h
		'se03b' => "\xf9\x7b", // R
		'se03c' => "\xf9\x7c", // }CN
		'se03d' => "\xf9\x7d", // f
		'se03e' => "\xf9\x7e", // y ()
		'se03f' => "\xf9\x80", // JM
		'se040' => "\xf9\x81", // TbNX
		'se041' => "\xf9\x82", // M^[
		'se042' => "\xf9\x83", // gybg
		'se043' => "\xf9\x84", // Xg
		'se044' => "\xf9\x85", // JNe
		'se045' => "\xf9\x86", // R[q[
		'se046' => "\xf9\x87", // P[L
		'se047' => "\xf9\x88", // r[
		'se048' => "\xf9\x89", // 
		'se049' => "\xf9\x8a", // ܂
		'se04a' => "\xf9\x8b", //  ()
		'se04b' => "\xf9\x8c", // J
		'se04c' => "\xf9\x8d", //  ()
		'se04d' => "\xf9\x8e", // 
		'se04e' => "\xf9\x8f", // Vg
		'se04f' => "\xf9\x90", // ˂
		'se050' => "\xf9\x91", // Ƃ
		'se051' => "\xf9\x92", // 
		'se052' => "\xf9\x93", // 
		'se053' => "\xf9\x94", // ˂
		'se054' => "\xf9\x95", // NW
		'se055' => "\xf9\x96", // yM
		'se056' => "\xf9\x97", // y ()
		'se057' => "\xf9\x98", //  ()
		'se058' => "\xf9\x99", //  ()
		'se059' => "\xf9\x9a", // { ()
		'se05a' => "\xf9\x9b", // E`
		'se101' => "\xf7\x41", // [M
		'se102' => "\xf7\x42", // [M
		'se103' => "\xf7\x43", // [
		'se104' => "\xf7\x44", // dbA
		'se105' => "\xf7\x45", // AJx[ ()
		'se106' => "\xf7\x46", // uu ()
		'se107' => "\xf7\x47", // Kr[ ()
		'se108' => "\xf7\x48", // ^[ ()
		'se109' => "\xf7\x49", // 
		'se10a' => "\xf7\x4a", // ^R
		'se10b' => "\xf7\x4b", // Ԃ
		'se10c' => "\xf7\x4c", // Fl
		'se10d' => "\xf7\x4d", // Pbg
		'se10e' => "\xf7\x4e", // 
		'se10f' => "\xf7\x4f", // d
		'se110' => "\xf7\x50", // 
		'se111' => "\xf7\x51", // LX
		'se112' => "\xf7\x52", // o[Xf[ (v[g)
		'se113' => "\xf7\x53", // sXg
		'se114' => "\xf7\x54", // ዾ
		'se115' => "\xf7\x55", // 
		'se116' => "\xf7\x56", // I[NV
		'se117' => "\xf7\x57", // ԉ
		'se118' => "\xf7\x58", // ݂
		'se119' => "\xf7\x59", // t
		'se11a' => "\xf7\x5a", // 
		'se11b' => "\xf7\x5b", // ΂
		'se11c' => "\xf7\x5c", // hN
		'se11d' => "\xf7\x5d", // t@C[
		'se11e' => "\xf7\x5e", // ΂
		'se11f' => "\xf7\x5f", // 
		'se120' => "\xf7\x60", // no[K[
		'se121' => "\xf7\x61", // 
		'se122' => "\xf7\x62", // Lv
		'se123' => "\xf7\x63", // 
		'se124' => "\xf7\x64", // Vn
		'se125' => "\xf7\x65", // `Pbg
		'se126' => "\xf7\x66", // CD
		'se127' => "\xf7\x67", // DVD
		'se128' => "\xf7\x68", // WI
		'se129' => "\xf7\x69", // rfI
		'se12a' => "\xf7\x6a", // er
		'se12b' => "\xf7\x6b", // Q[
		'se12c' => "\xf7\x6c", // ̂o
		'se12d' => "\xf7\x6d", // }[W
		'se12e' => "\xf7\x6e", // Ό
		'se12f' => "\xf7\x6f", // ܋ (h)
		'se130' => "\xf7\x70", // 
		'se131' => "\xf7\x71", // gtB[
		'se132' => "\xf7\x72", // S[ (`FbJ[tbO)
		'se133' => "\xf7\x73", // Xbg (777)
		'se134' => "\xf7\x74", // n
		'se135' => "\xf7\x75", // 
		'se136' => "\xf7\x76", // 
		'se137' => "\xf7\x77", // H
		'se138' => "\xf7\x78", // j
		'se139' => "\xf7\x79", // 
		'se13a' => "\xf7\x7a", // c
		'se13b' => "\xf7\x7b", // ˊ
		'se13c' => "\xf7\x7c", //  (Zzz)
		'se13d' => "\xf7\x7d", // 
		'se13e' => "\xf7\x7e", // nCq[
		'se13f' => "\xf7\x80", // 
		'se140' => "\xf7\x81", // gC
		'se141' => "\xf7\x82", // 
		'se142' => "\xf7\x83", // m点 (Kz)
		'se143' => "\xf7\x84", // j
		'se144' => "\xf7\x85", // bNON
		'se145' => "\xf7\x86", // bNOFF
		'se146' => "\xf7\x87", // X
		'se147' => "\xf7\x88", //  ()
		'se148' => "\xf7\x89", // {
		'se149' => "\xf7\x8a", // ב֑
		'se14a' => "\xf7\x8b", // 
		'se14b' => "\xf7\x8c", // j[X (p{Aei)
		'se14c' => "\xf7\x8d", // C (͂)
		'se14d' => "\xf7\x8e", // s
		'se14e' => "\xf7\x8f", // M
		'se14f' => "\xf7\x90", // ԏ
		'se150' => "\xf7\x91", // oX
		'se151' => "\xf7\x92", // OgC
		'se152' => "\xf7\x93", // 
		'se153' => "\xf7\x94", // X֋
		'se154' => "\xf7\x95", // ATM
		'se155' => "\xf7\x96", // a@
		'se156' => "\xf7\x97", // Rrj
		'se157' => "\xf7\x98", // wZ
		'se158' => "\xf7\x99", // ze
		'se159' => "\xf7\x9a", // oX
		'se15a' => "\xf7\x9b", // ^NV[
		'se201' => "\xf7\xa1", // k
		'se202' => "\xf7\xa2", // D
		'se203' => "\xf7\xa3", // ړIn (RR)
		'se204' => "\xf7\xa4", // r1
		'se205' => "\xf7\xa5", // r2
		'se206' => "\xf7\xa6", // r3
		'se207' => "\xf7\xa7", // 18
		'se208' => "\xf7\xa8", // ։
		'se209' => "\xf7\xa9", // S
		'se20a' => "\xf7\xaa", // oAt[ (Ԉ֎q}[N)
		'se20b' => "\xf7\xab", // Aei}[N
		'se20c' => "\xf7\xac", // n[g (gv)
		'se20d' => "\xf7\xad", // _C (gv)
		'se20e' => "\xf7\xae", // Xy[h (gv)
		'se20f' => "\xf7\xaf", // Nu (gv)
		'se210' => "\xf7\xb0", // V[v_C
		'se211' => "\xf7\xb1", // t[_C
		'se212' => "\xf7\xb2", // V
		'se213' => "\xf7\xb3", // XV
		'se214' => "\xf7\xb4", //  (COOL)
		'se215' => "\xf7\xb5", // L
		'se216' => "\xf7\xb6", // 
		'se217' => "\xf7\xb7", // z
		'se218' => "\xf7\xb8", // \
		'se219' => "\xf7\xb9", // o{^1 (IW)
		'se21a' => "\xf7\xba", // o{^2 ()
		'se21b' => "\xf7\xbb", // o{^4 ()
		'se21c' => "\xf7\xbc", // 1 (one)
		'se21d' => "\xf7\xbd", // 2 (two)
		'se21e' => "\xf7\xbe", // 3 (three)
		'se21f' => "\xf7\xbf", // 4 (four)
		'se220' => "\xf7\xc0", // 5 (five)
		'se221' => "\xf7\xc1", // 6 (six)
		'se222' => "\xf7\xc2", // 7 (seven)
		'se223' => "\xf7\xc3", // 8 (eight)
		'se224' => "\xf7\xc4", // 9 (nine)
		'se225' => "\xf7\xc5", // 0 (zero)
		'se226' => "\xf7\xc6", // 
		'se227' => "\xf7\xc7", // 
		'se228' => "\xf7\xc8", // T[rX
		'se229' => "\xf7\xc9", // ID
		'se22a' => "\xf7\xca", // 
		'se22b' => "\xf7\xcb", // 
		'se22c' => "\xf7\xcc", // w
		'se22d' => "\xf7\xcd", // cƎ
		'se22e' => "\xf7\xce", //  (w)
		'se22f' => "\xf7\xcf", //  (w)
		'se230' => "\xf7\xd0", //  (w)
		'se231' => "\xf7\xd1", // E (w)
		'se232' => "\xf7\xd2", // 
		'se233' => "\xf7\xd3", // 
		'se234' => "\xf7\xd4", // E
		'se235' => "\xf7\xd5", // 
		'se236' => "\xf7\xd6", // E
		'se237' => "\xf7\xd7", // 
		'se238' => "\xf7\xd8", // E
		'se239' => "\xf7\xd9", // 
		'se23a' => "\xf7\xda", // 
		'se23b' => "\xf7\xdb", // O
		'se23c' => "\xf7\xdc", //  
		'se23d' => "\xf7\xdd", // ߂
		'se23e' => "\xf7\xde", // 
		'se23f' => "\xf7\xdf", // Ђ
		'se240' => "\xf7\xe0", // 
		'se241' => "\xf7\xe1", // ӂ
		'se242' => "\xf7\xe2", // ɍ
		'se243' => "\xf7\xe3", // 
		'se244' => "\xf7\xe4", // Ƃߍ
		'se245' => "\xf7\xe5", // Ă҂
		'se246' => "\xf7\xe6", // 
		'se247' => "\xf7\xe7", // č
		'se248' => "\xf7\xe8", // €
		'se249' => "\xf7\xe9", // ݂ߍ
		'se24a' => "\xf7\xea", // 
		'se24b' => "\xf7\xeb", // ւт
		'se24c' => "\xf7\xec", // TOPy[W
		'se24d' => "\xf7\xed", // OK{^
		'se24e' => "\xf7\xee", // 쌠 (C)
		'se24f' => "\xf7\xef", // o^W (R)
		'se250' => "\xf7\xf0", // }i[[h
		'se251' => "\xf7\xf1", // d
		'se252' => "\xf7\xf2", //  (!)
		'se253' => "\xf7\xf3", // ē
		'se254' => "\xf7\xf4", // J-PHONEVbv
		'se255' => "\xf7\xf5", // XJCEFu
		'se256' => "\xf7\xf6", // XJCEH[J[
		'se257' => "\xf7\xf7", // XJCfB
		'se258' => "\xf7\xf8", // J-PHONE 1
		'se259' => "\xf7\xf9", // J-PHONE 2
		'se25a' => "\xf7\xfa", // J-PHONE 3
		'se301' => "\xf9\xa1", // 
		'se302' => "\xf9\xa2", // lN^C
		'se303' => "\xf9\xa3", // nCrXJX
		'se304' => "\xf9\xa4", // `[bv
		'se305' => "\xf9\xa5", // Ђ܂
		'se306' => "\xf9\xa6", // ԑ
		'se307' => "\xf9\xa7", // ₵̖
		'se308' => "\xf9\xa8", // T{e
		'se309' => "\xf9\xa9", // gC
		'se30a' => "\xf9\xaa", // wbhz
		'se30b' => "\xf9\xab", // ӎ (Ƃ)
		'se30c' => "\xf9\xac", // t (r[)
		'se30d' => "\xf9\xad", // j
		'se30e' => "\xf9\xae", // i
		'se30f' => "\xf9\xaf", // JvZ
		'se310' => "\xf9\xb0", // D
		'se311' => "\xf9\xb1", // e
		'se312' => "\xf9\xb2", // NbJ[
		'se313' => "\xf9\xb3", // nT~
		'se314' => "\xf9\xb4", // {
		'se315' => "\xf9\xb5", // }
		'se316' => "\xf9\xb6", // MD
		'se317' => "\xf9\xb7", // KtH
		'se318' => "\xf9\xb8", // Xq
		'se319' => "\xf9\xb9", // s[X
		'se31a' => "\xf9\xba", // ~[
		'se31b' => "\xf9\xbb", // Ou[c
		'se31c' => "\xf9\xbc", // g
		'se31d' => "\xf9\xbd", // }jLA
		'se31e' => "\xf9\xbe", // GXe
		'se31f' => "\xf9\xbf", // e@
		'se320' => "\xf9\xc0", // X
		'se321' => "\xf9\xc1", // 
		'se322' => "\xf9\xc2", // rLj
		'se323' => "\xf9\xc3", // uhobO
		'se324' => "\xf9\xc4", // J`R
		'se325' => "\xf9\xc5", // 
		'se326' => "\xf9\xc6", // x鉹
		'se327' => "\xf9\xc7", // ҂҂n[g
		'se328' => "\xf9\xc8", // hLhLn[g
		'se329' => "\xf9\xc9", // n[g˂Ƃ߂
		'se32a' => "\xf9\xca", // n[g ()
		'se32b' => "\xf9\xcb", // n[g ()
		'se32c' => "\xf9\xcc", // n[g ()
		'se32d' => "\xf9\xcd", // n[g ()
		'se32e' => "\xf9\xce", // NEW (҂҂)
		'se32f' => "\xf9\xcf", // 
		'se330' => "\xf9\xd0", // _bV
		'se331' => "\xf9\xd1", // юU銾
		'se332' => "\xf9\xd2", // 
		'se333' => "\xf9\xd3", // ~
		'se334' => "\xf9\xd4", // {
		'se335' => "\xf9\xd5", //  (_)
		'se336' => "\xf9\xd6", //  "?"
		'se337' => "\xf9\xd7", //  "!"
		'se338' => "\xf9\xd8", // 
		'se339' => "\xf9\xd9", // p
		'se33a' => "\xf9\xda", // \tgN[
		'se33b' => "\xf9\xdb", // tCh|eg
		'se33c' => "\xf9\xdc", // cq 
		'se33d' => "\xf9\xdd", // ׂ
		'se33e' => "\xf9\xde", // 
		'se33f' => "\xf9\xdf", // XpQeB
		'se340' => "\xf9\xe0", // [
		'se341' => "\xf9\xe1", // J[CX
		'se342' => "\xf9\xe2", // ɂ
		'se343' => "\xf9\xe3", // ł
		'se344' => "\xf9\xe4", // i
		'se345' => "\xf9\xe5", // 
		'se346' => "\xf9\xe6", // ݂
		'se347' => "\xf9\xe7", // 
		'se348' => "\xf9\xe8", // 
		'se349' => "\xf9\xe9", // g}g
		'se34a' => "\xf9\xea", // Ȃ
		'se34b' => "\xf9\xeb", // o[Xf[P[L
		'se34c' => "\xf9\xec", // w
		'se34d' => "\xf9\xed", // ix
		'se401' => "\xfb\x41", //  ()
		'se402' => "\xfb\x42", // قł ()
		'se403' => "\xfb\x43", // Ђ炲߂Ȃ ()
		'se404' => "\xfb\x44", // ւ ()
		'se405' => "\xfb\x45", // EBN ()
		'se406' => "\xfb\x46", // 킳т ()
		'se407' => "\xfb\x47", // ڂ邮 ()
		'se408' => "\xfb\x48", // @傤 ()
		'se409' => "\xfb\x49", // ׁ[ ()
		'se40a' => "\xfb\x4a", //  ()
		'se40b' => "\xfb\x4b", // QQ ()
		'se40c' => "\xfb\x4c", // }XN
		'se40d' => "\xfb\x4d", // 炪Ȃ
		'se40e' => "\xfb\x4e", // 炯
		'se40f' => "\xfb\x4f", // ⊾ ()
		'se410' => "\xfb\x50", // т ()
		'se411' => "\xfb\x51", //  ()
		'se412' => "\xfb\x52", // ΂ ()
		'se413' => "\xfb\x53", // Ăl
		'se414' => "\xfb\x54", // ɂɂ ()
		'se415' => "\xfb\x55", // ͂͂Ə΂ ()
		'se416' => "\xfb\x56", // ߂߂{Ă ()
		'se417' => "\xfb\x57", // KISS:
		'se418' => "\xfb\x58", // KISS
		'se419' => "\xfb\x59", // 
		'se41a' => "\xfb\x5a", // @
		'se41b' => "\xfb\x5b", // 
		'se41c' => "\xfb\x5c", // 
		'se41d' => "\xfb\x5d", // ߂Ȃ (킹)
		'se41e' => "\xfb\x5e", // oCoC (U)
		'se41f' => "\xfb\x5f", // 
		'se420' => "\xfb\x60", // OK (wŊۃTC)
		'se421' => "\xfb\x61", // Booing (ew)
		'se422' => "\xfb\x62", // ́`
		'se423' => "\xfb\x63", // ~ (rNX)
		'se424' => "\xfb\x64", //  (r𓪂)
		'se425' => "\xfb\x65", // Ȃł
		'se426' => "\xfb\x66", // y
		'se427' => "\xfb\x67", // oUC
		'se428' => "\xfb\x68", // lƐlĂ
		'se429' => "\xfb\x69", // C_X (oj[K[)
		'se42a' => "\xfb\x6a", // oXPbg{[
		'se42b' => "\xfb\x6b", // tbg{[
		'se42c' => "\xfb\x6c", // r[h
		'se42d' => "\xfb\x6d", // j
		'se42e' => "\xfb\x6e", // RV
		'se42f' => "\xfb\x6f", // gbN
		'se430' => "\xfb\x70", // h
		'se431' => "\xfb\x71", // ~}
		'se432' => "\xfb\x72", // pgJ[
		'se433' => "\xfb\x73", // WFbgR[X^[
		'se434' => "\xfb\x74", // nS
		'se435' => "\xfb\x75", // V(700n)
		'se436' => "\xfb\x76", // 叼
		'se437' => "\xfb\x77", // `R
		'se438' => "\xfb\x78", // l
		'se439' => "\xfb\x79", // Ǝ
		'se43a' => "\xfb\x7a", // hZ
		'se43b' => "\xfb\x7b", // ̂ڂ
		'se43c' => "\xfb\x7c", // Ƃ
		'se43d' => "\xfb\x7d", // 
		'se43e' => "\xfb\x7e", // gU[
		'se43f' => "\xfb\x80", // X
		'se440' => "\xfb\x81", // ԉ
		'se441' => "\xfb\x82", // L
		'se442' => "\xfb\x83", // 
		'se443' => "\xfb\x84", // 䕗
		'se444' => "\xfb\x85", // 
		'se445' => "\xfb\x86", // nEB
		'se446' => "\xfb\x87", // 
		'se447' => "\xfb\x88", // r[
		'se448' => "\xfb\x89", // T^N[X
		'se449' => "\xfb\x8a", // 
		'se44a' => "\xfb\x8b", // [
		'se44b' => "\xfb\x8c", // ꐯ
		'se44c' => "\xfb\x8d", // 
		'se501' => "\xfb\xa1", // uze
		'se502' => "\xfb\xa2", // A[g
		'se503' => "\xfb\xa3", // 
		'se504' => "\xfb\xa4", // fp[g
		'se505' => "\xfb\xa5", //  (a)
		'se506' => "\xfb\xa6", //  (m)
		'se507' => "\xfb\xa7", // f
		'se508' => "\xfb\xa8", // H
		'se509' => "\xfb\xa9", // ^[
		'se50a' => "\xfb\xaa", // 109
		'se50b' => "\xfb\xab", // { ()
		'se50c' => "\xfb\xac", // AJ ()
		'se50d' => "\xfb\xad", // tX ()
		'se50e' => "\xfb\xae", // hCc ()
		'se50f' => "\xfb\xaf", // C^A ()
		'se510' => "\xfb\xb0", // CMX ()
		'se511' => "\xfb\xb1", // XyC ()
		'se512' => "\xfb\xb2", // VA ()
		'se513' => "\xfb\xb3", //  ()
		'se514' => "\xfb\xb4", // ؍ ()
		'se515' => "\xfb\xb5", // l
		'se516' => "\xfb\xb6", // l
		'se517' => "\xfb\xb7", // Chl
		'se518' => "\xfb\xb8", // 
		'se519' => "\xfb\xb9", // ΂
		'se51a' => "\xfb\xba", // 
		'se51b' => "\xfb\xbb", // S
		'se51c' => "\xfb\xbc", // P
		'se51d' => "\xfb\xbd", // Ȑ_
		'se51e' => "\xfb\xbe", // q
		'se51f' => "\xfb\xbf", // tR
		'se520' => "\xfb\xc0", // CJ
		'se521' => "\xfb\xc1", // Ƃ
		'se522' => "\xfb\xc2", // Mы
		'se523' => "\xfb\xc3", // Ђ悱
		'se524' => "\xfb\xc4", // nX^[
		'se525' => "\xfb\xc5", // ނ
		'se526' => "\xfb\xc6", // 
		'se527' => "\xfb\xc7", // RA
		'se528' => "\xfb\xc8", // `pW[
		'se529' => "\xfb\xc9", // Ђ
		'se52a' => "\xfb\xca", // 
		'se52b' => "\xfb\xcb", // 
		'se52c' => "\xfb\xcc", // 
		'se52d' => "\xfb\xcd", // ւ
		'se52e' => "\xfb\xce", // ɂƂ
		'se52f' => "\xfb\xcf", // ̂
		'se530' => "\xfb\xd0", // 炭
		'se531' => "\xfb\xd1", // 
		'se532' => "\xfb\xd2", // A^
		'se533' => "\xfb\xd3", // B^
		'se534' => "\xfb\xd4", // AB^
		'se535' => "\xfb\xd5", // O^
		'se536' => "\xfb\xd6", // 
		'se537' => "\xfb\xd7", // TM (W)
		'se538' => "\xfb\xd8", // J-Sky 1
		'se539' => "\xfb\xd9", // J-Sky 2
		'se53a' => "\xfb\xda", // Vodafone 1
		'se53b' => "\xfb\xdb", // Vodafone 2
		'se53c' => "\xfb\xdc", // Vodafone 3
		'se53d' => "\xfb\xdd", // Vodafone 4
		'se53e' => "\xfb\xde", // Vodafone 5
	);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	$this->operator   = 'SoftBank';
	$this->use_redir  = true;
	$this->show_plugin_icon = false;
	$this->pcview_enabled = false;
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	// http://creation.mb.softbank.jp/web/web_pic_about.html
	$this->picto = array();
	$this->num_chars = array('G' => 90, 'E' => 90, 'F' => 90, 'O' => 77, 'P' => 76, 'Q' => 62);
	return;
}

/* ==================================================
 * @param	boolean $allow_search_engine
 * @return	boolean $in_network
 */
public function in_network($allow_search_engine = false) {
	return parent::in_network(self::$networks, $allow_search_engine);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = apply_filters('smiley_table/ktai_style.php', array(
		'icon_smile.gif'     => $this->picto['se056'],
		'icon_biggrin.gif'   => $this->picto['se057'],
		'icon_sad.gif'       => $this->picto['se058'],
		'icon_surprised.gif' => $this->picto['se410'],
		'icon_eek.gif'       => $this->picto['se410'],
		'icon_confused.gif'  => $this->picto['se407'],
		'icon_cool.gif'      => $this->picto['se214'],
		'icon_mad.gif'       => $this->picto['se059'],
		'icon_razz.gif'      => $this->picto['se409'],
		'icon_neutral.gif'   => $this->picto['se402'],
		'icon_wink.gif'      => $this->picto['se405'],
		'icon_lol.gif'       => $this->picto['se409'],
		'icon_redface.gif'   => $this->picto['se40a'],
		'icon_cry.gif'       => $this->picto['se411'],
		'icon_evil.gif'      => $this->picto['se416'],
		'icon_twisted.gif'   => $this->picto['se416'],
		'icon_rolleyes.gif'  => $this->picto['se407'],
		'icon_exclaim.gif'   => $this->picto['se021'],
		'icon_question.gif'  => $this->picto['se020'],
		'icon_idea.gif'      => $this->picto['se10f'],
		'icon_arrow.gif'     => $this->picto['se234'],
		'icon_mrgreen.gif'   => $this->picto['se415'],
	));
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_pict($buffer) {
	// http://www.au.kddi.com/email/emoji/
	// http://mb.softbank.jp/mb/service/3G/mail/pictogram/
	// http://www.nttdocomo.co.jp/service/mail/imode_mail/emoji_convert/
	// http://www.willcom-inc.com/ja/service/e_mail/pdf/conversiontable.pdf
	$trans = apply_filters('pictogram_table/ktai_style.php', $this->picto + array(
		'1'     => $this->picto['se252'], // u!v
		'2'     => $this->picto['se337'], // u!v
		'3'     => $this->picto['se336'], // u?v
		'4'     => 'Q',                  // uQv
		'5'     => $this->picto['se23b'], // Op1
		'6'     => $this->picto['se23a'], // EOp1
		'7'     => $this->picto['se23d'], // Op2
		'8'     => $this->picto['se23c'], // EOp2
		'9'     => '',                 // lp 1
		'10'    => '',                 // lp 2
		'11'    => '[i]',                // CtH[VV{
		'12'    => $this->picto['se044'], // COX
		'13'    => $this->picto['se142'], // Xs[J[
		'14'    => $this->picto['se12f'], // h}[N
		'15'    => $this->picto['se04c'], //  1
		'16'    => $this->picto['se13d'], // Ȃ
		'17'    => '',                 // lp 1
		'18'    => '',                 // lp 2
		'19'    => '',                 // H` 1
		'20'    => '',                 // H` 2
		'21'    => '',                 // lp 1
		'22'    => '',                 // lp 2
		'23'    => '',                 // H` 1
		'24'    => '',                 // H` 2
		'25'    => $this->picto['se026'], // rv
		'26'    => '+',                  // vX
		'27'    => '-',                  // }CiX
		'28'    => $this->picto['se32f'], //  1
		'29'    => $this->picto['se232'], //  1
		'30'    => $this->picto['se233'], //  1
		'31'    => $this->picto['se137'], // ۂɎ΂ߐ
		'32'    => '',                 // Op 1
		'33'    => '',                 // Op 1
		'34'    => '',                 // Op 2
		'35'    => '',                 // Op 2
		'36'    => '',                 // H` 1
		'37'    => '',                 // H` 2
		'38'    => '',                 // lp 1
		'39'    => '',                 // lp 2
		'40'    => '',                 //  1
		'41'    => '',                 //  2
		'42'    => $this->picto['se237'], //  2 ()
		'43'    => $this->picto['se238'], //  2 (E)
		'44'    => $this->picto['se04a'], // z
		'45'    => $this->picto['se016'], // 싅{[
		'46'    => $this->picto['se026'], // v
		'47'    => $this->picto['se04c'], //  2 ()
		'48'    => $this->picto['se325'], // x
		'49'    => '[e]',             // vbVs (e)
		'50'    => $this->picto['se002'], // 
		'51'    => $this->picto['se022'], // n[g
		'52'    => $this->picto['se044'], // }eB[j (JNeOX)
		'53'    => $this->picto['se110'], // lt
		'54'    => $this->picto['se537'], // g[h}[N (TM)
		'55'    => $this->picto['se333'], // 
		'56'    => $this->picto['se301'], //  1
		'57'    => '[v]',           // v 1
		'58'    => '[v]',           // v 2
		'59'    => $this->picto['se316'], // tbs[fBXN 1
		'60'    => '*',                  // ̌
		'61'    => $this->picto['se333'], // oc 1
		'62'    => $this->picto['se333'], // oc 2
		'63'    => $this->picto['se234'], // E 1
		'64'    => $this->picto['se235'], //  1
		'65'    => $this->picto['se047'], // }OJbv
		'66'    => '',                 // 
		'67'    => '[J_[]',       // J_[
		'68'    => $this->picto['se056'], // X}CtFCX
		'69'    => $this->picto['se32f'], //  2
		'70'    => $this->picto['se236'], // E 2 (E)
		'71'    => $this->picto['se239'], //  2 ()
		'72'    => $this->picto['se034'], // WG[
		'73'    => '',                 // `FbN}[N 1
		'74'    => $this->picto['se052'], //  (v[h)
		'75'    => $this->picto['se335'], //  3
		'76'    => $this->picto['se32e'], // Xp[N
		'77'    => $this->picto['se10f'], // d
		'78'    => $this->picto['se521'], // 
		'79'    => '[tH_]',       // tH_ 1 ()
		'80'    => $this->picto['se001'], //  1
		'81'    => $this->picto['se24e'], // Rs[Cg}[N (C)
		'82'    => $this->picto['se24f'], // WX^[h}[N (R)
		'83'    => $this->picto['se11e'], // u[tP[X (nhobN)
		'84'    => '[JtH_]',       // tH_ 2 (J)
		'85'    => $this->picto['se009'], // db 1 (vbVz)
		'86'    => $this->picto['se301'], // oRg
		'87'    => '[NWbgJ[h]', // NWbgJ[h
		'88'    => '',                 // Op 3
		'89'    => '',                 // Op 3
		'90'    => $this->picto['se50c'], // USA ()
		'91'    => $this->picto['se301'], // m[g 3
		'92'    => $this->picto['se301'], // Nbv{[h
		'93'    => $this->picto['se045'], // Jbv
		'94'    => $this->picto['se008'], // J
		'95'    => $this->picto['se04b'], // J
		'96'    => $this->picto['se42b'], // tbg{[
		'97'    => $this->picto['se148'], // { 1
		'98'    => $this->picto['se137'], // ֎~
		'99'    => $this->picto['se14e'], // M
		'100'   => $this->picto['se148'], // { 2
		'101'   => $this->picto['se148'], // { 3
		'102'   => $this->picto['se148'], // { 4
		'103'   => $this->picto['se301'], //  2
		'104'   => $this->picto['se313'], // ͂
		'105'   => $this->picto['se301'], // Ђ߂J_[
		'106'   => $this->picto['se125'], // `PbgELbv
		'107'   => $this->picto['se049'], // 
		'108'   => $this->picto['se103'], // 
		'109'   => $this->picto['se12f'], // ؎ (CHECK)
		'110'   => $this->picto['se03d'], // rfIJ
		'111'   => $this->picto['se507'], // nfBJ
		'112'   => $this->picto['se036'], // 
		'113'   => $this->picto['se304'], //  (`[bv)
		'114'   => '[iCt]',           // iCt
		'115'   => $this->picto['se129'], // rfIe[v
		'116'   => $this->picto['se214'], // ߂
		'117'   => '',               //  1
		'118'   => '',               //  2
		'119'   => $this->picto['se114'], // ނ߂
		'120'   => $this->picto['se03f'], // 
		'121'   => $this->picto['se301'], // m[g 1
		'122'   => $this->picto['se301'], // m[g 2 (J)
		'123'   => '[{gƃibg]',   // {g & ibg
		'124'   => $this->picto['se13e'], //  (nCq[)
		'125'   => $this->picto['se15a'], // 
		'126'   => $this->picto['se316'], // tbs[ 2
		'127'   => '[_Ot]',         // `[g (_Ot)
		'128'   => $this->picto['se14a'], // Ot 1 (܂Ot)
		'129'   => $this->picto['se101'], // [{bNX
		'130'   => '[d]',         // d
		'131'   => '[Roldex]',           // Roldex
		'132'   => '',                 // `FbN}[N 2
		'133'   => $this->picto['se118'], // ͂
		'134'   => $this->picto['se052'], // 
		'135'   => '[dr]',             // dr
		'136'   => '[XN[]',       // XN[
		'137'   => '[e]',             // т傤
		'138'   => $this->picto['se144'], // O
		'139'   => $this->picto['se12f'], // hD
		'140'   => $this->picto['se230'], // wmF
		'141'   => $this->picto['se231'], // wmFE
		'142'   => $this->picto['se301'], // 䒠
		'143'   => $this->picto['se301'], // Nbv
		'144'   => $this->picto['se112'], // v[g
		'145'   => '[D]',             // D
		'146'   => $this->picto['se043'], // Sn 1 (iCtƃtH[N)
		'147'   => $this->picto['se148'], // {
		'148'   => $this->picto['se42f'], // gbN
		'149'   => $this->picto['se301'], // Gsc
		'150'   => '[IDO]',              // S (PDC)
		'151'   => $this->picto['se103'], //  2
		'152'   => $this->picto['se116'], // `
		'153'   => $this->picto['se102'], // M BOX
		'154'   => $this->picto['se101'], // M BOX
		'155'   => $this->picto['se009'], // db 2 (b)
		'156'   => $this->picto['se038'], // HE
		'157'   => '',                 // K 1 ()
		'158'   => '',                 // K 2 (Op)
		'159'   => $this->picto['se14a'], // Ot 2
		'160'   => '[}K]',         // H 2 (}K)
		'161'   => $this->picto['se00a'], // db 3 (g)
		'162'   => '[RZg]',       // RZg
		'163'   => $this->picto['se428'], // Ƒ
		'164'   => $this->picto['se21a'], // N
		'165'   => $this->picto['se112'], // pbP[W
		'166'   => $this->picto['se00b'], // FAX
		'167'   => $this->picto['se04a'] . $this->picto['se049'], // Ƃǂ܂
		'168'   => $this->picto['se01d'], // s@
		'169'   => $this->picto['se135'], // {[g (D)
		'170'   => '[TCR]',         // TCR
		'171'   => '[V]',             // V
		'172'   => $this->picto['se01e'], // d
		'173'   => '@',                 // SuN
		'174'   => ' ',                  // uN
		'175'   => ' ',                  // 41uN
		'176'   => $this->picto['se30e'], // i
		'177'   => $this->picto['se208'], // ։
		'178'   => $this->picto['se20a'], // Ԉ֎q
		'179'   => $this->picto['se209'], // t}[N
		'180'   => $this->picto['se21c'], // lp 1
		'181'   => $this->picto['se21d'], // lp 2
		'182'   => $this->picto['se21e'], // lp 3
		'183'   => $this->picto['se21f'], // lp 4
		'184'   => $this->picto['se220'], // lp 5
		'185'   => $this->picto['se221'], // lp 6
		'186'   => $this->picto['se222'], // lp 7
		'187'   => $this->picto['se223'], // lp 8
		'188'   => $this->picto['se224'], // lp 9
		'189'   => $this->picto['se225'], // lp 10
		'190'   => $this->picto['se443'], // 䕗
		'191'   => $this->picto['se048'], // 䂫
		'192'   => $this->picto['se23f'], //  (Ђ)
		'193'   => $this->picto['se240'], //  ()
		'194'   => $this->picto['se241'], //  (oq)
		'195'   => $this->picto['se242'], //  (ɍ)
		'196'   => $this->picto['se243'], //  ()
		'197'   => $this->picto['se244'], //  (Ƃߍ)
		'198'   => $this->picto['se245'], //  (V)
		'199'   => $this->picto['se246'], //  ()
		'200'   => $this->picto['se247'], //  (č)
		'201'   => $this->picto['se248'], //  (€)
		'202'   => $this->picto['se249'], //  (r)
		'203'   => $this->picto['se24a'], //  ()
		'204'   => $this->picto['se24b'], //  (ւт)
		'205'   => $this->picto['se154'], // ATM
		'206'   => $this->picto['se156'], // 24 HOURS (Rrj)
		'207'   => $this->picto['se151'], // gC
		'208'   => $this->picto['se14f'], // p[LO
		'209'   => $this->picto['se150'], // oX
		'210'   => $this->picto['se14b'], // Aei (ʒu}[N)
		'211'   => $this->picto['se202'], // ` (}[N)
		'212'   => $this->picto['se14d'], // s
		'213'   => $this->picto['se03a'], // KXX^h
		'214'   => '[n}]',             // n}
		'215'   => $this->picto['se136'], // ]
		'216'   => $this->picto['se159'], // oX
		'217'   => $this->picto['se01f'], // V
		'218'   => $this->picto['se115'], // }\
		'219'   => $this->picto['se018'], // TbJ[
		'220'   => $this->picto['se015'], // ejX
		'221'   => $this->picto['se013'], // Xm[{[h
		'222'   => $this->picto['se132'], // `FbJ[tbO ([^[X|[c)
		'223'   => $this->picto['se124'], // Vn
		'224'   => $this->picto['se123'], // 
		'225'   => $this->picto['se30b'], //  (Ԃ傤)
		'226'   => $this->picto['se324'], // f ()
		'227'   => $this->picto['se44b'], // ̋
		'228'   => $this->picto['se509'], // ^[
		'229'   => $this->picto['se133'], // Xbg (777)
		'230'   => $this->picto['se312'], //  (A^̂)
		'231'   => $this->picto['se130'], // I|
		'232'   => $this->picto['se12b'], // Q[̃Rg[
		'233'   => $this->picto['se12f'], // ܋
		'234'   => $this->picto['se033'], // NX}Xc[
		'235'   => $this->picto['se030'], // Ԍ ()
		'236'   => $this->picto['se11b'], // 
		'237'   => $this->picto['se50b'], //  (jE̊)
		'238'   => $this->picto['se348'], // XCJ
		'239'   => $this->picto['se046'], // P[L
		'240'   => $this->picto['se147'], // tCp (ڋʏĂ)
		'241'   => '[]',       // 
		'242'   => $this->picto['se019'], // ӂ
		'243'   => $this->picto['se347'], // C`S
		'244'   => $this->picto['se342'], // ɂ
		'245'   => $this->picto['se120'], // no[K[ (t@[Xgt[h)
		'246'   => $this->picto['se054'], // 
		'247'   => $this->picto['se52c'], // 
		'248'   => $this->picto['se01a'], // 
		'249'   => $this->picto['se528'], // 
		'250'   => $this->picto['se531'], // 
		'251'   => $this->picto['se04f'], // L
		'252'   => $this->picto['se055'], // yM
		'253'   => '[a]',               // 
		'254'   => $this->picto['se10b'], // Ԃ
		'255'   => $this->picto['se307'], // ₵̂
		'256'   => $this->picto['se305'], // Ђ܂
		'257'   => $this->picto['se056'], //  1 (ꂵJI)
		'258'   => $this->picto['se059'], //  2 (JI)
		'259'   => $this->picto['se057'], //  3 (ȂJI)
		'260'   => $this->picto['se058'], //  4 (ꂽJI)
		'261'   => $this->picto['se13c'], //  (ZZZ...)
		'262'   => $this->picto['se334'], // { (Jb)
		'263'   => $this->picto['se108'], //  (܁E)
		'264'   => $this->picto['se105'], // 炩 (ׂ)
		'265'   => $this->picto['se023'], // n[g 2 (Ă)
		'266'   => $this->picto['se328'], // n[g 3 (傫 & )
		'267'   => $this->picto['se32e'], // Xp[N 2 (L}[N)
		'268'   => $this->picto['se311'], // e
		'269'   => $this->picto['se11d'], // 
		'270'   => '[SOS]',              // { (SOS)
		'271'   => $this->picto['se14c'], // ͂
		'272'   => $this->picto['se329'], // n[g 5 (Ă)
		'273'   => $this->picto['se003'], // LX}[N
		'274'   => $this->picto['se10c'], // Fl
		'275'   => $this->picto['se443'], // Ȃ
		'276'   => $this->picto['se536'], //  ()
		'277'   => $this->picto['se11a'], // 
		'278'   => $this->picto['se332'], // Ԋ
		'279'   => $this->picto['se315'], // ۔
		'280'   => '[100_]',            // 100__
		'281'   => $this->picto['se00d'], // p`
		'282'   => $this->picto['se330'], // _bV
		'283'   => $this->picto['se05a'], // E`}[N
		'284'   => $this->picto['se00f'], // lwTC
		'285'   => $this->picto['se226'], // }
		'286'   => $this->picto['se11c'], // ǂ
		'287'   => $this->picto['se00e'], // уTC (w)
		'288'   => $this->picto['se12a'], // er
		'289'   => $this->picto['se03c'], // }CN
		'290'   => '[z]',             // z
		'291'   => $this->picto['se326'], // fB
		'292'   => $this->picto['se041'], // M^[ (GL)
		'293'   => '[oCI]',       // oCI (NVbN)
		'294'   => $this->picto['se30a'], // wbhtH
		'295'   => $this->picto['se31c'], // g
		'296'   => $this->picto['se113'], // ANV (sXg)
		'297'   => $this->picto['se31e'], // GXe
		'298'   =>'[EZ]',                // EZ }[N
		'299'   => $this->picto['se216'], //  (FREE)
		'300'   => $this->picto['se126'], // CD/DVD
		'301'   => $this->picto['se319'], // wl
		'302'   => $this->picto['se12b'], // UFO
		'303'   => $this->picto['se213'], // XV (UP!)
		'304'   => $this->picto['se13b'], // ˊ ()
		'305'   => '[]',               // 
		'306'   => $this->picto['se014'], // St
		'307'   => $this->picto['se42a'], // oXPbg{[
		'308'   => '[y[W[]',       // |Pbgx
		'309'   => $this->picto['se502'], // A[g
		'310'   => $this->picto['se503'], // 
		'311'   => $this->picto['se506'], // Cxg (T[JX)
		'312'   => $this->picto['se314'], // {
		'313'   => $this->picto['se34b'], // o[Xf[
		'314'   => $this->picto['se20e'], // Xy[h
		'315'   => $this->picto['se20d'], // _C
		'316'   => $this->picto['se20f'], // Nu
		'317'   => $this->picto['se419'], // 
		'318'   => $this->picto['se41b'], // 
		'319'   => $this->picto['se011'], //  (`L)
		'320'   => $this->picto['se012'], //  (p[)
		'321'   => '',                 // V
		'322'   => $this->picto['se04c'], // ⌇
		'323'   => $this->picto['se04c'], // 
		'324'   => '[CL]',               // NA
		'325'   => $this->picto['se225'], // lp 0
		'326'   => $this->picto['se24d'], //  (OK)
		'327'   => $this->picto['se058'], // ӂӂ ()
		'328'   => $this->picto['se328'], // 킢
		'329'   => $this->picto['se330'], // ǂ (Ռ)
		'330'   => $this->picto['se331'], //  (юU銾)
		'331'   => '[ezplus]',           // C[W[vX
		'332'   => '[n]',             // n
		'333'   => $this->picto['se340'], // [
		'334'   => $this->picto['se212'], // NEW
		'335'   => $this->picto['se006'], // am
		'336'   => $this->picto['se007'], // amC
		'337'   => $this->picto['se00c'], // p\R
		'338'   => $this->picto['se128'], // WI
		'339'   => $this->picto['se032'], // o
		'340'   => $this->picto['se037'], // `y
		'341'   => $this->picto['se434'], // nS
		'342'   => $this->picto['se03b'], // xmR
		'343'   => $this->picto['se03e'], // 
		'344'   => $this->picto['se04e'], // Vg
		'345'   => $this->picto['se050'], // g
		'346'   => $this->picto['se051'], // 
		'347'   => $this->picto['se053'], // ˂
		'348'   => $this->picto['se405'], // EBN ()
		'349'   => $this->picto['se106'], // ڂn[g ()
		'350'   => $this->picto['se107'], // VbLO ()
		'351'   => $this->picto['se108'], //  ()
		'352'   => $this->picto['se10a'], // 
		'353'   => $this->picto['se10d'], // Pbg
		'354'   => $this->picto['se10e'], // 
		'355'   => $this->picto['se111'], // `[ (LXĂ)
		'356'   => $this->picto['se116'], // n}[
		'357'   => $this->picto['se117'], // łグԉ
		'358'   => $this->picto['se118'], // ͂t
		'359'   => $this->picto['se11e'], // d΂
		'360'   => $this->picto['se121'], // 
		'361'   => $this->picto['se122'], // Lv
		'362'   => $this->picto['se12d'], // 
		'363'   => $this->picto['se12e'], // VS (o[TX)
		'364'   => $this->picto['se131'], // gtB[
		'365'   => '[T]',               // J
		'366'   => $this->picto['se511'], // XyC
		'367'   => $this->picto['se512'], // VA
		'368'   => $this->picto['se137'], // H
		'369'   => $this->picto['se13f'], // C
		'370'   => $this->picto['se143'], // j}[N
		'371'   => $this->picto['se44a'], // [X
		'372'   => $this->picto['se147'], // 
		'373'   => $this->picto['se14a'], // 
		'374'   => $this->picto['se152'], // |X
		'375'   => $this->picto['se153'], // X֋
		'376'   => $this->picto['se155'], // a@
		'377'   => $this->picto['se157'], // wZ
		'378'   => $this->picto['se158'], // ze
		'379'   => $this->picto['se202'], // D
		'380'   => $this->picto['se207'], // 18
		'381'   => $this->picto['se20b'], // 
		'382'   => $this->picto['se214'], // COOL!
		'383'   => $this->picto['se227'], // }[N
		'384'   => $this->picto['se228'], // UE}[N
		'385'   => $this->picto['se229'], // ID}[N
		'386'   => $this->picto['se22a'], // }[N
		'387'   => $this->picto['se22b'], // }[N
		'388'   => $this->picto['se22c'], // w}[N
		'389'   => $this->picto['se22d'], // cƒ}[N
		'390'   => $this->picto['se22e'], // w
		'391'   => $this->picto['se22f'], // w
		'392'   => '[肢]',             // 肢 ()
		'393'   => $this->picto['se250'], // }i[[h
		'394'   => $this->picto['se251'], // dOFF
		'395'   => $this->picto['se301'], // 
		'396'   => $this->picto['se302'], // lN^C
		'397'   => $this->picto['se303'], // nCrXJX
		'398'   => $this->picto['se306'], // ԑ
		'399'   => $this->picto['se308'], // T{e
		'400'   => $this->picto['se30b'], // q & t
		'401'   => $this->picto['se047'], // t (r[)
		'402'   => $this->picto['se30d'], // j}[N
		'403'   => $this->picto['se30f'], // ז (JvZ)
		'404'   => $this->picto['se310'], // D
		'405'   => $this->picto['se312'], // NbJ[
		'406'   => '[eznavi]',           // eznavigation
		'407'   => $this->picto['se318'], // Xq
		'408'   => $this->picto['se31b'], // Ou[c
		'409'   => $this->picto['se31d'], // lC
		'410'   => $this->picto['se31f'], // e@
		'411'   => $this->picto['se320'], // 
		'412'   => $this->picto['se321'], // 
		'413'   => $this->picto['se322'], // rLj
		'414'   => $this->picto['se20c'], // n[g (gv)
		'415'   => $this->picto['se327'], // n[g
		'416'   => $this->picto['se32a'], // n[g
		'417'   => $this->picto['se32b'], // ΃n[g
		'418'   => $this->picto['se32c'], // n[g
		'419'   => $this->picto['se32d'], // n[g
		'420'   => $this->picto['se32e'], // 炫
		'421'   => $this->picto['se013'], // XL[
		'422'   => $this->picto['se332'], // 
		'423'   => $this->picto['se338'], // {
		'424'   => $this->picto['se339'], // Hp
		'425'   => $this->picto['se33a'], // \tgN[
		'426'   => $this->picto['se33b'], // |eg
		'427'   => $this->picto['se33c'], // 
		'428'   => $this->picto['se33d'], // ׂ
		'429'   => $this->picto['se33e'], // ͂
		'430'   => $this->picto['se33f'], // XpQeB
		'431'   => $this->picto['se341'], // J[
		'432'   => $this->picto['se343'], // ł
		'433'   => $this->picto['se344'], // i
		'434'   => $this->picto['se345'], // 
		'435'   => $this->picto['se346'], // ݂
		'436'   => $this->picto['se349'], // g}g
		'437'   => $this->picto['se34a'], // Ȃ
		'438'   => $this->picto['se34c'], // ٓ
		'439'   => $this->picto['se34d'], // 
		'440'   => $this->picto['se402'], // ӂ ()
		'441'   => $this->picto['se403'], // ڂ ()
		'442'   => $this->picto['se415'], // ւ ()
		'443'   => $this->picto['se406'], // s ()
		'444'   => $this->picto['se407'], // 킩
		'445'   => $this->picto['se408'], // 
		'446'   => $this->picto['se40a'], // ĂĂ ()
		'447'   => $this->picto['se40b'], //  ()
		'448'   => $this->picto['se40c'], // ׂЂ
		'449'   => $this->picto['se40d'], // M ()
		'450'   => $this->picto['se40e'], //  ()
		'451'   => $this->picto['se410'], // т ()
		'452'   => $this->picto['se40f'], //  ()
		'453'   => $this->picto['se326'], // y
		'454'   => $this->picto['se414'], // ɂɂ ()
		'455'   => $this->picto['se417'], // `[ 2 ()
		'456'   => $this->picto['se418'], // `b ()
		'457'   => $this->picto['se41a'], // @
		'458'   => $this->picto['se41c'], // 
		'459'   => $this->picto['se41d'], // S^肢
		'460'   => $this->picto['se41f'], // 
		'461'   => $this->picto['se420'], // OK! (wŊۃTC)
		'462'   => $this->picto['se421'], // u[CO (w)
		'463'   => $this->picto['se41e'], // oCoC
		'464'   => $this->picto['se423'], // NG (lR)
		'465'   => $this->picto['se424'], // OK! 2 (lR)
		'466'   => $this->picto['se426'], // ӂ (lR)
		'467'   => $this->picto['se425'], // Jbv
		'468'   => $this->picto['se429'], // oj[
		'469'   => $this->picto['se042'], // gybg
		'470'   => $this->picto['se42c'], // r[h
		'471'   => $this->picto['se42d'], // j
		'472'   => $this->picto['se430'], // h
		'473'   => $this->picto['se431'], // ~}
		'474'   => $this->picto['se432'], // pgJ[
		'475'   => $this->picto['se433'], // WFbgR[X^[
		'476'   => $this->picto['se436'], // 叼
		'477'   => $this->picto['se438'], // Ղ
		'478'   => $this->picto['se439'], // Ǝ
		'479'   => $this->picto['se43a'], // w
		'480'   => $this->picto['se43b'], // ̂ڂ
		'481'   => $this->picto['se43c'], // P
		'482'   => $this->picto['se43d'], // ԉ
		'483'   => $this->picto['se43f'], // X
		'484'   => $this->picto['se440'], // ԉ
		'485'   => $this->picto['se441'], // L
		'486'   => $this->picto['se442'], // 
		'487'   => $this->picto['se445'], // nEB
		'488'   => $this->picto['se446'], // 
		'489'   => $this->picto['se448'], // T^
		'490'   => $this->picto['se44b'], // ^ꐯ
		'491'   => $this->picto['se44c'], // 
		'492'   => $this->picto['se501'], // ze 2
		'493'   => $this->picto['se449'], // ̏o
		'494'   => $this->picto['se503'], // VNnbg
		'495'   => $this->picto['se504'], // fp[g
		'496'   => $this->picto['se505'], //  ({)
		'497'   => $this->picto['se506'], //  ([bp)
		'498'   => $this->picto['se508'], // H 2
		'499'   => $this->picto['se50d'], // tX
		'500'   =>'[I[vEF[u]',  // I[vEF[u
		'501'   => $this->picto['se144'], // bNmF
		'502'   => '[ABC]',              // 啶
		'503'   => '[abc]',              // 
		'504'   => '[012]',              // 
		'505'   => '[,@#]',              // L
		'506'   => '[]',               // ANZvg
		'507'   => '',                 // `FbN{bNX
		'508'   => $this->picto['se301'], // GfBbg
		'509'   => '',                 // WI{^
		'510'   => $this->picto['se114'], //  (ዾ)
		'511'   => $this->picto['se23b'], // ߂
		'512'   => $this->picto['se203'], // Cɓ
		'513'   => $this->picto['se104'], // I
		'514'   => $this->picto['se036'], // z[
		'515'   => $this->picto['se101'], // M 1
		'516'   => $this->picto['se219'], // }[N
		'517'   => $this->picto['se144'], // l ()
		'518'   => '[ēǂݍ]',       // ēǂݍ
		'700'   => $this->picto['se50e'], // hCc
		'701'   => $this->picto['se50f'], // C^A
		'702'   => $this->picto['se510'], // CMX
		'703'   => $this->picto['se513'], // 
		'704'   => $this->picto['se514'], // ؍
		'705'   => $this->picto['se515'], // l
		'706'   => $this->picto['se516'], // l
		'707'   => $this->picto['se517'], // Chl
		'708'   => $this->picto['se518'], // 
		'709'   => $this->picto['se519'], // ΂
		'710'   => $this->picto['se51a'], // Ԃ
		'711'   => $this->picto['se51b'], // H̐l
		'712'   => $this->picto['se51c'], // Pl
		'713'   => $this->picto['se520'], // CJ
		'714'   => $this->picto['se51f'], // _X
		'715'   => $this->picto['se522'], // Mы
		'716'   => $this->picto['se525'], // 
		'717'   => $this->picto['se526'], // 
		'718'   => $this->picto['se527'], // RA
		'719'   => $this->picto['se52b'], // zX^C
		'720'   => $this->picto['se52d'], // wr
		'721'   => $this->picto['se52e'], // {
		'722'   => $this->picto['se52f'], // ڂ
		'723'   => $this->picto['se530'], // ӂԂ炭
		'724'   => $this->picto['se532'], // A^
		'725'   => $this->picto['se533'], // B^
		'726'   => $this->picto['se534'], // O^
		'727'   => $this->picto['se535'], // AB^
		'728'   => $this->picto['se536'], // 
		'729'   => $this->picto['se007'], // Xj[J[
		'730'   => $this->picto['se50b'], // 
		'731'   => $this->picto['se236'], // J[u
		'732'   => $this->picto['se238'], // J[u
		'733'   => $this->picto['se337'] . $this->picto['se336'], // u!?v
		'734'   => $this->picto['se337'] . $this->picto['se337'], // u!!v
		'735'   => '-o-',                // 
		'736'   => '[]',           // 
		'737'   => '[pCibv]',     // pCibv
		'738'   => '[]',             // Ԃǂ
		'739'   => '[oii]',           // oii
		'740'   => '[Ƃ낱]',     // Ƃ낱
		'741'   => '[̂]',           // ̂
		'742'   => '[I]',               // I
		'743'   => '[]',               // 
		'744'   => '[Ĉ]',             // ₫
		'745'   => '[sU]',             // sU
		'746'   => '[^[L[]',         // ^[L[
		'747'   => '[[]',             // [
		'748'   => $this->picto['se045'], // gsJhN
		'749'   => '[C]',               // C
		'750'   => '[sAm]',           // sAm
		'751'   => $this->picto['se017'], // T[tB
		'752'   => $this->picto['se019'], // ނ
		'753'   => '[{EO]',       // {EO
		'754'   => '[Ȃ܂͂]',         // Ȃ܂͂
		'755'   => '[V]',             // V
		'756'   => '[p_]',           // p_
		'757'   => $this->picto['se105'], // ׁ[
		'758'   => $this->picto['se10b'], // Ԃ̕@
		'759'   => $this->picto['se032'], // 
		'760'   => $this->picto['se33a'], // ACXN[
		'761'   => '',                 // h[ic
		'762'   => '[NbL[]',         // NbL[
		'763'   => $this->picto['se437'], // `R
		'764'   => '[LfB]',       // LfB ()
		'765'   => '[؂؂LfB]',// LfB (؂؂)
		'766'   => '(/__)',             //  ()
		'767'   => '(ExE)',            // 킴 ()
		'768'   => '|(E_E)|',          //  ()
		'769'   => $this->picto['se03b'], // ΎR
		'770'   => $this->picto['se314'] . $this->picto['se022'], // {̃n[g
		'771'   => '[ABC]',             // puABCv
		'772'   => '[v]',          // v
		'773'   => '[I]',            // ~co`
		'774'   => '[ĂƂ]',      // egEV
		'775'   => '[I|bg]',      // I|bg
		'776'   => $this->picto['se345'], // 
		'777'   => $this->picto['se04e'], // Ĥ͂D
		'778'   => $this->picto['se407'], // ڂ܂鎞̋L
		'779'   => $this->picto['se416'], // Ձ[ (킢{)
		'780'   => $this->picto['se416'], // Ձ[ (킢{) (lR)
		'781'   => $this->picto['se44b'], // V̐
		'782'   => $this->picto['se417'], // `[ (lR)
		'783'   => $this->picto['se414'], // ɂ (lR)
		'784'   => $this->picto['se103'], // [
		'785'   => $this->picto['se412'], // ΂ (lR)
		'786'   => $this->picto['se412'], // ΂ ()
		'787'   => $this->picto['se106'], // ڂn[g (lR)
		'788'   => $this->picto['se410'], // ق[ (lR)
		'789'   => $this->picto['se410'], // ق[ ()
		'790'   => $this->picto['se413'], // ܂ۂ (lR)
		'791'   => $this->picto['se413'], // ܂ۂ ()
		'792'   => $this->picto['se402'], //  (lR)
		'793'   => $this->picto['se319'], // hX
		'794'   => '[C]',         // C
		'795'   => $this->picto['se039'], // w
		'796'   => '[ԎD]',             // ԎD
		'797'   => $this->picto['se519'], // W[J[
		'798'   => '[CVtC]',       // GrtC
		'799'   => $this->picto['se101'], // e[ACR
		'800'   => $this->picto['se201'], // l
		'801'   => $this->picto['se432'], // pgJ[̃v
		'802'   => $this->picto['se03d'], // ezmovie
		'803'   => $this->picto['se328'], // hLhLĂn[g
		'804'   => $this->picto['se523'], // ʌ̂Ђ悱
		'805'   => '',                 // W[Y
		'806'   => $this->picto['se329'], // n[g[
		'807'   => '[z]',         // z
		'808'   => '',                 // E
		'809'   => '',               // ㉺
		'810'   => $this->picto['se43e'], // rg
		'811'   => $this->picto['se447'], // ot
		'812'   => $this->picto['se441'], // ނ
		'813'   => $this->picto['se415'], //  (lR)
		'814'   => $this->picto['se415'], //  ()
		'815'   => $this->picto['se101'], // C[ACR
		'816'   => $this->picto['se447'], // n[u
		'817'   => $this->picto['se010'], //  (O[)
		'818'   => $this->picto['se210'], // u#v
		'819'   => $this->picto['se012'], //  (LN^[)
		'820'   => $this->picto['se422'], //  (LN^[)
		'821'   => $this->picto['se403'], // ڂ (LN^[)
		'822'   => $this->picto['se416'], // 킢{ (LN^[)
		'd001'  => $this->picto['se04a'], // 
		'd002'  => $this->picto['se049'], // ܂
		'd003'  => $this->picto['se04b'], // J
		'd004'  => $this->picto['se048'], //  
		'd005'  => $this->picto['se13d'], // 
		'd006'  => $this->picto['se443'], // 䕗
		'd007'  => '[]',               // 
		'd008'  => $this->picto['se43c'], // J
		'd009'  => $this->picto['se23f'], // r
		'd010'  => $this->picto['se240'], // 
		'd011'  => $this->picto['se241'], // oq
		'd012'  => $this->picto['se242'], // I
		'd013'  => $this->picto['se243'], // q
		'd014'  => $this->picto['se244'], // 
		'd015'  => $this->picto['se245'], // V
		'd016'  => $this->picto['se246'], // 嶍
		'd017'  => $this->picto['se247'], // ˎ
		'd018'  => $this->picto['se248'], // Rr
		'd019'  => $this->picto['se249'], // r
		'd020'  => $this->picto['se24a'], // 
		'd021'  => $this->picto['se322'], // X|[c
		'd022'  => $this->picto['se016'], // 싅
		'd023'  => $this->picto['se014'], // St
		'd024'  => $this->picto['se015'], // ejX
		'd025'  => $this->picto['se018'], // TbJ[
		'd026'  => $this->picto['se013'], // XL[
		'd027'  => $this->picto['se42a'], // oXPbg{[
		'd028'  => $this->picto['se132'], // [^[X|[c (`FbJ[tbO)
		'd029'  => '[y[W[]',       // |Pbgx
		'd030'  => $this->picto['se01e'], // d
		'd031'  => $this->picto['se434'], // nS
		'd032'  => $this->picto['se435'], // V
		'd033'  => $this->picto['se01b'], //  (Z_)
		'd034'  => $this->picto['se42e'], //  (RV)
		'd035'  => $this->picto['se159'], // oX
		'd036'  => $this->picto['se202'], // D
		'd037'  => $this->picto['se01d'], // s@
		'd038'  => $this->picto['se036'], // 
		'd039'  => $this->picto['se038'], // r
		'd040'  => $this->picto['se153'], // X֋
		'd041'  => $this->picto['se155'], // a@
		'd042'  => $this->picto['se14d'], // s
		'd043'  => $this->picto['se154'], // ATM
		'd044'  => $this->picto['se158'], // ze
		'd045'  => $this->picto['se156'], // Rrj
		'd046'  => $this->picto['se03a'], // K\X^h
		'd047'  => $this->picto['se14f'], // ԏ
		'd048'  => $this->picto['se14e'], // M
		'd049'  => $this->picto['se151'], // gC
		'd050'  => $this->picto['se043'], // Xg
		'd051'  => $this->picto['se045'], // iX
		'd052'  => $this->picto['se044'], // o[ (}eB[j)
		'd053'  => $this->picto['se047'], // r[
		'd054'  => $this->picto['se120'], // t@[Xgt[h (no[K[)
		'd055'  => $this->picto['se13e'], // ueBbN
		'd056'  => $this->picto['se313'], // e@ ()
		'd057'  => $this->picto['se03c'], // JIP
		'd058'  => $this->picto['se03d'], // f
		'd059'  => $this->picto['se236'], // E΂ߏ
		'd060'  => $this->picto['se124'], // Vn (ؔn)
		'd061'  => $this->picto['se30a'], // y (wbhz)
		'd062'  => $this->picto['se502'], // A[g
		'd063'  => $this->picto['se503'], // 
		'd064'  => $this->picto['se506'], // Cxg (T[JX)
		'd065'  => $this->picto['se125'], // `Pbg
		'd066'  => $this->picto['se30e'], // i
		'd067'  => $this->picto['se208'], // ։
		'd068'  => $this->picto['se008'], // J
		'd069'  => $this->picto['se323'], // Jo
		'd070'  => $this->picto['se148'], // {
		'd071'  => $this->picto['se314'], // {
		'd072'  => $this->picto['se112'], // v[g
		'd073'  => $this->picto['se34b'], // o[Xf[
		'd074'  => $this->picto['se009'], // db
		'd075'  => $this->picto['se00a'], // gѓdb
		'd076'  => $this->picto['se301'], // 
		'd077'  => $this->picto['se12a'], // TV
		'd078'  => $this->picto['se12b'], // Q[
		'd079'  => $this->picto['se126'], // CD
		'd080'  => $this->picto['se20c'], // n[g
		'd081'  => $this->picto['se20e'], // Xy[h
		'd082'  => $this->picto['se20d'], // _C
		'd083'  => $this->picto['se20f'], // Nu
		'd084'  => $this->picto['se419'], // 
		'd085'  => $this->picto['se41b'], // 
		'd086'  => $this->picto['se010'], //  (O[)
		'd087'  => $this->picto['se011'], //  (`L)
		'd088'  => $this->picto['se012'], //  (p[)
		'd089'  => $this->picto['se238'], // E΂߉
		'd090'  => $this->picto['se237'], // ΂ߏ
		'd091'  => $this->picto['se536'], // 
		'd092'  => $this->picto['se007'], // 
		'd093'  => $this->picto['se214'], // ዾ
		'd094'  => $this->picto['se20a'], // Ԉ֎q
		'd095'  => '',                 // V
		'd096'  => $this->picto['se04c'], // ⌇
		'd097'  => $this->picto['se04c'], // 
		'd098'  => $this->picto['se04c'], // O
		'd099'  => '',                 // 
		'd100'  => $this->picto['se052'], // 
		'd101'  => $this->picto['se04f'], // L
		'd102'  => $this->picto['se01c'], // ][g (bg)
		'd103'  => $this->picto['se033'], // NX}X
		'd104'  => $this->picto['se239'], // ΂߉
		'd105'  => $this->picto['se104'], // phone to
		'd106'  => $this->picto['se103'], // mail to
		'd107'  => $this->picto['se00b'], // fax to
		'd108'  => '[i]',                // i[h
		'd109'  => '[i]',                // i[h (gt)
		'd110'  => $this->picto['se103'], // [
		'd111'  => '[hR]',       // hR
		'd112'  => '[D]',                // hR|Cg
		'd113'  => $this->picto['se215'], // L
		'd114'  => $this->picto['se216'], // 
		'd115'  => $this->picto['se229'], // ID
		'd116'  => $this->picto['se03f'], // pX[h
		'd117'  => '',               // L
		'd118'  => '[CL]',               // NA
		'd119'  => $this->picto['se114'], // T[` (ׂ)
		'd120'  => $this->picto['se212'], // NEW
		'd121'  => $this->picto['se14b'], // ʒu
		'd122'  => $this->picto['se211'], // t[_C
		'd123'  => $this->picto['se210'], // V[v_C
		'd124'  => 'Q',                  // oQ
		'd125'  => $this->picto['se21c'], // 1 (one)
		'd126'  => $this->picto['se21d'], // 2 (two)
		'd127'  => $this->picto['se21e'], // 3 (three)
		'd128'  => $this->picto['se21f'], // 4 (four)
		'd129'  => $this->picto['se220'], // 5 (five)
		'd130'  => $this->picto['se221'], // 6 (six)
		'd131'  => $this->picto['se222'], // 7 (seven)
		'd132'  => $this->picto['se223'], // 8 (eight)
		'd133'  => $this->picto['se224'], // 9 (nine)
		'd134'  => $this->picto['se225'], // 0 (zero)
		'd135'  => $this->picto['se24d'], //  (OK)
		'd136'  => $this->picto['se022'], // n[g
		'd137'  => $this->picto['se328'], // hn[g
		'd138'  => $this->picto['se023'], // 
		'd139'  => $this->picto['se328'], // n[g (n[g)
		'd140'  => $this->picto['se056'], // [ ()
		'd141'  => $this->picto['se059'], //  ({)
		'd142'  => $this->picto['se057'], // ` (_)
		'd143'  => $this->picto['se407'], // ₾` (߂)
		'd144'  => $this->picto['se406'], // ӂӂ
		'd145'  => $this->picto['se236'], // Obh ()
		'd146'  => $this->picto['se03e'], //  ()
		'd147'  => $this->picto['se123'], // C ()
		'd148'  => $this->picto['se204'], // 킢
		'd149'  => $this->picto['se003'], // LX}[N
		'd150'  => $this->picto['se32e'], // ҂҂ (V)
		'd151'  => $this->picto['se10f'], // Ђ߂
		'd152'  => $this->picto['se334'], // ނ ({)
		'd153'  => $this->picto['se00d'], // p`
		'd154'  => $this->picto['se311'], // e
		'd155'  => $this->picto['se326'], // [h
		'd156'  => $this->picto['se238'], // obh ()
		'd157'  => $this->picto['se13c'], //  ()
		'd158'  => $this->picto['se021'], // exclamation
		'd159'  => $this->picto['se021'] . $this->picto['se020'], // exclamation and question
		'd160'  => $this->picto['se021'], // double exclamation
		'd161'  => $this->picto['se330'], // ǂ (Ռ)
		'd162'  => $this->picto['se331'], //  (юU銾)
		'd163'  => $this->picto['se108'], // [ ()
		'd164'  => $this->picto['se330'], // _bV (o)
		'd165'  => '``',               // [ (L1)
		'd166'  => '-o-',                // [ (L2)
		'd167'  => $this->picto['se324'], // J`R
		'd168'  => $this->picto['se12f'], // ӂ
		'd169'  => $this->picto['se301'], // y
		'd170'  => $this->picto['se056'], // le
		'd171'  => $this->picto['se11f'], // 
		'd172'  => $this->picto['se44b'], // 
		'd173'  => 'SOON',             // soon
		'd174'  => 'ON',             // on
		'd175'  => 'END',              // end
		'd176'  => $this->picto['se026'], // v
		'd201'  => '',                 // iAv
		'd202'  => '[]',               // iAv (gt)
		'd203'  => $this->picto['se006'], // TVc ({[_[)
		'd204'  => '[z]',             // ܌z
		'd205'  => $this->picto['se31c'], // 
		'd206'  => '',                 // W[Y
		'd207'  => $this->picto['se013'], // Xm{
		'd208'  => $this->picto['se325'], // `y
		'd209'  => '[hA]',             // hA
		'd210'  => $this->picto['se12f'], // h
		'd211'  => $this->picto['se00c'], // p\R
		'd212'  => $this->picto['se101'] . $this->picto['se022'], // u^[
		'd213'  => $this->picto['se116'], // `
		'd214'  => $this->picto['se301'], // M
		'd215'  => $this->picto['se10e'], // 
		'd216'  => $this->picto['se034'], // w
		'd217'  => '[v]',           // v
		'd218'  => $this->picto['se136'], // ]
		'd219'  => $this->picto['se338'], // ̂
		'd220'  => $this->picto['se026'], // rv
		'd221'  => $this->picto['se403'], // lĂ
		'd222'  => $this->picto['se40a'], // قƂ
		'd223'  => $this->picto['se415'] . $this->picto['se331'], // ⊾ ()
		'd224'  => $this->picto['se108'], // ⊾2 ()
		'd225'  => $this->picto['se416'], // ՂȊ
		'd226'  => $this->picto['se40e'], // {P[Ƃ
		'd227'  => $this->picto['se106'], // ڂn[g ()
		'd228'  => $this->picto['se00e'], // wOK
		'd229'  => $this->picto['se105'], // ׁ[
		'd230'  => $this->picto['se405'], // EBN
		'd231'  => $this->picto['se40a'], // ꂵ
		'd232'  => $this->picto['se406'], // ܂
		'd233'  => $this->picto['se402'], // L2
		'd234'  => $this->picto['se411'], // 
		'd235'  => $this->picto['se413'], // 
		'd236'  => $this->picto['se423'], // NG
		'd237'  => $this->picto['se301'], // Nbv
		'd238'  => $this->picto['se24e'], // Rs[Cg (C)
		'd239'  => $this->picto['se537'], // g[h}[N (TM)
		'd240'  => $this->picto['se115'], // l
		'd241'  => $this->picto['se315'], // }
		'd242'  => '[TCN]',       // TCN
		'd243'  => $this->picto['se24f'], // WX^[hg[h}[N (R)
		'd244'  => $this->picto['se252'], // 댯Ex (!)
		'd245'  => '[]',               // ֎~
		'd246'  => $this->picto['se22b'], // 󎺁EȁE
		'd247'  => '[i]',             // i}[N
		'd248'  => $this->picto['se22a'], // EȁE
		'd249'  => '',                 // 󍶉E
		'd250'  => '',               // ㉺
		'd251'  => $this->picto['se157'], // wZ
		'd252'  => $this->picto['se43e'], // g
		'd253'  => $this->picto['se03b'], // xmR
		'd254'  => $this->picto['se110'], // N[o[
		'd255'  => '[]',       // 
		'd256'  => $this->picto['se304'], // `[bv
		'd257'  => '[oii]',           // oii
		'd258'  => $this->picto['se345'], // 
		'd259'  => $this->picto['se110'], // 
		'd260'  => $this->picto['se118'], // ݂
		'd261'  => $this->picto['se030'], // 
		'd262'  => $this->picto['se342'], // ɂ
		'd263'  => $this->picto['se046'], // V[gP[L
		'd264'  => $this->picto['se30b'], // Ƃ (傱t)
		'd265'  => $this->picto['se340'], // ǂԂ
		'd266'  => $this->picto['se339'], // p
		'd267'  => $this->picto['se441'], // ނ
		'd268'  => $this->picto['se523'], // Ђ悱
		'd269'  => $this->picto['se055'], // yM
		'd270'  => $this->picto['se019'], // 
		'd271'  => $this->picto['se056'], // ܂! ()
		'd272'  => $this->picto['se415'], // EbVbV ()
		'd273'  => $this->picto['se01a'], // E}
		'd274'  => $this->picto['se10b'], // u^
		'd275'  => $this->picto['se044'], // COX
		'd276'  => $this->picto['se107'], //  ()
		'e253'  => $this->picto['se00f'], // lw
		'e254'  => $this->picto['se425'], // Jbv
		'e255'  => $this->picto['se209'], // t}[N
		'e256'  => $this->picto['se041'], // M^[
		'e257'  => $this->picto['se14a'], // `[g
		'e258'  => $this->picto['se207'], // 18Έȏ֎~
		'e259'  => $this->picto['se12d'], // v
		'e260'  => $this->picto['se428'], // R~jeB
		'e261'  => '[HIT]',              // qbg
		'e262'  => '[V]',             // V
		'e263'  => $this->picto['se448'], // T^N[X
		'e264'  => $this->picto['se428'], // Ƒ
		'e265'  => '@',               // [gp]
		'e266'  => '',               // RC
		'e267'  => '@',               // [gp]
		'e268'  => '@',               // [gp]
		'e269'  => 'EM',               // EMOBILE S (n)
		'e270'  => 'EM',               // EMOBILE S (Ԓn)
		'e271'  => '@',               // [gp]
		'e272'  => '@',               // [gp]
		'e273'  => '@',               // [gp]
		'e274'  => '@',               // [gp]
		'e275'  => '@',               // [gp]
		'e276'  => '@',               // [gp]
		'e277'  => '@',               // [gp]
		'e278'  => '@',               // [gp]
		'wf040' => $this->picto['se022'], // n[g
		'wf041' => $this->picto['se026'], // v
		'wf042' => $this->picto['se009'], // db
		'wf043' => $this->picto['se045'], // Jbv
		'wf044' => '*',                  // *
		'wf045' => '',               // ㉺ ()
		'wf046' => '',                 // E ()
		'wf047' => '(((',                // dg ()
		'wf048' => $this->picto['se04a'], // 
		'wf049' => $this->picto['se04b'], // J
		'wf04a' => $this->picto['se049'], // ܂
		'wf04b' => $this->picto['se108'], // 
		'wf04c' => $this->picto['se056'], // Ί
		'wf04d' => $this->picto['se003'], //  (LX}[N)
		'wf04e' => $this->picto['se03e'], // fB (\Z)
		'wf04f' => $this->picto['se01b'], // 
		'wf050' => $this->picto['se01e'], // d
		'wf051' => $this->picto['se01d'], // s@
		'wf052' => '[oCN]'          , // oCN
		'wf053' => $this->picto['se036'], // 
		'wf054' => $this->picto['se038'], // r
		'wf055' => $this->picto['se011'], // s[X ()
		'wf056' => $this->picto['se043'], // fBi[ (iCtƃtH[N)Xg)
		'wf057' => $this->picto['se044'], // OX)
		'wf058' => $this->picto['se413'], //  ()
		'wf059' => $this->picto['se304'], // `[bv
		'wf05a' => $this->picto['se016'], // 싅 (obg)
		'wf05b' => $this->picto['se016'], // {[
		'wf05c' => $this->picto['se010'], // p` ()
		'wf05d' => $this->picto['se13d'], // 
		'wf05e' => $this->picto['se059'], // {
		'wf05f' => $this->picto['se047'], // r[
		'wf060' => $this->picto['se301'], // m[g
		'wf061' => $this->picto['se301'], // y (M)
		'wf062' => $this->picto['se11c'], // hN
		'wf063' => $this->picto['se101'], // [
		'wf064' => $this->picto['se208'], // ։
		'wf065' => $this->picto['se325'], // x
		'wf066' => $this->picto['se030'], // 
		'wf067' => $this->picto['se123'], // 
		'wf068' => $this->picto['se04c'], //  (26)
		'wf069' => $this->picto['se50b'], // 
		'wf06a' => $this->picto['se40c'], // }XN ()
		'wf06b' => $this->picto['se30a'], // R[h
		'wf06c' => '[]',               // 
		'wf06d' => $this->picto['se052'], // 
		'wf06e' => $this->picto['se04f'], // L
		'wf06f' => $this->picto['se109'], // 
		'wf070' => $this->picto['se526'], // 
		'wf071' => $this->picto['se10a'], // 
		'wf072' => $this->picto['se340'], // k[h
		'wf073' => $this->picto['se03c'], // }CN (JIP)
		'wf074' => $this->picto['se334'], // ނ ({)
		'wf075' => $this->picto['se523'], // Ђ悱
		'wf076' => $this->picto['se408'], // 
		'wf077' => $this->picto['se045'], // R[q[
		'wf078' => $this->picto['se30e'], // ^oR
		'wf079' => $this->picto['se331'], // 
		'wf07a' => $this->picto['se342'], // ɂ
		'wf07b' => $this->picto['se323'], // Jo
		'wf07c' => $this->picto['se05a'], // 
		'wf07d' => $this->picto['se302'], // lN^C
		'wf07e' => $this->picto['se006'], // Vc
		'wf080' => $this->picto['se348'], // 
		'wf081' => $this->picto['se43f'], // JLX
		'wf082' => $this->picto['se322'], // rLj
		'wf083' => $this->picto['se313'], // ͂
		'wf084' => $this->picto['se13b'], // 
		'wf085' => $this->picto['se202'], // D (d)
		'wf086' => $this->picto['se531'], // 
		'wf087' => $this->picto['se012'], // oCoC ()
		'wf088' => $this->picto['se023'], // 
		'wf089' => $this->picto['se20d'], // _C (gv)v)
		'wf08a' => $this->picto['se20f'], // N[o[ (gv)
		'wf08b' => $this->picto['se20e'], // Xy[h (gv))
		'wf08c' => $this->picto['se301'], // Nbv
		'wf08d' => $this->picto['se048'], // Ⴞ
		'wf08e' => $this->picto['se34b'], // P[L
		'wf08f' => $this->picto['se345'], // 
		'wf090' => $this->picto['se112'], // v[g
		'wf091' => $this->picto['se12f'], //  (h)
		'wf092' => '[EXIT]',             // o
		'wf093' => '[hA]',             // 
		'wf094' => $this->picto['se518'], // ₶
		'wf095' => $this->picto['se00a'], // PHS
		'wf096' => $this->picto['se32f'], // 
		'wf097' => $this->picto['se125'], // `Pbg
		'wf098' => $this->picto['se328'], // n[g
		'wf099' => $this->picto['se10f'], // Ђ߂
		'wf09a' => $this->picto['se536'], // 
		'wf09b' => $this->picto['se057'], // Ί
		'wf09c' => $this->picto['se015'], // ejX
		'wf09d' => $this->picto['se03d'], // f
		'wf09e' => $this->picto['se013'], // XL[
		'wf09f' => $this->picto['se337'].$this->picto['se337'], // !!
		'wf0a0' => $this->picto['se337'].$this->picto['se336'], // !?
		'wf0a1' => $this->picto['se336'], // ?
		'wf0a2' => $this->picto['se238'], // ~ ()
		'wf0a3' => $this->picto['se236'], // ㏸ ()
		'wf0a4' => $this->picto['se00e'], // Obh (ew)
		'wf0a5' => $this->picto['se14c'], // ͂
		'wf0a6' => $this->picto['se329'], // L[sbg (n[gƖ)
		'wf0a7' => $this->picto['se332'], // ܂
		'wf0a8' => $this->picto['se443'], // 䕗
		'wf0a9' => $this->picto['se43e'], // C
		'wf0aa' => $this->picto['se017'], // T[tB
		'wf0ab' => $this->picto['se04d'], // R
		'wf0ac' => $this->picto['se03b'], // xmR
		'wf0ad' => $this->picto['se122'], // Lv
		'wf0ae' => $this->picto['se119'], // t
		'wf0af' => $this->picto['se159'], // oX
		'wf0b0' => $this->picto['se018'], // TbJ[
		'wf0b1' => $this->picto['se209'], // S
		'wf0b2' => $this->picto['se23d'], // ߂
		'wf0b3' => $this->picto['se23c'], // 
		'wf0b4' => '[dv]',             // dv
		'wf0b5' => $this->picto['se207'], // 18
		'wf0b6' => $this->picto['se252'], // 
		'wf0b7' => '[TCN]',       // TCN
		'wf0b8' => $this->picto['se20b'], // dEx
		'wf0b9' => ')))',                // dg (E)
		'wf0ba' => $this->picto['se333'], // oc
		'wf0bb' => $this->picto['se24e'], // Rs[Cg
		'wf0bc' => $this->picto['se24f'], // WX^[hg[h}[N
		'wf0bd' => $this->picto['se133'], // X[Zu
		'wf0be' => $this->picto['se225'], // 0 (zero)
		'wf0bf' => $this->picto['se21c'], // 1 (one)
		'wf0c0' => $this->picto['se21d'], // 2 (two)
		'wf0c1' => $this->picto['se21e'], // 3 (three)
		'wf0c2' => $this->picto['se21f'], // 4 (four)
		'wf0c3' => $this->picto['se220'], // 5 (five)
		'wf0c4' => $this->picto['se221'], // 6 (six)
		'wf0c5' => $this->picto['se222'], // 7 (seven)
		'wf0c6' => $this->picto['se223'], // 8 (eight)
		'wf0c7' => $this->picto['se224'], // 9 (nine)
		'wf0c8' => $this->picto['se23f'], // r
		'wf0c9' => $this->picto['se240'], // 
		'wf0ca' => $this->picto['se241'], // oq
		'wf0cb' => $this->picto['se242'], // I
		'wf0cc' => $this->picto['se243'], // q
		'wf0cd' => $this->picto['se244'], // 
		'wf0ce' => $this->picto['se245'], // V
		'wf0cf' => $this->picto['se246'], // 嶍
		'wf0d0' => $this->picto['se24b'], // ւт
		'wf0d1' => $this->picto['se247'], // ˎ
		'wf0d2' => $this->picto['se248'], // Rr
		'wf0d3' => $this->picto['se249'], // r
		'wf0d4' => $this->picto['se24a'], // 
		'wf0d5' => '[n]',             // n
		'wf0d6' => $this->picto['se120'], // }Nhih
		'wf0d7' => $this->picto['se120'], // Xo[K[
		'wf0d8' => '@',                 // [gp]
		'wf0d9' => $this->picto['se120'], // beA
		'wf0da' => '@',                 // [gp]
		'wf0db' => $this->picto['se045'], // hg[R[q[
		'wf0dc' => '@',                 // [gp]
		'wf0dd' => '@',                 // [gp]
		'wf0de' => '@',                 // [gp]
		'wf0df' => '@',                 // [gp]
		'wf0e0' => $this->picto['se043'], //  (o[~?)
		'wf0e1' => '@',                 // [gp]
		'wf0e2' => '@',                 // [gp]
		'wf0e3' => $this->picto['se043'], // тhL[
		'wf0e4' => '@',                 // [gp]
		'wf0e5' => '@',                 // [gp]
		'wf0e6' => '@',                 // [gp]
		'wf0e7' => $this->picto['se156'], // [\
		'wf0e8' => '@',                 // [gp]
		'wf0e9' => $this->picto['se156'], // am/pm
		'wf0ea' => '@',                 // [gp]
		'wf0eb' => '@',                 // [gp]
		'wf0ec' => '@',                 // [gp]
		'wf0ed' => '@',                 // [gp]
		'wf0ee' => '@',                 // [gp]
		'wf0ef' => '@',                 // [gp]
		'wf0f0' => $this->picto['se504'], // 
		'wf0f1' => '@',                 // [gp]
		'wf0f2' => '@',                 // [gp]
		'wf0f3' => '@',                 // [gp]
		'wf0f4' => '@',                 // [gp]
		'wf0f5' => '@',                 // [gp]
		'wf0f6' => '@',                 // [gp]
		'wf0f7' => '@',                 // [gp]
		'wf0f8' => '@',                 // [gp]
		'wf0f9' => '@',                 // [gp]
		'wf0fa' => '@',                 // [gp]
		'wf0fb' => '@',                 // [gp]
		'wf0fc' => $this->picto['se052'], // n`
		'wf140' => '[C]',         // C
		'wf141' => '@',                 // [gp]
		'wf142' => '@',                 // [gp]
		'wf143' => '@',                 // [gp]
		'wf144' => '@',                 // [gp]
		'wf145' => '@',                 // [gp]
		'wf146' => '@',                 // [gp]
		'wf147' => '@',                 // [gp]
		'wf148' => $this->picto['se14d'], // UFJ
		'wf149' => '@',                 // [gp]
		'wf14a' => '@',                 // [gp]
		'wf14b' => '@',                 // [gp]
		'wf14c' => '@',                 // [gp]
		'wf14d' => '[EXIT]',             // 
		'wf14e' => '@',                 // [gp]
		'wf14f' => '@',                 // [gp]
		'wf150' => $this->picto['se411'], // 
		'wf151' => '@',                 // [gp]
		'wf152' => '@',                 // [gp]
		'wf153' => '@',                 // [gp]
		'wf154' => '@',                 // [gp]
		'wf155' => '@',                 // [gp]
		'wf156' => '@',                 // [gp]
		'wf157' => '@',                 // [gp]
		'wf158' => '@',                 // [gp]
		'wf159' => '@',                 // [gp]
		'wf15a' => '@',                 // [gp]
		'wf15b' => '@',                 // [gp]
		'wf15c' => '@',                 // [gp]
		'wf15d' => '@',                 // [gp]
		'wf15e' => '@',                 // [gp]
		'wf15f' => '@',                 // [gp]
	));
	$buffer = preg_replace(
		'!<img localsrc="([^"]+)"( alt="([^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*)")?[^/>]*/?>!se', 
		'isset($trans["$1"]) ? $trans["$1"] : ("$3" ? "$3" : "")', 
		$buffer);
	$entities = array(
		'&spades;' => self::$pics['se20e'],
		'&#9824;'  => self::$pics['se20e'],
		'&#x2660;' => self::$pics['se20e'],
		'&clubs;'  => self::$pics['se20f'],
		'&#9827;'  => self::$pics['se20f'],
		'&#x2663;' => self::$pics['se20f'],
		'&hearts;' => self::$pics['se20c'],
		'&#9829;'  => self::$pics['se20c'],
		'&#x2665;' => self::$pics['se20c'],
		'&#9825;'  => self::$pics['se022'], // WHITE HEART
		'&#x2661;' => self::$pics['se022'], // WHITE HEART
		'&diams;'  => self::$pics['se20d'],
		'&#9830;'  => self::$pics['se20d'],
		'&#x2666;' => self::$pics['se20d'],
		'&#12336;' => '``', // WAVY DASH
		'&#x3030;' => '``', // WAVY DASH

	);
	$buffer = str_replace(array_keys($entities), $entities, $buffer);

	// ----- shrink escape sequences -----
	$count = version_compare(phpversion(), '5.1', '>=');
	while ($count) {
		$buffer = preg_replace("/(\x1b\\\$[A-Z])([!-z]+)\x0f\\1/", '$1$2', $buffer, -1, $count); // available after PHP 5.1.0
	}
	return parent::convert_pict($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	return parent::shrink_post_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function pickup_pics($buffer) {
	$buffer = $this->pickup_pics_webcode($buffer);
	$buffer = $this->pickup_pics_shift_jis($buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
private function pickup_pics_webcode($buffer) {
	$seq_index = array('G' => '0', 'E' => '1', 'F' => '2', 'O' => '3', 'P' => '4', 'Q' => '5');
	for ($offset = 0 , $replace = 'X' ;
	     preg_match('/\x1b.([GEFOPQ])([!-z]+)(\x0f|$)/', $buffer, $webcode, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace)) 
	{
		$orig    = $webcode[0][0];
		$offset  = $webcode[0][1];
		$seq     = $webcode[1][0];
		$chars   = $webcode[2][0];
		$replace = '';
		for ($i = 0 ; $i < strlen($chars) ; $i++) {
			if (ord($char[$i]) - 32 <= $this->num_chars[$seq]) {
				$replace .= sprintf('<img localsrc="se%d%02x" />', $seq_index[$seq], ord($chars[$i]) - 32);
			} else {
				$replace .= sprintf('<img localsrc="s" alt="[ESC$%s%dSI]" />', $seq, ord($chars[$i]));
			}
		}
		$buffer = substr_replace($buffer, $replace, $offset, strlen($orig));
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
private function pickup_pics_shift_jis($buffer) {
	$pics = array_flip(self::$pics);
	if (! $pics || ! function_exists('mb_regex_encoding')) {
		return $buffer;
	}
	mb_regex_encoding($this->charset);
	$replaced = mb_ereg_replace(
		"([\xf7\x40-\xf7\x5b]|[\xf7\x5d-\xf7\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc]|[\xfb\x40-\xfb\x5b]|[\xfb\x5d-\xfb\xfc])", 
		'isset($pics["\1"]) ? 
		"<img localsrc=\"" . $pics["\1"] . "\" />" : 
		"<img localsrc=\"s\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf7\x5c", '<img localsrc="' . $pics["\xf7\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="' . $pics["\xf9\x5c"] . '" />', $replaced);
		$replaced = mb_ereg_replace("\xfb\x5c", '<img localsrc="' . $pics["\xfb\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_Softbank_PDC class
   ================================================== */

class KtaiService_Softbank_PDC extends KtaiService_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	// http://creation.mb.softbank.jp/web/web_pic_about.html
	$p = 0;
	foreach ($this->num_chars as $s => $n) {
		for ($i = 1 ; $i <= $n ; $i++) {
			$this->picto[sprintf('se%d%02x', $p, $i)] = "\x1b\$$s" . chr(32 + $i) . "\x0f";
		}
		$p++;
	}

	$this->theme     = ks_option('ks_theme_sb_pdc');
	$this->type      = 'PDC';
	$this->flat_rate = false;
	preg_match('!^J-(PHONE|EMULATOR)/(\d\.\d+)/([-_.a-zA-Z0-9]+)/?(SN([-_.a-zA-Z0-9]*))? ?!', $user_agent, $specs);
	$this->term_name = isset($_SERVER['HTTP_X_JPHONE_MSNAME']) ? $_SERVER['HTTP_X_JPHONE_MSNAME'] : NULL;
	$this->term_name = $this->term_name ? $this->term_name : $specs[3];
	$this->term_ID   = isset($specs[5]) ? $specs[5] : NULL;
	$this->sub_ID    = isset($_SERVER['HTTP_X_JPHONE_UID']) ? $_SERVER['HTTP_X_JPHONE_UID'] : NULL;
	$this->cookie_available = false;
	$this->ext_css_available = false;
	$this->textarea_size = 6000;
	$this->page_size = 6000;
	if ($specs[2] < 4.0) {
		$this->cache_size = 6000;
		$this->sub_ID_available = false;
		$this->require_id_msg = "ERROR: Can't post a comment. We request your terminal's manufacture number but your phone does not available to trasmit it.";
	} else {
		$this->cache_size = 12000;
		$this->sub_ID_available = true;
		$this->require_id_msg = "ERROR: Please allow transmission of user infomation or your terminal's manifacture number.\nGo Yahoo! Japan &gt; My Softbank (User Support) &gt; Misc Application &gt; Transmission of User Infomation / Transmission of Manifacture Number.";
	}
	$this->preamble   = '';
	$this->xhtml_head = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<h([1-6])([^>]*)>(.*?)</h\\1>!s', '<div$2><p>$3</p></div>', $buffer);
	$buffer = preg_replace('!<img([^>]*?) src=([\'"])([^>]*?)\.gif\\2!s', '<img$1 src=$2$3.png$2', $buffer); //"
	$buffer = preg_replace('!<a([^>]*?) href=([\'"])([^>]*?)\.gif\\2!s', '<a$1 href=$2$3.png$2', $buffer); //"
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = str_replace('&nbsp;', ' ', $buffer);
	$buffer = preg_replace('!\s*</(li|dt|dd|option)>\s*!', '', $buffer);
	$buffer = preg_replace('! ?/>!', '>', $buffer);
/*	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"/#*+]+?) ?/>!', '<$1>', $buffer); */
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   KtaiService_Softbank_3G class
   ================================================== */

class KtaiService_Softbank_3G extends KtaiService_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$p = 0;
	foreach ($this->num_chars as $s => $n) {
		for ($i = 1 ; $i <= $n ; $i++) {
			$index = sprintf('se%d%02x', $p, $i);
			$this->picto[$index] = parent::$pics[$index];
		}
		$p++;
	}

	$this->theme     = ks_option('ks_theme_sb_3g');
	$this->type      = '3G';
	$this->flat_rate = true;
	if (preg_match('!^(Vodafone|SoftBank|Vemulator|Semulator)/\d\.\d+/([-_.a-zA-Z0-9]+)/[-_.a-zA-Z0-9]+/(SN([-_.a-zA-Z0-9]*))? !', $user_agent, $specs)) {
		$this->term_name  = $this->term_name ? $this->term_name : $specs[2];
	} elseif (preg_match('!^MOT(EMULATOR)?-([CV]\d+)/[-_.a-zA-Z0-9]+/(SN([-_.a-zA-Z0-9]*))? !', $user_agent, $specs)) {
		$names['C980'] = '702MO';
		$names['V980'] = '702sMO';
		$this->term_name  = $this->term_name ? $this->term_name : (isset($names[$specs[2]]) ? $names[$specs[2]] : NULL);
	}
	$this->term_ID    = isset($specs[4]) ? $specs[4] : NULL;
	$this->sub_ID     = isset($_SERVER['HTTP_X_JPHONE_UID']) ? $_SERVER['HTTP_X_JPHONE_UID'] : NULL;
	$this->sub_ID_available = true;
	$this->cookie_available = true;
	$this->ext_css_available = true;
	$this->textarea_size = 20000;
	$this->page_size  = 20000;
	$this->cache_size = 300000;
	$this->require_id_msg = "ERROR: Please allow transmission of user infomation or your terminal's manifacture number.\nGo Yahoo! Japan &gt; My Softbank (User Support) &gt; Misc Application &gt; Transmission of User Infomation.\nGo Yahoo! Keitai &gt; Common Settings &gt; Security Settings &gt; Manufacture Number.";
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">';
	$this->xhtml_head = '<html>';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	if ($this->mime_type == 'application/xhtml+xml') {
		$buffer = $this->input_to_style($buffer);
	}
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}
?>