<?php
/*
 Plugin Name: wp-kyodeki
 Plugin URI: http://wppluginsj.sourceforge.jp/wp-kyodeki/
 Description: その日にアクセスが多かった記事のリンクリストを出力します。
 Version: 1.00
 Author: hiromasa
 Author URI: http://another.maple4ever.net/
 */

/*  Copyright 2009 hiromasa (email : h1romas4@gmail.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpKyodeki - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;

/******************************************************************************
 * WpKyodeki
 *
 * @author		hiromasa
 * @version		1.00
 *
 *****************************************************************************/
class WpKyodekiWidget extends WP_Widget {
	
	/**
	 * WpKyodeki
	 * 
	 * @return WpKyodeki
	 */
	function WpKyodekiWidget() {
		
		$widget_ops = array(
			'classname' => 'wp-kyodeki'
			, 'description' => 'その日にアクセスが多かった記事のリンクリストを出力します。');
		$this->WP_Widget(
			'wp-kyodeki'
			, 'WpKyodeki'
			, $widget_ops);
		
	}
	
	/**
	 * (non-PHPdoc)
	 * 
	 * @see wp-includes/WP_Widget#widget($args, $instance)
	 */
	function widget($args, $instance) {
		
		extract($args);
		echo $before_widget;
		echo $before_title . $instance['title'] . $after_title;
		
		$wpKyodeki = new WpKyodeki();
		echo $wpKyodeki->getKyodeki($instance['count']);
		
		echo $after_widget;
		
	}
	
	/**
	 * (non-PHPdoc)
	 * 
	 * @see wp-includes/WP_Widget#update($new_instance, $old_instance)
	 */
	function update($new_instance, $old_instance) {				
		
		return $new_instance;
		
	}
	
	/**
	 * (non-PHPdoc)
	 * 
	 * @see wp-includes/WP_Widget#form($instance)
	 */
	function form($instance) {
		
		$title = esc_attr($instance['title']);
		$count = esc_attr($instance['count']);
		
		if(empty($count)) $count = 5;
		
		echo "<p><label for=\"{$this->get_field_id('title')}\">";
		echo _e('Title:');
		echo "<input class=\"widefat\" id=\"{$this->get_field_id('title')}\"";
		echo " name=\"{$this->get_field_name('title')}\" type=\"text\" value=\"{$title}\" />";
		echo "</label></p>";
		
		echo "<p><label for=\"{$this->get_field_id('count')}\">";
		echo "表示件数:";
		echo "<input class=\"widefat\" id=\"{$this->get_field_id('count')}\"";
		echo " name=\"{$this->get_field_name('count')}\" type=\"text\" value=\"{$count}\" />";
		echo "</label></p>";
		
	}
	
}

/******************************************************************************
 * WpKyodeki
 *
 * @author		hiromasa
 * @version		1.00
 *
 *****************************************************************************/
class WpKyodeki {
	
	var $access;
	
	/**
	 * WpKyodeki
	 * 
	 * @return WpKyodeki
	 */
	function WpKyodeki() {
		
		$this->access = get_option('wp-kyodeki');
		if(empty($this->access)) { 
			$this->access = array();
		}
		
	}
	
	/**
	 * getKyodeki
	 * 
	 * @param $args
	 * @return $list
	 */
	function getKyodeki($count) {
		
		$count = intval($count);
		if($count == 0) $count = 5;
		
		$this->countAccess();
		
		if(empty($this->access)) return '';
		
		arsort($this->access['log']);
		
		$index = 1;
		$list = "<ul>\n";
		foreach($this->access['log'] as $id => $hit) {
			$link = get_permalink($id);
			$title = get_the_title($id);
			$list .= "<li><a href=\"{$link}\">{$title}</a> ($hit)</li>\n";
			if($index >= $count) break;
			$index++;
		}
		$list .= "</ul>\n";
		
		return $list;
		
	}
	
	/**
	 * countAccess
	 * 
	 * @return unknown_type
	 */
	function countAccess() {
		
		global $post;
		
		if(!($post->post_status == 'publish' && $post->post_password == '')) {
			return;
		}
		
		if(!is_user_logged_in() && (is_single() || is_page())) {
			if(!empty($this->access['lastupdate'])) {
				if(date('Ymd') != $this->access['lastupdate']) {
					$this->access = array();
				}
			}
			$this->access['log'][$post->ID]++;
			$this->access['lastupdate'] = date('Ymd');
			update_option('wp-kyodeki', $this->access);
		}
		
	}
	
}

/******************************************************************************
 * WpKyodeki - WordPress Interface Define
 *****************************************************************************/
function the_kyodeki($count) {
	
	$wpKyodeki = new WpKyodeki();
	echo $wpKyodeki->getKyodeki($count);
	
}

add_action(
	'widgets_init'
	, create_function('', 'return register_widget("WpKyodekiWidget");'));
?>