<?php
/*
 Plugin Name: wp-kotodama
 Plugin URI: http://wppluginsj.sourceforge.jp/wp-kotodama/
 Description: <a href="http://tkzy.net/index.php?p=68">tkzy recent comment</a> clone
 Version: 1.00
 Author: hiromasa
 Author URI: http://another.maple4ever.net/
 */

/*  Copyright 2009 hiromasa (email : h1romas4@gmail.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpKotodama - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;

/******************************************************************************
 * WpKotodama
 *
 * @author		hiromasa
 * @version		1.00
 *
 *****************************************************************************/
class WpKotodama {
	
	var $options;
	var $comments;
	
	/**
	 * WpKotodama
	 *
	 * @return WpKotodama
	 */
	function WpKotodama() {
		
		$this->comments = array();
		$this->options = get_option('wp-kotodama');
		//initialize option first time
		if(empty($this->options)) {
			$this->options['title'] = 'Recent Comment';
			$this->options['limit'] = 6;
			$this->options['gravatar'] = false;
			$this->options['size'] = 18;
			update_option('wp-kotodama', $this->options);
		}
		
	}
	
	/**
	 * init
	 *
	 */
	function init() {
		
		wp_register_sidebar_widget(
			'wp-kotodama'
			, 'wp-kotodama'
			, array(&$this, 'widgetOutput')
			, array(
				'classname' => 'widget_wp-kotodama'
				, 'description' => "tkzy recent comment clone" ));
		wp_register_widget_control(
			'wp-kotodama'
			, 'wp-kotodama'
			, array(&$this, 'widgetRegister'));
		
	}
	
	/**
	 * widgetRegister
	 *
	 */
	function widgetRegister() {
		
		$newoptions = get_option('wp-kotodama');
		if (isset($_POST["wp-kotodama-submit"])) {
			$newoptions['title'] = strip_tags(stripslashes($_POST["wp-kotodama-title"]));
			$newoptions['limit'] = intval($_POST["wp-kotodama-limit"]);
			$newoptions['gravatar'] = $_POST["wp-kotodama-gravatar"] != '' ? true : false;
			$newoptions['size'] = intval($_POST["wp-kotodama-size"]);
		}
		if ( $this->options != $newoptions ) {
			$this->options = $newoptions;
			update_option('wp-kotodama', $this->options);
		}
		
		$title = attribute_escape($this->options['title']);
		$limit = attribute_escape($this->options['limit']);
		$gravatar = $this->options['gravatar'] == true ? 'checked' : '';
		$size = attribute_escape($this->options['size']);
		echo '<p>';
		echo '<label for="wp-kotodama-title">' . __('Title:');
		echo "<input class=\"widefat\" id=\"wp-kotodama-title\" name=\"wp-kotodama-title\" type=\"text\" value=\"{$title}\" />";
		echo '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"wp-kotodama-limit\" name=\"wp-kotodama-limit\" type=\"text\" style=\"width: 3em;\" value=\"{$limit}\" />";
		echo '<label for="wp-kotodama-limit"> : ' . __('表示する最大コメント数') . '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"wp-kotodama-gravatar\" name=\"wp-kotodama-gravatar\" type=\"checkbox\" style=\"width: 3em;\" {$gravatar} />";
		echo '<label for="wp-kotodama-limit"> : ' . __('アバターを表示する') . '</label>';
		echo '</p>' . "\n";
		echo '<p>';
		echo "<input class=\"widefat\" id=\"wp-kotodama-size\" name=\"wp-kotodama-size\" type=\"text\" style=\"width: 3em;\" value=\"{$size}\" />";
		echo '<label for="wp-kotodama-size"> : ' . __('アバターの画像サイズ') . '</label>';
		echo '</p>' . "\n";
		echo '<input type="hidden" id="wp-kotodama-submit" name="wp-kotodama-submit" value="1" />';
		
	}
	
	/**
	 * outputWidget
	 *
	 * @param unknown_type $args
	 */
	function widgetOutput($args) {
		
		extract($args, EXTR_SKIP);
		$title = $this->options['title'];
		$limit = $this->options['limit'];
		$gravatar = $this->options['gravatar'];
		$size = $this->options['size'];
		
		if($title == '') $title = "Recent Comments"; 
		if(intval($limit) == 0) $limit = 6;
		if(intval($size) == 0) $size = 18;
		
		echo $before_widget . "\n";
		echo $before_title . $title . $after_title . "\n";
		$this->getRelatedComments($limit, $gravatar, $size);
		echo $after_widget . "\n";
		
	}
	
	/**
	 * getRelatedComments
	 *
	 * @param unknown_type $limit
	 * @param unknown_type $gravatar
	 * @param unknown_type $size
	 */
	function getRelatedComments($limit, $gravatar = false, $size = 18) {
		
		$this->makeRecentComment($limit);
		
		$result = "<ul>\n";
		$before = '';
		for($rank = 0; $rank < count($this->comments); $rank++) {
			//post title
			if($this->comments[$rank]['permalink'] != $before) {
				if($before != '') {
					$result .= "</ul>\n</li>\n";
				}
				$result .= "<li><a href=\"{$this->comments[$rank]['permalink']}\">";
				$result .= "{$this->comments[$rank]['post_title']}</a>\n";
				$result .= "({$this->comments[$rank]['comment_count']})";
				$result .= "<ul>\n";
				$before = $this->comments[$rank]['permalink'];
			}
			$result .= "<li>";
			//gravatar
			if($gravatar == true) {
				$result .= get_avatar($this->comments[$rank]['comment_author_email'], $size);
			}
			//date
			$result .= "<span class=\"date\"> ";
			$result .= "{$this->comments[$rank]['comment_date']}</span> ";
			//author link
			$link = $this->comments[$rank]['comment_author_url'];
			if($link == '') {
				$result .= "{$this->comments[$rank]['comment_author']}";
			} else {
				$result .= "<a href=\"{$link}\" rel=\"external\">";
				$result .= "{$this->comments[$rank]['comment_author']}</a>";
			}
			$result .= "</li>\n";
		}
		$result .=  "</ul>\n</li>\n</ul>\n";
		
		echo $result;
		 
	}
	
	/**
	 * makeRecentComment
	 *
	 * @param unknown_type $limit
	 */
	function makeRecentComment($limit) {
		
		global $wpdb;
		
		if(count($this->comments) != 0) return;
		
		$comments = $wpdb->get_results($wpdb->prepare(
			"SELECT"
			. "  comments.ID"
			. "  ,comments.comment_ID"
			. "  ,comments.post_date"
			. "  ,comments.post_title"
			. "  ,comments.comment_count"
			. "  ,comments.comment_date"
			. "  ,comments.comment_author"
			. "  ,comments.comment_author_url"
			. "  ,comments.comment_author_email"
			. " FROM"
			. "     ("
			. "         SELECT"
			. "             co.comment_ID"
			. "             ,co.comment_post_ID"
			. "             ,co.comment_date"
			. "             ,co.comment_author"
			. "             ,co.comment_author_url"
			. "             ,co.comment_author_email"
			. "             ,po.ID"
			. "             ,po.post_date"
			. "             ,po.post_title"
			. "             ,po.comment_count"
			. "           FROM"
			. "               {$wpdb->comments} AS co"
			. "               ,{$wpdb->posts} AS po"
			. "           WHERE"
			. "               co.comment_approved = '1'"
			. "               AND po.post_status = 'publish'"
			. "               AND po.post_password = ''"
			. "               AND po.ID = co.comment_post_ID"
			. "           ORDER BY"
			. "               co.comment_date DESC"
			. "           LIMIT %d"
			. "     ) AS comments"
			. " ORDER BY"
			. "     comments.post_date DESC"
			. "     ,comments.comment_date ASC"
			, intval($limit)));
		
		if(count($comments) == 0) return;
		
		$rank = 0;
		foreach($comments as $comment) {
			$this->comments[$rank]['post_title'] =
				$comment->post_title;
			$this->comments[$rank]['permalink'] =
				get_permalink($comment->ID) . "#comments";
			$this->comments[$rank]['comment_ID'] =
				$comment->comment_ID;
			$this->comments[$rank]['comment_date'] =
				mysql2date('m/d', $comment->comment_date);
			$author = wp_specialchars($comment->comment_author, ENT_QUOTES);
			if($author == '')  $author = "Anonymous";
			$this->comments[$rank]['comment_author'] = $author;
			$this->comments[$rank]['comment_author_url'] =
				clean_url($comment->comment_author_url);
			$this->comments[$rank]['comment_author_email'] =
				$comment->comment_author_email;
			$this->comments[$rank]['comment_count'] =
				$comment->comment_count;
			$rank++;
		}
		
	}
	
}

/******************************************************************************
 * WpKotodama - Global Template Tag
 *****************************************************************************/
function kotodama_get_comments($limit = 7, $gravatar = false, $size = 18) {
	global $wpKotodama;
	return $wpKotodama->getRelatedComments($limit, $gravatar, $size);
}

/******************************************************************************
 * WpKotodama - WordPress Interface Define
 *****************************************************************************/
$wpKotodama = new WpKotodama();

add_action('init', array (&$wpKotodama, 'init'))
?>