<?php
/*
Plugin Name: Simple Tweet
Version: 1.0.1
Plugin URI: http://wppluginsj.sourceforge.jp/simple-tweet/
Description: Simple Twitter Post
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2008 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
if (!is_admin()) return false;

// ****** 要設定 ここから ******

define('TWITTER_USR',	'Enter the UserName');		// Twitter アカウント
define('TWITTER_PWD',	'Enter the Password');		// パスワード

// Twitter につぶやく言葉を変更できます。以下の文字は変換されてつぶやかれます。
//  %SITE_NAME%		サイト名
//  %POST_NO%		エントリの番号
//  %POST_TITLE%	エントリのタイトル
//  %POST_EXCERPT%	エントリの抜粋
define('TWEET_TEXT', 	'ブログにエントリ: %POST_TITLE% - %POST_EXCERPT%');

// ****** 要設定 ここまで ******

//define('TWEET_LOG_WRITE',	true);

if (!defined('QC_TWITTER_SENT_URL'))
	define('QC_TWITTER_SENT_URL', 'http://twitter.com/statuses/update.json');
if (!defined('QC_TWITTER_MAX'))
	define('QC_TWITTER_MAX', 140);
if (!defined('QC_TWITTER_TIMEOUT'))
	define('QC_TWITTER_TIMEOUT', 30);
if (!defined('QC_TINYURL_URL'))
	define('QC_TINYURL_URL', 'http://tinyurl.com/api-create.php?url=');

class SimpleTweetController {
	var $twitter_usr, $twitter_pwd, $tweet_text;
	var $twitter_client_name = 'SimpleTweetWP';
	var $twitter_client_version = '1.0.1';
	var $twitter_client_url = 'http://dogmap.jp/';
	var $_log;

	/**********************************************************
	* Constructor
	***********************************************************/
	function SimpleTweetController() {
		$this->__construct();
	}
	function __construct() {
		$this->twitter_usr = TWITTER_USR;
		$this->twitter_pwd = TWITTER_PWD;
		$this->tweet_text  = TWEET_TEXT;
	}

	/**********************************************************
	* Post to Twitter
	***********************************************************/
	function doTweet($post_id = '') {
		$this->_log = '';
		$post = &get_post($post_id);

		if ('publish' == $post->post_status && $post->post_date == $post->post_modified) {
			$this->_log .= "post ID:{$post_id}\n";
			$charset = get_option('blog_charset');
			$msg = str_replace(
				 array(
					 '%SITE_NAME%'
					,'%POST_NO%'
					,'%POST_TITLE%'
					,'%POST_EXCERPT%'
					)
				,array(
					 get_bloginfo('name')
					,$post_id
					,$post->post_title
					,preg_replace('/[\r\n ]+/', '', strip_tags(!empty($post->post_excerpt) ? $post->post_excerpt : $post->post_content))
					)
				,$this->tweet_text
				);
			$url = ' ' . $this->_getTinyURL(get_permalink($post_id));

			$notify_msg = $msg . $url;
			if (mb_strlen($notify_msg, $charset) >= QC_TWITTER_MAX)
				$notify_msg = mb_substr($msg, 0, QC_TWITTER_MAX - (mb_strlen($url, $charset) + 3), $charset) . '...' . $url;
			$this->_log .= "tweet message:{$notify_msg}\n";

			if ($this->_twitterPost($notify_msg, $this->twitter_usr, $this->twitter_pwd) !== false)
				$this->_log = "*** OK! ***\n\n" . $this->_log;
			else
				$this->_log = "** ERROR **\n\n" . $this->_log;
		}

		if (defined('TWEET_LOG_WRITE') && TWEET_LOG_WRITE && !empty($this->_log)) {
			$log_file = WP_CONTENT_DIR . '/simple_tweet.log';
			if (file_exists($log_file)) @unlink($log_file);
			$handle = fopen($log_file, 'w');
			fwrite($handle, $this->_log);
			fclose($handle);
		}
	}

	/**********************************************************
	* Post to Twitter!
	***********************************************************/
	function _twitterPost($tweet, $username, $password) {
		if (empty($tweet) || empty($username) || empty($password)) return false;

		$result = FALSE;
		$log = '';

		if (!class_exists('Snoopy'))
			require_once(ABSPATH . WPINC . '/class-snoopy.php');

		if (class_exists('Snoopy')) {
			$snoop = new Snoopy;
			$snoop->agent = $this->twitter_client_name.' '.$this->twitter_client_url;
			$snoop->rawheaders = array(
				 'X-Twitter-Client' => $this->twitter_client_name
				,'X-Twitter-Client-Version' => $this->twitter_client_version
				,'X-Twitter-Client-URL' => $this->twitter_client_url
				);
			$snoop->user = $username;
			$snoop->pass = $password;
			$snoop->read_timeout = QC_TWITTER_TIMEOUT;
			$snoop->timed_out = true;
			$snoop->submit(
				 QC_TWITTER_SENT_URL
				,array(
					 'status' => $tweet
					,'source' => $this->twitter_client_name
					)
				);
			$result = (strpos($snoop->response_code, '200') !== FALSE);
			$log .=	 "--- Class Snoopy Result ! ---\n"
				."response_code:{$snoop->response_code}"
				."results:{$snoop->results}\n"
				."status:{$snoop->status}\n"
				."error:{$snoop->error}\n";
			unset($snoop);
		}

		if (!$result) {
			$params = '?status=' . rawurlencode($tweet)
				. '&source=' . $this->twitter_client_name;
			$result = @file_get_contents(QC_TWITTER_SENT_URL.$params , false, stream_context_create(array(
				 "http" => array(
					"method" => "POST",
					"header" => "Authorization: Basic ". base64_encode($username. ":". $password)
					)
				))
			);
			$log .=	 "\n--- file_get_contents Result ! ---\n"
				."results:{$result}\n";
		}
		$this->_log .= $log;

		return ($result !== FALSE);
	}

	/**********************************************************
	* Get Tiny URL
	***********************************************************/
	function _getTinyURL($url = '') {
		if (empty($url)) return '';

		$buff = '';
		$url  = QC_TINYURL_URL . $url;
		if(function_exists('file_get_contents')) {
			$buff = @file_get_contents( $url );
		} else {
			$fp = @fopen($url, 'r');
			if($fp === FALSE) return '';
			while(!feof($fp)) {$buff .= fread( $fp, 1024 );}
			fclose($fp);
		}
		return $buff;
	}
}

$simple_tweet = new SimpleTweetController();
add_action('publish_post', array(&$simple_tweet, 'doTweet'));
unset($simple_tweet);
?>