<?php
// 直接実行拒否用
if (EMOJIURL == "EMOJIURL") { exit(); }
/*************************************************
  絵文字選択ウィンドウ作成
**************************************************/
// 絵文字の画像場所(外部用url)作成
$imagesurl = get_option('emoji_image_url');
if (!$imagesurl) {
	$imagesurl = get_option('siteurl') . '/wp-includes/images/smilies/';
}
// 絵文字の画像場所(内部用path)作成
$imagepath = get_option('emoji_image_path');
if (!$imagepath) {
	$imagepath = implode(array_slice(explode(DIRECTORY_SEPARATOR, __FILE__), 0, -4), DIRECTORY_SEPARATOR) . '/wp-includes/images/smilies/';
}
// 絵文字の画像表示順リスト作成
$imagesortlist = get_option('emoji_image_sortlist');
// 絵文字リスト作成
$emoji_images = array();
// ファイル指定分
if (file_exists($imagesortlist)) {
	$emoji_images = file($imagesortlist, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
}
// 存在しないファイルを削除
foreach ($emoji_images as $i => $img) :
	if (file_exists(dirname($imagesortlist) . DIRECTORY_SEPARATOR . rtrim($img))) {
		$emoji_images[$i] = strtolower(rtrim($img));
	} else {
		unset($emoji_images[$i]);
	}
endforeach;
// 新規分を追加
$imagedir = dir($imagepath);
while($imagefile=$imagedir->read()) {
	if (strtolower(pathinfo($imagefile,PATHINFO_EXTENSION)) == 'gif') {
		if (!in_array(strtolower($imagefile),$emoji_images)) {
			$emoji_images[] = $imagefile;
		}
	}
}
// 絵文字数よりウィンドウ幅作成
$emoji_sum = count($emoji_images);
$emoji_col = sqrt($emoji_sum);
if (is_float($emoji_col)) {
	$emoji_width = (floor($emoji_col) + 1) * 17;
} else {
	$emoji_width = $emoji_col * 17;
}
?>
<?php
/**************************************************
  スタイルシート設定
 **************************************************/
?>
<style type="text/css">
#emojidiv {
	position: absolute;
	width: 210px;
	background: #fff;
	z-index: 100;
	padding: 5px;
	border: 1px solid #dfdfdf;
	display: none;
}
#emojidiv img {
	margin: 1px;
}
#emojidiv a {
	text-decoration: none;
}
</style>
<?php
/**************************************************
  スクリプト設定
 **************************************************/
?>
<script type="text/javascript">
// マウス位置取得
function mousePosition(event) {
	if (event.pageX || event.pageY) {
		return {x:event.pageX, y:event.pageY};
	}
	return {
		x:event.clientX + document.body.scrollLeft - document.body.clientLeft,
		y:event.clientY + document.body.scrollTop  - document.body.clientTop
	};
}
var emoji_insert_type;
var emoji_insert_element;
var emoji_insert_function;
// 絵文字挿入
function emoji_insert(emoji) {
	var emoji_insert_image_url = "<?php echo $imagesurl ?>" + emoji;
	if (emoji_insert_type != "myself") {
		if (emoji_insert_element) {
			emoji_insert_element.value = emoji_insert_image_url;
		}
		if (emoji_insert_function) {
			emoji_insert_function(emoji_insert_element);
		}
		return;
	}
	var emojiurl = "<img src=\"" + emoji_insert_image_url + "\" alt=\"" + emoji + "\" />";
	if (jQuery("#quicktags").css("display") == "none") {
		tinyMCE.execCommand('mceInsertContent', false, emojiurl);
	} else {
		var inputField;
		if (document.getElementById("content") && document.getElementById("content").type == 'textarea') {
			inputField = document.getElementById("content");
		} else {
			return false;
		}
		if (document.selection) {
			inputField.focus();
			sel = document.selection.createRange();
			sel.text = emojiurl;
			inputField.focus();
		} else {
			if (inputField.selectionStart || inputField.selectionStart == '0') {
				var sPos = inputField.selectionStart;
				var ePos = inputField.selectionEnd;
				inputField.value = inputField.value.substring(0, sPos)
					+ emojiurl + inputField.value.substring(ePos, inputField.value.length);
				inputField.focus();
				inputField.selectionStart = ePos + emojiurl.length;
				inputField.selectionEnd = ePos + emojiurl.length;
			} else {
				inputField.value += emojiurl;
				inputField.focus();
			}
		}
	}
}
// 絵文字一覧
var emoji_list =
<?php
echo '"';
foreach ($emoji_images as $img) :
	echo '<a href=\"javascript:emoji_insert(\'',$img,'\');emoji_window_hide();void(0);\"><img src=\"',$imagesurl,$img,'\"/></a>';
endforeach;
echo '";';
?>
// 絵文字ウィンドウ表示
function emoji_window_show(event) {
	var mousePos = mousePosition(event);
	emojidiv_left = mousePos.x + 20;
	emojidiv_top = mousePos.y - 20;
	jQuery("#emojidiv").css("display", "block");
	jQuery("#emojidiv").css("left", emojidiv_left);
	jQuery("#emojidiv").css("top", emojidiv_top);
	jQuery("#emojidiv").css("width", <?php echo $emoji_width ?> + "px");
	jQuery("#emojidiv").html("<div style=\"text-align: right; margin-bottom: 5px;\"><a href=\"javascript: emoji_window_hide();void(0);\">閉じる</a></div>" + emoji_list);
	return;
}
// 絵文字ウィンドウ非表示
function emoji_window_hide() {
	jQuery("#emojidiv").css("display", "none");
}
jQuery(function () {
	jQuery("body").append("<div id=\"emojidiv\"></div>");
});
</script>
