<?php
/*
Plugin Name: WMD Editor
Plugin URI: http://wppluginsj.sourceforge.jp/wmd-editor/
Description: Adds the <a href="http://wmd-editor.com/">WMD Editor</a> to the comment field, to make life easier for your commenters.
Version: 1.0.2
Author: wokamoto
Author URI: http://dogmap.jp/

 This is a simple plugin that just adds the javascript call to your template.
 You can gather more info on this project at http://code.google.com/p/wmd/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2008 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Includes:
 This plugin includes WMD Editor
 http://wmd-editor.com/
 The MIT License
 http://www.opensource.org/licenses/mit-license.php
 Copyright(c) 2007-2008 Attacklab
*/

if (!class_exists('wokController') || !class_exists('wokScriptManager'))
	require(dirname(__FILE__).'/includes/common-controller.php');

class WMDEditorController extends wokController {
	var $plugin_name   = 'wmd-editor';
	var $plugin_js     = 'wmd/wmd.js';
	var $plugin_js_ver = '1.0.1';

	var $_options_default = array(
		 'buttons'    => 'bold italic | link blockquote code img | ol ul h1 hr'
		);

	/*
	* Constructor
	*/
	function WMDEditorController() {
		$this->__construct();
	}
	function __construct() {
		$this->init(__FILE__);
		$this->options = $this->_initOptions($this->getOptions());
	}

	function _initOptions($wk_options = '') {
		if (!is_array($wk_options)) $wk_options = array();
		if (!isset($wk_options['buttons'])) $wk_options['buttons'] = $this->_options_default['buttons'];
		return $wk_options;
	}

	function _isDisplay() {
		return ((is_single() || is_page()) && comments_open());
	}

	function addHead() {
		if ($this->_isDisplay()) {
			$out  = str_replace(
				 "<"
				,"<'+'"
				,"var wmdL10n = {"
				."wmdLink:{"
				." href:'http://www.wmd-editor.com/'"
				.",title:'".__("WMD: The Wysiwym Markdown Editor", $this->textdomain_name)."'"
				."}"
				.",description:{"
				." bold:'".__("Strong <strong>", $this->textdomain_name)."'"
				.",italic:'".__("Emphasis <em>", $this->textdomain_name)."'"
				.",link:'".__("Hyperlink <a>", $this->textdomain_name)."'"
				.",undo:'".__("Undo", $this->textdomain_name)."'"
				.",redo:'".__("Redo", $this->textdomain_name)."'"
				.",blockquote:'".__("Blockquote <blockquote>", $this->textdomain_name)."'"
				.",code:'".__("Code Sample <pre><code>", $this->textdomain_name)."'"
				.",img:'".__("Image <img>", $this->textdomain_name)."'"
				.",ol:'".__("Numbered List <ol>", $this->textdomain_name)."'"
				.",ul:'".__("Bulleted List <ul>", $this->textdomain_name)."'"
				.",h1:'".__("Heading <h1>/<h2>", $this->textdomain_name)."'"
				.",hr:'".__("Horizontal Rule <hr>", $this->textdomain_name)."'"
				."}"
				.",prompt:{"
				." img:'".__("<b>Enter the image URL.</b></p><p>You can also add a title, which will be displayed as a tool tip.</p><p>Example:<br />http://wmd-editor.com/images/cloud1.jpg   \"Optional title\"", $this->textdomain_name)."'"
				.",link:'".__("<b>Enter the web address.</b></p><p>You can also add a title, which will be displayed as a tool tip.</p><p>Example:<br />http://wmd-editor.com/   \"Optional title\"", $this->textdomain_name)."'"
				."}"
				.",selection:{"
				." alt:'".__("alt text", $this->textdomain_name)."'"
				.",link:'".__("link text", $this->textdomain_name)."'"
				."}"
				."};\n"
				);
			$out .= "var wmd_options = {buttons: '{$this->options['buttons']}'};\n";

			$this->writeScript($out, 'head');
		}
	}

	function addFooter() {
		if ($this->_isDisplay()) {
			$out  = "<script type=\"text/javascript\" src=\"{$this->plugin_url}{$this->plugin_js}\" charset=\"UTF-8\"></script>\n";
			echo $out;
		}
	}

	function addAdminMenu() {
		$this->add_optionPage( __('WMD Editor', $this->textdomain_name), array($this,'optionPage'));
	}

	function pluginActionLinks($links, $file) {
		$this_plugin = plugin_basename(__FILE__);
		if ($file == $this_plugin) {
			$settings_link = '<a href="options-general.php?page=' . $this->plugin_file . '">' . __('Settings') . '</a>';
			array_unshift($links, $settings_link); // before other links
		}
		return $links;
	}

	function _optionPage() {
		if(isset($_POST['ap_options_update'])) {
			// check referer
			if ($this->wp25) check_admin_referer("update_options", "_wpnonce_update_options");

			// strip slashes array
			$_POST = $this->stripArray($_POST);

			// get options
			$this->options['buttons']        = $_POST['ap_buttons'];
			$_POST = '';

			// options update
			$this->updateOptions();

			// Done!
			$this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

		} elseif(isset($_POST['ap_options_delete'])) {
			// check referer
			if ($this->wp25) check_admin_referer("delete_options", "_wpnonce_delete_options");

			// options delete
			$this->deleteOptions();
			$this->options = $this->_initOptions();

			// Done!
			$this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
			$this->error++;
		}

		$out  = '';

		// Add Options
		$out .= "<div class=\"wrap\">\n";
		$out .= "<h2>".__('WMD Editor Options', $this->textdomain_name)."</h2><br />\n";
		$out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
		if ($this->wp25) $out .= $this->makeNonceField("update_options", "_wpnonce_update_options", true, false);

		$out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

		// Buttons
		$out .= "<tr>";
		$out .= "<td style=\"width:60px;\"><strong>".__('Buttons', $this->textdomain_name)."</strong></td>";
		$out .= "<td>";
		$out .= "<input type=\"text\" name=\"ap_buttons\" id=\"ap_buttons\" size=\"100\" value=\"".$this->options['buttons']."\" /><br />";
		$out .= "</td>";
		$out .= "</tr>\n";
		$out .= "</tbody></table>";

		$out .= "<table style=\"border:none;margin-top:1em;margin-left:10em;\"><tbody>";
		$out .= "<tr><th style=\"text-align:left;\">bold</th><td>".htmlspecialchars(__("Strong <strong>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">italic</th><td>".htmlspecialchars(__("Emphasis <em>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">link</th><td>".htmlspecialchars(__("Hyperlink <a>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">blockquote</th><td>".htmlspecialchars(__("Blockquote <blockquote>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">code</th><td>".htmlspecialchars(__("Code Sample <pre><code>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">img</th><td>".htmlspecialchars(__("Image <img>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">ol</th><td>".htmlspecialchars(__("Numbered List <ol>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">ul</th><td>".htmlspecialchars(__("Bulleted List <ul>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">h1</th><td>".htmlspecialchars(__("Heading <h1>/<h2>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">hr</th><td>".htmlspecialchars(__("Horizontal Rule <hr>", $this->textdomain_name))."</td></tr>";
		$out .= "<tr><th style=\"text-align:left;\">|</th><td>".__("Delimiter", $this->textdomain_name)."</td></tr>";
		$out .= "</tbody></table>";

		// Add Update Button
		$out .= "<p style=\"margin-top:1em;\"><input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
		$out .= "</form></div>\n";

		// Add Options
		$out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
		$out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
		$out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
		if ($this->wp25) $out .= $this->makeNonceField("delete_options", "_wpnonce_delete_options", true, false);

		// Delete Button
		$out .= "<p style=\"margin-top:1em;\"><input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
		$out .= "</form></div>\n";

		// Output
		echo ( !empty($this->note) ? "<div id=\"message\" class=\"updated fade\"><p>{$this->note}</p></div>\n" : '' ) . "\n";
		echo ( $this->error == 0 ? $out : '' ) . "\n";
	}

}//class

$WMDEditor = new WMDEditorController();

if (is_admin()) {
	add_action('admin_menu', array(&$WMDEditor,'addAdminMenu'));
	add_filter('plugin_action_links', array(&$WMDEditor, 'pluginActionLinks'), 10, 2 );
} else {
	add_action('wp_head', array(&$WMDEditor,'addHead'));
	add_action('wp_footer', array(&$WMDEditor,'addFooter'));
}

unset($WMDEditor);
?>