<?php
/* ==================================================
 *   Ktai Admin Dashboard
 *   based on wp-admin/includes/dashboard.php of WP 2.7
   ================================================== */

require dirname(__FILE__) . '/admin.php';
$View = new KS_Admin_Dashboard($Ktai_Style, $KS_Admin);
global $title, $parent_file;
$title = __('Dashboard');
$parent_file = './';
include dirname(__FILE__) . '/admin-header.php';

$accesskey = 1;
$accesskey = $View->create($accesskey);
$accesskey = $View->right_now($accesskey);
$accesskey = $View->recent_comments($accesskey);
$accesskey = $View->recent_drafts($accesskey);

//do_action('activity_box_end');
include dirname(__FILE__) . '/admin-footer.php';
exit();

/* ==================================================
 *   KS_Admin_Dashboard class
   ================================================== */

class KS_Admin_Dashboard {
	private $base;
	private $admin;

// ==================================================
public function __construct($base, $admin) {
	$this->base  = $base;
	$this->admin = $admin;
}

// ==================================================
public function create($accesskey = 1) {
	$links = array();
	if (current_user_can('edit_posts')) {
		$links[] = '<a href="' . 
	$this->admin->add_sid('post-new.php', false) . '">' . ($this->base->check_wp_version(2.7) ? __('Add New Post') : __('Create New Post')) . 
	'</a>';
	}
	if (current_user_can('edit_pages')) {
		$links[] = '<a href="' . 
	$this->admin->add_sid('page-new.php', false) . '">' . ($this->base->check_wp_version(2.7) ? __('Add New Page') : __('Write a New Page')) . 
	'</a>';
	}
	if ($links) {
		echo '[ ' . implode(' | ', $links) . ' ] <br />';
	}
	return $accesskey;
}

// ==================================================
public function right_now($accesskey = 1) {
	?>
<br /><h2><?php _e('Right Now'); ?></h2>
	<?php
	$num_posts = wp_count_posts('post');
	$num_pages = wp_count_posts('page');
	$num_cats  = wp_count_terms('category');
	$num_tags  = wp_count_terms('post_tag');
	$num_comm  = wp_count_comments();
	echo '<dl>';

	// Posts
	echo '<dt>';
	$format = __('Posts: %link', 'ktai_style');
	$num = number_format_i18n($num_posts->publish);
	if ( current_user_can('edit_posts') && $num_posts->publish > 0) {
		ks_ordered_link($accesskey++, 10, $this->admin->add_sid('edit.php', false), $num, $format);
	} else {
		ks_ordered_link(-1, 10, NULL, $num, $format);
	}
	echo '</dt>';

	// Pages
	echo '<dt>';
	$format = __('Pages: %link', 'ktai_style');
	$num = number_format_i18n($num_pages->publish);
	if ( current_user_can('edit_pages') && $num_pages->publish > 0) {
		ks_ordered_link($accesskey++, 10, $this->admin->add_sid('edit-pages.php', false), $num, $format);
	} else {
		ks_ordered_link(-1, 10, NULL, $num, $format);
	}
	echo '</dt>';
	
	// Categories
	echo '<dt>';
	$format = __('Categories: %link', 'ktai_style');
	$num = number_format_i18n($num_cats);
/*	if ( current_user_can('manage_categories') && $num_cats > 0) {
		ks_ordered_link($accesskey++, 10, $this->admin->add_sid('categories.php', false), $num, $format);
	} else {
*/
		ks_ordered_link(-1, 10, NULL, $num, $format);
//	}
	echo '</dt>';

	// Tags
	echo '<dt>';
	$format = __('Tags: %link', 'ktai_style');
	$num = number_format_i18n($num_tags);
/*	if ( current_user_can('manage_categories') && $num_tags > 0) {
		ks_ordered_link($accesskey++, 10, $this->admin->add_sid('edit-tags.php', false), $num, $format);
	} else {
*/
		ks_ordered_link(-1, 10, NULL, $num, $format);
//	}
	echo '</dt>';

	// Total Comments
	echo '<dt>';
	$format = __('Comments: %link', 'ktai_style');
	$total_comments = isset($num_comm->total_comments) ? $num_comm->total_comments : intval($num_comm->approved + $num_comm->moderated + $num_comm->spam);
	$num = number_format_i18n($total_comments);
	if ( current_user_can('moderate_comments') && $total_comments > 0) {
		ks_ordered_link($accesskey++, 10, $this->admin->add_sid('edit-comments.php', false), $num, $format);
	} else {
		ks_ordered_link(-1, 10, NULL, $num, $format);
	}
	echo '</dt>';

	// Approved Comments
	$format = __('<font color="%1$s">Approved</font>: %2$s', 'ktai_style');
	$num = number_format_i18n($num_comm->approved);
/*	if ( current_user_can('moderate_comments') && $num_comm->approved > 0) {
		$num = '<a href="' . $this->admin->add_sid('edit-comments.php?comment_status=approved') . '">' . $num . '</a>';
	}
*/
	echo '<dt><ul><li>' . sprintf($format, 'green', $num) . '</li>';

	// Pending Comments
	$format = __('<font color="%1$s">Pending</font>: %2$s', 'ktai_style');
	$num = number_format_i18n($num_comm->moderated);
	if ( current_user_can('moderate_comments') && $num_comm->moderated > 0) {
		$num = '<a href="' . $this->admin->add_sid('edit-comments.php?comment_status=moderated') . '">' . $num . '</a>';
//		$num = '<a href="' . $this->admin->add_sid('moderation.php') . '">' . $num . '</a>';
	}
	echo '<li>' . sprintf($format, '#ff9900', $num) . '</li>';

	// Spam Comments
	$format = __('<font color="%1$s">Spam</font>: %2$s', 'ktai_style');
	$num = number_format_i18n($num_comm->spam);
	if ( current_user_can('moderate_comments') && $num_comm->spam > 0) {
		$num = '<a href="' . $this->admin->add_sid('edit-comments.php?comment_status=spam') . '">' . $num . '</a>';
	}
	echo '<li>' . sprintf($format, 'red', $num) . '</li></ul></dt></dl>';
	return $accesskey;
}

// ==================================================
public function recent_drafts($accesskey = 1, $drafts = false) {
	?>
<br /><h2><?php _e('Recent Drafts', 'ktai_style'); ?></h2>
	<?php
	if (! $drafts) {
		$drafts_query = new WP_Query( array(
			'post_type' => 'post',
			'what_to_show' => 'posts',
			'post_status' => 'draft',
			'author' => $GLOBALS['current_user']->ID,
			'posts_per_page' => 5,
			'orderby' => 'modified',
			'order' => 'DESC'
		) );
		$drafts =& $drafts_query->posts;
	}

	if ( $drafts && is_array($drafts) ) {
		global $Ktai_Style;
		echo '<dl>';
		foreach ( $drafts as $draft ) {
			$url = $this->admin->add_sid(get_edit_post_link($draft->ID, 'url'), false);
			$title = $this->admin->draft_or_post_title( $draft->ID );
			echo '<dt>';
			ks_ordered_link($accesskey++, 10, $url, $title);
			if ($Ktai_Style->check_wp_version(2.7)) {
				_ks_timestamp(get_the_time('U', $draft));
			}
			echo '</dt>';
			if ($the_content = preg_split( '#\s#', strip_tags( $draft->post_content ), 11, PREG_SPLIT_NO_EMPTY)) {
				echo '<dd>' . join( ' ', array_slice( $the_content, 0, 10 ) ) . ( 10 < count( $the_content ) ? '...' : '' ) . '</dd>';
			}
		}
	?>
</dl>
<div align="right"><img localsrc="63" alt="&#8594;" /><a href="<?php echo $this->admin->add_sid('edit.php?post_status=draft'); ?>"><?php _e('View all', 'ktai_style'); ?></a></div>
<?php
	} else {
		?><p><?php _e('There are no drafts at the moment', 'ktai_style');?></p><?php 
	}
	return $accesskey;
}

// ==================================================
public function recent_comments($accesskey = 1) {
	?>
<br /><h2><?php echo _c('Recent Comments|dashboard', 'ktai_style'); ?></h2>
	<?php
	global $wpdb;

	if ( current_user_can('edit_posts') ) {
		$allowed_states = array('0', '1');
	} else {
		$allowed_states = array('1');
	}

	// Select all comment types and filter out spam later for better query performance.
	$comments = array();
	$start = 0;

	while ( count( $comments ) < 5 && $possible = $wpdb->get_results($wpdb->prepare("SELECT * FROM `$wpdb->comments` ORDER BY comment_date_gmt DESC LIMIT %d, 50", $start)) ) {
		foreach ( $possible as $comment ) {
			if ( count( $comments ) >= 5 ) {
				break;
			} elseif (in_array($comment->comment_approved, $allowed_states)) {
				$comments[] = $comment;
			}
		}
		$start = $start + 50;
	}
	if ($comments) {
		?><dl><?php
		foreach ($comments as $comment) {
			$this->recent_comments_row($comment, $accesskey);
		}
		?></dl><?php
		if ( current_user_can('edit_posts') ) { ?>
			<div align="right"><img localsrc="63" alt="&#8594;" /><a href="<?php echo $this->admin->add_sid('edit-comments.php'); ?>"><?php _e('View all', 'ktai_style'); ?></a></div><?php	
		}
	} else {
		?><p><?php _e('No comments yet.', 'ktai_style'); ?></p><?php
	} // $comments;
	return $accesskey;
}

// ==================================================
public function recent_comments_row( &$comment, &$accesskey) {
	$show_date = true;
	$GLOBALS['comment'] =& $comment;

	$comment_post_title = get_the_title( $comment->comment_post_ID );
	$edit_url = $this->admin->add_sid("comment.php?action=editcomment&c={$comment->comment_ID}", false);
	if ( !$comment->comment_type || 'comment' == $comment->comment_type ) : 
		$desc = sprintf(__('From %s on %%link', 'ktai_style'), get_comment_author());
	else :
		switch ( $comment->comment_type ) :
		case 'pingback' :
			$type = __( 'Pingback' );
			break;
		case 'trackback' :
			$type = __( 'Trackback' );
			break;
		default :
			$type = ucwords( $comment->comment_type );
		endswitch;
		$desc = sprintf(__('%s on %%link', 'ktai_style'), wp_specialchars($type));
	endif;
	?><dt><?php 
	if (current_user_can('edit_post', $comment->comment_post_ID)) {
		ks_ordered_link($accesskey++, 10, $edit_url, $comment_post_title, $desc); 
	} else {
		ks_ordered_link(-1, 10, NULL, $comment_post_title, $desc); 
	}
	?><dt><?php 
	if (current_user_can('edit_post', $comment->comment_post_ID)) {
		echo '<dd>[ <a href="' . $this->admin->add_sid('comment-reply.php?replytocom=' . $comment->comment_ID) . '">' . __('Reply', 'ktai_style') . '</a> ]</dd>';
	}
}

// ===== End of class ====================
}
?>