<?php
/* ==================================================
 *   Ktai_Style_Admin class
   ================================================== */

define ('KS_SESSION_NAME', 'ksid');
define ('KS_SESSION_LIFETIME', 3600);
define ('KS_SESSION_RENEWTIME', 1800);

class Ktai_Style_Admin {
	protected $base;
	protected $sid;
	protected $next_id;
	protected $user_login;
	protected $user_agent;
	protected $term_ID;
	protected $sub_ID;
	protected $data;

function __construct() {
	global $Ktai_Style;
	$this->base = $Ktai_Style;
}

/* ==================================================
 * @param	none
 * @return	string  $user_login
 */
public function get_current_user() {
	return $this->user_login;
}

/* ==================================================
 * @param	string  $key
 * @return	mix     $param
 */
public function get($key) {
	return isset($this->$key) ? $this->$key : NULL;
}

/* ==================================================
 * @param	string  $key;
 * @return	mix     $data
 */
public function get_data($key) {
	return isset($this->data[$key]) ? stripslashes($this->data[$key]) : NULL;
}

/* ==================================================
 * @param	string  $key
 * @param   mix     $value
 * @return	mix     $value
 */
public function set_data($key, $value) {
	return $this->data[$key] = $value;
}

/* ==================================================
 * @param	none
 * @return	mix     $result
 */
public function save_data() {
	global $wpdb;
	if (! $this->sid) {
		return false;
	}
	$result = $wpdb->update($wpdb->prefix . 'ktaisession', array('data' => serialize($this->data)), array('sid' => $this->sid));
	return $result;
}

/* ==================================================
 * @param	none
 * @return	string  $sid
 */
public function get_sid() {
	if (isset($_POST[KS_SESSION_NAME])) {
		return $_POST[KS_SESSION_NAME];
	} elseif (isset($_GET[KS_SESSION_NAME])) {
		return $_GET[KS_SESSION_NAME];
	} else {
		return NULL;
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function sid_field() {
	if ($this->sid) {
		echo '<input type="hidden" name="' .KS_SESSION_NAME .'" value="' . htmlspecialchars($this->sid, ENT_QUOTES) . '" />';
	}
}

/* ==================================================
 * @param	string  $uri
 * @return	string  $uri
 */
public function add_sid($uri, $escape = true) {
	if ($this->sid && preg_match('!(^|^\.{1,2}/|' . KS_ADMIN_DIR . '/)[-\w]*(\.php)?!', $uri)
	&& ! preg_match('/\?([^&]+&)*' . KS_SESSION_NAME . '=/', $uri)) {
		$uri = add_query_arg(KS_SESSION_NAME, $this->sid, $uri);
//		$uri .= (strpos($uri, '?') === false ? '?' : '&') . KS_SESSION_NAME . '=' . $this->sid;
		if ($escape) {
			$uri = htmlspecialchars($uri, ENT_QUOTES);
		}
	}
	return $uri;
}

/* ==================================================
 * @param	string  $uri
 * @return	string  $uri
 */
public function remove_sid($uri) {
	if (strpos($uri, KS_SESSION_NAME . '=') !== false) {
		$uri = remove_query_arg(KS_SESSION_NAME, $uri);
	}
	return $uri;
}

/* ==================================================
 * @param	none
 * @return	string  $sid
 */
private function make_sid() {
	return str_replace(array('+', '/', '='), array('_', '.', ''), base64_encode(sha1(uniqid(mt_rand(), true), true)));
}

/* ==================================================
 * @param	string  $user_login
 * @param	string  $sid
 * @param	mix     $data
 * @return	string  $sid
 */
public function set_session($user_login, $sid = NULL, $data = NULL) {
	global $wpdb;
	$sid      = $sid ? $sid : $this->make_sid();
	$expires  = time() + intval(KS_SESSION_LIFETIME);
	$ua_hash  = $this->base->get('user_agent') ? sha1($this->base->get('user_agent')) : '';
	$tid_hash = $this->base->get('term_ID') ? sha1($this->base->get('term_ID')) : '';
	$sub_hash = $this->base->get('sub_ID') ? sha1($this->base->get('sub_ID')) : '';
	$result = $wpdb->insert($wpdb->prefix . 'ktaisession', array(
		'sid'        => $sid,
		'expires'    => date('Y-m-d H:i:s', $expires),
		'user_login' => $user_login,
		'user_agent' => $ua_hash,
		'term_id'    => $tid_hash,
		'sub_id'     => $sub_hash,
		'data'       => ($data ? serialize($data) : ''),
		));
	if (! $result) {
		return NULL;
	}
	$this->sid        = $sid;
	$this->next_id    = NULL;
	$this->expires    = $expires;
	$this->user_login = $user_login;
	$this->user_agent = $ua_hash;
	$this->term_ID    = $tid_hash;
	$this->sub_ID     = $sub_hash;
	$this->data       = $data;
	return $sid;
}

/* ==================================================
 * @param	none
 * @return	string  $new_sid
 */
public function renew_session() {
	global $wpdb;
	if ($this->next_id) {
		$sid = $this->next_id;
		$sql = $wpdb->prepare("SELECT * FROM `{$wpdb->prefix}ktaisession` WHERE next_id = %s", $sid);
		$result = $wpdb->get_row($sql);
		if ($result) {
			$this->sid        = $sid;
			$this->next_id    = $result->next_id;
			$this->expires    = strtotime($result->expires);
			$this->user_login = $result->user_login;
			$this->user_agent = $result->user_agent;
			$this->term_ID    = $result->term_id;
			$this->sub_ID     = $result->sub_id;
			$this->data       = unserialize($result->data);
			return $sid;
		}
		$this->next_id = NULL;
	}
	if ($this->sid && time() + intval(KS_SESSION_RENEWTIME) > $this->expires) {
		$new_sid    = $this->make_sid();
		$sql = $wpdb->prepare("UPDATE `{$wpdb->prefix}ktaisession` SET next_id = %s WHERE sid = %s AND next_id IS NULL LIMIT 1", $new_sid, $this->sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return $this->set_session($this->user_login, $new_sid, $this->data);
		}
	}
	return false;
}

/* ==================================================
 * @param	string  $sid
 * @return	boolean $is_succeeded
 */
public function unset_session($sid) {
	global $wpdb;
	if ($sid) {
		$sql = $wpdb->prepare("DELETE FROM `{$wpdb->prefix}ktaisession` WHERE sid = %s LIMIT 1", $sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return true;
		}
	}
	return false;
}

/* ==================================================
 * @param	string  $sid
 * @return	boolean $is_succeeded
 */
public function unset_prev_session($sid) {
	global $wpdb;
	if ($sid) {
		$sql = $wpdb->prepare("DELETE FROM `{$wpdb->prefix}ktaisession` WHERE next_id = %s  LIMIT 1", $sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return true;
		}
	}
	return false;
}

/* ==================================================
 * @param	none
 * @return	boolean $is_succeeded
 */
public function garbage_sessions() {
	global $wpdb;
	$sql = "DELETE FROM `{$wpdb->prefix}ktaisession` WHERE expires < NOW()";
	$result = $wpdb->query($sql);
	if ($result) {
		return true;
	}
	return false;
}

/* ==================================================
 * @param	none
 * @return	string   $user_login
 */
public function check_session() {
	global $wpdb;
	$sid = self::get_sid();
	if (empty($sid)) {
		return false;
	}
	self::garbage_sessions();
	$result = $wpdb->get_row($wpdb->prepare("SELECT * FROM `{$wpdb->prefix}ktaisession` WHERE sid = %s", $sid));

	if (! $result || strcmp(sha1($_SERVER['HTTP_USER_AGENT']), $result->user_agent) != 0) {
		return false;
	}

	// restore the session
	if (isset($this)) {
		$this->sid        = $sid;
		$this->next_id    = $result->next_id;
		$this->expires    = strtotime($result->expires);
		$this->user_login = $result->user_login;
		$this->user_agent = $result->user_agent;
		$this->term_ID    = $result->term_id;
		$this->sub_ID     = $result->sub_id;
		$data = unserialize($result->data);
		$this->data       = ($data ? $data : NULL);
	}
	return $result->user_login;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function redirect($redirect_to) {
	wp_redirect($this->add_sid($redirect_to, false));
}

/* ==================================================
 * @param	none
 * @return	none
 * based on wp_safe_redirect() at pluggable.php of WP 2.3
 */
public function safe_redirect($location) {
	$location = preg_replace('|[^a-z0-9-~+_.?#=&;,/:%]|i', '', $location);
	$location = wp_kses_no_null($location);

	// remove %0d and %0a from location
	$strip = array('%0d', '%0a');
	$found = true;
	while($found) {
		$found = false;
		foreach($strip as $val) {
			while(strpos($location, $val) !== false) {
				$found = true;
				$location = str_replace($val, '', $location);
			}
		}
	}

	if ( substr($location, 0, 2) == '//' ) {
		$location = 'http:' . $location;
	}
	$lp  = parse_url($location);
	$wpp = parse_url(get_option('home'));
	$allowed_hosts = (array) apply_filters('allowed_redirect_hosts', array($wpp['host']), $lp['host']);
	if ( isset($lp['host']) && ! in_array($lp['host'], $allowed_hosts) ) {
		$location = ks_admin_url(false);
	}
	wp_redirect($this->add_sid($location, false), $status);
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function shrink_redirect_to($uri) {
	$plugin_dir_pat = preg_quote(preg_replace('!^https?://[^/]*/!', '', $this->base->get('plugin_url')), '!');
	$redirect_to = preg_replace("!^.*?$plugin_dir_pat!", '', $uri);
	return $this->remove_sid($redirect_to);
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function auth_redirect() {
	if (! $this->check_session()) {
		$uri = preg_replace('!^.*' . preg_quote($this->base->strip_host($this->base->get('plugin_url')), '!') . '!', '', $_SERVER['REQUEST_URI']);
		wp_redirect($this->base->get('plugin_url') . 'login.php?redirect_to=' . urlencode($uri));
		exit();
	}
}

/* ==================================================
 * @param	none
 * @return	object  $this
 */
public function store_referer() {
	if (isset($_POST[KS_SESSION_NAME])) {
		return $this;
	}
	$current = $this->remove_sid($_SERVER['REQUEST_URI']);
	if ($this->get_data('referer')) {
		if (strcmp($this->get_data('referer'), $current) != 0) {
			$this->set_data('referer2', $this->get_data('referer'));
		}
	}
	$this->set_data('referer', $current);
	return $this;
}

/* ==================================================
 * @param	none
 * @return	string  $referer
 */
public function get_referer() {
	$referer = '';
	$current = $this->remove_sid($_SERVER['REQUEST_URI']);
	if (isset($_REQUEST['_wp_http_referer'])) {
		$referer = $this->remove_sid($_REQUEST['_wp_http_referer']);
	} elseif (isset($this->data['referer'])) {
		$referer = $this->get_data('referer');
		if (strcmp($referer, $current) == 0 && isset($this->data['referer2'])) {
			$referer = $this->get_data('referer2');
		}
	}
	if (strcmp($referer, $current) == 0) {
		$referer = false;
	} elseif ($referer) {
		$referer = $this->add_sid($referer, false);
	}
	return $referer;
}

// ===== End of class ====================
}
?>