<?php
/*
 Plugin Name: wp-odeckr
 Plugin URI: http://wppluginsj.sourceforge.jp/wp-odeckr/
 Description: 投稿時に記事から Flickr URL を抽出してメディアライブラリに登録します。
 Version: 1.00
 Author: hiromasa
 Author URI: http://another.maple4ever.net/
 */

/*  Copyright 2009 hiromasa (email : h1romas4@gmail.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpOdeckr - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;

/******************************************************************************
 * Pre-2.6 compatibility
 *****************************************************************************/
if(!defined('WP_CONTENT_DIR'))
	define('WP_CONTENT_DIR', ABSPATH . 'wp-content');
if(!defined('WP_CONTENT_URL'))
	define('WP_CONTENT_URL', get_option('siteurl') . '/wp-content');
if(!defined('WP_PLUGIN_DIR'))
	define('WP_PLUGIN_DIR', WP_CONTENT_DIR . '/plugins');
if(!defined('WP_PLUGIN_URL'))
	define('WP_PLUGIN_URL', WP_CONTENT_URL . '/plugins');

/******************************************************************************
 * WpOdeckr
 *
 * @author		hiromasa
 * @version		1.00
 *
 *****************************************************************************/
class WpOdeckr {
	
	var $imgPath;
	var $imgUrl;
	
	/**
	 * WpOdeckr
	 *
	 * @return WpOdeckr
	 */
	function WpOdeckr() {
		
		$this->imgPath = WP_CONTENT_DIR . '/uploads/flickr/';
		$this->imgUrl = WP_CONTENT_URL .  '/uploads/flickr/';
		
	}

	/**
	 * executeSchedulePublisd
	 *
	 * @param unknown_type $postID
	 */
	function executeSchedulePublisd($postID) {
		
		wp_schedule_single_event(
			time()
			,'getFrickr'
			,array($postID));
		
	}
	
	/**
	 * getFrickr
	 *
	 * @param unknown_type $postID
	 */
	function getFrickr($postID) {
		
		$post = get_post($postID);
		if(empty($post)) return;
		
		preg_match_all(
			'/\<img(.*)src=\"?([\-_\.\!\~\*\'\(\)a-z0-9\;\/\?\:@&=\+\$\,\%\#]+(jpg|jpeg|gif|png|bmp))/i'
			, $post->post_content
			, $matches
			, PREG_SET_ORDER);
		
		foreach($matches as $match) {
			$url = $match[2];
			$parsed = parse_url($url);
			if(strpos($parsed['host'], 'static.flickr.com') === false) {
				continue; 
			}
			$filepath = $this->getFrickrImage($url);
			if($filepath == false) {
				continue;
			}
			$image_url = $this->imgUrl . $filepath[1];
			if($this->checkOverride($image_url)) {
				continue;
			}
			preg_match('/alt=\"(.*)\"/i', $match[1] ,$alt);
			$title = $alt[1];
			if($title == '') $title = $url;
			$attachment = array(
				'guid'				=> $image_url,
				'post_mime_type'	=> 'image/jpg',
				'post_title' 		=> $title,
				'post_parent'       => $postID,
				'post_type'         => 'attachment',
				'post_content' 		=> '' );
			$id = wp_insert_attachment(
				$attachment
				, $filepath[0]
				, $postID);
			if (!is_wp_error($id)) {
				wp_update_attachment_metadata(
					$id
					,wp_generate_attachment_metadata($id, $filepath[0]));
			}
		}
		
	}
	
	/**
	 * checkOverride
	 *
	 * @return boolean
	 */
	function checkOverride($guid) {
		
		global $wpdb;
		
		$old_file =
			$wpdb->get_row($wpdb->prepare("
				SELECT ID
				FROM {$wpdb->posts}
				WHERE guid = '{%s}'
				AND post_type = 'attachment'"),
				$guid);
		if($old_file->ID != '') {
			return true;
		}
		return false;
		
	}
	
	/**
	 * getFrickrImage
	 *
	 * @param unknown_type $url
	 * @return $imgPath
	 */
	function getFrickrImage($url) {
		
		require_once(ABSPATH . WPINC . '/class-snoopy.php');
		
		$snoopy = new Snoopy;
		$snoopy->read_timeout = 30;
		$snoopy->timed_out = true;
		$snoopy->fetch($url);
		$imgbin = $snoopy->results;
		$http_code = $snoopy->response_code;
		unset($snoopy);
		
		if(strpos($http_code, '200') === false)
			return false;
		
		$img = @imagecreatefromstring($imgbin);
		if($img === false)
			return false;
		
		$imgPath = $this->getImgPath($url);
		@imagejpeg($img, $imgPath[0], 100);
		imagedestroy($img);
		
		return $imgPath;
		
	}
	
	/**
	 * getCachePath
	 *
	 * @return array($filePath, $fileName)
	 */
	function getImgPath($guid, $width = 320 , $height = 240) {
		
		$fileName = $this->getImgName($guid , $width , $height);
		$filePath = $this->imgPath . $fileName;
		
		return array($filePath, $fileName);
		
	}
	
	/**
	 * getCacheName
	 *
	 * @return $fileName
	 */
	function getImgName($guid, $width = 320, $height = 320) {
		
		$fileName = md5($guid . $width . $height) . '.jpg';
		return $fileName;
		
	}
	
}

/******************************************************************************
 * WpKougabu - WordPress Interface Define
 *****************************************************************************/

$wpOdeckr = new WpOdeckr();

//add_action('getFrickr', array (&$wpOdeckr, 'getFrickr'), 10, 1);
//add_action('publish_post', array (&$wpOdeckr, 'executeSchedulePublisd'));
add_action('publish_post', array (&$wpOdeckr, 'getFrickr'));
?>