<?php
/*
 Plugin Name: wp-kougabu
 Plugin URI: http://wppluginsj.sourceforge.jp/wp-kougabu/
 Description: 投稿記事から思い出の写真を抽出してページにサムネイル一覧表示する [kougabu] ショートコードを提供します。
 Version: 0.50
 Author: hiromasa
 Author URI: http://another.maple4ever.net/
 */

/*  Copyright 2008 hiromasa (email : h1romas4@gmail.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpKougabu - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;
if(is_admin()) return;

/******************************************************************************
 * Pre-2.6 compatibility
 *****************************************************************************/
if(!defined('WP_CONTENT_DIR'))
	define('WP_CONTENT_DIR', ABSPATH . 'wp-content');
if(!defined('WP_CONTENT_URL'))
	define('WP_CONTENT_URL', get_option('siteurl') . '/wp-content');
if(!defined('WP_PLUGIN_DIR'))
	define('WP_PLUGIN_DIR', WP_CONTENT_DIR . '/plugins');
if(!defined('WP_PLUGIN_URL'))
	define('WP_PLUGIN_URL', WP_CONTENT_URL . '/plugins');

/******************************************************************************
 * WpKougabu
 *
 * @author		hiromasa
 * @version		0.50
 *
 *****************************************************************************/
class WpKougabu {
	
	var $imageInfo;
	var $cachePath;
	
	/**
	 * The Constructor
	 *
	 * @param none
	 * @return none
	 */
	function WpKougabu() {
		
		$this->imageInfo = array();
		$this->cachePath = WP_PLUGIN_DIR . '/wp-kougabu/cache/';
		
	}
	
	/**
	 * WordPress shortcode Interface
	 *
	 * @param $attr
	 * @return $output
	 */
	function executeKougabu($attr) {
		
		extract(shortcode_atts(array(
			'itemtag'    => 'dl',
			'icontag'    => 'dt',
			'captiontag' => 'dd',
			'columns'    => 3,
			'max_width'  => 180,
			'max_height' => 180,
			'start'      => -1,
			'count'      => 0,
		), $attr));
		
		$listtag = tag_escape($listtag);
		$itemtag = tag_escape($itemtag);
		$captiontag = tag_escape($captiontag);
		$columns = intval($columns);
		$itemwidth = $columns > 0 ? floor(100/$columns) : 100;
		// internet explorer 7 hack.
		$itemwidth = $itemwidth - 1;
		$max_width = intval($max_width);
		$max_height = intval($max_height);
		$start = intval($start);
		$count = intval($count);
		
		$output = '';
		
		if(!$this->setImageInfo($start, $count)) {
			return "<p>There is no photograph in this page yet. </p>";
		}
		
		$output .= "
			<style type='text/css'>
			.gallery {
				margin: auto;
			}
			.gallery-item {
				float: left;
				margin-top: 10px;
				text-align: center;
				width: {$itemwidth}%;
			}
			.gallery img {
				border: 0px;
			}
			.gallery-caption {
				margin-left: 0;
			}
			</style>
			<div class='gallery'>";
		
		$cached = 0;
		foreach ($this->imageInfo as $guid => $image) {
			$image_size = wp_constrain_dimensions(
				$image['width'],
				$image['height'],
				$max_width,
				$max_height);
			
			$cachePath =
				$this->getCachePath($image['image_url'], $image_size[0], $image_size[1]);
			$image_url = WP_PLUGIN_URL . '/wp-kougabu';
			if(file_exists($cachePath)) {
				$image_url .= '/cache/';
				$image_url .=
					$this->getCacheName($image['image_url'], $image_size[0], $image_size[1]);
			} else if($cached < 10) {
				$image_url .= '/wp-kougabu-resize.php';
				$image_url .= '?guid=' . urlencode($image['image_url']);
				$image_url .= '&width=' . $image_size[0];
				$image_url .= '&height=' . $image_size[1];
				$this->imageInfo[$image['image_url']]['cached'] =
					array($image_size[0], $image_size[1]);
				$cached++;
			} else {
				$image_url = $image['image_url'];
			}
			
			$link  = "<a href=\"{$image['link_url']}\">";
			$link .=
					"<img src=\"{$image_url}\" width=\"{$image_size[0]}\" ".
					" height=\"{$image_size[1]}\" alt=\"{$image['name']}\" style='border: 0;'/>";
			$link .= "</a>";
			
			$output .= "<{$itemtag} class='gallery-item'>";
			$output .= "
			<{$icontag} class='gallery-icon'>
			$link
			</{$icontag}>";
			if ($captiontag && trim($image['post_title']) ) {
				$output .= "
				<{$captiontag} class='gallery-caption'>
				{$image['post_title']}
				</{$captiontag}>";
			}
			$output .= "</{$itemtag}>";
			if ( $columns > 0 && ++$i % $columns == 0 )
			$output .= '<br style="clear: both" />';
		}
		
		$output .= "
			<br style=\"clear: both\" /></div>";
		
		$this->updateOption();
		
		return $output;
		
	}
	
	/**
	 * setImageInfo
	 * 
	 * @param $start
	 * @param $end
	 * 
	 */
	function setImageInfo($start, $count) {
		
		global $wpdb;
		
		// http://ja.forums.wordpress.org/topic/387#post-1839
		$query =
			"SELECT"
			. "	 p1.ID as ID"
			. "	,p1.post_title as post_title"
			. "	,p2.guid as guid"
			. "	,m.meta_value as meta_value"
			. "  FROM"
			. "    {$wpdb->posts} as p1"
			. "    ,{$wpdb->posts} as p2"
			. "    ,{$wpdb->postmeta} as m"
			. "  WHERE"
			. "    p1.ID = p2.post_parent"
			. "    AND p1.post_parent = 0"
			. "    AND p1.post_status = 'publish'"
			. "    AND p2.ID = m.post_id"
			. "    AND p2.post_status = 'inherit'"
			. "    AND p2.post_mime_type like 'image%'"
			. "    AND m.meta_key = '_wp_attachment_metadata'"
			. "  ORDER BY"
			. "    p2.post_date DESC";
		//TODO:
		if($start != -1) {
			$query .= "    LIMIT {$start}, {$count}";
		}
		
		$images = $wpdb->get_results($query);
		if(count($images) == 0) return false;
		
		foreach($images as $image) {
			$meta = maybe_unserialize($image->meta_value);
			$this->imageInfo[$image->guid]['link_url'] = get_permalink((int)$image->ID);
			$this->imageInfo[$image->guid]['post_title'] = $image->post_title;
			$this->imageInfo[$image->guid]['image_url'] = $image->guid;
			$this->imageInfo[$image->guid]['width'] = $meta['width'];
			$this->imageInfo[$image->guid]['height'] = $meta['height'];
			$this->imageInfo[$image->guid]['name'] = basename($meta['file']);
		}
		
		return true;
		
	}
	
	/**
	 * updateOption
	 *
	 */
	function updateOption() {
		
		$value = get_option('wp-kougabu');
		if($value == '') {
			$value = array();
		}
		$value = array_merge($value, $this->imageInfo);
		update_option('wp-kougabu', $value);
		
	}
	
	/**
	 * getCachePath
	 *
	 * @return unknown
	 */
	function getCachePath($guid, $width, $height) {
		
		$fileName = $this->getCacheName($guid , $width , $height);
		$filePath = $this->cachePath . $fileName;
		
		return $filePath;
		
	}
	
	/**
	 * getCacheName
	 *
	 * @return unknown
	 */
	function getCacheName($guid, $width, $height) {
		
		$fileName = md5($guid . $width . $height) . '.jpg';
		return $fileName;
		
	}
	
}

/******************************************************************************
 * WpKougabu - WordPress Interface Define
 *****************************************************************************/

$wpKougabu = & new WpKougabu();
add_shortcode('kougabu', array (&$wpKougabu, 'executeKougabu'));

?>
