<?php 
load_theme_textdomain('redportal');

function redportal_get_next_num() {
	global $wp_query;
	$per_page = get_option('posts_per_page');
	$page = get_query_var('paged') ? get_query_var('paged') : 1;
	if ($page == $wp_query->max_num_pages -1) {
		$next_num = $wp_query->found_posts % $per_page;
	} else {
		$next_num = $per_page;
	}
	return $next_num;
}

/* ==================================================
 *   Redportal_Walker_Comment class
 *   based on class Walker_Comment at wp-includes/comment-template.php of WP 2.7
   ================================================== */
class Redportal_Walker_Comment extends Walker {
	public $tree_type = 'comment';
	public $db_fields = array ('parent' => 'comment_parent', 'id' => 'comment_ID');

	public function start_lvl(&$output, $depth, $args) {
		$GLOBALS['comment_depth'] = $depth + 1;

		switch ( $args['style'] ) {
			case 'div':
				break;
			case 'ol':
				echo '<ol>';
				break;
			default:
			case 'ul':
				echo '<ul>';
				break;
		}
	}

	public function end_lvl(&$output, $depth, $args) {
		$GLOBALS['comment_depth'] = $depth + 1;

		switch ( $args['style'] ) {
			case 'div':
				break;
			case 'ol':
				echo '</ol>';
				break;
			default:
			case 'ul':
				echo '</ul>';
				break;
		}
	}

	public function start_el(&$output, $comment, $depth, $args) {
		$depth++;
		$GLOBALS['comment_depth'] = $depth;

		if ( !empty($args['callback']) ) {
			call_user_func($args['callback'], $comment, $args, $depth);
			return;
		}

		$GLOBALS['comment'] = $comment;
		extract($args, EXTR_SKIP);

		if ( 'div' == $args['style'] ) {
			$tag = 'div';
		} else {
			$tag = 'li';
		}
?>
		<<?php echo $tag ?>><a name="comment-<?php comment_ID(); ?>"><?php 
		if (! ks_option('ks_separate_comments')) {
			?><font size="-1" color="<?php echo ks_option('ks_comment_type_color'); ?>">[<?php 
			comment_type(_c('Comment|noun'), __('Trackback'), __('Pingback')); ?>]</font><?php 
		}
		?></a> <img localsrc="<?php comment_type(68, 112, 112); ?>" alt="" /><?php ks_comment_author_link();
		?><img localsrc="46" alt=" @ " /><font color="red"><?php ks_comment_datetime(); ?></font><br />
		<?php if ($comment->comment_approved == '0') { ?>
			<em><font color="blue"><?php _e('Your comment is awaiting moderation.') ?></font></em><br />
		<?php }
		comment_text();
		comment_reply_link(array_merge(
			array('before' => '<div>', 'after' => '</div><br />', 'reply_text' => '<img localsrc="149" alt="" />' . __('Reply'), 'login_text' => '<img localsrc="120" alt="" />' . __('Log in to Reply')), 
			$args, 
			array('depth' => $depth, 'max_depth' => $args['max_depth'])
		));
	}

	public function end_el(&$output, $comment, $depth, $args) {
		if ( !empty($args['end-callback']) ) {
			call_user_func($args['end-callback'], $comment, $args, $depth);
			return;
		}
		if ( 'div' == $args['style'] )
			echo '</div>';
		else
			echo '</li>';
	}

}
// ===== End of class ====================
?>