<?php
/* ==================================================
 *   Ktai Admin Edit Post
 *   based on wp-admin/edit.php of WP 2.3, 2.7
   ================================================== */

define ('KS_SHOW_TAG_PAGE_SIZE', 9000);
define ('KS_HEADER_FOOTER_SIZE', 3000);
define ('KS_COLUMN_SIZE_BIG', 768);
define ('KS_COLUMN_SIZE_SMALL', 340);
require dirname(__FILE__) . '/admin.php';
$title = __('Edit Posts', 'ktai_style');
$parent_file = 'edit.php';
$View = new KS_Admin_Edit_Posts($Ktai_Style, $KS_Admin);
$View->output();
exit();

/* ==================================================
 *   KS_Admin_Edit_Posts class
   ================================================== */

class KS_Admin_Edit_Posts {
	private $base;
	private $admin;
	private $year;
	private $monthnum;
	private $cat;
	private $tag;
	private $search;
	private $show_tags;

// ==================================================
public function __construct($base, $admin) {
	$this->base  = $base;
	$this->admin = $admin;
	$this->year = isset($_GET['year']) ? intval($_GET['year']) : '';
	if ($this->year < 1900 || $this->year > 2999) {
		$this->year = '';
	}
	$this->monthnum = isset($_GET['monthnum']) ? intval($_GET['monthnum']) : '';
	if ($this->monthnum < 1 || $this->monthnum > 12) {
		$this->monthnum = '';
	}
	$this->cat = isset($_GET['cat']) ? intval($_GET['cat']) : '';
	$this->tag = isset($_GET['tag']) ? $_GET['tag'] : '';
	$this->search = isset($_GET['s']) ? stripslashes($_GET['s']) : '';
	$this->show_tags = ($this->base->ktai->get('page_size') >= KS_SHOW_TAG_PAGE_SIZE);
}

// ==================================================
private function edit_posts_query() {
	$post_stati  = array(	//	array( adj, noun )
		'publish' => array(__('Published'), __('Published posts'), __ngettext_noop('Published (%s)', 'Published (%s)')),
		'future' => array(__('Scheduled'), __('Scheduled posts'), __ngettext_noop('Scheduled (%s)', 'Scheduled (%s)')),
		'pending' => array(__('Pending Review'), __('Pending posts'), __ngettext_noop('Pending Review (%s)', 'Pending Review (%s)')),
		'draft' => array(__('Draft'), _c('Drafts|manage posts header'), __ngettext_noop('Draft (%s)', 'Drafts (%s)')),
		'private' => array(__('Private'), __('Private posts'), __ngettext_noop('Private (%s)', 'Private (%s)')),
	);
	$post_stati = apply_filters('post_stati', $post_stati);

	$column_size = ($this->show_tags) ? KS_COLUMN_SIZE_BIG : KS_COLUMN_SIZE_SMALL;
	$per_page = intval(($this->base->get('page_size') - KS_HEADER_FOOTER_SIZE) / $column_size);
	if ($per_page < 1) {
		$per_page = 1;
	} elseif ($per_page > 15) {
		$per_page = 15;
	}
	$pagenum = isset($_GET['paged']) ? intval($_GET['paged']) : 1;

	$query = array(
		'post_type' => 'post',
		'what_to_show' => 'posts',
		'post_status' => 'any',
		'posts_per_page' => $per_page,
		'paged' => $pagenum, 
		'year' => $this->year,
		'monthnum' => $this->monthnum,
		'cat' => $this->cat,
		'tag' => $this->tag,
		'author' => intval($_GET['author']),
		's' => $this->search,
	);
	if ( isset($_GET['post_status'])) {
		$post_status = stripslashes($_GET['post_status']);
		if ( in_array($post_status, array_keys($post_stati)) ) {
			$query['post_status'] = $post_status;
			$query['perm'] = 'readable';
		}
	}
	if ( 'pending' === $_GET['post_status'] ) {
		$query['order']   = 'ASC';
		$query['orderby'] = 'modified';
	} elseif ( 'draft' === $_GET['post_status'] ) {
		$query['order']   = 'DESC';
		$query['orderby'] = 'modified';
	} else {
		$query['order']   = 'DESC';
		$query['orderby'] = 'date';
	}
	$query = apply_filters('manage_pages_query', $query);
	query_posts($query);

	return array($post_stati, $pagenum, $per_page);
}

// ==================================================
public function status_menu($post_stati) {
	global $parent_file, $submenu, $submenu_file;

	$num_posts = wp_count_posts('post', 'readable');
	$link = $submenu_file = 'edit.php';
	$submenu[$parent_file] = array(
		array(($this->base->check_wp_version(2.7) ? __('Add New Post') : __('Create New Post')), 'edit_posts', 'post-new.php'),
		array(__('Any', 'ktai_style'), 'edit_posts', $link),
	);
	$post_status_label = __('Posts');

	$avail_post_stati = get_available_post_statuses('post');
	foreach ( $post_stati as $status => $label ) {
		if ( !in_array( $status, $avail_post_stati ) ) {
			continue;
		}
		if ( empty( $num_posts->$status ) ) {
			continue;
		}
		$link = add_query_arg( 'post_status', $status, $link );
		$submenu[$parent_file][] = array(sprintf(__ngettext( $label[2][0], $label[2][1], $num_posts->$status, 'ktai_style'), number_format_i18n($num_posts->$status)), 'edit_posts', $link);
		if ( str_replace( 'any', '', $status ) == $_GET['post_status'] ) {
			$submenu_file = $link;
			$post_status_label = $label[1];
		}
	}
	return $post_status_label;
}

// ==================================================
public function page_title($post_status_label) {
	global $user_ID, $post_listing_pageable, $wp_locale;
	if ($post_listing_pageable && ! is_archive() && ! is_search()) {
		$h2_noun = is_paged() ? sprintf(__( 'Previous %s' ), $post_status_label) : sprintf(__('Latest %s'), $post_status_label);
	} else {
		$h2_noun = $post_status_label;
	}
	// Use $_GET instead of is_ since they can override each other
	$h2_author = '';
	$_GET['author'] = intval($_GET['author']);
	if ( $_GET['author'] != 0 ) {
		if ( $_GET['author'] == '-' . $user_ID ) { // author exclusion
			$h2_author = ' ' . __('by other authors');
		} else {
			$author_user = get_userdata( $_GET['author'] );
			$h2_author = ' ' . sprintf(__('by %s', 'ktai_style'), wp_specialchars( $author_user->display_name ));
		}
	}
	$h2_search = $this->search ? ' ' . sprintf(__('matching &#8220;%s&#8221;', 'ktai_style'), wp_specialchars($this->search)) : '';
	$h2_cat = $this->cat ? ' ' . sprintf(__('in &#8220;%s&#8221;', 'ktai_style'), single_cat_title('', false)) : '';
	$h2_tag = $this->tag ? ' ' . sprintf(__('with tag &#8220;%s&#8221;', 'ktai_style'), single_tag_title('', false)) : '';
	$h2_m = $this->monthum ? $wp_locale->get_month($this->monthum) : '';
	$h2_y = $this->year ? $this->year : '';
	$h2_month = "$h2_m$h2_y" ? sprintf(__('during %1$s, %2$d', 'ktai_style'), $h2_m, $h2_y) : '';
//	return sprintf(_c('%1$s%2$s%3$s%4$s%5$s|You can reorder these: 1: Posts, 2: by {s}, 3: matching {s}, 4: in {s}, 5: during {s}'), $h2_noun, $h2_author, $h2_search, $h2_cat, $h2_month);
	if ($h2_author || $h2_search || $h2_cat || $h2_tag || $h2_month) {
		echo '<h2>' . sprintf(_c('%1$s%2$s%3$s%4$s%5$s%6$s|You can reorder these: 1: Posts, 2: by {s}, 3: matching {s}, 4: in {s}, 5: with {s}, 6: during {s}', 'ktai_style'), $h2_noun, $h2_author, $h2_search, $h2_cat, $h2_tag, $h2_month) . '</h2>';
	}
}

// ==================================================
public function author_menu() {
	global $user_ID;
	$editable_ids = get_editable_user_ids($user_ID);
	$html = '';
	if ( $editable_ids && count($editable_ids) >= 1 ) {
		if (function_exists('wp_dropdown_users')) {
			$html = __('Author');
			$html .= $this->base->filter_tags(wp_dropdown_users(array(
				'include' => $editable_ids, 
				'show_option_all' => __('Any', 'ktai_style'), 
				'name' => 'author', 
				'selected' => isset($_GET['author']) ? $_GET['author'] : 0, 
				'echo' => 0)));
		} else {
			$html = __('Post Author');
			$html .= '<select name="author"><option value="0">' . __('Any', 'ktai_style') . '</option>';
			foreach ($editable_ids as $e) {
				$a = get_userdata($e);
				if (isset($_GET['author']) && $_GET['author'] == $a->ID) { 
					$selected = ' selected="selected"';
				} else {
					$selected = '';
				}
				$html .= '<option value="' . intval($e) . '"' . $selected . '>' . $a->display_name . '</option>';
			}
			$html .= '</select>';
		}
	}
	return $html;
}

// ==================================================
public function month_menu() {
	$html = sprintf(__('<label>Monthnum: <input type="text" name="monthnum" size="2" istyle="4" mode="numeric" value="%1$s" /></label>, <label>Year: <input type="text" name="year" size="4" istyle="4" mode="numeric" value="%2$s" /></label>', 'ktai_style'), $this->monthnum, $this->year);
	return $html;
}

/// ==================================================
public function output() {
	global $wp_query, $title, $parent_file;
	list($post_stati, $pagenum, $per_page) = $this->edit_posts_query();	

	include dirname(__FILE__) . '/admin-header.php';
	$post_status_label = $this->status_menu($post_stati);
	$this->page_title($post_status_label);
	if ( isset($_GET['posted']) && $_GET['posted'] ) {
		$_GET['posted'] = (int) $_GET['posted'];
		?><p><font color="teal"><?php _e('Your post has been saved.'); ?></font></p><?php
		$_SERVER['REQUEST_URI'] = remove_query_arg(array('posted'), $_SERVER['REQUEST_URI']);
	}
?>
<form action="" method="get"><div>
<?php $this->admin->sid_field(); ?>
<?php _e('Search'); ?><input type="text" name="ks" value="<?php echo wp_specialchars($this->search); ?>" size="17" /><br />
<?php
	$author_menu = $this->author_menu();
	if ($author_menu) {
		echo $author_menu . '<br />';
	}
	$month_menu = $this->month_menu();
	if ($month_menu) {
		echo $month_menu . '<br />';
	}
	if ( isset($_GET['post_status'] ) ) { ?>
<input type="hidden" name="post_status" value="<?php echo attribute_escape($_GET['post_status']) ?>" />
<?php } ?>
<input type="submit" value="<?php _e('Filter', 'ktai_style'); ?>" /></div></form>
<?php
	if (have_posts()) {
		$this->post_rows();
		$page_links = paginate_links( array(
			'base' => add_query_arg('paged', '%#%'), 
			'format' => '',
			'total' => $GLOBALS['wp_query']->max_num_pages,
			'current' => $pagenum,
			'prev_text' => __('<img localsrc="7" alt="&laquo;" />Previous Page', 'ktai_style'),
			'next_text' => __('Next Page<img localsrc="8" alt="&raquo;" />', 'ktai_style'),
		));
		if ($page_links) {
			$page_links = $this->base->filter_tags($page_links);
			$page_links = preg_replace('/ class=([\'"])[-_ \w]+\1/', '', $page_links); //"
			$page_links = str_replace("\n", ' ', $page_links);
			$page_links = str_replace(ks_admin_url(false), '', $page_links);
			echo '<br /><div>' . $page_links . '</div>';
		}
	} else { ?>
<p><?php _e('No posts found.'); ?></p>
<?php
	} // have_posts()
	include dirname(__FILE__) . '/admin-footer.php';
}

// ==================================================
public function post_rows() {
	global $post;
	$second = false;
?><dl><?php 
	while (have_posts()) : the_post();
		$title = $this->admin->draft_or_post_title();
		if ( current_user_can('edit_post', $post->ID) ) {
			$title = sprintf(__('<img localsrc="149" alt="" /><a href="%1$s">%2$s</a>', 'ktai_style'), $this->admin->add_sid(get_edit_post_link($post->ID)), $title);
		}
		if ('draft' === $_GET['post_status'] || 'pending' === $_GET['post_status']) {
			if ('0000-00-00 00:00:00' == $post->post_modified) {
				$time = __('Never');
			} else {
				$time = ks_get_mod_time();
			}
		} else {
			if ('0000-00-00 00:00:00' == $post->post_date) {
				$time = __('Unpublished');
			} else {
				$time = ks_get_time();
			}
		}
		echo '<dt>' . sprintf(_c('%1$5d:%2$s%3$s|post_row_title', 'ktai_style'), $post->ID, $title, $this->admin->get_post_states($post)) . '</dt><dd>' . 
			sprintf(__('<img localsrc="68" alt="by " />%1$s<img localsrc="46" alt=" at " /><font color="%2$s">%3$s</font>', 'ktai_style'), get_the_author(), ks_option('ks_date_color'), $time) . '</dd>';
		$categories = get_the_category();
		if (! empty($categories)) {
			$cat_links = array();
			foreach ($categories as $c) {
				$cat_links[] = '<a href="' . basename(__FILE__) . $this->admin->add_sid('?cat=' . $c->cat_ID) . '"><font color="gray">' . wp_specialchars(sanitize_term_field('name', $c->name, $c->term_id, 'category', 'display')) . '</font></a>';
			}
			echo '<dd>' . sprintf(__('<img localsrc="354" alt="%1$s" /><font size="-1">%2$s</font>', 'ktai_style'), __('Category:'), implode(', ', $cat_links)) . '</dd>';
		}
		if ($this->show_tags) {
			$tags = get_the_tags($post->ID);
			if (! empty($tags)) {
				$tag_links = array();
				foreach ($tags as $t) {
					$tag_links[] = '<a href="' . basename(__FILE__) . $this->admin->add_sid('?tag=' . $t->slug) . '"><font color="gray">' . wp_specialchars(sanitize_term_field('name', $t->name, $t->term_id, 'post_tag', 'display')) . '</font></a>';
				}
				echo '<dd>' . sprintf(__('<img localsrc="77" alt="%1$s" /><font size="-1">%2$s</font>', 'ktai_style'), __('Tags:'), implode(', ', $tag_links)) . '</dd>';
			}
		}
	endwhile;
?></dl><?php
}

// ===== End of class ====================
}
?>