<?php
/* 
Plugin Name: Weather Journal
Plugin URI: http://wppluginsj.sourceforge.jp/weather_journal/
Description: Insert a weather symbol at each date.
Author: IKEDA yuriko
Version: 1.2.0
Author URI: http://www.yuriko.net/cat/wordpress/
*/
/*  Copyright (c) 2007-2009 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define ('WEATHER_PICS_DIR', 'pics/');
define ('WEATHER_SET_STRIING', 'WEATHER:');

if (defined('WP_INSTALLING') && WP_INSTALLING) {
	return;
}
global $Weather;
$Weather = new Weather_Journal;

/* ==================================================
 *   Weather_Journal classses
   ================================================== */

class Weather_Journal_Item {
	public $type;
	public $desc;
}

class Weather_Journal {
	private $plugin_dir;
	private $plugin_url;
	private $db_prefix;
	static  $wp_vers;
	static public $type;
	static public $ktai_pict = array(
		'sun'          => '44',
		'cloud'        => '107',
		'thunder'      => '16',
		'fog'          => '305',
		'rain'         => '95',
		'storm'        => '190',
		'snow'         => '191',
		'snowfall'     => '191',
		'sleet'        => '191',
		'snow_thunder' => '191',
	);

// ==================================================
public function __construct() {
	global $wpdb;
	$this->set_plugin_dir();
	$this->load_textdomain('weather_journal');
	$this->db_prefix = $wpdb->prefix;  
	if (defined('WEATHER_JOURNAL_DB_PREFIX') && ! preg_match('/[^0-9a-zA-Z_]/', WEATHER_JOURNAL_DB_PREFIX)) {
		$this->db_prefix = WEATHER_JOURNAL_DB_PREFIX;
	}

	$this->type = array(
		'sun'                => __('Sunny', 'weather_journal'),
		'sun+cloud'          => __('Sunny intervals', 'weather_journal'), 
		'sun-cloud'          => __('Sunny then Cloudy', 'weather_journal'), 
		'sun+rain'           => __('Sunny, and Shower', 'weather_journal'), 
		'sun.rain'           => __('Sunny, intermittent Shower', 'weather_journal'), 
		'sun-rain'           => __('Sunny then Rain', 'weather_journal'), 
		'sun.thunder'        => __('Sunny, intermittent Thunderstorm', 'weather_journal'), 
		'sun-thunder'        => __('Sunny then Thunderstorm', 'weather_journal'), 
		'sun+snow'           => __('Sunny, and Snow Shower', 'weather_journal'), 
		'sun.snow'           => __('Sunny, intermittent Snow', 'weather_journal'), 
		'sun-snow'           => __('Sunny then Snow', 'weather_journal'), 
		'cloud'              => __('Cloudy', 'weather_journal'), 
		'cloud+sun'          => __('Partly Cloudy', 'weather_journal'), 
		'cloud-sun'          => __('Cloudy then Sunny', 'weather_journal'), 
		'cloud+rain'         => __('Shower', 'weather_journal'), 
		'cloud.rain'         => __('Intermittent Shower', 'weather_journal'), 
		'cloud-rain'         => __('Cloudy then Rain', 'weather_journal'), 
		'cloud+thunder'      => __('Shower with Thunder', 'weather_journal'), 
		'cloud.thunder'      => __('Intermittent Thunderstorm', 'weather_journal'), 
		'cloud-thunder'      => __('Cloudy then Thunderstorm', 'weather_journal'), 
		'cloud+snow'         => __('Snow Shower', 'weather_journal'), 
		'cloud.snow'         => __('Intermittent Snow', 'weather_journal'), 
		'cloud-snow'         => __('Cloudy then Snow', 'weather_journal'), 
		'cloud+snow_thunder' => __('Snow Shower with Thunder', 'weather_journal'), 
		'fog'                => __('Fog', 'weather_journal'), 
		'rain'               => __('Rain', 'weather_journal'), 
		'storm'              => __('Storm', 'weather_journal'), 
		'thunder'            => __('Thunderstorm', 'weather_journal'), 
		'rain+sun'           => __('Rain, Sunny at times', 'weather_journal'), 
		'rain-sun'           => __('Rain then Sunny', 'weather_journal'), 
		'rain+cloud'         => __('Mostly Rain', 'weather_journal'), 
		'rain-cloud'         => __('Rain then Cloudy', 'weather_journal'), 
		'rain.sleet'         => __('Rain, intermittent Sleet', 'weather_journal'), 
		'rain+snow'          => __('Rain with Snow Shower', 'weather_journal'), 
		'rain.snow'          => __('Rain, intermittent Snow', 'weather_journal'), 
		'rain-snow'          => __('Rain then Snow', 'weather_journal'), 
		'snow'               => __('Snow', 'weather_journal'), 
		'snowfall'           => __('Heavy Snow', 'weather_journal'), 
		'snow+sun'           => __('Snow, Sunny at times', 'weather_journal'), 
		'snow-sun'           => __('Snow then Sunny', 'weather_journal'), 
		'snow+cloud'         => __('Mostly Snow', 'weather_journal'), 
		'snow-cloud'         => __('Snow then Cloudy', 'weather_journal'), 
		'snow+rain'          => __('Snow with Rain Shower', 'weather_journal'), 
		'snow.rain'          => __('Snow, intermittent Rain Shower', 'weather_journal'), 
		'snow-rain'          => __('Snow then Rain', 'weather_journal'), 
		'snow.sleet'         => __('Snow, intermittent Sleet', 'weather_journal'), 
		'snow-sleet'         => __('Snow then Sleet', 'weather_journal'), 
		'snow_thunder'       => __('Snow with Thunder', 'weather_journal'), 
	);
	add_filter('the_date', array($this, 'show'), 10, 4);
	add_action('edit_post', array($this, 'set'), 10);
	add_action('publish_post', array($this, 'set'), 10);
	add_action('publish_phone', array($this, 'set_by_content'), 10);

	if ($this->check_wp_version(2.5)) {
		if (defined('WP_ADMIN') && WP_ADMIN) {
			add_action('admin_init', array($this, 'add_weather_meta'));
			$plugin = $this->get('plugin_dir') . '/' . basename(__FILE__);
			add_action('activate_' . $plugin, array($this, 'install'));
		}
	} else {
		add_action('dbx_post_sidebar', array($this, 'edit_23'), 10);
		if (isset($_GET['activate']) && $_GET['activate'] == 'true') {
			add_action('init', array($this, 'install'));
		}
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
private function set_plugin_dir() {
	$this->plugin_dir = basename(dirname(__FILE__));
	if (defined('WP_PLUGIN_URL')) {
		$url = WP_PLUGIN_URL . '/';
	} else {
		$url = get_bloginfo('wpurl') . '/' . (defined('PLUGINDIR') ? PLUGINDIR . '/': 'wp-content/plugins/');
	}
	$this->plugin_url = $url . $this->plugin_dir . '/';
}

/* ==================================================
 * @param	string   $domain
 * @param	string   $subdir
 * @return	none
 */
private function load_textdomain($domain, $subdir = '') {
	if ($this->check_wp_version('2.6') && defined('WP_PLUGIN_DIR')) {
		load_plugin_textdomain($domain, false, $this->get('plugin_dir') . ($subdir ? '/' . $subdir : ''));
	} else {
		$plugin_path = defined('PLUGINDIR') ? PLUGINDIR . '/': 'wp-content/plugins/';
		load_plugin_textdomain($domain, $plugin_path . $this->get('plugin_dir') . ($subdir ? '/' . $subdir : ''));
	}
}

/* ==================================================
 * @param	string   $version
 * @param	string   $operator
 * @return	boolean  $result
 */
public function check_wp_version($version, $operator = '>=') {
	if (! isset($this->wp_vers)) {
		$this->wp_vers = get_bloginfo('version');
		if (! is_numeric($this->wp_vers)) {
			$this->wp_vers = preg_replace('/[^.0-9]/', '', $this->wp_vers);
		}
	}
	return version_compare($this->wp_vers, $version, $operator);
}

/* ==================================================
 * @param	string  $key
 * @return	boolean $charset
 */
//public 
function get($key) {
	return isset($this->$key) ? $this->$key : NULL;
}

// ==================================================
public function show($the_date, $d, $before, $after) {
	if (! $the_date) {
		return $the_date;
	}
	global $post;
	$weather = $this->read($post->post_date);
	if (is_null($weather)) {
		return $the_date;
	}
	if (function_exists('is_ktai') && is_ktai() 
	|| function_exists('is_mobile') && is_mobile()
	|| function_exists('mobile_press')) {
		$output = $this->mobile_weather($weather);
		if ($output) {
			$the_date = preg_replace(
				'/' . preg_quote($after, '/') . '$/', 
				' ' . __('Weather:', 'weather_journal') . $output . $after, 
				$the_date
			);
		}
	} else {
		if ($weather->type) {
			$output .= '<img src="' . attribute_escape($this->get('plugin_url') . WEATHER_PICS_DIR . $weather->type) . '.png" alt="' . attribute_escape($weather->desc) . '" />';
		}
		$the_date .= "\n" . '<div class="weather">' . $output . '</div>';
	}
	return $the_date;
}

// ==================================================
private function ktai_pict($type, $desc) {
	return '<img localsrc="' . attribute_escape(self::$ktai_pict[$type]) . '" alt="' . attribute_escape($desc) . '" />';
}

// ==================================================
private function mobile_weather($weather) {
	if (class_exists('Ktai_Style') && strcmp(is_ktai(), 'Unknown') !== 0) {
		if (strpos($weather->type, '+') !== false || strpos($weather->type, '.') !== false) {
			$w = preg_split('/[+.]/', $weather->type, 2);
			$output = $this->ktai_pict($w[0], $weather->desc) . '/' . $this->ktai_pict($w[1], '');
		} elseif (strpos($weather->type, '-') !== false) {
			$w = explode('-', $weather->type);
			$output = $this->ktai_pict($w[0], $weather->desc) . '<img localsrc="63" alt="" />' . $this->ktai_pict($w[1], '');
		} elseif ($weather->type) {
			$output = $this->ktai_pict($weather->type, $weather->desc);
		} else {
			$output = '';
		}
	} else {
		$output = $weather->desc;
	}
	return $output;
}

/* ==================================================
 * @param	int      $post_ID
 * @return	int      $post_ID
 */
public function set($post_ID) {
	if (! isset($_POST['weather_of_date'])) {
		return $post_ID;
	}
	$weather = stripslashes($_POST['weather_of_date']);
	$post = get_post($post_ID);
	if ($post) {
		$this->update($post->post_date, $weather);
	}
	return $post_ID;
}

/* ==================================================
 * @param	int      $post_ID
 * @return	int      $post_ID
 */
public function set_by_content($post_ID) {
	$post = get_post($post_ID);
	if (! $post) {
		return $post_ID;
	}

	if (! preg_match('/^(<p>|<div>)?' . preg_quote(WEATHER_SET_STRIING, '/') . '(.*)$/m', $post->post_content, $w)) {
		return $post_ID;		
	}
	$weather = trim($w[2]);

	if (! array_key_exists($weather, $this->type)) {
		$weather = array_search($weather, $this->type);
		if ($weather === false) {
			return $post_ID;
		}
	}

	$result = $this->update($post->post_date, $weather);
	global $wpdb;
	$post->post_content = trim(preg_replace('/^' . preg_quote($w[0], '/') . '[ \t\r]*(\n|\z)/m', '', $post->post_content, 1));
	$content_sql = $wpdb->escape($post->post_content);
	$id_sql = intval($post->ID);
	$wpdb->query("UPDATE {$wpdb->posts} SET post_content = '$content_sql' WHERE ID = $id_sql");
	$posts = array($post);
	update_post_cache($posts);
	return  $post_ID;
}

// ==================================================
private function read($date) {
	global $wpdb;
	if (is_array($date)) {
		$date_list = $date;
	} else {
		$date_list = array($date);
	}
	$result = array();
	foreach ($date_list as $pub_date) {
		$d = mysql2date('Y-m-d', $pub_date);
		$type = $wpdb->get_var("SELECT type FROM `{$this->db_prefix}ynweather` WHERE pub_date = '$d' LIMIT 1");
		$w = new Weather_Journal_Item;
		$w->type = $type;
		$w->desc = $type ? $this->type[$type] : '';
		$result[$d] = $w;
	}
	if (is_array($date)) {
		return $result;
	}
	return $result[$d];
}

// ==================================================
private function update($pub_date, $type) {
	if ($type != 'x' && ! array_key_exists($type, $this->type)) {
		return false;
	}
	global $wpdb;
	$date_sql = mysql2date('Y-m-d', $pub_date);
	if ($type == 'x') {
		$result = $wpdb->query("DELETE FROM `{$this->db_prefix}ynweather` WHERE pub_date = '$date_sql' LIMIT 1");
	} else {
		$type_sql = $wpdb->escape($type);
		$result = $wpdb->query("REPLACE INTO `{$this->db_prefix}ynweather` (pub_date, type) VALUES ('$date_sql', '$type_sql')");
	}
	return $result;
}

// ==================================================
public function install() {
	global $wpdb, $user_level;
	global $wpdb;
	if (! current_user_can('activate_plugins')) {
		return;
	}
	$types = implode("','", array_keys($this->type));
	$sql = "CREATE TABLE IF NOT EXISTS `{$this->db_prefix}ynweather` (
		    `pub_date` date NOT NULL default '1900-00-00',
		    `type` enum('$types') default NULL,
		    PRIMARY KEY (`pub_date`)
		    );";
	require_once ABSPATH . 'wp-admin/upgrade-functions.php';
	dbDelta($sql);
	return;
}

// ==================================================
public function add_weather_meta() {
	if (function_exists('add_meta_box')) {
		$context = $this->check_wp_version(2.7) ? 'side' : 'advanced';
		add_meta_box('weather_journal', __('Weather of this date', 'weather_journal'), array($this, 'edit'), 'post', $context);
	}
}

// ==================================================
public function edit($post, $box) {
	$dropdown = $this->get_weather_dropdown($post);
?>
<select name="weather_of_date"><?php echo $dropdown; ?></select>
<?php
}

// ==================================================
public function edit_23() {
	global $post;
	$dropdown = $this->get_weather_dropdown($post);
?>
<fieldset id="weatherdiv" class="dbx-box">
<h3 class="dbx-handle"><?php _e('Weather of this date', 'weather_journal') ?></h3> 
<div class="dbx-content"><select name="weather_of_date"><?php echo $dropdown; ?></select></div>
</fieldset>
<?php
}

// ==================================================
public function get_weather_dropdown($post) {
	if (isset($post->post_date)) {
		$weather = $this->read($post->post_date);
		$type = $weather->type;
	} else {
		$type = '-';
	}
	$list = array('-' => __('(unknown)', 'weather_journal')) + $this->type + array('x' => __('-Delete-', 'weather_journal'));
	$dropdown = '';
	foreach ($list as $k => $w) {
		$selected = ($type == $k) ? '" selected="selected"' : '"';
		$dropdown .= '<option value="' . $k . $selected . '>' . $w . '</option>' . "\n";
	}
	return $dropdown;
}
// ===== End of class ==============================
}

?>