<?php
/*
Plugin Name: Twicon for WordPress
Plugin URI: http://wppluginsj.sourceforge.jp/twicon/
Description: This is a simple but yet powerful plugin for wordpress that lets you show your users Twitter avatar together with their comments in your website.
Author: wokamoto
Version: 1.0.0
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2009 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

define ('TWICON_EXPIRED', 12);

class twiconController {
	var $avatars;
	var $meta_value;

	/**********************************************************
	* Constructor
	***********************************************************/
	function twiconController() {
		$this->__construct();
	}
	function __construct() {
		if (!class_exists('Snoopy'))
			require_once(ABSPATH . WPINC . '/class-snoopy.php');
		$this->avatars = get_option('twicon');
		$this->meta_value = array();
	}

	function updateAvatars() {
		update_option('twicon', $this->avatars);
	}

	function getAvatar($avatar, $id_or_email, $size = '96', $default = '', $alt = false) {
		$result = $this->showUser($id_or_email);

		// If User has twitter
		if(isset($result['profile_image_url']) && $result['profile_image_url'] !== false) {
			$safe_alt = ( false === $alt ? '': attribute_escape( $alt ));

			if ( !is_numeric($size) )
				$size = '96';

			if ($size <= "24")
				$suffix = "_mini";
			else if ($size <= "48")
				$suffix = "_normal";
			else if ($size <= "73")
				$suffix = "_bigger";
			else
				$suffix = "";

			$image = $result['profile_image_url'];
			if (strpos($image, "static.twitter.com") === false) {
				$wherestop = strrpos($image, "_");
				$lenght = strlen( $image  );
				$takeof = $lenght - $wherestop;
				$keepit = $lenght - 4;
				$fileextension = substr($image, $keepit, 4);
				$image = substr($image, 0, -$takeof) . $suffix . $fileextension;

				$avatar = preg_replace('/^(<img.*src=[\'"])[^\'"]*([\'"].* \/>)$/i', '$1'.$image.'$2', $avatar);
			}

		}

		return $avatar;
	}

	// Function showUser
	function showUser($id_or_email){
		$result['profile_image_url'] = false;
		$result['expiration_date'] = time() + TWICON_EXPIRED * 24 * 60 * 60;

		$email = '';
		$post_id = '';
		$comment_id = '';
		$twitter_id = '';

		if ( is_numeric($id_or_email) ) {
			$id = (int) $id_or_email;
			$user = get_userdata($id);
			if ( $user )
				$email = $user->user_email;
		} elseif ( is_object($id_or_email) ) {
			if ( isset($id_or_email->comment_type) && '' != $id_or_email->comment_type && 'comment' != $id_or_email->comment_type )
				return $result; // No avatar for pingbacks or trackbacks

			if ( !empty($id_or_email->user_id) ) {
				$id = (int) $id_or_email->user_id;
				$user = get_userdata($id);
				if ( $user)
					$email = $user->user_email;
			} elseif ( !empty($id_or_email->comment_author_email) ) {
				$email = $id_or_email->comment_author_email;
			}

			if ( !empty($id_or_email->comment_post_ID) ) {
				$post_id = $id_or_email->comment_post_ID;
				if ( defined('QC_NOTIFY_TWITTER') && !isset($this->meta_value[$post_id]) )
					$this->meta_value[$post_id] = maybe_unserialize(get_post_meta($post_id, QC_NOTIFY_TWITTER, true));
			}

			if ( !empty($id_or_email->comment_ID) )
				$comment_id = $id_or_email->comment_ID;

		} else {
			$email = $id_or_email;
		}

		if (empty($email))
			return $result; // No avatar for pingbacks or trackbacks

		// Will arrange the url we need to open @ twitter to get the photo info
		$id = $email;
		$request = 'http://twitter.com/users/show/show.xml?email='.urlencode($id);

		if (isset($this->meta_value[$post_id]) && is_array($this->meta_value[$post_id])) {
			foreach ($this->meta_value[$post_id] as $key => $val) {
				if (!empty($key) && in_array($comment_id, $val, false)) {
					$id = $key;
					$request = 'http://twitter.com/users/show/'.$id.'.xml';
					break;
				}
			}
			unset($val);
		}

		// Will open another function that will do all the hard work :)
		return (!empty($id) ? $this->process($id, $request) : $result);
	}

	// Function process
	function process($id, $url, $postargs=false){
		if (!isset($this->avatars[$id]) || !(isset($this->avatars[$id]['expiration_date']) && time() < $this->avatars[$id]['expiration_date'])) {
			if (class_exists('Snoopy')) {
				$snoop = new Snoopy;
				$snoop->read_timeout = 30;
				$snoop->timed_out = true;
				$snoop->submit($url);
				$response = $snoop->results;
				$responseInfo['http_code'] = $snoop->response_code;
				unset($snoop);
			} else {
			        // CURL will be used to open the URL and Retrieve the user ifo based on the email.
			        $ch = curl_init($url);

			        if($postargs !== false){
			            curl_setopt ($ch, CURLOPT_POST, true);
			            curl_setopt ($ch, CURLOPT_POSTFIELDS, $postargs);
			        }

			        curl_setopt($ch, CURLOPT_VERBOSE, 1);
			        curl_setopt($ch, CURLOPT_NOBODY, 0);
			        curl_setopt($ch, CURLOPT_HEADER, 0);
			        curl_setopt($ch, CURLOPT_FOLLOWLOCATION,1);
			        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

			        $response = curl_exec($ch);

			        $responseInfo=curl_getinfo($ch);
			        curl_close($ch);
			}
		} else {
			return $this->avatars[$id];
		}

		if(strpos($responseInfo['http_code'], '200') !== FALSE && preg_match('/<profile_image_url>([^<]*)<\/profile_image_url>/i', $response, $matched))
			$this->avatars[$id]['profile_image_url'] = $matched[1];
		else
			$this->avatars[$id]['profile_image_url'] = false;
		$this->avatars[$id]['expiration_date'] = time() + TWICON_EXPIRED * 60 * 60;
		unset($matched);

		return $this->avatars[$id];
	}
}

global $twicon;

$twicon = new twiconController();
add_action('comment_form', array($twicon, 'updateAvatars'));
add_filter('get_avatar', array($twicon, 'getAvatar'), 10, 5);
?>