<?php
/* ==================================================
 *   Ktai Admin Edit Page
 *   based on wp-admin/edit-pages.php of WP 2.7
   ================================================== */

require dirname(__FILE__) . '/admin.php';
$title = __('Edit Pages', 'ktai_style');
$parent_file = 'edit-pages.php';
$View = new KS_Admin_Edit_Pages($Ktai_Style, $KS_Admin);
$View->output();
exit;

/* ==================================================
 *   KS_Admin_Edit_Pages class
   ================================================== */

class KS_Admin_Edit_Pages {
	private $base;
	private $admin;
	private $search;

// ==================================================
public function __construct($base, $admin) {
	$this->base  = $base;
	$this->admin = $admin;
	$this->search = isset($_GET['s']) ? stripslashes($_GET['s']) : '';
}

// ==================================================
private function edit_pages_query() {
	$post_stati  = array(	//	array( adj, noun )
		'publish' => array(__('Published'), __('Published pages'), __ngettext_noop('Published (%s)', 'Published (%s)')),
		'future' => array(__('Scheduled'), __('Scheduled pages'), __ngettext_noop('Scheduled (%s)', 'Scheduled (%s)')),
		'pending' => array(__('Pending Review'), __('Pending pages'), __ngettext_noop('Pending Review (%s)', 'Pending Review (%s)')),
		'draft' => array(__('Draft'), _c('Drafts|manage posts header'), __ngettext_noop('Draft (%s)', 'Drafts (%s)')),
		'private' => array(__('Private'), __('Private pages'), __ngettext_noop('Private (%s)', 'Private (%s)'))
	);
	$post_stati = apply_filters('post_stati', $post_stati);

	$per_page = intval(($this->base->get('page_size') - 3000) / 256);
	if ($per_page < 1) {
		$per_page = 1;
	} elseif ($per_page > 15) {
		$per_page = 15;
	}
	$pagenum = isset($_GET['paged']) ? absint($_GET['paged']) : 1;

	$query = array(
		'post_type' => 'page', 
		'what_to_show' => 'posts',
		'post_status' => 'any',
		'posts_per_page' => $per_page, 
		'posts_per_archive_page' => -1, 
		'orderby' => 'menu_order title', 
		'order' => 'ASC',
		's' => $this->search,
	);

	if ( isset($_GET['post_status'])) {
		$post_status = stripslashes($_GET['post_status']);
		if ( in_array($post_status, array_keys($post_stati)) ) {
			$query['post_status'] = $post_status;
			$query['perm'] = 'readable';
		}
	}
	$query = apply_filters('manage_pages_query', $query);
	query_posts($query);

	return array($post_stati, $per_page, $pagenum);
}

// ==================================================
public function status_menu($post_stati) {
	global $parent_file, $submenu, $submenu_file;

	$num_posts = wp_count_posts('page', 'readable');
	$num_total = array_sum( (array) $num_posts);

	$link = $submenu_file = 'edit-pages.php';
	$submenu[$parent_file] = array(
		array(($this->base->check_wp_version(2.7) ? __('Add New Page') : __('Write a New Page')), 'edit_pages', 'page-new.php'),
		array(sprintf(__('All (%s)', 'ktai_style'), $num_total), 'edit_pages', $link),
	);
	$post_status_label = __('Pages');
	$avail_post_stati = get_available_post_statuses('page');
	foreach ( $post_stati as $status => $label ) {
		if ( !in_array( $status, $avail_post_stati ) ) {
			continue;
		}
		if ( empty( $num_posts->$status ) ) {
			continue;
		}
		$link = add_query_arg( 'post_status', $status, $link );
		$submenu[$parent_file][] = array(sprintf(__ngettext( $label[2][0], $label[2][1], $num_posts->$status, 'ktai_style'), number_format_i18n($num_posts->$status)), 'edit_pages', $link);
		if ( str_replace( 'all', '', $status ) == $_GET['post_status'] ) {
			$submenu_file = $link;
			$post_status_label = $label[1];
			$num_total = $num_posts->$status;
		}
	}
	return array($post_status_label, $num_total);
}

// ==================================================
public function output() {
	global $title, $parent_file;
	list($post_stati, $per_page, $pagenum) = $this->edit_pages_query();

	include dirname(__FILE__) . '/admin-header.php';
	list($post_status_label, $total_posts) = $this->status_menu($post_stati);
	if ($this->search) {
		echo '<h2>' . sprintf( __('Search results for &#8220;%s&#8221;'), wp_specialchars($this->search) ) . '</h2>';
	}
	if ( isset($_GET['posted']) && $_GET['posted'] ) {
		$_GET['posted'] = (int) $_GET['posted'];
		?><p><font color="olive"><?php _e('Your page has been saved.'); ?></font></p><?php
		$_SERVER['REQUEST_URI'] = remove_query_arg(array('posted'), $_SERVER['REQUEST_URI']);
	}
/*
if ( isset($_GET['locked']) || isset($_GET['skipped']) || isset($_GET['updated']) || isset($_GET['deleted']) ) { ?>
<p><font color="olive">
<?php if ( isset($_GET['updated']) && (int) $_GET['updated'] ) {
	printf( __ngettext( '%s page updated.', '%s pages updated.', $_GET['updated'] ), number_format_i18n( $_GET['updated'] ) );
	unset($_GET['updated']);
}

if ( isset($_GET['skipped']) && (int) $_GET['skipped'] ) {
	printf( __ngettext( '%s page not updated, invalid parent page specified.', '%s pages not updated, invalid parent page specified.', $_GET['skipped'] ), number_format_i18n( $_GET['skipped'] ) );
	unset($_GET['skipped']);
}

if ( isset($_GET['locked']) && (int) $_GET['locked'] ) {
	printf( __ngettext( '%s page not updated, somebody is editing it.', '%s pages not updated, somebody is editing them.', $_GET['locked'] ), number_format_i18n( $_GET['skipped'] ) );
	unset($_GET['locked']);
}

if ( isset($_GET['deleted']) && (int) $_GET['deleted'] ) {
	printf( __ngettext( 'Page deleted.', '%s pages deleted.', $_GET['deleted'] ), number_format_i18n( $_GET['deleted'] ) );
	unset($_GET['deleted']);
}
$_SERVER['REQUEST_URI'] = remove_query_arg( array('locked', 'skipped', 'updated', 'deleted'), $_SERVER['REQUEST_URI'] );
?>
</font></p>
<?php } ?>
*/
?>
<form id="posts-filter" action="" method="get">
<?php $this->admin->sid_field(); ?>
<div><?php _e('Search'); ?><input type="text" name="ks" value="<?php echo wp_specialchars($this->search); ?>" size="17" /><br />
<?php if (isset($_GET['post_status'])) { ?>
<input type="hidden" name="post_status" value="<?php echo attribute_escape($_GET['post_status']) ?>" />
<?php } ?>
<input type="submit" value="<?php _e('Filter', 'ktai_style'); ?>" /></div></form>
<?php 
	if (have_posts()) {
		$this->page_rows($pagenum, $per_page);
		$page_links = paginate_links( array(
			'base' => add_query_arg( 'paged', '%#%' ),
			'format' => '',
			'total' => $GLOBALS['wp_query']->max_num_pages,
			'current' => $pagenum,
			'prev_text' => '<img localsrc="7" alt="&laquo;" />' . __('Previous Page', 'ktai_style'),
			'next_text' => __('Next Page', 'ktai_style') . '<img localsrc="8" alt="&raquo;" />',
		));
		if ($page_links) {
			$page_links = $this->base->filter_tags($page_links);
			$page_links = preg_replace('/ class=([\'"])[-_ \w]+\1/', '', $page_links);
			$page_links = str_replace("\n", ' ', $page_links);
			$page_links = str_replace(ks_admin_url(false), '', $page_links);
			echo '<p>' . $page_links . '</p>';
		}
	} else { ?>
<p><?php _e('No pages found.') ?></p>
<?php
	} // have_posts()
	include dirname(__FILE__) . '/admin-footer.php';
}

// ==================================================
private function page_rows($pagenum = 1, $per_page = 20) {
	global $wpdb, $wp_query;
	$level = 0;
	$pages =& $wp_query->posts;
	if ( ! $pages ) {
		return false;
	}
	/*
	 * arrange pages into two parts: top level pages and children_pages
	 * children_pages is two dimensional array, eg.
	 * children_pages[10][] contains all sub-pages whose parent is 10.
	 * It only takes O(N) to arrange this and it takes O(1) for subsequent lookup operations
	 * If searching, ignore hierarchy and treat everything as top level
	 */
	if ( empty($this->search) ) {

		$top_level_pages = array();
		$children_pages = array();

		foreach ( $pages as $page ) {

			// catch and repair bad pages
			if ( $page->post_parent == $page->ID ) {
				$page->post_parent = 0;
				$wpdb->query( $wpdb->prepare("UPDATE $wpdb->posts SET post_parent = '0' WHERE ID = %d", $page->ID) );
				clean_page_cache( $page->ID );
			}

			if ( 0 == $page->post_parent )
				$top_level_pages[] = $page;
			else
				$children_pages[ $page->post_parent ][] = $page;
		}

		$pages = &$top_level_pages;
	}

	$count = 0;
	$start = ($pagenum - 1) * $per_page;
	$end = $start + $per_page;
?><dl><?php 
	foreach ( $pages as $page ) {
		if ( $count >= $end )
			break;

		if ( $count >= $start )
			echo $this->display_page_row( $page, $level );

		$count++;

		if ( isset($children_pages) )
			$this->_page_rows( $children_pages, $count, $page->ID, $level + 1, $pagenum, $per_page );
	}

	// if it is the last pagenum and there are orphaned pages, display them with paging as well
	if ( isset($children_pages) && $count < $end ){
		foreach( $children_pages as $orphans ){
			foreach ( $orphans as $op ) {
				if ( $count >= $end )
					break;
				if ( $count >= $start )
					echo $this->display_page_row( $op, 0 );
				$count++;
			}
		}
	}
?></dl><?php 
}

// ==================================================
private function _page_rows( &$children_pages, &$count, $parent, $level, $pagenum, $per_page ) {

	if ( ! isset( $children_pages[$parent] ) )
		return;

	$start = ($pagenum - 1) * $per_page;
	$end = $start + $per_page;

	foreach ( $children_pages[$parent] as $page ) {

		if ( $count >= $end )
			break;

		// If the page starts in a subtree, print the parents.
		if ( $count == $start && $page->post_parent > 0 ) {
			$my_parents = array();
			$my_parent = $page->post_parent;
			while ( $my_parent) {
				$my_parent = get_post($my_parent);
				$my_parents[] = $my_parent;
				if ( !$my_parent->post_parent )
					break;
				$my_parent = $my_parent->post_parent;
			}
			$num_parents = count($my_parents);
			while( $my_parent = array_pop($my_parents) ) {
				echo "\t" . $this->display_page_row( $my_parent, $level - $num_parents );
				$num_parents--;
			}
		}

		if ( $count >= $start )
			echo $this->display_page_row( $page, $level );

		$count++;

		$this->_page_rows( $children_pages, $count, $page->ID, $level + 1, $pagenum, $per_page );
	}

	unset( $children_pages[$parent] ); //required in order to keep track of orphans
}

// ==================================================
function display_page_row( $page, $level = 0 ) {
	global $post;

	$post = $page;
	setup_postdata($page);

//	$page->post_title = wp_specialchars($page->post_title);
?>
<dt>
<?php
	$title = $this->admin->draft_or_post_title();
	$pad = str_repeat('&#8212; ', $level);
	if (current_user_can('edit_post', $page->ID)) {
		$title = '<img localsrc="149" alt="" /><a href="' . $this->admin->add_sid(get_edit_post_link($page->ID)) . '">' . $title . '</a>';
	}
	echo '<dt>' . intval($post->ID) . ':' . $pad . $title . '</dt>' . 
	     '<dd><img localsrc="68" alt="by " />' . get_the_author() . 
		 '<img localsrc="46" alt=" at " /><font color="' . ks_option('ks_date_color') . '">';
	if ('draft' === $_GET['post_status'] || 'pending' === $_GET['post_status']) {
		if ('0000-00-00 00:00:00' == $post->post_modified) {
			_e('Never');
		} else {
			ks_mod_time();
		}
	} else {
		if ('0000-00-00 00:00:00' == $post->post_date) {
			_e('Unpublished');
		} else {
			ks_time();
		}
	}
?>
</font></dd>
<?php
}

// ===== End of class ====================
}
?>