<?php
/* ==================================================
 *   Ktai_Style_Admin class
   ================================================== */

define ('KS_SESSION_NAME', 'ksid');
define ('KS_SESSION_LIFETIME', 3600);
define ('KS_SESSION_RENEWTIME', 1800);

class Ktai_Style_Admin {
	private $sid;
	private $next_id;
	private $user_login;
	private $user_agent;
	private $term_ID;
	private $sub_ID;
	private $data;

/* ==================================================
 * @param	none
 * @return	string  $user_login
 */
public function get_current_user() {
	return $this->user_login;
}

/* ==================================================
 * @param	string  $key
 * @return	mix     $param
 */
public function get($key) {
	return @$this->$key;
}

/* ==================================================
 * @param	string  $key;
 * @return	mix     $data
 */
public function get_data($key) {
	return stripslashes(@$this->data[$key]);
}

/* ==================================================
 * @param	string  $key
 * @param   mix     $value
 * @return	mix     $value
 */
public function set_data($key, $value) {
	return $this->data[$key] = $value;
}

/* ==================================================
 * @param	none
 * @return	mix     $result
 */
public function save_data() {
	global $wpdb;
	if (! $this->sid) {
		return false;
	}
	$result = $wpdb->update($wpdb->prefix . 'ktaisession', array('data' => serialize($this->data)), array('sid' => $this->sid));
	return $result;
}

/* ==================================================
 * @param	none
 * @return	string  $sid
 */
public function get_sid() {
	if (isset($_POST[KS_SESSION_NAME])) {
		return $_POST[KS_SESSION_NAME];
	} elseif (isset($_GET[KS_SESSION_NAME])) {
		return $_GET[KS_SESSION_NAME];
	} else {
		return NULL;
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function sid_field() {
	if ($this->sid) {
		echo '<input type="hidden" name="' .KS_SESSION_NAME .'" value="' . htmlspecialchars($this->sid, ENT_QUOTES) . '" />';
	}
}

/* ==================================================
 * @param	string  $uri
 * @return	string  $uri
 */
public function add_sid($uri, $escape = true) {
	if ($this->sid && preg_match('!(^|^\.{1,2}/|' . KS_ADMIN_DIR . '/)[-\w]*(\.php)?!', $uri)
	&& ! preg_match('/\?([^&]+&)*' . KS_SESSION_NAME . '=/', $uri)) {
//		$uri = add_query_arg(KS_SESSION_NAME, $this->sid, $uri);
		$uri .= (strpos($uri, '?') === false ? '?' : '&') . KS_SESSION_NAME . '=' . $this->sid;
		if ($escape) {
			$uri = htmlspecialchars($uri, ENT_QUOTES);
		}
	}
	return $uri;
}

/* ==================================================
 * @param	string  $uri
 * @return	string  $uri
 */
public function remove_sid($uri) {
	if (strpos($uri, KS_SESSION_NAME . '=') !== false) {
		$uri = remove_query_arg(KS_SESSION_NAME, $uri);
	}
	return $uri;
}

/* ==================================================
 * @param	none
 * @return	string  $sid
 */
private function make_sid() {
	return str_replace(array('+', '/', '='), array('_', '.', ''), base64_encode(sha1(uniqid(mt_rand(), true), true)));
}

/* ==================================================
 * @param	string  $user_login
 * @param	string  $sid
 * @param	mix     $data
 * @return	string  $sid
 */
public function set_session($user_login, $sid = NULL, $data = NULL) {
	global $wpdb, $Ktai_Style;
	$sid      = $sid ? $sid : $this->make_sid();
	$expires  = time() + intval(KS_SESSION_LIFETIME);
	$ua_hash  = $Ktai_Style->get('user_agent') ? sha1($Ktai_Style->get('user_agent')) : '';
	$tid_hash = $Ktai_Style->get('term_ID') ? sha1($Ktai_Style->get('term_ID')) : '';
	$sub_hash = $Ktai_Style->get('sub_ID') ? sha1($Ktai_Style->get('sub_ID')) : '';
	$result = $wpdb->insert($wpdb->prefix . 'ktaisession', array(
		'sid'        => $sid,
		'expires'    => date('Y-m-d H:i:s', $expires),
		'user_login' => $user_login,
		'user_agent' => $ua_hash,
		'term_id'    => $tid_hash,
		'sub_id'     => $sub_hash,
		'data'       => ($data ? serialize($data) : ''),
		));
	if (! $result) {
		return NULL;
	}
	$this->sid        = $sid;
	$this->next_id    = NULL;
	$this->expires    = $expires;
	$this->user_login = $user_login;
	$this->user_agent = $ua_hash;
	$this->term_ID    = $tid_hash;
	$this->sub_ID     = $sub_hash;
	$this->data       = $data;
	return $sid;
}

/* ==================================================
 * @param	none
 * @return	string  $new_sid
 */
public function renew_session() {
	global $wpdb;
	if ($this->next_id) {
		$sid = $this->next_id;
		$sql = $wpdb->prepare("SELECT * FROM `{$wpdb->prefix}ktaisession` WHERE next_id = %s", $sid);
		$result = $wpdb->get_row($sql);
		if ($result) {
			$this->sid        = $sid;
			$this->next_id    = $result->next_id;
			$this->expires    = strtotime($result->expires);
			$this->user_login = $result->user_login;
			$this->user_agent = $result->user_agent;
			$this->term_ID    = $result->term_id;
			$this->sub_ID     = $result->sub_id;
			$this->data       = unserialize($result->data);
			return $sid;
		}
		$this->next_id = NULL;
	}
	if ($this->sid && time() + intval(KS_SESSION_RENEWTIME) > $this->expires) {
		$new_sid    = $this->make_sid();
		$sql = $wpdb->prepare("UPDATE `{$wpdb->prefix}ktaisession` SET next_id = %s WHERE sid = %s AND next_id IS NULL LIMIT 1", $new_sid, $this->sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return $this->set_session($this->user_login, $new_sid, $this->data);
		}
	}
	return false;
}

/* ==================================================
 * @param	string  $sid
 * @return	boolean $is_succeeded
 */
public function unset_session($sid) {
	global $wpdb;
	if ($sid) {
		$sql = $wpdb->prepare("DELETE FROM `{$wpdb->prefix}ktaisession` WHERE sid = %s LIMIT 1", $sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return true;
		}
	}
	return false;
}

/* ==================================================
 * @param	string  $sid
 * @return	boolean $is_succeeded
 */
public function unset_prev_session($sid) {
	global $wpdb;
	if ($sid) {
		$sql = $wpdb->prepare("DELETE FROM `{$wpdb->prefix}ktaisession` WHERE next_id = %s  LIMIT 1", $sid);
		$result = $wpdb->query($sql);
		if ($result) {
			return true;
		}
	}
	return false;
}

/* ==================================================
 * @param	none
 * @return	boolean $is_succeeded
 */
public function garbage_sessions() {
	global $wpdb;
	$sql = "DELETE FROM `{$wpdb->prefix}ktaisession` WHERE expires < NOW()";
	$result = $wpdb->query($sql);
	if ($result) {
		return true;
	}
	return false;
}

/* ==================================================
 * @param	none
 * @return	string   $user_login
 */
public function check_session() {
	global $wpdb;
	$sid = self::get_sid();
	if (empty($sid)) {
		return false;
	}
	self::garbage_sessions();
	$sql = $wpdb->prepare("SELECT * FROM `{$wpdb->prefix}ktaisession` WHERE sid = %s", $sid);
	$result = $wpdb->get_row($sql);

	if (! $result || strcmp(sha1($_SERVER['HTTP_USER_AGENT']), $result->user_agent) != 0) {
		return false;
	}

	// restore the session
	if (isset($this)) {
		$this->sid        = $sid;
		$this->next_id    = $result->next_id;
		$this->expires    = strtotime($result->expires);
		$this->user_login = $result->user_login;
		$this->user_agent = $result->user_agent;
		$this->term_ID    = $result->term_id;
		$this->sub_ID     = $result->sub_id;
		$data = unserialize($result->data);
		$this->data       = ($data ? $data : NULL);
	}
	return $result->user_login;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function redirect($redirect_to) {
	wp_redirect($this->add_sid($redirect_to, false));
}

/* ==================================================
 * @param	none
 * @return	none
 * based on wp_safe_redirect() at pluggable.php of WP 2.3
 */
public function safe_redirect($location) {
	$location = preg_replace('|[^a-z0-9-~+_.?#=&;,/:%]|i', '', $location);
	$location = wp_kses_no_null($location);

	// remove %0d and %0a from location
	$strip = array('%0d', '%0a');
	$found = true;
	while($found) {
		$found = false;
		foreach($strip as $val) {
			while(strpos($location, $val) !== false) {
				$found = true;
				$location = str_replace($val, '', $location);
			}
		}
	}

	if ( substr($location, 0, 2) == '//' ) {
		$location = 'http:' . $location;
	}
	$lp  = parse_url($location);
	$wpp = parse_url(get_option('home'));
	$allowed_hosts = (array) apply_filters('allowed_redirect_hosts', array($wpp['host']), $lp['host']);
	if ( isset($lp['host']) && ! in_array($lp['host'], $allowed_hosts) ) {
		$location = ks_admin_url(false);
	}
	wp_redirect($this->add_sid($location, false), $status);
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function shrink_redirect_to($uri) {
	global $Ktai_Style;
	$plugin_dir_pat = preg_quote(preg_replace('!^https?://[^/]*/!', '', $Ktai_Style->get('plugin_url')), '!');
	$redirect_to = preg_replace("!^.*?$plugin_dir_pat!", '', $uri);
	return $this->remove_sid($redirect_to);
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function auth_redirect() {
	if (! $this->check_session()) {
		global $Ktai_Style;
		$uri = preg_replace('!^.*' . preg_quote($Ktai_Style->strip_host($Ktai_Style->get('plugin_url')), '!') . '!', '', $_SERVER['REQUEST_URI']);
		wp_redirect($Ktai_Style->get('plugin_url') . 'login.php?redirect_to=' . urlencode($uri));
		exit();
	}
}

/* ==================================================
 * @param	none
 * @return	object  $this
 */
public function store_referer() {
	$path = $_SERVER['REQUEST_URI'];
	if ($this->get_data('referer')) {
		if (strcmp($this->get_data('referer'), $path) != 0) {
			$this->set_data('referer2', $this->get_data('referer'));
		}
	}
	$this->set_data('referer', $path);
	return $this;
}

/* ==================================================
 * @param	none
 * @return	string  $referer
 */
public function get_referer() {
	$referer = '';
	if (isset($_POST['_wp_http_referer'])) {
		$referer = $_POST['_wp_http_referer'];
	} elseif (isset($_GET['_wp_http_referer'])) {
		$referer = $_GET['_wp_http_referer'];
	} elseif (! isset($this->data['referer'])) {
		$referer = NULL;
	} elseif (strcmp($this->get_data('referer'), $_SERVER['REQUEST_URI']) == 0 && isset($this->data['referer2'])) {
		$referer = $this->get_data('referer2');
	} else {
		$referer = $this->get_data('referer');
	}
	if (strpos($referer, KS_SESSION_NAME . '=') !== false) {
		$referer = remove_query_arg(KS_SESSION_NAME, $referer);
		$referer = $this->add_sid($referer, false);
	}
	return $referer;
}

/* ==================================================
 * @param	string  $action
 * @return	none
 */
public function nonce_ays($action) {
	global $pagenow, $Ktai_Style;

	if ( $this->get_referer() ) {
		$adminurl = clean_url($this->get_referer());
		if (! preg_match('/' . KS_SESSION_NAME . '=/', $adminurl)) {
			$adminurl = $this->add_sid($adminurl);
		}
	} else {
		$adminurl = $this->add_sid(ks_admin_url(false));
	}
	
	$title = $Ktai_Style->encode_for_ktai(__('WordPress Confirmation', 'ktai_style'));
	list ($desc, $allow_proceed) = $this->explain_nonce($action);
	if ($allow_proceed) {
		$no  = __('No');
		$yes = __('Yes');
	} else {
		$no  = __('Back', 'ktai_style');
	}
	// Remove extra layer of slashes.
	$_POST = stripslashes_deep($_POST);
	if ($_POST) {
		$q = http_build_query($_POST);
		$q = explode( ini_get('arg_separator.output'), $q);
		$html .= '<form method="post" action="' . clean_url($pagenow) . '"><input type="hidden" name="' . KS_SESSION_NAME . '" value="' . $this->sid . '" />';
		foreach ( (array) $q as $a ) {
			$v = substr(strstr($a, '='), 1);
			$k = substr($a, 0, -(strlen($v)+1));
			$html .= '<input type="hidden" name="' . wp_specialchars(urldecode($k)) . '" value="' . wp_specialchars(urldecode($v)) . '" />';
		}
		$add_html = '<input type="hidden" name="_wpnonce" value="' . wp_create_nonce($action) . '" /><p>' . wp_specialchars($desc) . '<br /><a href="' . $adminurl . '">' . $no . '</a>' . ($allow_proceed ? ' <input type="submit" value="' . $yes . '" />' : '') . '</div></form>';
	} else {
		$add_html = '<p>' . wp_specialchars($desc) . '<br /><a href="' . $adminurl . '">' . $no. '</a>' . ($allow_proceed ? ' <a href="' . clean_url(add_query_arg('_wpnonce', wp_create_nonce($action), $_SERVER['REQUEST_URI'])) . '">' . $yes . '</a>' : '') . ' </p>';
	}
	$html .= $Ktai_Style->encode_for_ktai($add_html);
	Ktai_Style::ks_die($html, $title, false, true);
}

/* ==================================================
 * @param	string  $action
 * @return	string  $desc
 * @return	boolean $allow_proceed
 */
private function explain_nonce($action) {
	global $Ktai_Style, $KS_Shrinkage;
	remove_filter('the_title', array($KS_Shrinkage, 'shrink_title'), 90);
	if ( $action === -1 || ! preg_match('/([a-z]+)-([a-z]+)(_(.+))?/', $action, $matches) ) {
		return;
	}
	$verb = $matches[1];
	$noun = $matches[2];
	$trans = array();
	$trans['change']['cats'] = array(__('Are you sure you want to change categories of this post: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['unapprove']['comment'] = array(__('Are you sure you want to unapprove this comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['approve']['comment'] = array(__('Are you sure you want to approve this comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['delete']['comment'] = array(__('Are you sure you want to delete this comment: &quot;%s&quot;?', 'ktai_style'), 'use_id');
	$trans['delete']['post'] = array(__('Are you sure you want to delete this post: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['delete']['page'] = array(__('Are you sure you want to delete this page: &quot;%s&quot;?', 'ktai_style'), 'get_the_title');
	$trans['bulk']['spamdelete'] = array(__('Are you sure you want to delete all spam?', 'ktai_style'));

	if ( isset($trans[$verb][$noun]) ) {
		if (! empty($trans[$verb][$noun][1]) ) {
			$lookup = $trans[$verb][$noun][1];
			$object = $matches[4];
			if ('use_id' != $lookup) {
				$object = call_user_func($lookup, $object);
			}
			$desc = sprintf($trans[$verb][$noun][0], $object);
		} else {
			$desc = $trans[$verb][$noun][0];
		}
		$allow_proceed = true;
	} else {
		$desc = wp_explain_nonce($action);
		$allow_proceed = false;
	}
	return array($desc, $allow_proceed);
}

/* ==================================================
 * @param	int     $comment_id
 * @return	none
 * based on get_edit_comment_link() at wp-includes/link-template.php of WP 2.3
 */
public function get_edit_comment_link($comment_id = 0) {
	$comment = &get_comment($comment_id);
	$post = &get_post($comment->comment_post_ID);

	if ($post->post_type == 'attachment') {
		return;
	} elseif ($post->post_type == 'page') {
		if (! current_user_can( 'edit_page', $post->ID)) {
			return;
		}
	} elseif (! current_user_can( 'edit_post', $post->ID)) {
		return;
	}

	$location = 'comment.php?action=editcomment&c=' . $comment->comment_ID;
	return apply_filters( 'get_edit_comment_link', $location );
}

/* ==================================================
 * @param	string  $name
 * @param	int     $selected
 * @return	string  $html
 */
public function dropdown_categories($name = 'default_category', $selected = 0) {
	global $wpdb;
	$html = '';
	$categories = get_categories('get=all');
	if (count($categories) < 1) {
		return $html;
	}
	$html .= '<select name="' . htmlspecialchars($name, ENT_QUOTES) . '">';
	foreach ($categories as $c) {
		$cat_id = isset($c->term_id) ? $c->term_id : $c->cat_ID;
		$html .= '<option value="' . intval($cat_id) . '"' . ($selected == $cat_id ? ' selected="selected"' : '') . '>' . wp_specialchars($c->cat_name) . '</option>';
	}
	$html .= '</select>';
	return $html;
}

/* ==================================================
 * @param	string  $urk
 * @param	int     $id
 * @return	string  $context
 */
public function fix_edit_post_link($uri, $id, $context = NULL) {
	global $Ktai_Style;
	if (is_null($context)) {
		$uri = str_replace('&amp;', '&', $uri);
	}
	$uri = preg_replace('!^.*/wp-admin/!' , KS_ADMIN_DIR . '/', $uri);
	$uri = $Ktai_Style->get('plugin_url') . $this->add_sid($uri, false);
	return $uri;
}

/* ==================================================
 * @param	string  $urk
 * @param	int     $id
 * @return	string  $context
 */
public function draft_or_post_title($post_id = 0) {
	$title = get_the_title($post_id);
	if ( empty($title) )
		$title = __('(no title)');
	return $title;
}

/* ==================================================
 * @param	none
 * @return	int     $post_ID
 * based on write_post() at wp-admin/includes/post.php of WP 2.3
 */
public function write_post() {
	global $current_user;
	if (! current_user_can('edit_posts')) {
		Ktai_Style::ks_die(__('You are not allowed to create posts or drafts on this blog.'));
	}
	$charset = ks_detect_encoding();
	$_POST['post_title']   = trim(strip_tags(ks_mb_get_form('post_title', $charset)));
	$_POST['post_content'] = trim(ks_mb_get_form('content', $charset));
	if (isset($_POST['tags_input'])) {
		$_POST['tags_input'] = trim(strip_tags(ks_mb_get_form('tags_input', $charset)));
	}
	$_POST['post_excerpt']  = '';
//	$_POST['post_date']     = current_time('mysql');
//	$_POST['post_date_gmt'] = get_gmt_from_date($_POST['post_date']);
	$_POST['post_name']     = isset($_POST['post_name']) ? $_POST['post_name'] : date('His', strtotime($_POST['post_date']));
	$_POST['post_author']   = intval($_POST['user_ID']);

	if (isset($_POST['post_cats'])) {
		$_POST['post_category'] = array_map('intval', explode(',', $_POST['post_cats']));
	}

	if (! isset( $_POST['comment_status'])) {
		$_POST['comment_status'] = 'closed';
	}
	if (! isset( $_POST['ping_status'])) {
		$_POST['ping_status'] = 'closed';
	}

	// What to do based on which button they pressed
	if (isset($_POST['publish']) && '' != $_POST['publish'] && $_POST['post_status'] != 'private') {
		$_POST['post_status'] = 'publish';
	}
/*
	if (isset($_POST['advanced']) && '' != $_POST['advanced']) {
		$_POST['post_status'] = 'draft';
	}
 */
 	if ('publish' == $_POST['post_status'] && ! current_user_can('publish_posts')) {
		$_POST['post_status'] = 'pending';
	}

	if ( isset($_POST['visibility']) && 'private' == $_POST['visibility']) {
		$_POST['post_status'] = 'private';
		$_POST['post_password'] = '';
		unset( $_POST['sticky'] );
	}

	$post_ID = wp_insert_post($_POST);
	if (is_wp_error($post_ID)) {
		Ktai_Style::ks_die($post_ID->get_error_message());
	} else {
		return $post_ID;
	}
}

/* ==================================================
 * @param	none
 * @return	int     $post_ID
 * based on edit_post() at wp-admin/includes/post.php of WP 2.3
 */
public function edit_post($post_ID) {
	global $current_user;
	if (! $post_ID) {
		Ktai_Style::ks_die(__("You attempted to edit a post that doesn't exist. Perhaps it was deleted?"));
	} elseif (! current_user_can('edit_post', $post_ID)) {
		Ktai_Style::ks_die(__('You are not allowed to edit this post.'));
	}
	$post = wp_get_single_post($post_ID, ARRAY_A);
	$charset = ks_detect_encoding();
	$_POST['ID']           = intval($post_ID);
	$_POST['post_title']   = trim(strip_tags(ks_mb_get_form('post_title', $charset)));
	$_POST['post_name']    = trim(strip_tags(ks_mb_get_form('post_name', $charset)));
	$_POST['post_content'] = trim(ks_mb_get_form('content', $charset));
	if (isset($_POST['tags_input'])) {
		$_POST['tags_input'] = trim(ks_mb_get_form('tags_input', $charset));
	}
	if ($post['post_author'] != $current_user->ID && ! current_user_can('edit_others_posts')) {
		Ktai_Style::ks_die(__('You are not allowed to edit posts as this user.'));
	}
	if (isset($_POST['post_cats'])) {
		$_POST['post_category'] = array_map('intval', explode(',', $_POST['post_cats']));
	}

	if (! isset( $_POST['comment_status'])) {
		$_POST['comment_status'] = 'closed';
	}
	if (! isset( $_POST['ping_status'])) {
		$_POST['ping_status'] = 'closed';
	}

	// What to do based on which button they pressed
	if (isset($_POST['publish']) && '' != $_POST['publish']) {
		$_POST['post_status'] = 'publish';
	}
/*
	if (! current_user_can('edit_published_posts')) {
		$_POST['post_status'] = 'pending';
	}
*/
	if ('publish' == $_POST['post_status'] && ! current_user_can('publish_posts')) {
		$_POST['post_status'] = 'pending';
	}

	if ( isset($_POST['visibility']) && 'private' == $_POST['visibility']) {
		$_POST['post_status'] = 'private';
		$_POST['post_password'] = '';
		unset( $_POST['sticky'] );
	}

	wp_update_post( $_POST );
	return intval($post_ID);
}

// ===== End of class ====================
}

/* ==================================================
 *   KS_Category_Checklist class
 *   based on class Walker_Category_Checklist at wp-admin/includes/template.php of WP 2.5.1
   ================================================== */

class KS_Category_Checklist extends Walker {
	public $tree_type = 'category';
//	public $db_fields = array ('parent' => 'parent', 'id' => 'term_id');
	public $db_fields = array ('parent' => 'category_parent', 'id' => 'cat_ID');

	function start_lvl(&$output, $depth, $args) {
		return '';
	}

	function end_lvl(&$output, $depth, $args) {
		return '';
	}

	function start_el(&$output, $category, $depth, $args) {
		extract($args);

		$output .= "\n<li>" . '<label><input value="' . $category->cat_ID . '" type="checkbox" name="cat[]" ' . (in_array( $category->cat_ID, $selected_cats ) ? ' checked="checked"' : "" ) . '/> ' . wp_specialchars( apply_filters('the_category', $category->cat_name )) . '</label>';
		return $output;
	}

	function end_el(&$output, $category, $depth, $args) {
		$output .= "</li>\n";
		return $output;
	}
}
// ===== End of class ====================
?>