<?php
/*
Plugin Name: Hatena bookmark anywhere
Version: 0.1.4
Plugin URI: http://wppluginsj.sourceforge.jp/hatena-bookmark-anywhere/
Description: Hatena bookmark anywhere
Author: <a href="http://blog.masuidrive.jp/" title="Visit Authorhomepage">masuidrive</a> &amp; <a href="http://dogmap.jp/" title="Visit Authorhomepage">wokamoto</a>
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

Includes:
 This plugin includes "どこでもはてブ - Hatena bookmark anywhere"
  http://blog.masuidrive.jp/index.php/category/hba/
  The MIT License
  Copyright (c) 2008 Yuichiro MASUI <masui@masuidrive.jp>
*/

class HateBuAnywhereController {
  var $plugin_name  = 'hatena-bookmark-anywhere';

  var $options_default = array(
        'limit'       => 100	// 表示する件数
       ,'style'       => true	// true でデフォルトスタイル false を設定するとCSSでスタイルの指定が可能
       ,'collapse'    => false	// true にすると、コメントの書いてないブクマを表示しない。指定しない場合は、表示件数を超えた場合のみコメントを表示しない
       ,'set_auto'    => true	// true にすると、本文記事の後に自動でセット
       ,'set_css'     => false	// true にすると、ヘッダ部にCSSを読込
       ,'css'         =>
         array(
            'body'    => 'font-size: 90%; font-family: "Arial", sans-serif; color: #000;'
           ,'any'     => 'margin: 0; padding: 0; text-align: left; font-weight: normal; font-family: "Arial", sans-serif;'
           ,'zero'    => 'background-color:#edf1fd; border-top:1px solid #5279e7; list-style-position: inside; margin:2px 0 0 0;padding: 8px 5px 12px 8px;'
           ,'ul'      => 'background-color:#edf1fd; border-top:1px solid #5279e7; list-style-position: inside; margin:2px 0 0 0;padding: 8px 5px 12px 8px;'
           ,'li'      => 'list-style-type: circle; padding: 1px 0;'
           ,'user'    => 'color: #00e; text-decoration: underline; margin: 0 2px;'
           ,'tags'    => 'font-size: 90%; color: #66c; margin: 0 4px 0 2px;'
           ,'tags_a'  => 'text-decoration: none; color: #66c;'
           ,'go'      => 'font-size: 90%; color: #66c; text-decoration: none;'
         )
       ,'css_id'      => 'hatena_bookmark_anywhere'
       ,'load'        =>
         array(
            'single'  => true
           ,'page'    => true
         )
      );

  var $js_file      = 'js/hatena-bookmark-anywhere-0-1.js';
  var $js_ver       = '0.1';

  var $plugin_dir, $plugin_file, $plugin_url;
  var $admin_option,$admin_action;
  var $options,$option_name;
  var $textdomain_name;
  var $note,$error;

  /*
  * Constructor
  */
  function HateBuAnywhereController() {
    $this->setPluginDir();
    $this->loadTextdomain();

    $this->note = '';
    $this->error = 0;

    $this->admin_option    = basename(__FILE__);
    $this->admin_action    = trailingslashit(get_bloginfo('wpurl'))."wp-admin/admin.php?page=".$this->admin_option;

    $this->option_name     = $this->plugin_name." Options";
    $this->options         = $this->getOptions();
  }

  function setPluginDir() {
    $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_dir  = $filename[count($filename) - 2];
    $this->plugin_file = $filename[count($filename) - 1];
    $this->plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$this->plugin_dir);
    unset($filename);
  }

  function loadTextdomain( $sub_dir = '/language' ) {
    global $wp_version;
    $this->textdomain_name = $this->plugin_dir;
    $textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir).$sub_dir);
    if (version_compare($wp_version, "2.6", ">=") && defined('WP_PLUGIN_DIR')) {
      load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
    } else {
      $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
      load_plugin_textdomain($this->textdomain_name, $plugins_dir.$textdomain_dir);
    }
  }
  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function initOptions($wk_options = '') {
    if (!is_array($wk_options)) $wk_options = array();
    if (!isset($wk_options['limit']))      $wk_options['limit']      = $this->options_default['limit'];
    if (!isset($wk_options['style']))      $wk_options['style']      = $this->options_default['style'];
    if (!isset($wk_options['collapse']))   $wk_options['collapse']   = $this->options_default['collapse'];
    if (!isset($wk_options['set_auto']))   $wk_options['set_auto']   = $this->options_default['set_auto'];
    if (!isset($wk_options['set_css']))    $wk_options['set_css']    = $this->options_default['set_css'];
    if (!isset($wk_options['css']))        $wk_options['css']        = '';
    if (!isset($wk_options['load']))       $wk_options['load']       = $this->options_default['load'];
    return $wk_options;
  }

  function getOptions(){
    return $this->initOptions(get_option($this->option_name));
  }

  function updateOptions() {
    update_option($this->option_name, $this->options);
  }

  function deleteOptions() {
    delete_option($this->option_name);
  }

  function isDisplay() {
    return (
            ($this->options['load']['single'] && is_single())
         || ($this->options['load']['page'] && is_page())
           );
  }

  // regist script
  function addScripts() {
    if ($this->isDisplay()) {
      wp_enqueue_script($this->plugin_name, $this->plugin_url.$this->js_file, array(), $this->js_ver);
    }
  }

  function addHead() {
    if (!($this->options['set_css'] && is_array($this->options['css']))) return;

    if ($this->isDisplay()) {
      $wk_tmpl = "#".$this->options_default['css_id']." %s{%s}\n";
      $out  = "<style type=\"text/css\">\n";
      $out .= sprintf($wk_tmpl, "", $this->options['css']['body']);
      $out .= sprintf($wk_tmpl, "* ", $this->options['css']['any']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_zero ", $this->options['css']['zero']);
      $out .= sprintf($wk_tmpl, "ul ", $this->options['css']['ul']);
      $out .= sprintf($wk_tmpl, "ul li ", $this->options['css']['li']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_user ", $this->options['css']['user']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_tags ", $this->options['css']['tags']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_tags a ", $this->options['css']['tags_a']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_go ", $this->options['css']['go']);
      $out .= "</style>\n";

      echo $out;
    }
  }

  function addFooter() {
    if ($this->isDisplay()) {
     echo $out;
    }
  }

  function addContent($content) {
    if ($this->isDisplay()) {
      // パーセントエンコーディングを大文字に変換
      $url  = get_permalink();
      if (preg_match('/(%[0-9a-f]{2}?)+/', $url)) {
       $url  = preg_replace_callback('/(%[0-9a-f]{2}?)+/', create_function('$matches','return strtoupper($matches[0]);'), $url);
      }

      if ($this->options['set_auto']) {$content .= "<div id=\"".$this->options_default['css_id']."\"></div>\n";}
      $content .= "<script type=\"text/javascript\">/*<![CDATA[*/\n";
      $content .= "var hatena_bookmark_anywhere_limit = ".$this->options['limit'].";";
      $content .= "var hatena_bookmark_anywhere_style = ".($this->options['style']?"true":"false").";";
      if ($this->options['collapse']) {$content .= "var hatena_bookmark_anywhere_collapse = true;";}
      $content .= "var hatena_bookmark_anywhere_url = '".$url."';\n";
      $content .= "/*]]>*/</script>\n";
    }
    return $content;
  }

  function addAdminMenu() {
    add_options_page( __('Hatena bookmark anywhere', $this->textdomain_name)
                     ,__('Hatena bookmark anywhere', $this->textdomain_name)
                     ,9
                     ,$this->admin_option
                     ,array($this,'optionPage')
                    );
  }

  function optionPage() {
    global $wp_version;

    // check referer (Wordpress 2.5+)
    $check_referer = version_compare($wp_version, "2.5", ">=");

    if(isset($_POST['ap_options_update'])) {
      // check referer
      if ($check_referer) check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['limit']          = (is_numeric($_POST['hatena_bookmark_anywhere_limit']) ? $_POST['hatena_bookmark_anywhere_limit'] : $this->options_default['limit']);
      $this->options['set_auto']       = ($_POST['hatena_bookmark_anywhere_auto']=='1' ? true : false);
      $this->options['load']['single'] = ($_POST['hatena_bookmark_anywhere_single']=='1' ? true : false);
      $this->options['load']['page']   = ($_POST['hatena_bookmark_anywhere_page']=='1' ? true : false);
      $this->options['style']          = ($_POST['hatena_bookmark_anywhere_style']=='1' ? true : false);
      $this->options['collapse']       = ($_POST['hatena_bookmark_anywhere_collapse']=='1' ? true : false);
      $this->options['set_css']        = ($_POST['hatena_bookmark_anywhere_style']!='1' && $_POST['hatena_bookmark_anywhere_css']=='1' ? true : false);
      if ($this->options['set_css']) {
        $this->options['css'] = 
         array(
            'body'    => $_POST['css_body']
           ,'any'     => $_POST['css_any']
           ,'zero'    => $_POST['css_zero']
           ,'ul'      => $_POST['css_ul']
           ,'li'      => $_POST['css_li']
           ,'user'    => $_POST['css_user']
           ,'tags'    => $_POST['css_tags']
           ,'tags_a'  => $_POST['css_tags_a']
           ,'go'      => $_POST['css_go']
         );
      }
      $_POST = '';

      // options update
      $this->updateOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

    } elseif(isset($_POST['ap_options_delete'])) {
      // check referer
      if ($check_referer) check_admin_referer("delete_options", "_wpnonce_delete_options");

      // options delete
      $this->deleteOptions();
      $this->options = $this->initOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
      $this->error++;
    }

    $out  = '';

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('Hatena bookmark anywhere Options', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("update_options", "_wpnonce_update_options", true, false);

    $out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

    // Limit
    $out .= "<tr>";
    $out .= "<td style=\"width:60px;\"><strong>".__('Limit', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"hatena_bookmark_anywhere_limit\" id=\"hatena_bookmark_anywhere_limit\" size=\"10\" value=\"".$this->options['limit']."\" /></td>";
    $out .= "</tr>\n";

    // Display
    $out .= "<tr>";
    $out .= "<td><strong>".__('Display', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"checkbox\" name=\"hatena_bookmark_anywhere_auto\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['set_auto']?' checked="true"':'')." />".__('Displays automatically', $this->textdomain_name)."</td>";
    $out .= "</tr>\n";

    // JavaScript Load
    $out .= "<tr>";
    $out .= "<td><strong>".__('Load', $this->textdomain_name)."</strong></td>";
    $out .= "<td>";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_single\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['load']['single']?' checked="true"':'')." />".__('Post')."&nbsp;";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_page\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['load']['page']?' checked="true"':'')." />".__('Page');
    $out .= "</td>";
    $out .= "</tr>\n";

    // Style
    $out .= "<tr>";
    $out .= "<td><strong>".__('Style', $this->textdomain_name)."</strong></td>";
    $out .= "<td>";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_style\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['style']?' checked="true"':'')." onclick=\"javascript:document.getElementById('hatena-bookmark-anywhere_css_check').style.display=(!this.checked?'block':'none');if(this.checked){document.getElementById('hatena_bookmark_anywhere_css').checked = false;document.getElementById('hatena-bookmark-anywhere_css_options').style.display='none';}\" />".__('Default Style', $this->textdomain_name)."<br />";

    // CSS
    $wk_css_options = $this->options['css'];
    if (!is_array($wk_css_options)) {$wk_css_options = $this->options_default['css'];}
    $out .= "<span id=\"hatena-bookmark-anywhere_css_check\" style=\"display:".(!$this->options['style']?'block':'none').";\">";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_css\" id=\"hatena_bookmark_anywhere_css\" value=\"1\" style=\"margin-right:0.5em\" ".(!$this->options['style'] && $this->options['set_css']?' checked="true"':'')." onclick=\"javascript:document.getElementById('hatena-bookmark-anywhere_css_options').style.display=(this.checked?'block':'none');\" />".__('CSS is set from the plugin', $this->textdomain_name)."<br />";
    $out .= "</span>";

    $sub_table_style = " style=\"margin:.25em;padding:0;border-style:none;\"";
    $out .= "<div id=\"hatena-bookmark-anywhere_css_options\" style=\"display:".(!$this->options['style'] && $this->options['set_css']?'block':'none').";\">";
    $out .= "<table{$sub_table_style}>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('Background', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_body\" id=\"css_body\" size=\"100\" value=\"".$wk_css_options['body']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('Any', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_any\" id=\"css_any\" size=\"100\" value=\"".$wk_css_options['any']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('Zero', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_zero\" id=\"css_zero\" size=\"100\" value=\"".$wk_css_options['zero']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('List (ul)', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_ul\" id=\"css_ul\" size=\"100\" value=\"".$wk_css_options['ul']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('List (li)', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_li\" id=\"css_li\" size=\"100\" value=\"".$wk_css_options['li']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('User', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_user\" id=\"css_user\" size=\"100\" value=\"".$wk_css_options['user']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('Tags', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_tags\" id=\"css_tags\" size=\"100\" value=\"".$wk_css_options['tags']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('Tags (link)', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_tags_a\" id=\"css_tags_a\" size=\"100\" value=\"".$wk_css_options['tags_a']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr{$sub_table_style}>";
    $out .= "<td{$sub_table_style}><strong>".__('Go', $this->textdomain_name)."</strong></td>";
    $out .= "<td{$sub_table_style}><input type=\"text\" name=\"css_go\" id=\"css_go\" size=\"100\" value=\"".$wk_css_options['go']."\" /></td>";
    $out .= "</tr>";
    $out .= "</table>";
    $out .= "</div>";
    unset($wk_css_options);

    $out .= "</td>";
    $out .= "</tr>\n";

    // Collapse
    $out .= "<tr>";
    $out .= "<td><strong>".__('Collapse', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"checkbox\" name=\"hatena_bookmark_anywhere_collapse\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['collapse']?' checked="true"':'')." />".__('No display where the comment is not written', $this->textdomain_name)."</td>";
    $out .= "</tr>\n";

    $out .= "</tbody></table>";

    // Add Update Button
    $out .= "<p style=\"margin-top:1em;\"><input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
    $out .= "</form></div>\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("delete_options", "_wpnonce_delete_options", true, false);

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function make_nonce_field($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }

}//class

$HateBuAnywhere = new HateBuAnywhereController();

add_action('admin_menu', array(&$HateBuAnywhere,'addAdminMenu'));

add_action('wp_print_scripts', array(&$HateBuAnywhere,'addScripts'));
add_action('wp_head', array(&$HateBuAnywhere,'addHead'));
add_action('wp_footer', array(&$HateBuAnywhere,'addFooter'));
add_filter('the_content', array(&$HateBuAnywhere,'addContent'), 9999);

unset($HateBuAnywhere);
?>