(function(jQuery){
var userAgent = navigator.userAgent.toLowerCase();
jQuery.browser = jQuery.extend(
	jQuery.browser
	,{
		version: ((!/chrome/.test( userAgent ) ? userAgent.match( /.+(?:rv|it|ra|ie)[\/: ]([\d.]+)/ ) : userAgent.match( /.+chrome\/([\d.]+)/ ) ) || [])[1] ,
		safari: /webkit/.test( userAgent ) && !/chrome/.test( userAgent ),
		chrome: /chrome/.test( userAgent )
	}
);

if (jQuery.browser.chrome) {
	jQuery.fn.extend({
		ready: function(fn) {
			// Attach the listeners
			bindReady();

			// If the DOM is already ready
			if ( jQuery.isReady )
				// Execute the function immediately
				fn.call( document, jQuery );

			// Otherwise, remember the function for later
			else
				// Add the function to the wait list
				jQuery.readyList.push( function() { return fn.call(this, jQuery); } );

			return this;
		}
	});

	var readyBound = false;
	function bindReady(){
		if ( readyBound ) return;
		readyBound = true;

		var numStyles;
		(function(){
			if (jQuery.isReady) return;
			if ( document.readyState != "loaded" && document.readyState != "complete" ) {
				setTimeout( arguments.callee, 0 );
				return;
			}
			if ( numStyles === undefined )
				numStyles = jQuery("style, link[rel=stylesheet]").length;
			if ( document.styleSheets.length != numStyles ) {
				setTimeout( arguments.callee, 0 );
				return;
			}
			// and execute any waiting functions
			jQuery.ready();
		})();

		// A fallback to window.onload, that will always work
		jQuery.event.add( window, "load", jQuery.ready );
	}
}
})(jQuery);
