<?php
/*
Plugin Name: Quick Comments
Version: 0.5.4
Plugin URI: http://wppluginsj.sourceforge.jp/quick-comments/
Description: Post comments quickly without leaving or refreshing the page.
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

Includes:
 jQuery 1.2.6 - New Wave Javascript
  Copyright (c) 2008 John Resig (jquery.com)
  Dual licensed under the MIT and GPL licenses.

 jQuery blockUI plugin (http://malsup.com/jquery/block/)
  Version 2.08 (06/11/2008)
  Copyright (c) 2007-2008 M. Alsup
  Dual licensed under the MIT and GPL licenses:

 jQuery.ScrollTo http://flesler.blogspot.com
  Version 1.4 (09/11/2008)
  Copyright (c) 2007-2008 Ariel Flesler - aflesler(at)gmail(dot)com | 
  Dual licensed under MIT and GPL.

*/

class QuickCommentsController {
  var $plugin_name  = 'quick-comments';

  var $plugin_js    = 'js/quick-comments-0.5.3.min.js';
  var $plugin_ver   = '0.5.4';

  var $jquery_js    = 'js/jquery-1.2.6.min.js';
  var $jquery_ver   = '1.2.6';

  var $blockUI_js   = 'js/jquery.blockUI.min.js';
  var $blockUI_ver  = '2.08';

  var $scrollto_js  = 'js/jquery.scrollTo-min.js';
  var $scrollto_ver = '1.41';

  var $forChrome_js = 'js/jquery.browser.chrome.min.js';

  var $plugin_dir, $plugin_file, $plugin_url;
  var $textdomain_name;
  var $admin_option, $admin_action;
  var $options_default, $options, $option_name;
  var $effects, $effect_speeds;
  var $note, $error;

  /*
  * Constructor
  */
  function QuickCommentsController() {
    $this->setPluginDir();
    $this->loadTextdomain();

    $this->note = '';
    $this->error = 0;

    $this->admin_option    = $this->plugin_file;
    $this->admin_action    = trailingslashit(get_bloginfo('wpurl'))."wp-admin/admin.php?page=".$this->admin_option;

    $this->effects         = array(
                              "0" => __('Default', $this->textdomain_name)
                             ,"1" => __('Slide Down', $this->textdomain_name)
                             ,"2" => __('Fade In', $this->textdomain_name)
                             );
    $this->effect_speeds   = array(
                              "fast"   => __('Fast', $this->textdomain_name)
                             ,"normal" => __('Normal', $this->textdomain_name)
                             ,"slow"   => __('Slow', $this->textdomain_name)
                             );

    $this->editor_chk_mode = array(
                              "1" => __('Simple check', $this->textdomain_name)
                             ,"2" => __('Severe check', $this->textdomain_name)
                             );

    $this->option_name     = $this->plugin_name." Options";

    $this->options = $this->getOptions();
  }

  function setPluginDir() {
    $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_dir  = $filename[count($filename) - 2];
    $this->plugin_file = $filename[count($filename) - 1];
    $this->plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$this->plugin_dir);
    unset($filename);
  }

  function loadTextdomain( $sub_dir = '/language' ) {
    global $wp_version;
    $this->textdomain_name = $this->plugin_dir;
    $textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir).$sub_dir);
    if (version_compare($wp_version, "2.6", ">=") && defined('WP_PLUGIN_DIR')) {
      load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
    } else {
      $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
      load_plugin_textdomain($this->textdomain_name, $plugins_dir.$textdomain_dir);
    }
  }

  // Handles Add/strips slashes to the given array
  function stripArray($array) {
    if(is_array($array)) {
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  // Init Options
  function initOptions($wk_options = '') {
    $this->options_default = array(
      'form'    => 'form#commentform'
     ,'list'    => 'ol.commentlist:first'
     ,'message' => __('Please wait', $this->textdomain_name).'...'
     ,'message2'=> __('Loading', $this->textdomain_name).'...'
     ,'loader'  => $this->plugin_url.'images/ajax-loader.gif'
     ,'messageCSS' => "border:1px solid #8C8C8C; font:normal 12px Arial;"
     ,'overlayCSS' => "backgroundColor:#FFF; opacity:0.6;"
     ,'effect'  => 0
     ,'speed'   => "fast"
     ,'editMode'=> false
     ,'editMin' => 30
     ,'editIcon' => '<span style="float:right;"><img src="'.$this->plugin_url.'images/edit.png" title="'.__('Edit comment').'" alt="'.__('Edit comment').'" style="float:left;margin:0 .25em;border:none;" />'.__('Edit comment').'</span>'
     ,'editReturn' => '#edit-comment-%ID%'
     ,'editorChk' => 1
     );
    $template = get_settings('template');
    if ( preg_match('/^default/i', $template) ) {
     $this->options_default['form'] = 'form#commentform';
     $this->options_default['list'] = 'ol.commentlist:first';
     $this->options_default['editReturn'] = '#comment-%ID%';
    } elseif ( preg_match('/^(classic|easyall|k2)/i', $template) ) {
     $this->options_default['form'] = 'form#commentform';
     $this->options_default['list'] = 'ol#commentlist';
     $this->options_default['editReturn'] = '#comment-%ID%';
    } elseif ( preg_match('/^wp.vicuna/i', $template) ) {
     $this->options_default['form'] = 'form#commentsForm';
     $this->options_default['list'] = 'dl.log:first';
     $this->options_default['editReturn'] = '#comment%ID%';
    } elseif ( preg_match('/^sandbox/i', $template) ) {
     $this->options_default['form'] = 'form#commentform';
     $this->options_default['list'] = 'div#comments-list ol:first';
     $this->options_default['editReturn'] = '#comment-%ID%';
    }

    if (!is_array($wk_options)) $wk_options = array();
    if (!isset($wk_options['form']))       $wk_options['form']       = $this->options_default['form'];
    if (!isset($wk_options['list']))       $wk_options['list']       = $this->options_default['list'];
    if (!isset($wk_options['message']))    $wk_options['message']    = $this->options_default['message'];
    if (!isset($wk_options['message2']))   $wk_options['message2']   = $this->options_default['message2'];
    if (!isset($wk_options['loader']))     $wk_options['loader']     = $this->options_default['loader'];
    if (!isset($wk_options['messageCSS'])) $wk_options['messageCSS'] = $this->options_default['messageCSS'];
    if (!isset($wk_options['overlayCSS'])) $wk_options['overlayCSS'] = $this->options_default['overlayCSS'];
    if (!isset($wk_options['effect']))     $wk_options['effect']     = $this->options_default['effect'];
    if (!isset($wk_options['speed']))      $wk_options['speed']      = $this->options_default['speed'];

    if (!isset($wk_options['editMode']))   $wk_options['editMode']   = $this->options_default['editMode'];
    if (!isset($wk_options['editMin']))    $wk_options['editMin']    = $this->options_default['editMin'];
    if (!isset($wk_options['editIcon']))   $wk_options['editIcon']   = $this->options_default['editIcon'];
    if (!isset($wk_options['editReturn'])) $wk_options['editReturn'] = $this->options_default['editReturn'];
    if (!isset($wk_options['editorChk']))  $wk_options['editorChk']  = $this->options_default['editorChk'];

    return $wk_options;
  }

  // Get Text
  function getText($text) {
    return __($text, $this->textdomain_name);
  }

  // Get Options
  function getOptions(){
    return $this->initOptions(get_option($this->option_name));
  }

  // Update Options
  function updateOptions() {
    update_option($this->option_name, $this->options);
  }

  // Delete Options
  function deleteOptions() {
    delete_option($this->option_name);
  }

  // Make Nonce field
  function makeNonceField($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }

  // Output Javascript
  function writeScript($out = '', $place = 'head') {
    if ($out == '') return;

    global $script_manager;

    if (isset($script_manager)) {
      add_filter($place.'_script/ScriptManager', create_function('$js', 'return $js . "'.addcslashes($out,'"').'";'));
    } else {
      echo "<script type=\"text/javascript\">/*<![CDATA[ */\n";
      echo $out;
      echo "/* ]]>*/</script>\n";
    }
  }

  // Get Options for Javascript
  function getJsOptions() {
    global $user_ID;

    $out  = "var quickCommentsL10n = {";
    $out .= " form:'{$this->options['form']}'";
    $out .= ",list:'{$this->options['list']}'";
    $out .= ",message:'{$this->options['message']}'";
    $out .= ",loader:'{$this->options['loader']}'";
    if ( get_settings('require_name_email') && !$user_ID ) {
      $out .= ",requireNameEmail:true";
      $out .= ",errMsgNameEmail:'".__('Error: please fill the required fields (name, email).')."'";
    }
    $out .= ",errMsgEmail:'".__('Error: please enter a valid email address.')."'";
    $out .= ",errMsgCommentNone:'".__('Error: please type a comment.')."'";

    if ($this->options['messageCSS'] != $this->options_default['messageCSS']) {
      $messageCSS = preg_split('/[,;]/', $this->options['messageCSS'], -1, PREG_SPLIT_NO_EMPTY);
      if (is_array($messageCSS) && count($messageCSS) > 0) {
        $out .= ",messageCSS:{";
        $count = 0;
        foreach ($messageCSS as $value) {
          if ($count++ >= 1) $out .= ',';
          $out .= preg_replace("/^([^:]*)[ \t]*:[ \t]*(.*)$/", "$1:'$2'", trim($value));
        }
        $out .= "}";
      }
    }

    if ($this->options['overlayCSS'] != $this->options_default['overlayCSS']) {
      $overlayCSS = preg_split('/[,;]/', $this->options['overlayCSS'], -1, PREG_SPLIT_NO_EMPTY);
      if (is_array($overlayCSS) && count($overlayCSS) > 0) {
        $out .= ",overlayCSS:{";
        $count = 0;
        foreach ($overlayCSS as $value) {
          if ($count++ >= 1) $out .= ',';
          $out .= preg_replace("/^([^:]*)[ \t]*:[ \t]*(.*)$/", "$1:'$2'", trim($value));
        }
        $out .= "}";
      }
    }

    if ($this->options['effect'] != $this->options_default['effect']) $out .= ",effect:".(int)$this->options['effect'];
    if ($this->options['speed'] != $this->options_default['speed']) $out .= ",speed:'{$this->options['speed']}'";
    if ($this->options['editMode']) {
      $out .= ",message2:'{$this->options['message2']}'";
      $out .= ",update:'{$this->plugin_url}{$this->plugin_file}'";
      $out .= ",editReturn:'{$this->options['editReturn']}'";
    }

    $out .= "};\n";

    return $out;
  }

  // Regist Javascript
  function addScripts() {
    if (is_single() && !$this->isKtai()) {
      global $script_manager;

      if (isset($script_manager)) $script_manager->register_script('jquery', $this->plugin_url.$this->jquery_js, false, $this->jquery_ver);
      wp_enqueue_script('jquery');
      wp_enqueue_script('jquery.chrome',   $this->plugin_url.$this->forChrome_js, array('jquery'), $this->jquery_ver);
      wp_enqueue_script('jquery.blockUI',  $this->plugin_url.$this->blockUI_js,   array('jquery'), $this->blockUI_ver);
      wp_enqueue_script('jquery.scrollTo', $this->plugin_url.$this->scrollto_js,  array('jquery'), $this->scrollto_ver);
    }
  }

  // Regist Javascript (for WordPress 2.0.x)
  function addHeadScripts() {
    if (is_single() && !$this->isKtai()) {
      $out  = "";
      $out .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}{$this->jquery_js}\"></script>\n";
      $out .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}{$this->forChrome_js}\"></script>\n";
      $out .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}{$this->blockUI_js}\"></script>\n";
      $out .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}{$this->scrollto_js}\"></script>\n";
      echo $out;
    }
  }

  // Add Header Javascript
  function addHead() {
    if (is_single() && !$this->isKtai()) {
      $out  = $this->getJsOptions();
      $this->writeScript($out, 'head');
    }
  }

  // Add Footer Javascript
  function addFooter() {
    if (is_single() && !$this->isKtai()) {
      $out  = "<script type=\"text/javascript\" src=\"".$this->plugin_url.$this->plugin_js."\" charset=\"UTF-8\"></script>\n";
      echo $out;
    }
  }

  // Add Admin Menu
  function addAdminMenu() {
    add_options_page( __('Quick Comments', $this->textdomain_name)
                     ,__('Quick Comments', $this->textdomain_name)
                     ,9
                     ,$this->admin_option
                     ,array($this,'optionPage')
                    );
  }

  // Show Option Page
  function optionPage() {
    global $wp_version;

    // check referer (Wordpress 2.5+)
    $check_referer = version_compare($wp_version, "2.5", ">=");

    if (isset($_POST['ap_options_update'])) {
      if ($check_referer) check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['form']       = $_POST['ap_form'];
      $this->options['list']       = $_POST['ap_list'];
      $this->options['message']    = $_POST['ap_message'];
      $this->options['message2']   = $_POST['ap_message2'];
      $this->options['loader']     = $_POST['ap_loader'];
      $this->options['messageCSS'] = $_POST['ap_messageCSS'];
      $this->options['overlayCSS'] = $_POST['ap_overlayCSS'];
      $this->options['effect']     = $_POST['ap_effect'];
      $this->options['speed']      = $_POST['ap_speed'];
      $this->options['editMode']   = ($_POST['ap_editMode'] == 'on' ? true : false);
      $this->options['editMin']    = (int) $_POST['ap_editMin'];
      $this->options['editIcon']   = $_POST['ap_editIcon'];
      $this->options['editReturn'] = $_POST['ap_editReturn'];
      $this->options['editorChk']  = ($_POST['ap_editorChk'] == "1" ? 1 : 2);

      $_POST = '';

      // options update
      $this->updateOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

    } elseif(isset($_POST['ap_options_delete'])) {
      if ($check_referer) check_admin_referer("delete_options", "_wpnonce_delete_options");

      // options delete
      $this->deleteOptions();
      $this->options = $this->initOptions();

      // Done!
      $this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
      $this->error++;
    }

    $out  = '';

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('Quick Comments Options', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->makeNonceField("update_options", "_wpnonce_update_options", true, false);

    $out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

    // Form
    $out .= "<tr>";
    $out .= "<th>".__('Comment Form CSS Path', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_form\" id=\"ap_form\" size=\"50\" value=\"".$this->options['form']."\" /></td>";
    $out .= "</tr>\n";

    // List
    $out .= "<tr>";
    $out .= "<th>".__('Comment List CSS Path', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_list\" id=\"ap_list\" size=\"50\" value=\"".$this->options['list']."\" /></td>";
    $out .= "</tr>\n";

    // Wait Message
    $out .= "<tr>";
    $out .= "<th>".__('Wait Message', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_message\" id=\"ap_message\" size=\"50\" value=\"".$this->options['message']."\" /></td>";
    $out .= "</tr>\n";

    // Loading Image
    $out .= "<tr>";
    $out .= "<th>".__('Loading Image', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_loader\" id=\"ap_loader\" size=\"50\" value=\"".$this->options['loader']."\" /></td>";
    $out .= "</tr>\n";

    // Message CSS
    $out .= "<tr>";
    $out .= "<th>".__('Message CSS', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_messageCSS\" id=\"ap_messageCSS\" size=\"50\" value=\"".$this->options['messageCSS']."\" /></td>";
    $out .= "</tr>\n";

    // Overlay CSS
    $out .= "<tr>";
    $out .= "<th>".__('Overlay CSS', $this->textdomain_name)."</th>";
    $out .= "<td><input type=\"text\" name=\"ap_overlayCSS\" id=\"ap_overlayCSS\" size=\"50\" value=\"".$this->options['overlayCSS']."\" /></td>";
    $out .= "</tr>\n";

    // Effect
    $out .= "<tr>";
    $out .= "<th>".__('Effect', $this->textdomain_name)."</th>";
    $out .= "<td>";
    $out .= "<select name=\"ap_effect\">";
    foreach($this->effects as $key => $value) {
      $out .= "<option value=\"{$key}\"".($this->options['effect']==$key ? " selected=\"true\"": "").">{$value}</option>";
    }
    $out .= "</select>";

    $out .= "<select name=\"ap_speed\" style=\"margin-left:1em;\">";
    foreach($this->effect_speeds as $key => $value) {
      $out .= "<option value=\"{$key}\"".($this->options['speed']==$key ? " selected=\"true\"": "").">{$value}</option>";
    }
    $out .= "</select>";
    $out .= "</td>";
    $out .= "</tr>\n";

    // Allows users to edit their comments?
    $out .= "<tr>";
    $out .= "<th>".__('Allows users to edit their comments?', $this->textdomain_name)."</th>";
    $out .= "<td>";
    $out .= "<input type=\"checkbox\" name=\"ap_editMode\" value=\"on\" style=\"margin-right:0.5em;\" ".($this->options['editMode'] === true ? " checked=\"true\"" : "")." />";
    $out .= __('Allows users to edit their comments for a limited number of minutes after posting.', $this->textdomain_name)."<br />";
    $out .= "<select name=\"ap_editorChk\">";
    foreach($this->editor_chk_mode as $key => $value) {
      $out .= "<option value=\"{$key}\"".($this->options['editorChk']==$key ? " selected=\"true\"": "").">{$value}</option>";
    }
    $out .= "</select>";
    $out .= "</td>";
    $out .= "</tr>\n";

    // Time Limit
    $out .= "<tr>";
    $out .= "<th>".__('Number of minutes that users are allowed to edit their comment', $this->textdomain_name)."</th>";
    $out .= "<td>";
    $out .= "<input type=\"text\" name=\"ap_editMin\" id=\"ap_editMin\" size=\"5\" value=\"".$this->options['editMin']."\" />&nbsp;".__('minutes after posting', $this->textdomain_name);
    $out .= "</td>";
    $out .= "</tr>\n";

    // Loading Message
    $out .= "<tr>";
    $out .= "<th>".__('Comment Loading Message', $this->textdomain_name)."</th>";
    $out .= "<td>";
    $out .= "<input type=\"text\" name=\"ap_message2\" id=\"ap_message2\" size=\"50\" value=\"".$this->options['message2']."\" />";
    $out .= "</td>";
    $out .= "</tr>\n";

    // Edit Icon
    $out .= "<tr>";
    $out .= "<th>".__('Edit icon', $this->textdomain_name)."</th>";
    $out .= "<td>";
    $out .= "<input type=\"text\" name=\"ap_editIcon\" id=\"ap_editIcon\" size=\"75\" value=\"".str_replace('"', '&quot;', wp_specialchars($this->options['editIcon']))."\" />";
    $out .= "</td>";
    $out .= "</tr>\n";

    // Position that returns after it edits it (CSS path)
    $out .= "<tr>";
    $out .= "<th>".__('Position that returns after it edits it', $this->textdomain_name)."</th>";
    $out .= "<td>";
    $out .= "<input type=\"text\" name=\"ap_editReturn\" id=\"ap_editReturn\" size=\"30\" value=\"{$this->options['editReturn']}\" />";
    $out .= __('css path (%ID% is substituted for comment ID.)', $this->textdomain_name);
    $out .= "</td>";
    $out .= "</tr>\n";

    $out .= "</tbody></table>";

    // Add Update Button
    $out .= "<p style=\"margin-top:1em\"><input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" /></p>";
    $out .= "</form></div>\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";

    if ($check_referer) $out .= $this->makeNonceField("delete_options", "_wpnonce_delete_options", true, false);

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  // get auth param
  function getAuthParam($param = '') {
    switch ($this->options['editorChk']) {
     case 1:
      if ($param == '') {$param = $_SERVER['REMOTE_ADDR'];}
      return preg_replace( '/[^0-9a-fA-F:., ]/', '', $param);
      break;
     case 2:
      global $comment;
      if ($param == '') {$param = $comment;}
      return md5($param->comment_author_IP
                .$param->comment_agent
                .$param->comment_author
                .$param->comment_author_email
                .$param->comment_author_url);
      break;
     default:
      return false;
    }
  }

  // Comment Redirect
  function commentRedirect($location) {
    global $comment_id, $comment_post_ID;
    if (isset($_POST['quick-comments']) && !$this->isKtai()) {
      $auth_param = $this->getAuthParam();
      $param = '?getlist'
             . '&comment_post_ID='.$comment_post_ID
             . '&comment_ID='.$comment_id
             . '&qc_auth_param='.$auth_param;

      // set COOKIE
      switch ($this->options['editorChk']) {
       case 1:
        break;
       case 2:
        setcookie('qc_auth_param_'.COOKIEHASH, $auth_param, time() + (60 * intval($this->options['editMin'])), COOKIEPATH, COOKIE_DOMAIN );
        break;
       default:
        break;
      }

      if (isset($_POST['redirect_to']) && strstr($_POST['redirect_to'], '?'))
        $param .= '&'.preg_replace('/^.*\?(.*)$/' ,'$1', $_POST['redirect_to']);
      return $this->plugin_url.$this->plugin_file.$param;

    } else {
      return $location;
    }
  }

  // quick-comments active?
  function isActive() {
    $is_active = false;
    foreach (get_option('active_plugins') as $val) {
      if (preg_match('/'.preg_quote($this->plugin_file).'/i', $val)) {
        $is_active = true;
        break;
      }
    }
    return $is_active;
  }

  // Mobile Access ?
  function isKtai(){
    return ((function_exists('is_mobile') && is_mobile())
          ||(function_exists('is_ktai') && is_ktai())
           );
  }

  // is Comment or (Trackback or Pingback) ?
  function isComment($comment_id = '') {
    global $comment;

    if (!isset($comment)) $comment = &get_comment($comment_id);

    return (  $comment->comment_type != "trackback"
           && $comment->comment_type != "pingback"
           && !ereg("<pingback />", $comment->comment_content)
           && !ereg("<trackback />", $comment->comment_content)
           );
  }

  // Time limit ?
  function isTimeLimit($date_gmt){
    $time_ago  = time() - strtotime($date_gmt . ' GMT');	           // in seconds
    $time_left = round(($this->options['editMin'] - ($time_ago / 60)), 0); // in minutes
    return $time_ago < (60 * intval($this->options['editMin']));
  }

  // Allow Comment ?
  function isCommentAllow($comment_id = '') {
    global $comment, $user_ID, $post;

    if (!$this->options['editMode'] || $this->isKtai()) return false;

    if (!isset($comment)) $comment = &get_comment($comment_id);
    if (!isset($post))    $post = &get_post($comment->comment_post_ID);

    switch ($this->options['editorChk']) {
     case 1:
      $auth_param = preg_replace( '/[^0-9a-fA-F:., ]/', '', (isset($_REQUEST['qc_auth_param']) ? $_REQUEST['qc_auth_param'] : $_SERVER['REMOTE_ADDR'] ));
      break;
     case 2:
      $auth_param = (isset($_REQUEST['qc_auth_param']) ? $_REQUEST['qc_auth_param'] : $_COOKIE['qc_auth_param_'.COOKIEHASH]);
      break;
     default:
      $auth_param = preg_replace( '/[^0-9a-fA-F:., ]/', '', (isset($_REQUEST['qc_auth_param']) ? $_REQUEST['qc_auth_param'] : $_SERVER['REMOTE_ADDR'] ));
      break;
    }

    return ( current_user_can( 'edit_'.$post->post_type, $post->ID ) )
        || ( user_can_edit_post_comments($user_ID, $post->ID) )
        || ( $auth_param == $this->getAuthParam($this->options['editorChk'] == 1 ? $comment->comment_author_IP : $comment)
          && $this->isTimeLimit($comment->comment_date_gmt) );
  }

  // Get Comments from post ID
  function getComments($comment_post_ID, $with_stylesheet = false) {
    global $post, $comment, $authordata, $withcomments;

    // get comment list elements
    $list_element = 'ol';
    $list_id      = '';
    $list_class   = '';
    if (preg_match('/^([^#\.]*)([#\.])([^:]*)/', $this->options['list'], $matches)) {
      $list_element = $matches[1];
      $list_id      = ($matches[2]=='#' ? $matches[3] : '');
      $list_class   = ($matches[2]=='.' ? $matches[3] : '');
    } else {
      $list_element = preg_replace('/^([^#\.]*)[#\.].*$/', '$1', $this->options['list']);
    }
    unset($matches);

    // get post data
    if (function_exists('get_post')) {
      $post = get_post($comment_post_ID);
      $authordata = get_userdata($post->post_author);
    } else {
      $post->ID = $comment_post_ID;
    }
    $withcomments = true;

    // generate HTML
    $out  = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
    $out .= "<html>\n";
    $out .= "<head>";
    $out .= "<title>Comments (PostID:{$comment_post_ID})</title>";
    if ($with_stylesheet) $out .= "<link rel=\"stylesheet\" href=\"".get_stylesheet_uri()."\" type=\"text/css\" media=\"screen\" />";
    $out .= "</head>\n";
    $out .= "<body><div>";

    // get comment data
    ob_start();								// start buffering output
    comments_template();
    $commentout = preg_replace('/[\r\n\t]/ims', '', ob_get_clean());	// grab buffered output

    // get comment list element
    $list_id    = ($list_id    != '' ? ' [^>]*id=[\'"]'.$list_id.'[\'"]' : '');
    $list_class = ($list_class != '' ? ' [^>]*class=[\'"]'.$list_class.'[\'"]' : '');
    if (preg_match('/<'.$list_element.$list_id.$list_class.'[^>]*>.*<\/'.$list_element.'>/i', preg_replace('/<form.*$/i', '', $commentout), $matches)) {
      $out .= $matches[0];
    } else {
      $out .= $commentout;
    }
    unset($matches);

    $out .= "</div></body>\n";
    $out .= "</html>";

    // convert encoding (UTF-8)
    $charset = get_option('blog_charset');
    if (strtoupper($charset) != "UTF-8") $out = mb_convert_encoding($out, "UTF-8", $charset);

    // output
    nocache_headers();
    header('Content-type: text/html; charset=utf-8');
    echo $out;
  }

  // get comments list
  function getCommentList($comment_post_ID, $comment_ID = '') {
    if (!$this->isActive() && $this->isCommentAllow($comment_ID)) {
      header("HTTP/1.0 403 Forbidden");
      wp_die(__('403 Forbidden', $this->textdomain_name));
    }

    $this->getComments($comment_post_ID);
  }

  // Get Comment Data (JSON) from comment ID
  function getCommentData($comment_id = '') {
    global $comment;

    if (!$this->options['editMode'] || !$this->isActive()) {
      header("HTTP/1.0 403 Forbidden");
      wp_die(__("You aren't allowed to edit this comment.", $this->textdomain_name));
    }

    // get comment
    if (!isset($comment)) $comment = &get_comment($comment_id);
    if (isset($comment) && $this->isCommentAllow($comment->comment_ID)) {
      $comment_content = str_replace('"', '\\"', preg_replace("/\r\n/ims", "\n", $comment->comment_content));
      $out  = '{';
      $out .= '"status":true';
      $out .= ',"id":"'.$comment->comment_ID.'"';
      $out .= ',"author":"'.$comment->comment_author.'"';
      $out .= ',"email":"'.$comment->comment_author_email.'"';
      $out .= ',"url":"'.$comment->comment_author_url.'"';
      $out .= ',"datetime":"'.$comment->comment_date.'"';
      $out .= ',"content":"'.preg_replace('/\n/ims', '\\n', $comment_content).'"';
      $out .= '}';
    } else {
      $out  = '{';
      $out .= '"status":false';
      $out .= ',"message":"'.sprintf(__("You aren't allowed to edit this comment, either because you didn't write it or you passed the %d minute time limit.", $this->textdomain_name), $this->options['editMin']).'"';
      $out .= '}';
    }

    // convert encoding (UTF-8)
    $charset = get_option('blog_charset');
    if (strtoupper($charset) != "UTF-8") $out = mb_convert_encoding($out, "UTF-8", $charset);

    // output
    nocache_headers();
    header('Content-Type: application/x-javascript; charset=utf-8');
    echo $out;
  }

  // Edit Comment
  function updateCommentData($comment_post_ID, $comment_ID, $comment_content, $comment_author = '', $comment_email = '', $comment_url = ''){
    global $wpdb, $comment, $post;

    // is this Plugin Active and Edit Mode?
    if (!$this->options['editMode'] || !$this->isActive()) {
      header("HTTP/1.0 403 Forbidden");
      wp_die(__("You aren't allowed to edit this comment.", $this->textdomain_name));
    }

    // get comments & post
    if (!isset($comment)) $comment = &get_comment($comment_id);
    if (!isset($post))    $post = &get_post($comment_post_ID);

    // allow comment ?
    if (!$this->isCommentAllow($comment_ID)) {
      header("HTTP/1.0 403 Forbidden");
      wp_die(sprintf(__("You aren't allowed to edit this comment, either because you didn't write it or you passed the %d minute time limit.", $this->textdomain_name), $this->options['editMin']));
    }

    // comment update
    $comment_content = apply_filters('comment_save_pre', str_replace('\\"', '"', $comment_content)); // escaping and shiz. Same as wp-admin comment editing
    $wpdb->query($wpdb->prepare(
        "UPDATE $wpdb->comments"
       ." SET comment_content = %s"
       ." WHERE comment_ID = %d"
      , $comment_content, $comment_ID)
    );
    if(function_exists('clean_comment_cache'))     clean_comment_cache($comment_ID);
    if(function_exists('wp_update_comment_count')) wp_update_comment_count($comment_post_ID);
    do_action('edit_comment', $comment_ID);

    // get comments list
    $this->getComments($comment_post_ID);
  }

  // Get comment edit link
  function getCommentEditLink() {
    global $comment, $user_ID, $post;

    // allow comment ?
    if ($this->isComment($comment->ID) && $this->isCommentAllow($comment->ID)) {
      return '<a href="#" title="'.__('Edit comment').'" class="edit-comment" id="edit-comment-'.$comment->comment_ID.'" style="cursor:pointer;">'.$this->options['editIcon'].'</a>';
    } else {
      return '';
    }
  }

  // Add Edit Icon before comment author link
  function commentAuthorLink($link) {
    return $this->getCommentEditLink().$link;
  }
}//class

if(!function_exists('get_option')) {
  $path = (defined('ABSPATH') ? ABSPATH : dirname(dirname(dirname(dirname(__FILE__)))) . '/');
  require_once(file_exists($path.'wp-load.php') ? $path.'wp-load.php' : $path.'wp-config.php');
}

if (!class_exists('ScriptManager')) {
  require(dirname(__FILE__).'/includes/script-manager.php');
}


$QuickComments = new QuickCommentsController();

// Add Edit Icon before comment author link
add_filter('get_comment_author_link', array(&$QuickComments,'commentAuthorLink'));

if (strstr($_SERVER['PHP_SELF'], '/quick-comments.php')) {
  // get Param
  if (isset($_REQUEST['comment_post_ID'])) $comment_post_ID = (int) $_REQUEST['comment_post_ID'];
  if (isset($_REQUEST['comment_ID']))      $comment_ID =      (int) $_REQUEST['comment_ID'];

  if (isset($_REQUEST['getlist'])) {
    // Get comment list
    $QuickComments->getCommentList($comment_post_ID, $comment_ID);
  } elseif (isset($_REQUEST['json'])) {
    // Get comment data
    $QuickComments->getCommentData($comment_ID);
  } elseif (isset($_REQUEST['update'])) {
    // Edit comment data
    $QuickComments->updateCommentData($comment_post_ID, $comment_ID, $_REQUEST['comment'], $_REQUEST['author'], $_REQUEST['email'], $_REQUEST['url']);
  } else {
    $err_message = $QuickComments->getText('403 Forbidden');
    unset($QuickComments);
    header("HTTP/1.0 403 Forbidden");
    wp_die($err_message);
  }

} else {
  add_action('admin_menu', array(&$QuickComments,'addAdminMenu'));

  if (function_exists('wp_enqueue_script')) {
    // Wordpress 2.1+
    add_action('wp_print_scripts', array(&$QuickComments,'addScripts'));
  } else {
    // Wordpress 2.0.x
    add_action('wp_head', array(&$QuickComments,'addHeadScripts'));
  }
  add_action('wp_head', array(&$QuickComments,'addHead'));
  add_action('wp_footer', array(&$QuickComments,'addFooter'));
  add_filter('comment_post_redirect', array(&$QuickComments,'commentRedirect'));
}

unset($QuickComments);
?>