<?php
/*
Plugin Name: WP-lightpop
Version: 0.6.1
Plugin URI: http://wppluginsj.sourceforge.jp/wp-lightpop/
Description: Add overlay images and videos (and more) to Your Wordpress site.
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

Includes:
 jQuery 1.2.6 - New Wave Javascript
  Copyright (c) 2008 John Resig (jquery.com)
  Dual licensed under the MIT and GPL licenses.

 FLV Media Player 3.16
  The FLV Media Player is licensed under a <a href="http://creativecommons.org/licenses/by-nc-sa/2.0/">Creative Commons License</a>.
  It allows you to use, modify and redistribute the script for free for noncommercial purposes.
  For corporate use, <a href="http://www.jeroenwijering.com/?page=order" title="Order commercial licenses">please apply for a 20 euros commercial license</a>!

*/
class LightPopController {
  var $plugin_name  = 'wp-lightpop';

  var $jquery_js    = 'js/jquery-1.2.6.min.js';
  var $jquery_ver   = '1.2.6';

  var $lightpop_js  = 'js/jquery.lightpop-0.6.1.min.js';
  var $lightpop_ver = '0.6.1';

  var $options_default = array(
        'overlayBgColor'       => "#000"
       ,'overlayOpacity'       => 0.7
       ,'contentFrameType'     => 0
       ,'contentBorder'        => "none"
       ,'contentBgColor'       => "#FFF"
       ,'imageLoading'         => "images/lightpop-ico-loading.gif"
       ,'imageBtnPrev'         => "images/lightpop-btn-prev.gif"
       ,'imageBtnNext'         => "images/lightpop-btn-next.gif"
       ,'imageBtnClose'        => "images/lightpop-btn-close.gif"
       ,'imageBlank'           => "images/lightpop-blank.gif"
       ,'imageBox'             => "images/lightpop-box.gif"
       ,'imageBorderL'         => "images/lightpop-border-l.gif"
       ,'imageBorderR'         => "images/lightpop-border-r.gif"
       ,'imageMaxWidth'        => 0
       ,'imageMaxHeight'       => 0
       ,'containerBorderSize'  => 10
       ,'boxBorderSize'        => 6
       ,'containerResizeSpeed' => 400
       ,'txtImage'             => "Image"
       ,'txtOf'                => "of"
       ,'keyToClose'           => "c"
       ,'keyToPrev'            => "p"
       ,'keyToNext'            => "n"
       ,'flvplayer'            => "mediaplayer.swf"
       ,'iconAdd'              => 0
       ,'iconPath'             => "images/"
       ,'setLinkToTitle'       => 0
       ,'paramYouTube'         => ''
       ,'paramMetacafe'        => ''
       ,'paramLiveLeak'        => ''
       ,'paramGoogleVideo'     => ''
       ,'paramifilm'           => ''
       ,'paramDailymotion'     => ''
       ,'paramsuperdeluxe'     => ''
      );

  var $frame_type = array(
        0 => array('Border')
       ,1 => array('Default box',          'images/box0.gif', 'images/box0_l.gif', 'images/box0_r.gif', '#FFF', 17)
       ,2 => array('Emboss',               'images/box1.gif', 'images/box1_l.gif', 'images/box1_r.gif', '#FFF',  6)
       ,3 => array('Drop shadow',          'images/box2.gif', 'images/box2_l.gif', 'images/box2_r.gif', '#FFF',  6)
       ,4 => array('Shadow in the inside', 'images/box3.gif', 'images/box3_l.gif', 'images/box3_r.gif', '#FFF',  6)
       ,5 => array('Double shadow',        'images/box4.gif', 'images/box4_l.gif', 'images/box4_r.gif', '#FFF',  9)
       ,6 => array('Detainment of corner', 'images/box5.gif', 'images/box5_l.gif', 'images/box5_r.gif', '#FFF', 16)
       ,9 => array('Original design')
      );

  var $plugin_dir, $plugin_file, $plugin_url;
  var $textdomain_name;
  var $options, $option_name, $elements;
  var $note,$error;

  /*
  * Constructor
  */
  function LightPopController() {
    $this->setPluginDir();
    $this->loadTextdomain();

    $this->note  = '';
    $this->error = 0;
    $this->option_name = $this->plugin_name." Options";
    $this->options     = $this->initOptions(get_option($this->option_name));
  }

  function setPluginDir() {
    $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_dir  = $filename[count($filename) - 2];
    $this->plugin_file = $filename[count($filename) - 1];
    $this->plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$this->plugin_dir);
    unset($filename);
  }

  function loadTextdomain( $sub_dir = '/language' ) {
    global $wp_version;
    $this->textdomain_name = $this->plugin_dir;
    $textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir).$sub_dir);
    if (version_compare($wp_version, "2.6", ">=") && defined('WP_PLUGIN_DIR')) {
      load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
    } else {
      $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
      load_plugin_textdomain($this->textdomain_name, $plugins_dir.$textdomain_dir);
    }
  }

  /*
  * Init Options
  */
  function initOptions($wk_options) {
    $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');

    if (!is_array($wk_options)) $wk_options = array();

    if (!isset($wk_options['targetCSS']))  $wk_options['targetCSS']  = "a[@href^=".trailingslashit($siteurl.get_option('upload_path'))."]\na[@href*=.youtube.com/watch]";
    if (!isset($wk_options['postClass']))  $wk_options['postClass']  = "";

    foreach ($this->options_default as $key => $value) {
      if (!isset($wk_options[$key])) {
        switch ($key) {
        case 'imageLoading':
        case 'imageBtnPrev':
        case 'imageBtnNext':
        case 'imageBtnClose':
        case 'imageBlank':
        case 'imageBox':
        case 'imageBlank':
        case 'imageBorderL':
        case 'imageBorderR':
        case 'iconPath':
          $wk_options[$key] = $this->plugin_url.$value;
          break;
        case 'flvplayer':
          if (file_exists('./swf/mediaplayer.swf')) {
            $wk_options[$key] = $this->plugin_url."swf/mediaplayer.swf";
          } elseif (file_exists('./flvplayer.swf')) {
            $wk_options[$key] = $this->plugin_url."flvplayer.swf";
          } elseif (file_exists('../videopop_plus/swf/mediaplayer.swf')) {
            $wk_options[$key] = $plugins_dir.'videopop_plus/swf/mediaplayer.swf';
          } elseif (file_exists('../videopop_plus/flvplayer.swf')) {
            $wk_options[$key] = $plugins_dir.'videopop_plus/flvplayer.swf';
          } else {
            $wk_options[$key] = $value;
          }
          break;
        default:
          $wk_options[$key] = $value;
          break;
        }
      }
    }
    if (!isset($wk_options['lightpop_option'])) $wk_options['lightpop_option'] = $this->getLightpopOption();
    return ($wk_options);
  }

  function getLightpopOption() {
    $retVal  = " imageLoading:'".$this->options['imageLoading']."'"
              .",imageBtnPrev:'".$this->options['imageBtnPrev']."'"
              .",imageBtnNext:'".$this->options['imageBtnNext']."'"
              .",imageBtnClose:'".$this->options['imageBtnClose']."'"
              .",imageBlank:'".$this->options['imageBlank']."'"
              .",flvplayer:'".$this->options['flvplayer']."'";

    switch ($this->options['contentFrameType']) {
    case 0:
     $retVal .= ",contentFrameType:'border'";
     if ($this->options['overlayBgColor'] != $this->options_default['overlayBgColor']) {
      $retVal .= ",overlayBgColor:'".$this->options['overlayBgColor']."'";
     }
     if ($this->options['contentBorder'] != $this->options_default['contentBorder']) {
      $retVal .= ",contentBorder:'".$this->options['contentBorder']."'";
     }
     break;

    case 9:
     $retVal .= ",contentFrameType:'box'"
               .",overlayBgColor:'".$this->options['overlayBgColor']."'"
               .",boxBorderSize:".$this->options['boxBorderSize']
               .",imageBox:'".$this->options['imageBox']."'"
               .",imageBorderL:'".$this->options['imageBorderL']."'"
               .",imageBorderR:'".$this->options['imageBorderR']."'";
     break;

    default:
     $retVal .= ",contentFrameType:'box'";
     if ($this->options['overlayBgColor'] == $this->options_default['overlayBgColor']) {
      $retVal .= ",overlayBgColor:'".$this->frame_type[$this->options['contentFrameType']][4]."'";
     } else {
      $retVal .= ",overlayBgColor:'".$this->options['overlayBgColor']."'";
     }
     $retVal .= ",boxBorderSize:".$this->frame_type[$this->options['contentFrameType']][5]
               .",imageBox:'".$this->plugin_url.$this->frame_type[$this->options['contentFrameType']][1]."'"
               .",imageBorderL:'".$this->plugin_url.$this->frame_type[$this->options['contentFrameType']][2]."'"
               .",imageBorderR:'".$this->plugin_url.$this->frame_type[$this->options['contentFrameType']][3]."'";
     break;
    }

    $options = array('overlayOpacity'
                    ,'containerBorderSize'
                    ,'containerResizeSpeed'
                    ,'imageMaxWidth'
                    ,'imageMaxHeight'
                    );
    foreach($options as $option_key) {
     if (isset($this->options[$option_key]) && $this->options[$option_key] != $this->options_default[$option_key]) {
      $retVal .= ",".$option_key.":".$this->options[$option_key];
     }
    }
    $options = array('contentBgColor'
                    ,'txtImage'
                    ,'txtOf'
                    ,'keyToClose'
                    ,'keyToPrev'
                    ,'keyToNext'
                    );
    foreach($options as $option_key) {
     if (isset($this->options[$option_key]) && $this->options[$option_key] != $this->options_default[$option_key]) {
      $retVal .= ",".$option_key.":'".$this->options[$option_key]."'";
     }
    }

    if ($this->options['setLinkToTitle'] == 1) {
     $retVal .= ",setLinkToTitle:true";
    }
    if ($this->options['iconAdd'] == 1) {
     $retVal .= ",iconAdd:true"
               .",iconImage:'".$this->options['iconPath']."icon-image.png'"
               .",iconVideo:'".$this->options['iconPath']."icon-video.png'"
               .",iconYouTube:'".$this->options['iconPath']."icon-youtube.png'"
               .",iconMetacafe:'".$this->options['iconPath']."icon-metacafe.png'"
               .",iconLiveLeak:'".$this->options['iconPath']."icon-liveleak.png'"
               .",iconGoogleVideo:'".$this->options['iconPath']."icon-googlevideo.png'"
               .",iconifilm:'".$this->options['iconPath']."icon-ifilm.png'"
               .",iconDailymotion:'".$this->options['iconPath']."icon-dailymotion.png'"
               .",iconsuperdeluxe:'".$this->options['iconPath']."icon-superdeluxe.png'"
               .",iconnicovideo:'".$this->options['iconPath']."icon-nicovideo.png'"
               .",iconContents:'".$this->options['iconPath']."icon-html.png'";
    } else {
     $retVal .= ",iconAdd:false";
    }

    $options = array('paramYouTube'
                    ,'paramMetacafe'
                    ,'paramLiveLeak'
                    ,'paramGoogleVideo'
                    ,'paramifilm'
                    ,'paramDailymotion'
                    ,'paramsuperdeluxe'
                    );
    foreach($options as $option_key) {
     if (isset($this->options[$option_key]) && $this->options[$option_key] != '') {
      $retVal .= ",".$option_key.":[";
      foreach(explode("&", $this->options[$option_key]) as $value) {
       $retVal .= "'".$value."',";
      }
      $retVal  = preg_replace("/,$/", "", $retVal);
      $retVal .= "]";
     }
    }

    $retVal  = "{".$retVal."}";

    unset($options);

    return $retVal;
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      $slashed_array = array();
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
      return $slashed_array;
    } else {
      return $array;
    }
  }

  /*
  * Update Options
  */
  function update_options() {
    update_option($this->option_name, $this->options);
  }

  /*
  * Delete Options
  */
  function deleteOptions() {
    delete_option($this->option_name);
    $this->options = array();
  }

  function writeScript($out = '', $place = 'head') {
    if ($out == '') return;

    global $script_manager;

    if (isset($script_manager)) {
      add_filter($place.'_script/ScriptManager', create_function('$js', 'return $js . "'.addcslashes($out,'"').'";'));
    } else {
      echo "<script type=\"text/javascript\">/*<![CDATA[ */\n";
      echo $out;
      echo "/* ]]>*/</script>\n";
    }
  }

  function getJsOptions() {
    if (!isset($this->options['lightpop_option'])) $this->options['lightpop_option'] = $this->getLightpopOption();
    $out  = '';
    $out .= "var lightpop={options:{$this->options['lightpop_option']},start:function(){}};\n";
    return $out;
  }

  function getJsLighPopStart() {
    $elements = preg_split('/[\n\r]/', apply_filters('css_elements/wp-lightpop.php', $this->options['targetCSS']));

    $out  = "lightpop.start=function(){";
    if (trim($this->options['postClass']) != '') {
      $out .= "jQuery('.".trim($this->options['postClass'])."').each(function(){";
      foreach($elements as $value) {
        if (trim($value) != '') {
          $out .= "jQuery('".trim($value)."', jQuery(this)).lightpop(lightpop.options);";
        }
      }
      $out .= "});";
    } else {
      foreach($elements as $value) {
        if (trim($value) != '') {
          $out .= "jQuery('".trim($value)."').lightpop(lightpop.options);";
        }
      }
    }
    $out .= "};";
    $out .= "jQuery(lightpop.start);\n";

    unset($elements);

    return $out;
  }

  function addScripts() {
    if (!is_admin()) {
      global $script_manager;

      if (defined('YUI_GET_ON') && YUI_GET_ON) {
        wp_register_script('yui-core', 'http://yui.yahooapis.com/2.5.2/build/yahoo/yahoo-min.js', false, '2.5.2');
        wp_register_script('yui-get',  'http://yui.yahooapis.com/2.5.2/build/get/get-min.js', array('yui-core'), '2.5.2');
        wp_enqueue_script("yui-get");	// YUI Get
      }

      if (isset($script_manager)) $script_manager->register_script('jquery', $this->plugin_url.$this->jquery_js, false, $this->jquery_ver);
      wp_enqueue_script("jquery");	// jQuery

      if (!(defined('YUI_GET_ON') && YUI_GET_ON)) {
        wp_enqueue_script('jquery.lightpop', $this->plugin_url.$this->lightpop_js, array('jquery'), $this->lightpop_ver);
      }
    }
  }

  function addHead() {
    $out  = '';

    if (!(defined('YUI_GET_ON') && YUI_GET_ON)) {
      $out .= $this->getJsOptions();
    }

    $this->writeScript($out, 'head');
  }

  function addFooter() {
    $out  = '';

    if (!(defined('YUI_GET_ON') && YUI_GET_ON)) {
      $out .= $this->getJsLighPopStart();
    } else {
      $out .= "YAHOO.util.Get.script('{$this->plugin_url}{$this->lightpop_js}', {onSuccess:function(){\n";
      $out .= $this->getJsOptions();
      $out .= $this->getJsLighPopStart();
      $out .= "}});\n";
    }

    $this->writeScript($out, 'footer');
  }

  function addAdminMenu() {
    add_options_page(__('LightPop', $this->textdomain_name), __('LightPop', $this->textdomain_name), 9, basename(__FILE__), array($this,'optionPage'));
  }

  function optionPage() {
    global $wp_version;

    // check referer (Wordpress 2.5+)
    $check_referer = version_compare($wp_version, "2.5", ">=");

    // options update
    if(isset($_POST['ap_options_update'])) {
      // check referer
      if ($check_referer) check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['targetCSS'] = $_POST['ap_targetCSS'];
      $this->options['postClass'] = $_POST['ap_postClass'];
      $this->options['overlayBgColor'] = $_POST['ap_overlayBgColor'];
      $this->options['overlayOpacity'] = $_POST['ap_overlayOpacity'];
      $this->options['contentFrameType'] = $_POST['ap_contentFrameType'];
      $this->options['contentBorder'] = $_POST['ap_contentBorder'];
      $this->options['contentBgColor'] = $_POST['ap_contentBgColor'];
      $this->options['imageLoading'] = $_POST['ap_imageLoading'];
      $this->options['imageBtnPrev'] = $_POST['ap_imageBtnPrev'];
      $this->options['imageBtnNext'] = $_POST['ap_imageBtnNext'];
      $this->options['imageBtnClose'] = $_POST['ap_imageBtnClose'];
      $this->options['imageBlank'] = $_POST['ap_imageBlank'];
      $this->options['boxBorderSize'] = $_POST['ap_boxBorderSize'];
      $this->options['imageBox'] = $_POST['ap_imageBox'];
      $this->options['imageBorderL'] = $_POST['ap_imageBorderL'];
      $this->options['imageBorderR'] = $_POST['ap_imageBorderR'];
      $this->options['imageMaxWidth'] = $_POST['ap_imageMaxWidth'];
      $this->options['imageMaxHeight'] = $_POST['ap_imageMaxHeight'];
      $this->options['containerBorderSize'] = $_POST['ap_containerBorderSize'];
      $this->options['containerResizeSpeed'] = $_POST['ap_containerResizeSpeed'];
      $this->options['txtImage'] = $_POST['ap_txtImage'];
      $this->options['txtOf'] = $_POST['ap_txtOf'];
      $this->options['keyToClose'] = $_POST['ap_keyToClose'];
      $this->options['keyToPrev'] = $_POST['ap_keyToPrev'];
      $this->options['keyToNext'] = $_POST['ap_keyToNext'];
      $this->options['flvplayer'] = $_POST['ap_flvplayer'];
      $this->options['iconAdd'] = $_POST['ap_iconAdd'];
      $this->options['iconPath'] = $_POST['ap_iconPath'];
      $this->options['setLinkToTitle'] = $_POST['ap_setLinkToTitle'];
      $this->options['lightpop_option'] = $this->getLightpopOption();
      $_POST = '';

      // Done!
      $this->update_options();
      $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);

    // options delete
    } elseif(isset($_POST['ap_options_delete'])) {
      // check referer
      if ($check_referer) check_admin_referer("delete_options", "_wpnonce_delete_options");

      // Done!
      $this->deleteOptions();
      $this->options = $this->initOptions(array());
      $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);
      $this->error++;
    }

    $out  = '';

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('WP-LightPop Options', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$_SERVER['REQUEST_URI']."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("update_options", "_wpnonce_update_options", true, false);

    $out .= "<table>\n";

    // Target CSS
    $out .= "<tr>";
    $out .= "<td><strong>".__('Target Element', $this->textdomain_name)."</strong></td>";
    $out .= "<td><textarea name=\"ap_targetCSS\" cols=\"100\" rows=\"5\">".$this->options['targetCSS']."</textarea></td>";
    $out .= "</tr>\n";

    // 
    $out .= "<tr>";
    $out .= "<td><strong>".__('Post Class', $this->textdomain_name)."</strong></td>";
    $out .= "<td>";
    $out .= "<input type=\"text\" name=\"ap_postClass\" id=\"ap_postClass\" size=\"20\" value=\"".$this->options['postClass']."\" />";
    $out .= "&nbsp;&nbsp;<strong>".__('Each class makes it to the group.', $this->textdomain_name)."</strong>";
    $out .= "</td>";
    $out .= "</tr>\n";

    // Choose Frame type
    $out .= "<tr>";
    $out .= "<td><strong>".__('Frame type', $this->textdomain_name)."</strong></td>";
    $out .= "<td>";
    $out .= "<select name=\"ap_contentFrameType\" onchange=\"javascript:document.getElementById('lightpop-box-options').style.display = (this.value==9 ? 'block' : 'none');\">";
    foreach($this->frame_type as $key => $value) {
      $out .= "<option value=\"".$key."\"".($this->options['contentFrameType'] == $key ? " selected=\"selected\"" : "").">".__($value[0], $this->textdomain_name)."</option>";
    }
    $out .= "</select>";
    $out .= "<div id=\"lightpop-box-options\"".($this->options['contentFrameType'] != 9 ? " style=\"display:none\"" : "")."><br /><table>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Border Size', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_boxBorderSize\" id=\"ap_boxBorderSize\" size=\"10\" value=\"".$this->options['boxBorderSize']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Box Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageBox\" id=\"ap_imageBox\" size=\"75\" value=\"".$this->options['imageBox']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Border left Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageBorderL\" id=\"ap_imageBorderL\" size=\"75\" value=\"".$this->options['imageBorderL']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Border right Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageBorderR\" id=\"ap_imageBorderR\" size=\"75\" value=\"".$this->options['imageBorderR']."\" /></td>";
    $out .= "</tr>";
    $out .= "</table></div>";
    $out .= "</td>";
    $out .= "</tr>\n";

    // icon add
    $out .= "<tr>";
    $out .= "<td><strong>".__('Link icon', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"checkbox\" name=\"ap_iconAdd\" value=\"1\" style=\"margin-right:0.5em;\" ".($this->options['iconAdd']==1?" checked=\"true\"":"")." />".__('Before link', $this->textdomain_name)."</td>";
    $out .= "</tr>\n";

    // set link to title
    $out .= "<tr>";
    $out .= "<td><strong>".__('Set link to title', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"checkbox\" name=\"ap_setLinkToTitle\" value=\"1\" style=\"margin-right:0.5em;\" ".($this->options['setLinkToTitle']==1?" checked=\"true\"":"")." /></td>";
    $out .= "</tr>\n";

    $out .= "</table>\n";

    // more options
    $out .= "<a href=\"#\" onclick=\"javascript:document.getElementById('lightpop-more-options').style.display='block';this.style.display='none';return false;\">".__('More options', $this->textdomain_name)."</a><br />\n";

    $out .= "<div id=\"lightpop-more-options\" style=\"display:none\"><table>\n";

    // overlay
    $out .= "<tr>";
    $out .= "<td><strong>".__('Overlay', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Background color', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_overlayBgColor\" id=\"ap_overlayBgColor\" size=\"10\" value=\"".$this->options['overlayBgColor']."\" /></td>";
    $out .= "</tr>\n";

    $out .= "<tr>";
    $out .= "<td></td>";
    $out .= "<td><strong>".__('Opacity', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_overlayOpacity\" size=\"5\" value=\"".$this->options['overlayOpacity']."\" /></td>";
    $out .= "</tr>\n";

    // content border
    $out .= "<tr>";
    $out .= "<td><strong>".__('Content', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Border CSS', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_contentBorder\" size=\"75\" value=\"".$this->options['contentBorder']."\" /></td>";
    $out .= "</tr>\n";

    // Container
    $out .= "<tr>";
    $out .= "<td><strong>".__('Container', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Border size', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_containerBorderSize\" size=\"5\" value=\"".$this->options['containerBorderSize']."\" /></td>";
    $out .= "</tr>\n";

    $out .= "<tr>";
    $out .= "<td></td>";
    $out .= "<td><strong>".__('Resize speed', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_containerResizeSpeed\" size=\"5\" value=\"".$this->options['containerResizeSpeed']."\" /></td>";
    $out .= "</tr>\n";


    $out .= "<tr>";
    $out .= "<td></td>";
    $out .= "<td><strong>".__('Background color', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_contentBgColor\" size=\"10\" value=\"".$this->options['contentBgColor']."\" /></td>";
    $out .= "</tr>\n";

    // Image Max Width & Max Height
    $out .= "<tr>";
    $out .= "<td><strong>".__('Image', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Max Width', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageMaxWidth\" size=\"5\" value=\"".$this->options['imageMaxWidth']."\" /></td>";
    $out .= "</tr>\n";

    $out .= "<tr>";
    $out .= "<td></td>";
    $out .= "<td><strong>".__('Max Height', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageMaxHeight\" size=\"5\" value=\"".$this->options['imageMaxHeight']."\" /></td>";
    $out .= "</tr>\n";

    // Prev button image
    $out .= "<tr>";
    $out .= "<td><strong>".__('Prev button', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageBtnPrev\" size=\"75\" value=\"".$this->options['imageBtnPrev']."\" /></td>";
    $out .= "</tr>\n";

    // Next button image
    $out .= "<tr>";
    $out .= "<td><strong>".__('Next button', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageBtnNext\" size=\"75\" value=\"".$this->options['imageBtnNext']."\" /></td>";
    $out .= "</tr>\n";

    // Close button image
    $out .= "<tr>";
    $out .= "<td><strong>".__('Close button', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageBtnClose\" size=\"75\" value=\"".$this->options['imageBtnClose']."\" /></td>";
    $out .= "</tr>\n";

    // Loading image
    $out .= "<tr>";
    $out .= "<td><strong>".__('Loading', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageLoading\" size=\"75\" value=\"".$this->options['imageLoading']."\" /></td>";
    $out .= "</tr>\n";

    // Blank image
    $out .= "<tr>";
    $out .= "<td><strong>".__('Blank', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('Image path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_imageBlank\" size=\"75\" value=\"".$this->options['imageBlank']."\" /></td>";
    $out .= "</tr>\n";

    // Navigation text
    $out .= "<tr>";
    $out .= "<td><strong>".__('Navigation', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('text of', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_txtOf\" size=\"5\" value=\"".$this->options['txtOf']."\" /></td>";
    $out .= "</tr>\n";

    // Key navigation
    $out .= "<tr>";
    $out .= "<td><strong>".__('Key bind', $this->textdomain_name)."</strong></td>";
    $out .= "<td><strong>".__('to Prev', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_keyToPrev\" size=\"5\" value=\"".$this->options['keyToPrev']."\" /></td>";
    $out .= "</tr>\n";

    $out .= "<tr>";
    $out .= "<td></td>";
    $out .= "<td><strong>".__('to Next', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_keyToNext\" size=\"5\" value=\"".$this->options['keyToNext']."\" /></td>";
    $out .= "</tr>\n";

    $out .= "<tr>";
    $out .= "<td></td>";
    $out .= "<td><strong>".__('to Close', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_keyToClose\" size=\"5\" value=\"".$this->options['keyToClose']."\" /></td>";
    $out .= "</tr>\n";

    // flvplayer
    $out .= "<tr>";
    $out .= "<td colspan=2><strong>".__('FLV player path', $this->textdomain_name)."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"ap_flvplayer\" size=\"75\" value=\"".$this->options['flvplayer']."\" /></td>";
    $out .= "</tr>\n";

    $out .= "</table></div>\n";

    // more options
    $out .= "<input type=\"hidden\" name=\"ap_iconPath\" value=\"".$this->options['iconPath']."\" />";
    $out .= "<input type=\"hidden\" name=\"ap_txtImage\" value=\"".$this->options['txtImage']."\" />";

    // Add Update Button
    $out .= "<br clear=\"all\" />";
    $out .= "<input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("delete_options", "_wpnonce_delete_options", true, false);

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error > 0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function make_nonce_field($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }

}//class

if (!class_exists('ScriptManager')) {
  require(dirname(__FILE__).'/includes/script-manager.php');
}

$wpLightPop = new LightPopController();

add_action('admin_menu', array(&$wpLightPop,'addAdminMenu'));

add_action('wp_print_scripts', array(&$wpLightPop,'addScripts'));
add_action('wp_head',array(&$wpLightPop,'addHead'));
add_action('wp_footer',array(&$wpLightPop,'addFooter'));

unset($wpLightPop);
?>
