<?php
/*
 Plugin Name: WordPress Related Post for Japanese
 Plugin URI: http://wppluginsj.sourceforge.jp/wp-jrelated/
 Description: Yahoo! Japan が提供する「日本語形態素解析Webサービス」を使って投稿の内容を分析し関連する投稿などを表示します。
 Version: 1.00
 Author: hiromasa
 Author URI: http://another.maple4ever.net/
 */

/*  Copyright 2008 hiromasa (email : h1romas4@gmail.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpJRelated - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;

/******************************************************************************
 * WpJRelated
 *
 * @author		hiromasa
 * @version		1.00
 *
 *****************************************************************************/
class WpJRelatedController {
	
	var $plugin_name;
	var $model;
	
	/**
	 * Constructor
	 *
	 * @return WpJRelatedController
	 */
	function WpJRelatedController() {
		
		$this->plugin_name = 'WpJRelated';
		$this->model = $this->getModelObject();
		
	}
	
	/**
	 * executeSchedulePublisd
	 *
	 * @param unknown_type $postID
	 */
	function executeSchedulePublisd($postID) {
		
		wp_schedule_single_event(
			time(),
			'makeDictionary',
			array($postID, true));
		
	}

	/**
	 * executeScheduleView
	 *
	 * @param unknown_type $postID
	 */
	function executeScheduleView($content) {
		
		global $post;
		
		if(!is_single()) return $content;
		
		$postID = $post->ID;
		wp_schedule_single_event(
			time(),
			'makeDictionary',
			array($postID, false));
		
		return $content;
		
	}
	
	/**
	 * outputRelated
	 *
	 * @param unknown_type $content
	 * @return unknown
	 */
	function outputRelated($content) {
		
		global $post;
		
		if(!is_single()) return $content;
		
		$postID = $post->ID;
		if(trim($this->model->relatedHeader) != '') {
			$header = "\n" . $this->model->relatedHeader . "\n";
		}
		$related = $this->model->getRelatedPost($postID);
		if($related !== false) {
			$content .= $header;
			$content .= $related;
		}
		
		return $content;
		
	}
	
	/**
	 * outputMeta
	 *
	 * @param unknown_type $content
	 * @return unknown
	 */
	function outputMeta() {
		
		global $post;
		
		if(!is_single()) return;
		
		$postID = $post->ID;
		$output = '';
		$words = $this->outputTopWord($postID, 10);
		if(trim($words) == '') return;
		$output = '<meta name="keywords" content="' . $words . '">';
		
		echo $content;
		
	}
	
	/**
	 * makeDictionary
	 *
	 * @param unknown_type $postID
	 */
	function makeDictionary($postID, $update) {
		
		$this->model->makeDictionary($postID, $update);
		
	}
	
	/**
	 * getTopWord
	 *
	 * @param unknown_type $postID
	 * @param unknown_type $count
	 * @return unknown
	 */
	function outputTopWord($postID, $count, $delimiter = ', ') {
		
		if(!$this->isEnabled()) return;
		
		$texts = $this->model->getTopWord($postID, $count);
		$output = '';
		foreach($texts as $text) {
			$output .= $text . $delimiter;
		}
		$output = substr($output, 0, strlen($output) - strlen($delimiter));
		
		return $output;
		
	}
	
	/**
	 * isEnabled
	 *
	 * @return unknown
	 */
	function isEnabled() {
		
		if(trim($this->model->yahooId) != '') {
			return true;
		}
		return false;
		
	}
	
	/**
	 * isEnabledRelated
	 *
	 * @return unknown
	 */
	function isEnabledRelated() {
		
		return $this->model->outputRelated;
		
	}

	/**
	 * isEnabledRelated
	 *
	 * @return unknown
	 */
	function isEnabledMeta() {
		
		return $this->model->outputMeta;
		
	}
	
	/**
	 * getNotifyPublish
	 *
	 * @return unknown
	 */
	function getNotifyPublish() {
		
		return $this->model->makeNotify['publish'];
		
	}
	
	/**
	 * getNotifyPublish
	 *
	 * @return unknown
	 */
	function getNotifyView() {
		
		return $this->model->makeNotify['view'];
		
	}
	
	/**
	 * Define WordPress Admin Interface
	 *
	 */
	function addAdminMenu() {
		
		add_options_page(
			'JRelated',
			'JRelated',
			8,
			'wp-jrelated.php',
			array (&$this, 'executeAdmin')
		);
		
	}
	
	/**
	 * Execute WordPress Admin Interface
	 *
	 */
	function executeAdmin() {
		
		$requestVO = new WpJRelatedHTTPRequestVO();
		$messages = array();
		
		$action = $requestVO->getParam('action');
		if($action == 'update') {
			if($this->model->updateOption($requestVO, $messages)) {
				$this->updateWpOption($this->model);
			}
		}
		
		$view = new WpJRelatedView();
		$resultVO = & new WpJRelatedValueObject();
		$this->model->getOption($resultVO);
		$view->echoAdmin($resultVO, $messages);
		
	}
	
	/**
	 * getModelObject
	 * 
	 * @return $model
	 */
	function getModelObject() {
		
		$option = get_option($this->plugin_name);
		
		$model = null;
		//PHP 4.0 Bug?
		if(strtolower(get_class($option)) == strtolower('WpJRelated')) {
			$model = $option;
		} else {
			$model = new WpJRelated();
			$this->addWpOption($model);
		}
		
		return $model;
		
	}
	
	/**
	 * Add WordPress Option
	 *
	 * @param WpJRelated $optionValue
	 */
	function addWpOption($optionValue) {
		
		$option_description = $this->plugin_name . " Options";
		add_option($this->plugin_name, $optionValue, $option_description);
		
	}
	
	/**
	 * Update WordPress Option
	 *
	 * @param WpJRelated $optionValue
	 */
	function updateWpOption($optionValue) {
		
		$option_description = $this->plugin_name . " Options";
		update_option($this->plugin_name, $optionValue, $option_description);
		
	}
	
}

/******************************************************************************
 * WpJRelated
 *
 * @author		hiromasa
 * @version		1.00
 *
 *****************************************************************************/
class WpJRelated {
	
	var $version;
	var $staleKey;
	var $yahooId;
	var $makeNotify = array();
	var $relatedHeader;
	var $outputRelated;
	var $outputMeta;
	
	var $yahooURL = 'http://api.jlp.yahoo.co.jp/MAService/V1/parse';
	
	/**
	 * WpJRelated
	 *
	 * @return WpJRelated
	 */
	function WpJRelated() {
		
		$this->version = 'WpJRelated/1.0';
		$this->staleKey = $this->getStaleKey();
		$this->yahooId = "";
		$this->makeNotify['publish'] = true;
		$this->makeNotify['view'] = true;
		$this->relatedHeader = '<h3>このブログで関連すると思われる他の投稿</h3>';
		$this->outputRelated = true;
		$this->outputMeta = false;
		
		$this->createTable();
		
	}
	
	/**
	 * makeDictionary
	 *
	 * @param unknown_type $postID
	 * @param unknown_type $update
	 */
	function makeDictionary($postID, $update) {
		
		global $wpdb;
		global $table_prefix;
		
		//新規ならテーブルに INSERT、既存なら UPDATE
		$count = $wpdb->get_var($wpdb->prepare(
			"select count(*) from {$table_prefix}morpheme where yahooid = '%s' and ID = '%s';",
			$this->yahooId,
			$postID
			));
		//既に存在していて投稿の更新がなければ処理しない
		if($update == false && $count != 0) return; 
			
		//投稿取得
		$post = get_post($postID);
		if(empty($post)) return;
		//タイトルと投稿を合成して整形
		$content =
			html_entity_decode(
				strip_tags($post->post_title . ' ' . $post->post_content),
				ENT_QUOTES);
		//HTML実体参照削除(TODO:とりあえず)
		$content = preg_replace('/#[0-9]+;/', '', $content);
		
		//日本語形態素解析Webサービスに問い合わせ
		$responseMaXml = $this->requestYahoo($content, 'ma');
		$responseUniqXml = $this->requestYahoo($content, 'uniq');
		
		//レスポンス不正なら次回に期待してなにもしない
		$response = @simplexml_load_string($responseUniqXml);
		if($response === false) return;
		
		//辞書用情報作成
		$delimitar_text = '';
		$delimitar_text_hash = '';
		
		//名詞のみ抽出
		$words = $response->uniq_result->word_list->word;
		foreach ($words as $word) {
			if($word->pos != '名詞') continue;
			$delimitar_text .= $word->surface . ',';
			$delimitar_text_hash .= md5($word->surface) . ',';
		}
		$delimitar_text =
			substr($delimitar_text, 0, strlen($delimitar_text) - 1);
		$delimitar_text_hash =
			substr($delimitar_text_hash, 0, strlen($delimitar_text_hash) - 1);
		
		//RAWデータと辞書データをデータベースに INSERT/UPDATE
		if($count == 0) {
			$this->insertMorpheme(	
				$this->yahooId, 
				$postID,
				$responseMaXml,
				$responseUniqXml,
				$delimitar_text,
				$delimitar_text_hash);
		} else {
			$this->updateMorpheme(	
				$this->yahooId, 
				$postID,
				$responseMaXml,
				$responseUniqXml,
				$delimitar_text,
				$delimitar_text_hash);
		}
		
	}
	
	/**
	 * requestYahoo
	 *
	 * @param unknown_type $content
	 * @param unknown_type $kind
	 * @return unknown
	 */
	function requestYahoo($content, $kind) {
		
		$request = array(
			'appid' => $this->yahooId,
			'sentence' => $content,
			'results' => $kind);
		$request = http_build_query($request, "", "&");
		$header = array(
			'Content-Type: application/x-www-form-urlencoded',
			'Content-Length: ' . strlen($request)
		);
		$context = array(
			'http' => array(
				'method' => 'POST',
				'header' => implode("\r\n", $header),
				'content' => $request
			)
		);
		$context = stream_context_create($context);
		$response = @file_get_contents($this->yahooURL, false, $context);
		if($response === false) return false;
		
		return $response;
		
	}

	/**
	 * getRelatedPost
	 *
	 * @param unknown_type $postID
	 * @return unknown
	 */
	function getRelatedPost($postID) {
		
		global $wpdb;
		global $table_prefix;
		
		//投稿の形態素分析結果から頻出単語上位10個のハッシュを取得する。
		$morpheme = $wpdb->get_row($wpdb->prepare(
			"select uniq_delimitar_hash from {$table_prefix}morpheme where yahooid = '%s' and ID = '%s' LIMIT 0, 1;"
			,$this->yahooId
			,$postID
			));
		$hashes = split(',', $morpheme->uniq_delimitar_hash, 11);
		//まだ辞書がなかったらなにもしない
		if($hashes === false) return false;
		//上位10以外は捨てる
		if(count($hashes) >= 11) array_pop($hashes);
		$morpheme = '';
		
		//がんばってSQLつくる
		$sql_select = '';
		$sql_where = '';
		foreach($hashes as $hash) {
			$sql_select .= $wpdb->prepare(
				"IF(INSTR(uniq_delimitar_hash, '%s') <> 0,INSTR(uniq_delimitar_hash, '%s'), 10000) +"
				,$hash
				,$hash
			);
			$sql_where .= $wpdb->prepare(
				"uniq_delimitar_hash LIKE '%s' or "
				,'%' . $hash . '%'
			);
		}
		$sql_select = substr($sql_select , 0, strlen($sql_select) - 1) . "\n";
		$sql_where = substr($sql_where , 0, strlen($sql_where) - 3) . "\n";
		$query = 
			"SELECT" .
			"    ID" .
			"    ,$sql_select as rank" .
			"  FROM" .
			"    {$table_prefix}morpheme" .
			"  WHERE" .
			"    ($sql_where) " .
			"    AND ID <> $postID" .
			"  ORDER BY" .
			"  	rank" .
			'  LIMIT 0, 5';
		
		//クエリーなげるて関連投稿リンクの文字列作成(TODO:ちょっと遅いかも)
		$content = '<li id="wpjrelated">' . "\n";
		$entries = $wpdb->get_results($query);
		if(count($entries) == 0) return false;
		foreach($entries as $entry) {
			$post = get_post($entry->ID);
			$link = get_permalink($post);
			$content .= "<ol><a href=\"{$link}\">{$post->post_title}</a></ol>\n";
		}
		$content .= '</li>' . "\n";
		
		return $content;
		
	}
	
	/**
	 * getTopWord
	 *
	 * @param unknown_type $postID
	 * @param unknown_type $count
	 * @return unknown
	 */
	function getTopWord($postID, $count) {
		
		global $wpdb;
		global $table_prefix;
		
		//投稿の形態素分析結果から頻出単語上位10個のテキストを取得する。
		$morpheme = $wpdb->get_row($wpdb->prepare(
			"select uniq_delimitar_text from {$table_prefix}morpheme where yahooid = '%s' and ID = '%s' LIMIT 0, 1;"
			,$this->yahooId
			,$postID
			));
		$texts = split(',', $morpheme->uniq_delimitar_text, $count + 1);
		//まだ辞書がなかったらなにもしない
		if($texts === false) return;
		//上位10以外は捨てる
		if(count($texts) >= $count + 1) array_pop($texts);
		
		return $texts;
		
	}
	
	/**
	 * insertMorpheme
	 *
	 * @param unknown_type $yahooId
	 * @param unknown_type $postID
	 * @param unknown_type $responseMaXml
	 * @param unknown_type $responseUniqXml
	 * @param unknown_type $delimitar_text
	 * @param unknown_type $delimitar_text_hash
	 * @return unknown
	 */
	function insertMorpheme(	
		$yahooId, 
		$postID,
		$responseMaXml,
		$responseUniqXml,
		$delimitar_text,
		$delimitar_text_hash) {
		
		global $wpdb;
		global $table_prefix;
		
		$wpdb->query($wpdb->prepare(
			"INSERT" .
			 " INTO" .
			 "   {$table_prefix}morpheme(" .
			 "     yahooid" .
			 "     ,ID" .
			 "     ,xml_ma" .
			 "     ,xml_uniq" .
			 "     ,uniq_delimitar_text" .
			 "     ,uniq_delimitar_hash" .
			 "     ,update_time" .
			 "     ,make_time" .
			 "   )" .
			 " VALUES" .
			 "   (" .
			 "     '%s'" .
			 "     ,'%s'" .
			 "     ,'%s'" .
			 "     ,'%s'" .
			 "     ,'%s'" .
			 "     ,'%s'" .
			 "     ,NOW()" .
			 "     ,NOW()" .
			 "   )",
			$yahooId, 
			$postID,
			$responseMaXml,
			$responseUniqXml,
			$delimitar_text,
			$delimitar_text_hash));
		
		return true;
		
	}
	
	/**
	 * updateMorpheme
	 *
	 * @param unknown_type $yahooId
	 * @param unknown_type $postID
	 * @param unknown_type $responseMaXml
	 * @param unknown_type $responseUniqXml
	 * @param unknown_type $delimitar_text
	 * @param unknown_type $delimitar_text_hash
	 * @return unknown
	 */
	function updateMorpheme(	
		$yahooId, 
		$postID,
		$responseMaXml,
		$responseUniqXml,
		$delimitar_text,
		$delimitar_text_hash) {
		
		global $wpdb;
		global $table_prefix;
		
		$wpdb->query($wpdb->prepare(
			"UPDATE". 
			 "    {$table_prefix}morpheme". 
			 "  SET". 
			 "    xml_ma = '%s'". 
			 "    ,xml_uniq = '%s'". 
			 "    ,uniq_delimitar_text = '%s'". 
			 "    ,uniq_delimitar_hash = '%s'". 
			 "    ,update_time = NOW()". 
			 "  WHERE". 
			 "    yahooid = '%s'". 
			 "    AND ID = '%s'"
			,$responseMaXml
			,$responseUniqXml
			,$delimitar_text
			,$delimitar_text_hash
			,$yahooId
			,$postID));
		
		return true;
		
	}
	
	/**
	 * createTable
	 *
	 * @return unknown
	 */
	function createTable() {
		
		global $wpdb;
		global $table_prefix;
		
		$wpdb->query(
			"DROP TABLE {$table_prefix}morpheme;");
		$wpdb->query(
			"CREATE TABLE {$table_prefix}morpheme(" .
			"  yahooid VARCHAR(255) NOT NULL," .
			"  ID BIGINT(20) NOT NULL," .
			"  xml_ma text," .
			"  xml_uniq text," .
			"  uniq_delimitar_text text," .
			"  uniq_delimitar_hash text," .
			"  update_time DATETIME  NOT NULL default '0000-00-00 00:00:00'," .
			"  make_time DATETIME  NOT NULL default '0000-00-00 00:00:00'" .
			") ENGINE=MyISAM DEFAULT CHARSET=utf8;");
		$wpdb->query(
			"alter table {$table_prefix}morpheme add primary key (" .
			"    yahooid," .
			"    ID" .
			");");
		
		return true;
		
	}
	
	/**
	 * getOption
	 *
	 * @param unknown_type $resultVO
	 */
	function getOption(&$resultVO) {
		
		$resultVO->setParam('yahooid', $this->yahooId);
		$resultVO->setParam('publish', $this->makeNotify['publish']);
		$resultVO->setParam('view', $this->makeNotify['view']);
		$resultVO->setParam('relatedheader', $this->relatedHeader);
		$resultVO->setParam('outputrelated', $this->outputRelated);
		$resultVO->setParam('outputmeta', $this->outputMeta);
		$resultVO->setParam('staleKey', $this->staleKey);
		
	}
	
	/**
	 * updateOption
	 *
	 * @param unknown_type $request
	 * @param unknown_type $messages
	 * @return unknown
	 */
	function updateOption(&$requestVO, &$messages) {
		
		if($this->staleKey != $requestVO->getParam('stalekey')) {
			array_push(
				$messages,
				"データが他で更新されている可能性があるため、変更を破棄し更新を中止しました。");
			return false;
		}
		
		$this->yahooId =
			stripslashes($requestVO->getParam('yahooid'));
		$this->makeNotify['publish'] =
			$requestVO->getParam('publish') != '' ? true : false;
		$this->makeNotify['view'] = 
			 $requestVO->getParam('view') != '' ? true : false;
		$this->relatedHeader =
			stripslashes($requestVO->getParam('relatedheader'));
		$this->outputRelated = 
			 $requestVO->getParam('outputrelated') != '' ? true : false;
		$this->outputMeta = 
			 $requestVO->getParam('outputmeta') != '' ? true : false;
		
		$this->staleKey = $this->getStaleKey();
		
		return true;
		
	}
	
	/**
	 * getStaleKey
	 *
	 * @return unknown
	 */
	function getStaleKey() {
		
		return md5(time() . SECURE_AUTH_KEY);
		
	}
	
}

/******************************************************************************
 * WpJRelatedView
 *
 * @author		hiromasa
 * @version		1.00
 *
 *****************************************************************************/
class WpJRelatedView {
	
	var $result;
	
	/**
	 * echoAdmin
	 *
	 * @param unknown_type $result
	 * @param unknown_type $messages
	 */
	function echoAdmin(&$result = null, &$messages = array()) {
		
		$this->result = $result;
		
		$yahooId = $this->outputValue($this->result->getParam('yahooid'), false);
		$makeNotify['publish'] =
			$this->outputValue($this->result->getParam('publish') == true ? 'checked' : '', false);
		$makeNotify['view'] = 
			$this->outputValue($this->result->getParam('view') == true ? 'checked' : '', false);
		$outputMeta = 
			$this->outputValue($this->result->getParam('outputmeta') == true ? 'checked' : '', false);
		$outputRelated = 
			$this->outputValue($this->result->getParam('outputrelated') == true ? 'checked' : '', false);
		$relatedHeader = $this->outputValue($this->result->getParam('relatedheader'), false);
		
		$this->echoMessage($messages);
		$this->echoAdminHeader();
		
		echo '<table class="form-table">' . "\n";
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row"><label for="yahooid">Yahoo! JAPAN Webサービス アプリケーションID</label></th>' . "\n";
		echo '<td>';
		echo "<input name=\"yahooid\" type=\"text\" id=\"yahooid\" value=\"{$yahooId}\" size=\"40\" />";
		echo " (必須)" . "\n";
		echo '</td>' . "\n";
		echo '</tr>' . "\n";
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row"><label for="makeindex">インデックス作成契機</label></th>' . "\n";
		echo '<td>' . "\n";
		echo '<label for="publish">';
		echo '<input name="publish" type="checkbox" id="publish" style="vertical-align: text-bottom;"';
		echo " {$makeNotify['publish']} />";
		echo ' 投稿時</label><br />' . "\n";
		echo '<label for="view">';
		echo '<input name="view" type="checkbox" id="view" style="vertical-align: text-bottom;"';
		echo " {$makeNotify['view']} />";
		echo ' 閲覧時(投稿を閲覧した時にその投稿のインデックスがなければ作成します)</label><br />' . "\n";
		echo '</td>' . "\n";
		echo '</tr>' . "\n";
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row"><label for="relatedheader">関連出力</label></th>' . "\n";
		echo '<td>';
		echo '<input name="outputrelated" type="checkbox" id="outputrelated" style="vertical-align: text-bottom;"';
		echo " {$outputRelated} /> シングルページ表示時に投稿の最後に関連投稿のリンクを付与する。<br />";
		echo "出力時に付与するヘッダー" . "\n";
		echo "<input name=\"relatedheader\" type=\"text\" id=\"relatedheader\" value=\"{$relatedHeader}\" size=\"40\" />";
		echo '</td>' . "\n";
		echo '</tr>' . "\n";
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row"><label for="outputMeta"><del>メタタグ出力</del>（未実装）</label></th>' . "\n";
		echo '<td>';
		echo '<input name="outputmeta" type="checkbox" id="outputmeta" style="vertical-align: text-bottom;"';
		echo " {$outputMeta} /> " . ' &lt;meta name="keywords" content="[キーワード]" / &gt; をヘッダに出力する。';
		echo '</td>' . "\n";
		echo '</tr>' . "\n";
		echo '</table>' . "\n";
		echo '<p class="submit">' . "\n";
		echo '<input type="submit" name="Submit" value="Save Changes" />' . "\n";
		echo '</p>' . "\n";
		
		$this->echoAdminFooter();
		
	}
	
	/**
	 * echoMessage
	 *
	 * @param unknown_type $messages
	 */
	function echoMessage($messages) {
		
		if(count($messages) == 0) return;
		
		$information = '';
		foreach($messages as $message) {
			$information .= '<p><strong>'
				. $this->outputValue($message, false)
				. '</strong></p>' . "\n";
		}
		
		echo '<div id="message" class="updated fade">' . "\n";
		echo $this->outputValue($information, false, false);
		echo '</div>' . "\n";
		
	}
	
	/**
	 * echoAdminHeader
	 *
	 */
	function echoAdminHeader() {
		
		echo '<div class="wrap">' . "\n";;
		echo '<h2>JRelated</h2>' . "\n";
		echo '<form method="post">' . "\n";
		
	}
	
	/**
	 * echoAdminFooter
	 *
	 */
	function echoAdminFooter() {
		
		$stakeKey =
			$this->outputValue($this->result->getParam('staleKey'), false);
		
		echo "<input type=\"hidden\" name=\"stalekey\" value=\"$stakeKey\" />" . "\n";
		echo '<input type="hidden" name="action" id="action" value="update" />' . "\n";
		echo '</form>';
		echo '</div><!-- wrap -->';
		
	}
	
	/**
	 * outputValue
	 *
	 * @param unknown_type $value
	 * @param unknown_type $echo
	 * @param unknown_type $escape
	 * @return unknown
	 */
	function outputValue($value, $echo = true, $escape = true) {
		
		$result = stripslashes($value);
		if($escape) {
			$result = attribute_escape($value);
		}
		if($echo) {
			echo $result;
		}
		return $result;
		
	}
	
}

/******************************************************************************
 * ValueObject Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpJRelatedValueObject {
	
	var $paramsMap = Array ();
	
	/**
	 * setParam
	 *
	 * @param unknown_type $name
	 * @param unknown_type $value
	 */
	function setParam($name, $value) {
		
		$this->paramsMap[$name] = $value;
		
	}
	
	/**
	 * getParam
	 *
	 * @param unknown_type $name
	 * @return unknown
	 */
	function getParam($name) {
		
		return $this->paramsMap[$name];
		
	}
	
}

/******************************************************************************
 * HTTPRequestVO Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpJRelatedHTTPRequestVO extends WpJRelatedValueObject {
	
	/**
	 * Constructor
	 *
	 * @return WpJRelatedHTTPRequestVO
	 */
	function WpJRelatedHTTPRequestVO() {
		
		if(is_array($_REQUEST)) {
			foreach ($_REQUEST as $name => $value) {
				$this->setParam($name, $value);
			}
		}
		
	}
	
}

/******************************************************************************
 * WpJRelated - WordPress Interface Define
 *****************************************************************************/

$wpjr = new WpJRelatedController();

if(is_admin()) {
	add_action('admin_menu', array (&$wpjr, 'addAdminMenu'));
}

if(!$wpjr->isEnabled()) return;

add_action('makeDictionary', array (&$wpjr, 'makeDictionary'), 10, 2);

if($wpjr->getNotifyPublish()) {
	add_action('publish_post', array (&$wpjr, 'executeSchedulePublisd'));
	add_action('edit_post', array (&$wpjr, 'executeSchedulePublisd'));
}
if($wpjr->getNotifyView()) {
	add_filter('the_content', array (&$wpjr, 'executeScheduleView'));
}
if($wpjr->isEnabledRelated()) {
	add_filter('the_content', array (&$wpjr, 'outputRelated'));
}
//if($wpjr->isEnabledMeta()) {
//	add_action('wp_head', array (&$wpjr, 'outputMeta'));
//}
?>
