<?php
/*
Plugin Name: WP-AutoPager
Version: 0.5.0
Plugin URI: http://wppluginsj.sourceforge.jp/wp-autopager/
Description: Add autoloading for next page to Wordpress. DblClick to enable/disable it.
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

Based:
 This script based on
 GoogleAutoPager(http://la.ma.la/blog/diary_200506231749.htm)
 thanks to ma.la.


*/

class AutoPagerController {
  var $plugin_name   = 'wp-autopager';

  var $autopager_js  = 'js/wp-autopager-0.5.0.js';
  var $autopager_ver = '0.5.0';

  var $jquery_js    = 'js/jquery-1.2.6.min.js';
  var $jquery_ver   = '1.2.6';

  var $plugin_dir, $plugin_file, $plugin_url;
  var $textdomain_name;

  var $options, $option_name;
  var $admin_option, $admin_action;
  var $note, $error;

  var $wpLightpop_enable = false;

  /*
  * Constructor
  */
  function AutoPagerController() {
    $this->setPluginDir();
    $this->loadTextdomain();

    $this->note = '';
    $this->error = 0;

    $this->option_name  = $this->plugin_name." Options";
    $this->options      = get_option($this->option_name);
    $this->initOptions();

    $this->admin_option = basename(__FILE__);
    $this->admin_action = trailingslashit(get_bloginfo('wpurl'))."wp-admin/admin.php?page=".$this->admin_option;

    // wp-lightpop active?
    foreach (get_option("active_plugins") as $val) {
      if (preg_match('/wp\-lightpop\.php/i', $val)) {$this->wpLightpop_enable = true; break;}
    }
  }

  function setPluginDir() {
    $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
    $filename = explode("/", __FILE__);
    if(count($filename) <= 1) $filename = explode("\\", __FILE__);
    $this->plugin_dir  = $filename[count($filename) - 2];
    $this->plugin_file = $filename[count($filename) - 1];
    $this->plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$this->plugin_dir);
    unset($filename);
  }

  function loadTextdomain( $sub_dir = '/language' ) {
    global $wp_version;
    $this->textdomain_name = $this->plugin_dir;
    $textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir).$sub_dir);
    if (version_compare($wp_version, "2.6", ">=") && defined('WP_PLUGIN_DIR')) {
      load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
    } else {
      $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
      load_plugin_textdomain($this->textdomain_name, $plugins_dir.$textdomain_dir);
    }
  }

  /*
  * Init Options
  */
  function initOptions() {
    if (!is_array($this->options)) $this->options = array();

    if (!isset($this->options['content_id']))       $this->options['content_id'] = "content";
    if (!isset($this->options['post_class']))       $this->options['post_class'] = "post";
    if (!isset($this->options['navigation_class'])) $this->options['navigation_class'] = "navigation";
    if (!isset($this->options['remain']))           $this->options['remain'] = 500;
    if (!isset($this->options['default_enable']))   $this->options['default_enable'] = 1;
  }

  /*
  * Update Options
  */
  function update_options() {
    update_option($this->option_name, $this->options);
  }

  /*
  * Delete Options
  */
  function deleteOptions() {
    delete_option($this->option_name);
    $this->options = array();
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  /*
  * add action (wp_print_scripts)
  */
  function addScripts() {
   if (is_admin() || is_404() || is_single() || is_page() ) {return false;}
   global $script_manager;
   if (isset($script_manager)) $script_manager->register_script('jquery', $this->plugin_url.$this->jquery_js, false, $this->jquery_ver);
   wp_enqueue_script('wp-autopager', $this->plugin_url.$this->autopager_js, array('jquery'), $this->autopager_ver);
  }

  function isLoadScripts() {
    return (!is_404() && !is_single() && !is_page());
  }

  /*
  * add action (wp_head)
  */
  function addWpHead() {
    if ($this->isLoadScripts() && !have_posts()){
      header("HTTP/1.1 404 Not Found");
    }
  }

  /*
  * add action (wp_footer)
  */
  function addWpFooter() {
    if ($this->isLoadScripts() && have_posts()){
      global $request, $posts_per_page, $wpdb, $paged, $script_manager;

      // get Max Page
      $numposts = 0;
      if(strpos(get_query_var('tag'), " ")) {
        preg_match('#^(.*)\sLIMIT#siU', $request, $matches);
        $fromwhere = $matches[1];
        $results = $wpdb->get_results($fromwhere);
        $numposts = count($results);
      } else {
        preg_match('#FROM\s*+(.+?)\s+(GROUP BY|ORDER BY)#si', $request, $matches);
        $fromwhere = $matches[1];
        $numposts = $wpdb->get_var("SELECT COUNT(DISTINCT ID) FROM $fromwhere");
      }
      $max_page = ceil($numposts/$posts_per_page);

      // get Next Page No.
      if(empty($paged)) {$paged = 1;}
      $next_page = $paged + 1;

      // get Query String
      $query = get_pagenum_link($next_page);
      if (strstr($query,"?") != false) {
        if (preg_match("/^(.*\/)page\/(\d+)\/(.*)$/i", $query, $matches)) {
          $query = $matches[1].$matches[3]."&paged=";
          $next_page = $matches[2];
        } elseif (preg_match("/(.*paged=)(\d+)/i", $query, $matches)) {
          $query = $matches[1];
          $next_page = $matches[2];
        }
      } elseif (preg_match("/(.+page\/)(\d+)/i", $query, $matches)) {
          $query = $matches[1];
          $next_page = $matches[2];
      } else {
        if (preg_match("/(.+paged=)(\d+)/i", $query, $matches)) {
          $query = $matches[1];
          $next_page = $matches[2];
        } else {
          if (strstr($query,"?")) {
            $query = $query."&paged=";
          }
        }
      }
      $query = str_replace('http://'.$_SERVER['SERVER_NAME'].'/', '/', $query);

      // lightpop callback
      $callback  = "function(){";
      if ($this->wpLightpop_enable) {
        $lightpop_options = get_option("wp-lightpop Options");
        if (isset($lightpop_options)) {
          $elements = preg_split('/[\n\r]/', apply_filters('css_elements/wp-lightpop.php', $lightpop_options['targetCSS']));

          if (trim($lightpop_options['postClass']) != '') {
            $callback .= "jQuery('.".trim($lightpop_options['postClass'])."').each(function(){";
            foreach($elements as $value) {
              if (trim($value) != '') {
                $callback .= "jQuery('".trim($value)."', jQuery(this)).lightpop(ligtpop_options);";
              }
            }
            $callback .= "});";
          } else {
            foreach($elements as $value) {
              if (trim($value) != '') {
                $callback .= "jQuery('".trim($value)."').lightpop(ligtpop_options);";
              }
            }
          }

          unset($elements);
        }
      }
      $callback .= "}";

      // settings
      $settings  = "{";
      $settings .= "enable:".($this->options['default_enable']==1?'true':'false');
      $settings .= ",remain:".(int) $this->options['remain'];
      $settings .= ",contentId:'{$this->options['content_id']}'";
      $settings .= ",postClass:'{$this->options['post_class']}'";
      $settings .= ",naviClass:'{$this->options['navigation_class']}'";
      $settings .= ",loadingSrc:'{$this->plugin_url}images/ajax-loader.gif'";
      $settings .= ",loadingTxt:'".__('Now Loading...', $this->textdomain_name)."'";
      if ($callback != '') {$settings .= ",callback:".$callback;}
      $settings .= "}";

      // echo javascript
      $start_autopager = "autopager('%s', %d, %d, %s);";
      $out = "jQuery(function(){".sprintf($start_autopager, $query, $next_page, $max_page, $settings)."});\n";

      if (isset($script_manager)) {
        add_filter('footer_script/ScriptManager', create_function('$js', 'return $js . "'.addcslashes($out,'"').'";'));
      } else {
        echo "<script type=\"text/javascript\">/*<![CDATA[ */\n";
        echo $out;
        echo "/* ]]>*/</script>\n";
      }
    }
  }

  /*
  * add action (admin_menu)
  */
  function addAdminMenu() {
    add_options_page(__('AutoPager', $this->textdomain_name)
                    ,__('AutoPager', $this->textdomain_name)
                    ,9
                    ,$this->admin_option
                    ,array($this,'optionPage')
                    );
  }

  function optionPage() {
    global $wp_version;

    // check referer (Wordpress 2.5+)
    $check_referer = version_compare($wp_version, "2.5", ">=");

    // options update
    if(isset($_POST['ap_options_update'])) {
      // check referer
      if ($check_referer) check_admin_referer("update_options", "_wpnonce_update_options");

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['content_id']       = $_POST['ap_content_id'];
      $this->options['post_class']       = $_POST['ap_post_class'];
      $this->options['navigation_class'] = $_POST['ap_navigation_class'];
      $this->options['remain']           = $_POST['ap_remain'];
      $this->options['default_enable']   = $_POST['ap_default_enable'] == 1;
      $_POST = '';

      // Done!
      $this->update_options();
      $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);

    } elseif(isset($_POST['ap_options_uninstall'])) {
      // check referer
      if ($check_referer) check_admin_referer("delete_options", "_wpnonce_delete_options");

      // uninstall
      $this->deleteOptions();
      $this->note .= __('<strong>Done!</strong>', $this->textdomain_name);
      $this->error++;
      $this->initOptions();
   }

    // Add Options
    $out .= '<div class="wrap">'."\n";
    $out .= '<h2>'.__('WP-AutoPager Options', $this->textdomain_name).'</h2><br />'."\n";
    $out .= '<form method="post" id="update_options" action="'.$this->admin_action.'">'."\n";
    if ($check_referer) $out .= $this->make_nonce_field("update_options", "_wpnonce_update_options", true, false);

    $out .= '<table>'."\n";

    // Content ID
    $out .= '<tr><td><strong>'.__('Content ID', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_content_id" value="'.$this->options['content_id'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    // Posts Class
    $out .= '<tr><td><strong>'.__('Posts Class', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_post_class" value="'.$this->options['post_class'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    // Navigation Class
    $out .= '<tr><td><strong>'.__('Navigation Class', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_navigation_class" value="'.$this->options['navigation_class'].'"/></td>';
    $out .= '<td></td></tr>'."\n";

    // Remain
    $out .= '<tr><td><strong>'.__('Remain', $this->textdomain_name).'</strong></td>';
    $out .= '<td><input type="text" name="ap_remain" value="'.$this->options['remain'].'" /></td>';
    $out .= '<td>'.__('Position in which lookahead is begun(relative value px from the bottom of a browser)', $this->textdomain_name).'</td></tr>'."\n";

    // Default Enable / Desable
    $out .= '<tr><td><strong>'.__('Default Enable', $this->textdomain_name).'</strong></td>';
    $out .= '<td><select name="ap_default_enable">';
    $out .= '<option value="0"'.($this->options['default_enable']==0?' selected="selected"':'').'>'.__('disable', $this->textdomain_name).'</option>';
    $out .= '<option value="1"'.($this->options['default_enable']==1?' selected="selected"':'').'>'.__('enable', $this->textdomain_name).'</option>';
    $out .= '</select></td>';
    $out .= '<td>'.__('Whether operation is enabled when the page is displayed is set.', $this->textdomain_name).'</td></tr>'."\n";

    $out .= '</table>'."\n";

    // Add Update Button
    $out .= '<input type="submit" name="ap_options_update" value="'.__('Update Options', $this->textdomain_name).' &raquo;" class="button" />';
    $out .= '</form></div>'."\n";

    // Add Usage
    $out .= '<div class="wrap" style="margin-top:3em;">'."\n";
    $out .= '<h2>'.__('Usage', $this->textdomain_name).'</h2><br />'."\n";
    $out .= '<p>'.__('If it is a default template base, it operates yet in there is no template correction.', $this->textdomain_name).'<br />'."\n";
    $out .= __('If the structure of HTML is as follows, it is OK.', $this->textdomain_name).'</p>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7ED;width:auto;_width:95%;margin:0.25em;padding:0.25em;">'."\n";
    $out .= '&lt;html&gt;<br />'."\n";
    $out .= '&lt;head&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<p>&lt;/head&gt;<br />'."\n";
    $out .= '&lt;body&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7DD;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>id=&#8221;content&#8221;</strong></em>&gt;</p>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";

    $out .= '<div style="border:1px solid gray;background-color:#F9F7AA;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;post&#8221;</strong></em> id=&#8221;post-???&#8221;&gt;&#8230;'.__('Content of post', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<div style="border:1px solid gray;background-color:#F9F7BB;width:auto;_width:95%;margin:0.25em;padding:0.25em;">&lt;div <em><strong>class=&#8221;navigation&#8221;</strong></em>&gt;&#8230;'.__('Page navigation', $this->textdomain_name).'&#8230;&lt;/div&gt;</div>'."\n";

    $out .= '<p>&lt;/div&gt;</div>'."\n";
    $out .= '<div style="padding-left:3em;">：</div>'."\n";
    $out .= '<p>&lt;/body&gt;<br />'."\n";
    $out .= '&lt;/html&gt;'."\n";
    $out .= '</div>'."\n";

    $out .= '</div>'."\n";

    // Add Options
    $out .= "<div class=\"wrap\" style=\"margin-top:3em;\">\n";
    $out .= "<h2>".__('Uninstall', $this->textdomain_name)."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
    if ($check_referer) $out .= $this->make_nonce_field("delete_options", "_wpnonce_delete_options", true, false);

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_uninstall\" value=\"".__('Delete Options', $this->textdomain_name)." &raquo;\" class=\"button\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

  function make_nonce_field($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
    if ( !function_exists('wp_nonce_field') ) {
      return;
    } else {
      return wp_nonce_field($action, $name, $referer, $echo);
    }
  }

}//class

if (!class_exists('ScriptManager')) {
  require(dirname(__FILE__).'/includes/script-manager.php');
}

$wpAutoPager = new AutoPagerController();

add_action('admin_menu', array(&$wpAutoPager,'addAdminMenu'));

add_action('wp_print_scripts', array(&$wpAutoPager,'addScripts'));
add_action('wp_head',array(&$wpAutoPager,'addWpHead'));
add_action('wp_footer',array(&$wpAutoPager,'addWpFooter'));

unset($wpAutoPager);
?>
