<?php
/*
Plugin Name: Google Maps Anywhere
Version: 0.2.2
Plugin URI: http://wppluginsj.sourceforge.jp/googlemaps-anywhere/
Description: Add Google Maps to your posts and pages.(Only for WordPress 2.5+)
Author: wokamoto
Author URI: http://dogmap.jp/

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html
*/

//define('GOOGLEMAPS_API_KEY', 'XXXXX');

define('GOOGLEMAPS_SHORTCODE',      'googlemap');
define('GOOGLEMAPS_ELEMENT',        'div.googlemap');

// User Level Permission -- Subscriber = 0,Contributor = 1,Author = 2,Editor= 7,Administrator = 9
define('GOOGLEMAPS_OPTION_ACCESS_LEVEL', 9);

define('GOOGLEMAPS_DEFAULT_LAT',     35.5000);
define('GOOGLEMAPS_DEFAULT_LNG',    139.0000);
define('GOOGLEMAPS_DEFAULT_WIDTH',  '300px');
define('GOOGLEMAPS_DEFAULT_HEIGHT', '150px');
define('GOOGLEMAPS_DEFAULT_ZOOM',   14);
define('GOOGLEMAPS_DEFAULT_TYPE',   'G_NORMAL_MAP');

define('GOOGLEMAPS_MOBILE_WIDTH',   128);
define('GOOGLEMAPS_MOBILE_HEIGHT',   80);

define('GEO_META_FIELD_NAME',       'Lat_Long');

class GoogleMapsAnywhereController {
 var $plugin_js  = 'js/googlemaps-anywhere-0.2.0.min.js';
 var $plugin_ver = '0.2.2';

 var $jquery_js  = 'js/jquery-1.2.6.min.js';
 var $jquery_ver = '1.2.6';

 var $api_key = false;
 var $added_footer = false;
 var $nonce = -1;

 var $plugin_dir, $plugin_file, $plugin_url;
 var $textdomain_name;

 function GoogleMapsAnywhereController() {
  global $wp_version;

  // Wordpress 2.5+
  if (version_compare($wp_version, "2.5", ">=")) {
   $this->setPluginDir();
   $this->loadTextdomain();

   // get Google Maps API Key
   $this->api_key = get_option('googlemaps_api_key');
   if (!$this->api_key) $this->api_key = get_option('yf_google_api_key');
   if (!$this->api_key) $this->api_key = (defined('GOOGLEMAPS_API_KEY') ? GOOGLEMAPS_API_KEY : false);

   // script loader
   add_action('wp_print_scripts', array($this,'addScripts'));
   add_filter('script_loader_src', array($this,'scriptSrcCleanup'));

   // set style sheet & JavaScript
   add_action('wp_head', array($this, 'addHead'));
   //add_action('wp_footer', array($this, 'addFooter'));

   // shortcode API
   if (function_exists('add_shortcode')) add_shortcode(GOOGLEMAPS_SHORTCODE, array($this, 'shortcodeHandler'));

   // set JavaScript (admin head)
   add_action('admin_head', array($this, 'addAdminHead'));

   // media button support
   add_action('media_buttons', array($this, 'addMediaButton'), 20);

   add_action('media_upload_googlemaps', 'media_upload_googlemaps');
   if ($this->api_key != false) add_action('admin_head_media_upload_googlemaps_form', array($this, 'addMediaHead'));
   add_action('media_upload_googlemaps_option', 'media_upload_googlemaps_option');

   if (version_compare($wp_version, "2.6", "<")) {
    add_action('admin_head_media_upload_googlemaps_form', 'media_admin_css');
    add_action('admin_head_media_upload_googlemaps_option_form', 'media_admin_css');
   }

   // for Ktai style
   add_filter('image_to_link/ktai_style.php', array($this, 'ks_keep_gmap_image'), 10, 3);
  }
 }

 function setPluginDir() {
  $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
  $filename = explode("/", __FILE__);
  if(count($filename) <= 1) $filename = explode("\\", __FILE__);
  $this->plugin_dir  = $filename[count($filename) - 2];
  $this->plugin_file = $filename[count($filename) - 1];
  $this->plugin_url  = trailingslashit(trailingslashit(defined('WP_PLUGIN_URL') ? WP_PLUGIN_URL : trailingslashit(get_bloginfo('wpurl')).$plugins_dir).$this->plugin_dir);
  unset($filename);
 }

 function loadTextdomain( $sub_dir = '/language' ) {
  global $wp_version;
  $this->textdomain_name = $this->plugin_dir;
  $textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir).$sub_dir);
  if (version_compare($wp_version, "2.6", ">=") && defined('WP_PLUGIN_DIR')) {
   load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
  } else {
   $plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
   load_plugin_textdomain($this->textdomain_name, $plugins_dir.$textdomain_dir);
  }
 }

 /*
 * Script loader
 */
 function addScripts() {
  if (!is_admin()) {
   if ( !((function_exists('is_ktai') && is_ktai()) || (function_exists('is_mobile') && is_mobile())) ) {
    global $script_manager;
    // regist jQuery
    if (isset($script_manager)) $script_manager->register_script('jquery', $this->plugin_url.$this->jquery_js, false, $this->jquery_ver);
    wp_enqueue_script('jquery');
    wp_enqueue_script('google.loader', 'http://www.google.com/jsapi?key='.$this->api_key);
   }
  }
 }

 function scriptSrcCleanup($src) {
  return (strstr($src, "http://www.google.com/jsapi") != false ? preg_replace("/(\?|\&|\&(amp|#038);)ver=.*$/i", "", $src) : $src);
 }

 /*
 * style sheet & JavaScript
 */
 function addHead() {
  global $script_manager;
  if (!is_admin()) {
   $css_out  = "<style type=\"text/css\" media=\"screen,tv,print,handheld\"> /*<![CDATA[ */\n";
   $css_out .= GOOGLEMAPS_ELEMENT."{width:".GOOGLEMAPS_DEFAULT_WIDTH.";height:".GOOGLEMAPS_DEFAULT_HEIGHT.";clear:both;margin:1em auto;border:1px solid #999;line-height:1.25em;text-align:center;overflow:hidden;}\n";
   $css_out .= GOOGLEMAPS_ELEMENT." img {margin:0;padding:0;border:0 none;}\n";
   $css_out .= GOOGLEMAPS_ELEMENT." .infowindow {text-align:left;font-size:0.88em;}\n";
   $css_out .= GOOGLEMAPS_ELEMENT." p {margin:0;text-indent:0;text-align:left;font-size:0.75em;}\n";
   $css_out .= "/* ]]>*/ </style>\n";
   echo $css_out;

   $js_out  = "var googlemapsAnywhereL10n = {";
   $js_out .= " language:\"".(defined('WPLANG') ? WPLANG : 'en')."\"";
   $js_out .= ",markerTitle:\"".__('Move to the Google Maps.', $this->textdomain_name)."\"";
   $js_out .= ",cssPath:\"".GOOGLEMAPS_ELEMENT."\"";
   $js_out .= "};\n";
   if (isset($script_manager)) {
    add_filter('head_script/ScriptManager', create_function('$js', 'return $js . "'.addcslashes($js_out,'"').'";'));
   } else {
    echo "<script type=\"text/javascript\">/*<![CDATA[ */\n";
    echo $js_out;
    echo "/* ]]>*/</script>\n";
   }
  }
 }

 function addFooter() {
  if (!is_admin() && !$this->added_footer) {
   if ( !((function_exists('is_ktai') && is_ktai()) || (function_exists('is_mobile') && is_mobile())) ) {
    $out .= "<script type=\"text/javascript\" src=\"{$this->plugin_url}{$this->plugin_js}\"></script>\n";
    echo $out;
    $this->added_footer = true;
   }
  }
 }

 function addAdminHead() {
  if (strstr($_SERVER['PHP_SELF'], 'post.php') || strstr($_SERVER['PHP_SELF'], 'page-new.php') || strstr($_SERVER['PHP_SELF'], 'post-new.php') || strstr($_SERVER['PHP_SELF'], 'page.php')) {
   $out  = "<script type=\"text/javascript\">/*<![CDATA[ */\n";
   $out .= "function send_meta_value(metakey, metavalue) {";
   $out .= "jQuery('#metakeyinput').val(metakey);";
   $out .= "jQuery('#metavalue').val(metavalue);";
   $out .= "jQuery('#addmetasub').trigger('click');";
   $out .= "}\n";
   $out .= "/* ]]>*/</script>\n";
   echo $out;
  }
 }

 /*
 * Wordpress 2.5 - media button support
 */
 function addMediaButton() {
  global $post_ID, $temp_ID;

  $uploading_iframe_ID = (int) (0 == $post_ID ? $temp_ID : $post_ID);
  $media_upload_iframe_src = "media-upload.php?post_id={$uploading_iframe_ID}";

  $type = "googlemaps";
  $tab  = ($this->api_key != false || !current_user_can(GOOGLEMAPS_OPTION_ACCESS_LEVEL) ? "googlemaps" : "googlemaps_option");
  $googlemaps_iframe_src = apply_filters('media_upload_googlemaps_iframe_src', "{$media_upload_iframe_src}&amp;type={$type}&amp;tab={$tab}");
  $googlemaps_title = __('Add Google Maps', $this->textdomain_name);
  $link_markup = "<a href=\"{$googlemaps_iframe_src}&amp;TB_iframe=true&amp;keepThis=true&amp;height=500&amp;width=640\" class=\"thickbox\" title=\"{$googlemaps_title}\"><img src=\"{$this->plugin_url}images/googlemaps-media.gif\" alt=\"{$googlemaps_title}\" /></a>\n";

  echo $link_markup;
 }

 function googlemapsMediaBrowse() {
  global $type, $tab;

  $width  = 620;
  $height = 335;
  $lat    = GOOGLEMAPS_DEFAULT_LAT;
  $lng    = GOOGLEMAPS_DEFAULT_LNG;

  $post_id = intval($_REQUEST['post_id']);
  $form_action_url = trailingslashit(get_bloginfo('wpurl'))."wp-admin/media-upload.php?type={$type}&amp;tab={$tab}&amp;post_id={$post_id}";
  $callback = "type_form_{$type}";

  if ($this->api_key != false) {
?>
<div id="map" style="width:<?php echo $width; ?>px;height:<?php echo $height; ?>px;margin:0.5em auto 0px;padding:0px;"></div>

<form method="post" action="<?php echo attribute_escape($form_action_url); ?>" class="media-upload-form type-form validate" id="<?php echo $type; ?>-form">
 <table class="optiontable form-table" style="margin-top:0"><tbody>
  <tr>
   <td>
    <?php _e('Place Name', $this->textdomain_name); ?>: <input type="text" name="placename" value="" />
    <?php _e('Width', $this->textdomain_name); ?>: <input type="text" name="width" size="7" value="<?php echo GOOGLEMAPS_DEFAULT_WIDTH; ?>" />
    <?php _e('Height', $this->textdomain_name); ?>: <input type="text" name="height" size="7" value="<?php echo GOOGLEMAPS_DEFAULT_HEIGHT; ?>" />
   </td>
   <td>
    <input type="submit" class="button" name="insertonlybutton" value="<?php echo attribute_escape(__('Insert into Post')) ?>" /><br />
   </td>
  </tr>
  <tr>
   <td>
    <?php echo attribute_escape(__('Key')); ?>: <input type="text" name="metakeyname" size="7" value="<?php echo GEO_META_FIELD_NAME; ?>" />
    <?php echo attribute_escape(__('Value')); ?>: <input type="text" name="metavalue" value="" />
   </td>
   <td>
    <input type="submit" class="button" name="sendmetavalbutton" value="<?php echo attribute_escape(__('Add Custom Field')) ?>" />
   </td>
  </tr>
 </tbody></table>
</form>

<script type="text/javascript">/* <![CDATA[ */
var onload_callback = function(func){
 if (jQuery.browser.mozilla && typeof top.jQuery != 'undefined' ) {
  var ver = jQuery.browser.version.split('.');
  if ( Number(ver.length > 1 ? ver[0] + '.' + ver[1] : ver[0]) < 1.9 && top.jQuery('iframe').size() > 0 ) {
   top.jQuery('iframe').load(func);
  } else {
   google.setOnLoadCallback(func);
  }
 } else {
  google.setOnLoadCallback(func);
 }
};

onload_callback(
  function() {
    var default_point = new GLatLng(<?php echo $lat; ?>, <?php echo $lng; ?>);
    var gmap, gmarker;

    var form = jQuery('#<?php echo $type; ?>-form').submit(function() {return false;});

    gmap = new GMap2(document.getElementById("map"), {size: new GSize(<?php echo $width; ?>, <?php echo $height; ?>)});
    gmap.setCenter(default_point, 4);
    gmap.addMapType(G_PHYSICAL_MAP);
    gmap.setMapType(<?php echo GOOGLEMAPS_DEFAULT_TYPE; ?>);

    gmarker = new GMarker(default_point, {draggable: true});
    gmap.addOverlay(gmarker);

    GEvent.addListener(gmap, 'click',
      function(overlay, point) {
        if (point) {
          gmarker.setPoint(point);
          jQuery('input[name=metavalue]:first', form).val(point.toUrlValue());
        }
      }
    );
    GEvent.addListener(gmarker, 'dragend',
      function(overlay) {
        var point = gmarker.getLatLng();
        if (point) {
          jQuery('input[name=metavalue]:first', form).val(point.toUrlValue());
        }
      }
    );

    gmap.addControl(new GLargeMapControl());
    gmap.addControl(new GMapTypeControl());
    gmap.addControl(new GOverviewMapControl());
    gmap.addControl(new google.maps.LocalSearch({onSearchCompleteCallback:
      function(searcher){
        if (searcher.results.length >= 1) {
          var point = new GLatLng(searcher.results[0].lat, searcher.results[0].lng);
          var placename = searcher.results[0].addressLines[searcher.results[0].addressLines.length - 1];
          gmap.setCenter(point, <?php echo GOOGLEMAPS_DEFAULT_ZOOM; ?>);
          gmarker.setPoint(point);
          jQuery('input[name=placename]:first', form).val(placename);
          jQuery('input[name=metavalue]:first', form).val(point.toUrlValue());
        }
      }
    }));

    jQuery('input[name=insertonlybutton]:first', form).unbind('click').click(
      function(){
        var gmaptypes = Array(
          {name:gmap.getMapTypes()[0].getName(true), type:'G_NORMAL_MAP'}
         ,{name:gmap.getMapTypes()[1].getName(true), type:'G_SATELLITE_MAP'}
         ,{name:gmap.getMapTypes()[2].getName(true), type:'G_HYBRID_MAP'}
         ,{name:gmap.getMapTypes()[3].getName(true), type:'G_PHYSICAL_MAP'}
        );
        var point = gmarker.getPoint();
        var latlng = point.toUrlValue().split(',');
        var placename = jQuery('input[name=placename]:first', form).val();
        var width  = jQuery('input[name=width]:first', form).val();
        var height = jQuery('input[name=height]:first', form).val();
        var maptype = gmaptypes[0].type;
        for (var i = 0; i < gmaptypes.length; i++) {
         if (gmaptypes[i].name == gmap.getCurrentMapType().getName(true)) {
          maptype = gmaptypes[i].type;
          break;
         }
        }
        var gmap_val  = '[<?php echo GOOGLEMAPS_SHORTCODE; ?>'
                      + ' lat="' + (latlng.length >= 1 ? latlng[0] : point.lat()) + '"'
                      + ' lng="' + (latlng.length >= 1 ? latlng[1] : point.lng()) + '"'
                      + ' width="' + width + '"'
                      + ' height="' + height + '"'
                      + ' zoom="' + gmap.getZoom() + '"'
                      + ' type="' + maptype + '"'
                      + ']'
                      + (placename != '' ? placename : point.toUrlValue())
                      + '[/<?php echo GOOGLEMAPS_SHORTCODE; ?>]';
        top.send_to_editor(gmap_val);
        GUnload();
        top.tb_remove();
        return false;
      }
    );

    jQuery('input[name=sendmetavalbutton]:first', form).unbind('click').click(
      function(){
        var meta_key = jQuery('input[name=metakeyname]:first', form).val();
        var meta_val = jQuery('input[name=metavalue]:first', form).val();
        top.send_meta_value(meta_key, meta_val);
        GUnload();
        top.tb_remove();
        return false;
      }
    );
  }
);
/* ]]> */</script>
<?php
  }
 }

 function googlemapsOptionBrowse() {
  global $type, $tab;

  if (!current_user_can(GOOGLEMAPS_OPTION_ACCESS_LEVEL)) return;

  $post_id = intval($_REQUEST['post_id']);
  $form_action_url = trailingslashit(get_bloginfo('wpurl'))."wp-admin/media-upload.php?type={$type}&amp;tab={$tab}&amp;post_id={$post_id}";
  $callback = "type_form_$type";

  $msg = "<div id=\"message\" class=\"updated fade\" style=\"margin-top:1em;\"><p><strong>%s</strong></p></div>\n";
  if (isset($_POST['info_update'])) {
   check_admin_referer($this->nonce);
   $this->api_key = $this->upate_options();
   if ($this->api_key != false) {
    echo sprintf($msg, __('Done!', $this->textdomain_name));
   }
  }
  if ($this->api_key == false) {
    echo sprintf($msg, __('Please Enter Your Google Maps API Key', $this->textdomain_name));
  }

?>
<div class="wrap">
 <form method="post" action="<?php echo attribute_escape($form_action_url); ?>" class="media-upload-form type-form validate" id="<?php echo $type; ?>-form">
<?php $this->make_nonce_field($this->nonce); ?>
  <h2 id="apikey"><?php _e('Your Google Maps API Key', $this->textdomain_name); ?></h2>
  <table class="optiontable form-table"><tbody>
   <tr>
    <th width="20%" scope="row"><label for="googlemaps_api_key"><?php _e('API Key', $this->textdomain_name); ?>:</label></th>
    <td><input type="text" name="googlemaps_api_key" id="googlemaps_api_key" /> <?php echo sprintf(__("(don't have one? get one <a href=%s>here</a>)", $this->textdomain_name), '"http://www.google.com/apis/maps/signup.html"'); ?></td>
   </tr>
<?php if ($this->api_key != false) { ?>
   <tr>
    <th><?php _e('Current API Key', $this->textdomain_name); ?>:</th>
    <td><em><?php echo $this->api_key; ?></em></td>
   </tr>
<?php } ?>
  </tbody></table>
  <div class="submit">
   <input type="hidden" name="action" value="update" />
   <input type="submit" name="info_update" value="<?php _e('Update Options', $this->textdomain_name); ?> &raquo;" />
  </div>
 </form>
</div>
<?php

 }

 function make_nonce_field($action = -1) {
  if ( !function_exists('wp_nonce_field') ) {
   return;
  } else {
   return wp_nonce_field($action);
  }
 }

 function modifyMediaTab($tabs) {
  if ( current_user_can( GOOGLEMAPS_OPTION_ACCESS_LEVEL ) ) {
   return array('googlemaps'        =>  __('Google Maps', $this->textdomain_name)
               ,'googlemaps_option' =>  __('Option', $this->textdomain_name));
  } else {
   return array('googlemaps'        =>  __('Google Maps', $this->textdomain_name));
  }
 }

 function addMediaHead() {
  if ($this->api_key == false) return;

  $post_id = intval($_REQUEST['post_id']);
?>
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;hl=<?php echo (defined('WPLANG') ? WPLANG : 'en'); ?>&amp;key=<?php echo $this->api_key; ?>" type="text/javascript" charset="utf-8"></script>
<script src="http://www.google.com/uds/api?file=uds.js&amp;v=1.0&amp;hl=<?php echo (defined('WPLANG') ? WPLANG : 'en'); ?>&amp;key=<?php echo $this->api_key; ?>" type="text/javascript"></script>
<script src="http://www.google.com/uds/solutions/localsearch/gmlocalsearch.js" type="text/javascript"></script>
<script src="http://dogmap.jp/wp-includes/js/jquery/jquery.js" type="text/javascript"></script>
<script type="text/javascript">/* <![CDATA[ */
 var post_id = <?php echo (int) $post_id; ?>;
/* ]]> */</script>
<style type="text/css">
 @import url("http://www.google.com/uds/css/gsearch.css");
 @import url("http://www.google.com/uds/solutions/localsearch/gmlocalsearch.css");
 body {margin:0px; padding:0px;}
 #map {border:1px solid #979797;width:100%;height:575px;}
</style>
<?php
 }

 function iframe($content_func) {
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php do_action('admin_xml_ns'); ?> <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php echo get_option('blog_charset'); ?>" />
<title><?php bloginfo('name') ?> &rsaquo; <?php _e('Uploads'); ?> &#8212; <?php _e('WordPress'); ?></title>
<?php
wp_admin_css( 'css/global' );
wp_admin_css();
wp_admin_css( 'css/colors' );
?>
<script type="text/javascript">
//<![CDATA[
function addLoadEvent(func) {if (typeof wpOnload!='function'){wpOnload=func;}else{var oldonload=wpOnload;wpOnload=function(){oldonload();func();}}}
//]]>
</script>
<?php
//do_action('admin_print_scripts');
//do_action('admin_head');
if ( is_string($content_func) ) do_action( "admin_head_{$content_func}" );
?>
</head>
<body<?php if ( isset($GLOBALS['body_id']) ) echo ' id="' . $GLOBALS['body_id'] . '"'; ?>>
<?php
	$args = func_get_args();
	$args = array_slice($args, 1);
	call_user_func_array($content_func, $args);
?>
</body>
</html>
<?php
 }

 /*
 * update options
 */
 function upate_options() {
  $gmap_api_key = (isset($_POST['googlemaps_api_key']) ? $_POST['googlemaps_api_key'] : false);
  if ($gmap_api_key) {
   update_option('googlemaps_api_key', $gmap_api_key);
   delete_option('yf_google_api_key');
  } elseif ($gmap_api_key = get_option('yf_google_api_key')) {
   update_option('googlemaps_api_key', $gmap_api_key);
   delete_option('yf_google_api_key');
  } else {
   $gmap_api_key = false;
  }
  return $gmap_api_key;
 }

 /*
 * Wordpress 2.5 - New shortcode API
 */
 function shortcodeHandler($atts, $content = '') {
  extract( shortcode_atts( array(
       'lat'    => GOOGLEMAPS_DEFAULT_LAT
      ,'lng'    => GOOGLEMAPS_DEFAULT_LNG
      ,'width'  => GOOGLEMAPS_DEFAULT_WIDTH
      ,'height' => GOOGLEMAPS_DEFAULT_HEIGHT
      ,'zoom'   => GOOGLEMAPS_DEFAULT_ZOOM
      ,'type'   => GOOGLEMAPS_DEFAULT_TYPE
      ), $atts ) );

  // add JavaScript
  add_action('wp_footer', array($this, 'addFooter'));

  return $this->createHTMLSrc($lat, $lng, $width, $height, $zoom, $type, $content);
 }

 function createHTMLSrc($lat = GOOGLEMAPS_DEFAULT_LAT, $lng = GOOGLEMAPS_DEFAULT_LNG, $width = GOOGLEMAPS_DEFAULT_WIDTH, $height = GOOGLEMAPS_DEFAULT_HEIGHT, $zoom = GOOGLEMAPS_DEFAULT_ZOOM, $type = GOOGLEMAPS_DEFAULT_TYPE, $content= "") {
  list($element, $class) = split("\.", GOOGLEMAPS_ELEMENT, 2);

  $ret_val = "";
  if ( !((function_exists('is_ktai') && is_ktai()) || (function_exists('is_mobile') && is_mobile())) ) {
   $style  = "";
   if ($width  != GOOGLEMAPS_DEFAULT_WIDTH)  $style .= "width:{$width};";
   if ($height != GOOGLEMAPS_DEFAULT_HEIGHT) $style .= "height:{$height};";
   if ($style  != "") $style = " style=\"{$style}\"";

   $ret_val .= "<{$element} class=\"{$class}\"{$style}>";
   $ret_val .= "<a href=\"http://maps.google.co.jp/maps?hl=".(defined('WPLANG') ? WPLANG : 'en')."&amp;q={$lat},{$lng}&amp;z={$zoom}&amp;t={$type}\" title=\"{$content}\">";
   $ret_val .= "<img src=\"http://maps.google.com/staticmap?markers={$lat},{$lng},red&amp;zoom={$zoom}&amp;size=".preg_replace("/^([\d]+).*$/","$1",GOOGLEMAPS_DEFAULT_WIDTH)."x".preg_replace("/^([\d]+).*$/","$1",GOOGLEMAPS_DEFAULT_HEIGHT)."&amp;key={$this->api_key}&amp;hl=".(defined('WPLANG') ? WPLANG : 'en')."\" alt=\"{$content}\" title=\"{$content}\" />";
   $ret_val .= "</a>";
   $ret_val .= "</{$element}>\n";

  } else {
   global $Lw_GoogleMaps;
   if (isset($Lw_GoogleMaps)) {
    $width  = $Lw_GoogleMaps->get('width');
    $height = $Lw_GoogleMaps->get('height');
   } elseif (class_exists('LWGM_Mobile')) {
    $Lwgm = new LWGM_Mobile();
    $width  = $Lwgm->width;
    $height = $Lwgm->height;
    unset($Lwgm);
   } else {
    $width  = GOOGLEMAPS_MOBILE_WIDTH;
    $height = GOOGLEMAPS_MOBILE_HEIGHT;
   }
   $ret_val .= "<div align=\"center\">";
   $ret_val .= "<img src=\"http://maps.google.com/staticmap?markers={$lat},{$lng},red&amp;zoom={$zoom}&amp;size={$width}x{$height}&amp;maptype=mobile&amp;key={$this->api_key}&amp;hl=".(defined('WPLANG') ? WPLANG : 'en')."\" alt=\"{$content}\" title=\"{$content}\" />";
   $ret_val .= "</div>\n";
  }

  return $ret_val;
 }

 /*
 * for Ktai Style
 */
 function ks_keep_gmap_image($replace, $orig, $src) {
  if (preg_match('/^http:\/\/maps\.google\.com\/staticmap/i', $src)) {
   $replace = $orig;
  }
  return $replace;
 }
}

function media_upload_googlemaps() {
 global $gm_anywhere, $wp_version;

 if (isset($gm_anywhere)) {
  if (version_compare($wp_version, "2.6", ">=")) {
   wp_iframe('media_upload_googlemaps_form');
  } else {
   $gm_anywhere->iframe('media_upload_googlemaps_form');
  }
 }
}
function media_upload_googlemaps_form() {
 global $gm_anywhere;

 if (isset($gm_anywhere)) {
  add_filter('media_upload_tabs', array(&$gm_anywhere, 'modifyMediaTab'));

  echo "<div id=\"media-upload-header\">\n";
  media_upload_header();
  echo "</div>\n";

  $gm_anywhere->googlemapsMediaBrowse();
 }
}

function media_upload_googlemaps_option() {
 wp_iframe('media_upload_googlemaps_option_form');
}
function media_upload_googlemaps_option_form() {
 global $gm_anywhere;

 if (isset($gm_anywhere)) {
  if ( !function_exists('wp_nonce_field') ) {
   $gm_anywhere->nonce = -1;
  } else {
   $gm_anywhere->nonce = 'googlemaps-anywhere-update-config';
  }

  $gm_anywhere->api_key = (isset($_POST['googlemaps_api_key']) ? $_POST['googlemaps_api_key'] : $gm_anywhere->api_key);
  add_filter('media_upload_tabs', array(&$gm_anywhere, 'modifyMediaTab'));

  echo "<div id=\"media-upload-header\">\n";
  media_upload_header();
  echo "</div>\n";

  $gm_anywhere->googlemapsOptionBrowse();
 }
}

global $wp_version, $gm_anywhere;

// Wordpress 2.5+
if (version_compare($wp_version, "2.5", ">=")) {
 if (!class_exists('ScriptManager')) {
  require(dirname(__FILE__).'/includes/script-manager.php');
 }
 $gm_anywhere = new GoogleMapsAnywhereController();
}
?>
