<?php
/*
Plugin Name: wp-tmkm-amazon
Plugin URI: http://tomokame.moo.jp/
Description: ASIN を指定して Amazon から個別商品の情報を取出します。BOOKS, DVD, CD は詳細情報を取り出せます。
Author: ともかめ
Version: 1.1ja
Author URI: http://tomokame.moo.jp/
Special Thanks: Keith Devens.com (http://keithdevens.com/software/phpxml)
Special Thanks: websitepublisher.net (http://www.websitepublisher.net/article/aws-php/)
Special Thanks: hiromasa.zone :o) (http://hiromasa.zone.ne.jp/)
Special Thanks: PEAR :: Package :: Cache_Lite (http://pear.php.net/package/Cache_Lite)
*/

/********** Notes
 # ECS4.0 に対応しています。
 # PHP4.x で動作します。ただし Keith Devens.com の PHP XML Library が必要（ 同梱しています ）。
 # [tmkm-amazon]ASIN[/tmkm-amazon] または <?php tmkm_amazon_view('ASIN'); ?> という記述で動作します。
 # LGPL で提供されている Lite.php および Open Source License で提供されている xml.php を同梱しています。
 # 記事およびページ投稿／編集画面での Amazon 検索が可能です。
**********/

/********** Usage
 # 1. ダウンロードした zip ファイルを解凍します。
 # 2. wp-tmkm-amazon フォルダを wp-content/plugins フォルダに転送します。
 # 3. 管理画面から wp-tmkm-amazon を有効化します。
 # 4. 管理画面にある「設定」画面内の「Wp_Tmkm_Amazon」メニューで、ご自分のアソシエイト ID を入力します。
 # 5. 各テーマの php ファイル、もしくは記事本文中に以下を記載します。
 #### PHP 関数として呼び出す場合	...	<?php tmkm_amazon_view('ASIN'); ?>　：テーマファイルに記述
 #### 記事本文中にコードを書く場合	...	[tmkm-amazon]ASIN[/tmkm-amazon]
 
 ## 記事本文中で PHP コードを実行できるプラグインを導入していれば、PHP 関数として呼び出すこともできます。
 ## 書籍の場合、ASIN に 10 桁および 13 桁の ISBN を使用できます。
 ## 同梱の amazon_noimg.png と amazon_noimg_small.png を差し替えれば、商品画像がないときの代替画像を好きなものにできます。
**********/

/******************************************************************************
 * THIS FILE IS CALLED ONLY.
 *****************************************************************************/

if( basename( $_SERVER['SCRIPT_FILENAME'] ) == 'wp-tmkm-amazon.php' ) {
	die();
}
$tmkm_plugin_directory = get_option('siteurl') . '/wp-content/plugins/wp-tmkm-amazon/';
$tmkm_amazon_php = 'wp-tmkm-amazon.php';
$tmkm_amazon_search_php = 'wp-tmkm-amazon-search.php';

$tmkm_amazon_settings = get_option('wp_tmkm_admin_options');

/******************************************************************************
 * wp-tmkm-amazon-function : amazon ECS search engine
 * WpBabel WordPress Plugin Framework Define
 *****************************************************************************/
include_once('wp-tmkm-amazon-function.php');


/******************************************************************************
 * 管理画面からオプションを設定
 *****************************************************************************/
class WpTmkmAmazonAdmin {
	var $tmkm_amazon_settings, $tmkm_amazon_options;

	function WpTmkmAmazonAdmin() {
		if ( !get_option('wp_tmkm_admin_options') ){
			// create default options
			$tmkm_amazon_options['associatesid'] = 'tomokametei-22';

			update_option('wp_tmkm_admin_options', $tmkm_amazon_options);
		}
	}

	function tmkm_amazon_options_page() {
		global $tmkm_amazon_settings;
		$tmkm_amazon_options = get_option('wp_tmkm_admin_options');

		$tmkm_amazon_admin_html =
			'<div class="wrap" id="footnote-options">' . "\n".
			'<h2>Wp-Tmkm-Amazon プラグイン設定</h2>' . "\n";

		if ( $_POST['action'] ){
			$tmkm_amazon_admin_html .= '<div class="updated"><p><strong>設定を保存しました。</strong></p></div>'; 
		}

		$tmkm_amazon_admin_html .=
			'<form method="post" action="' . $_SERVER['PHP_SELF'] . "?" . $_SERVER['QUERY_STRING'] . '">' .
			'<input type="hidden" name="action" value="save_options" />' .
			'<table class="form-table">' .
			'<tr>' .
			'<th>あなたのアソシエイト ID</th>' .
			'<td><input type="text" name="associatesid" value="' . $tmkm_amazon_options['associatesid'] . '"  /></td>' .
			'</tr>' .
			'</table>' .
			'<p class="submit"><input type="submit" name="Submit" value="設定を保存する &raquo;" /></p>' .
			'</form>' .
			'</div>';

			echo $tmkm_amazon_admin_html;
	}

	function tmkm_amazon_add_options() {
		global $tmkm_amazon_php;
		// Add a new menu under Options:
		add_options_page(
			'Wp_Tmkm_Amazon',
			'Wp_Tmkm_Amazon',
			8,
			$tmkm_amazon_php,
			array(&$this, 'tmkm_amazon_options_page')
		);
	}
	
	function tmkm_amazon_save_options() {
		// create array
		global $tmkm_amazon_settings;

		if ( !$tmkm_amazon_settings ){
			// create default options
			$tmkm_amazon_options['associatesid'] = 'tomokametei-22';

			update_option('wp_tmkm_admin_options', $tmkm_amazon_options);
		}
		$tmkm_amazon_options['associatesid'] = $_POST['associatesid'];
		
		update_option('wp_tmkm_admin_options', $tmkm_amazon_options);
		$options_saved = true;
	}

}


/******************************************************************************
 * 記事本文中に Amazon から取得した商品情報を表示
 *****************************************************************************/
class WpTmkmAmazonView {

	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */

	function WpTmkmAmazonView() {

		$this->makedetailview = & new MakeAmazonHtml();

	}

	/**
	 * 記事本文中のコードを個別商品表示 HTML に置き換える
	 * 
	 * @param $content
	 * @return $transformedstring
	 */
	function _replacestrings($content) { // 記事本文中の呼び出しコードを変換

		global $post;

//		$poststring = '/\[tmkm-amazon type\=([a-z]+)\]([a-zA-Z0-9,]+)\[\/tmkm-amazon\]/';
		$poststring = '/\[tmkm-amazon\]([a-zA-Z0-9,]+)\[\/tmkm-amazon\]/';
		$transformedstring = $content;
		if( preg_match_all($poststring, $content, $regs1) ) {

			for ($i=0; $i<count($regs1[0]); $i++) {
//				$type = $regs1[1][$i];
				$SearchString = $regs1[1][$i];

//				$display = $this->makedetailview->format_amazon( $SearchString, $type );
				$display = $this->makedetailview->format_amazon( $SearchString, 'detail' );

				if( ereg( $SearchString, $regs1[0][$i], $str ) ) { // ASINコードの置換
					$transformedstring = str_replace($regs1[0][$i], $display, $transformedstring);
				}
			}
		}

		$transformedstring = str_replace('<p><div class="tmkm-amazon-view">', '<div class="tmkm-amazon-view">', $transformedstring);
		$transformedstring = str_replace('<hr class="tmkm-amazon-clear" /></div></p>', '<hr class="tmkm-amazon-clear" /></div>', $transformedstring);

		return $transformedstring;

	}


	/**
	 * PHP 関数として Amazon の個別商品 HTML を呼び出す
	 * 
	 * @param $SearchString ( ASIN )
	 * @param $type ( book / dvd / cd )
	 * @return echo $display ( HTML )
	 */
	function tmkm_amazon_view($SearchString) { // PHP テ−マファイル中に記述する関数
		$display = $this->makedetailview->format_amazon( $SearchString, 'detail' );
		echo $display;
	}


}


/******************************************************************************
 * PHP を記述した箇所にブログの記事で参照している Amazon の商品一覧を表示
 *****************************************************************************/
class WpTmkmAmazonList {

	var $sql;
	var $ordersql;

	function WpTmkmAmazonList() {

		$this->makedetailview = & new MakeAmazonHtml();
		$this->sql = '';
		$this->ordersql = '';

	}

	function tmkm_amazon_list( $orderby = 'post_id', $order = 'asc' ) {
	
	    global $wpdb;

		switch( $orderby ) {
			case post_id: $this->ordersql = "$wpdb->posts.ID " . $order; break;
			case post_title: $this->ordersql = "$wpdb->posts.post_title " . $order; break;
			case post_date: $this->ordersql = "$wpdb->posts.post_date " . $order; break;
			case modified_date: $this->ordersql = "$wpdb->posts.post_modified " . $order; break;
		}

	    $this->sql =
			"SELECT " .
				"ID, post_title, " .
				"DATE_FORMAT(post_modified, '%Y/%m/%d') as mdate, " .
				"meta_key, meta_value " .
			"FROM " .
				"$wpdb->posts, $wpdb->postmeta " .
			"WHERE " .
				"$wpdb->posts.ID = $wpdb->postmeta.post_id AND " .
				"$wpdb->posts.post_date <= NOW() AND " .
				"$wpdb->posts.post_status = 'publish' AND " .
				"$wpdb->postmeta.meta_key = 'tmkm-amazon' " .
			"ORDER BY " .
				$this->ordersql;

	    $PostRetainAsin = $wpdb->get_results($this->sql);
	    if( $PostRetainAsin ) {
	    	print '<div id="amazonlist">' . "\n" . '<dl>' . "\n";
	    	foreach( $PostRetainAsin as $asinlist ) {
	    		$asins = explode(',',$asinlist->meta_value);
	    		foreach( $asins as $asin ) {
	    			$permalink = get_permalink($asinlist->ID);
	    			$display = $this->makedetailview->format_amazon( $asin, 'list' );

					$heredoc = '<dt>このブログの記事：<a href="' . $permalink . '">' . $asinlist->post_title . '</a> ( ' . $asinlist->mdate . ' )</dt>' . "\n";
	    			$heredoc .= '<dd>' . "\n";
	    			$heredoc .= $display . "\n";
	    			$heredoc .= '</dd>' . "\n";
	    			echo $heredoc;
	    		}
	    	}
	    	print '</dl>' . "\n" . '</div>';
	    }
	}

}

/******************************************************************************
 * Amazon ECS から取得した XML から HTML を生成
 *****************************************************************************/
class MakeAmazonHtml {
	var $plugin_path;
	var $mediumimgfile;
	var $smallimgfile;
	var $associatesid;

	function MakeAmazonHtml() {

		$this->amazonparse = & new GetAmazonXmlParse();
		$this->generalfunclib = & new generalFuncLibrary();

	}

	/**
	 * Amazon 商品の HTML ソースを生成
	 * @param $SearchString ( ASIN )
	 * @param $mediatype ( book / dvd / cd )
	 * @return $output ( HTML )
	 */
	function format_amazon( $SearchString, $formattype ) {
		global $tmkm_amazon_settings, $tmkm_plugin_directory;

        $this->mediumimgfile = 'amazon_noimg.png';
        $this->smallimgfile = 'amazon_noimg_small.png';
        $associatesid = $tmkm_amazon_settings['associatesid'];

		$output = '';
		if( strlen( $SearchString ) == 13 ){
			$SearchString = $this->generalfunclib->calc_chkdgt_isbn10( substr( $SearchString, 3, 9 ) );
		}

		$AmazonXml = $this->amazonparse->getamazonxml( $associatesid, $SearchString, 'single', '', 'Large' ); // --- Call Amazon XML function ---
/*		echo "<pre>"; // DEBUG
		print_r($AmazonXml);
		echo "</pre>";
		echo $SearchString.'<br />';
*/

		// --- Get results of the Amazon function ---
		if( false === $AmazonXml ){  // Amazon function was returned false, so AWS is down

			echo '<p>アマゾンのサーバでエラーが起こっているかもしれません。一度ページを再読み込みしてみてください。</p>';

		}else{ // Amazon function returned XML data

			$status = $AmazonXml["ItemLookupResponse"]["Items"]["Request"];

			if( $status["IsValid"] == 'False' ){ // Request is invalid

				echo '<p>与えられたリクエストが正しくありません</p>';

			}else{ // results were found, so display the products
	
		// --- Display the product data returned from the XML ---
				$item = $AmazonXml["ItemLookupResponse"]["Items"]["Item"];

				$mediumimage = $this->amazonparse->get_goods_image($item,'medium');
				if( $mediumimage == '' ) { $mediumimage = $tmkm_plugin_directory . $this->mediumimgfile; }
				$smallimage = $this->amazonparse->get_goods_image($item,'small');
				if( $smallimage == '' ) { $smallimage = $tmkm_plugin_directory . $this->smallimgfile; }

				$url = $this->amazonparse->get_amazon_text($item,'url');
				$Title = $this->amazonparse->get_amazon_text($item,'title');
				$Manufacturer = $this->amazonparse->get_amazon_text($item,'manufacturer');
				$Binding = $this->amazonparse->get_amazon_text($item,'binding');
				$EANcode = $this->amazonparse->get_amazon_text($item,'eancode');

				$Price = $this->amazonparse->get_amazon_text($item,'price');
				$ASIN = $this->amazonparse->get_amazon_text($item,'asincode');
				$ReleaseDate = $this->amazonparse->get_amazon_text($item,'releasedate');

				$ProductGroup = $this->amazonparse->get_amazon_text($item,'productgroup');

				$output = '<div class="tmkm-amazon-view">';
				
				if( $formattype == 'detail' ) {
					if( $ProductGroup == 'Book' ){
	
						$Role = $this->amazonparse->get_amazon_text($item,'role');
						$Author = $this->amazonparse->get_amazon_text($item,'author');
						$ISBN10 = $this->amazonparse->get_amazon_text($item,'isbn10');
						$PublicationDate = $this->amazonparse->get_amazon_text($item,'publicationdate');
	
						$output .= '<p><a href="'.$url.'"><img src="' . $mediumimage . '" border="0" alt="" /></a></p>' . "\n";
						$output .= '<p><a href="'.$url.'">' . $Title . '</a></p>' . "\n";
						if( $Author != "" ) {
							$output .= "<p><em>著者／訳者：</em>";
							if( count($Author) == 1 ) {
								$output .= $Author; 
							} else {
								foreach($Author as $auth){ $output .= $auth.' '; }
							}
							$output .= '</p>' . "\n";
						}
						$output .= "<p><em>出版社：</em>$Manufacturer( $PublicationDate )</p>" . "\n";
						$output .= "<p><em>定価：</em>$Price</p>" . "\n";
						$output .= "<p>$Binding</p>" . "\n";
						$output .= "<p>ISBN-10 : $ISBN10</p>" . "\n";
						$output .= "<p>ISBN-13 : $EANcode</p>" . "\n";
	
					} elseif( $ProductGroup == 'DVD' ) {
	
						$RunningTime = $this->amazonparse->get_amazon_text($item,'runningtime');
						$numofdisc = $this->amazonparse->get_amazon_text($item,'numofdisc');
	
						$output .= '<p><a href="'.$url.'"><img src="' . $mediumimage . '" border="0" alt="" /></a></p>' . "\n";
						$output .= '<p><a href="'.$url.'">' . $Title . '</a></p>' . "\n";
						$output .= "<p><em>販売元：</em>$Manufacturer( $ReleaseDate )</p>" . "\n";
						$output .= "<p><em>定価：</em>$Price</p>" . "\n";
						$output .= "<p><em>時間：</em>$RunningTime 分</p>" . "\n";
						$output .= "<p>$numofdisc" . " 枚組 ( " . $Binding . " )</p>" . "\n";
						$output .= "<p>ASIN : $ASIN</p>" . "\n";
						$output .= "<p>JAN コード : $EANcode</p>" . "\n";
	
					} elseif( $ProductGroup == 'Music' ) {
	
						$Format = $this->amazonparse->get_amazon_text($item,'format');
						$Artist = $this->amazonparse->get_amazon_text($item,'artist');
	
						$output .= '<p><a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="" /></a></p>' . "\n";
						$output .= '<p><a href="'.$url.'">' . $Title . ' / ' . $Artist . "</a> / $Format $Binding ( $ProductGroup )</p>" . "\n";
						$output .= "<p>$Manufacturer</p>" . "\n";
						$output .= "<p><em>定価：</em>$Price ( $ReleaseDate )</p>" . "\n";
						$output .= "<p>ASIN : $ASIN ( JAN コード : $EANcode )</p>" . "\n";
	
					} else {
						$output .= '<p><a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="' . $Title . '" /></a></p>' . "\n";
						$output .= '<p><a href="'.$url.'">' . $Title . '</a></p>' . "\n";
						if( $Price != '' ) { $output .= "<p><em>定価：</em>$Price</p>" . "\n"; }
						if( $ReleaseDate != '' ) { $output .= "<p><em>発売日：</em>$ReleaseDate</p>" . "\n"; }
						$output .= "<p>ASIN : $ASIN</p>" . "\n";
						if( $EANcode != '' ) { $output .= "<p>JAN コード : $EANcode</p>" . "\n"; }
					}
					$output .= '<hr class="tmkm-amazon-clear" /></div>' . "\n";

				} elseif( $formattype == 'list' ) {
					$output = '<p><a href="'.$url.'"><img src="' . $smallimage . '" border="0" alt="' . $Title . '" /></a></p>' . "\n";
					$output .= '<p><a href="'.$url.'">' . $Title . '</a></p>' . "\n";
				}

				return $output;

			}
		}
	}

}

/******************************************************************************
 * 記事投稿画面に検索フォームを追加
 *****************************************************************************/
class WpTmkmAmazonFind {

	var $searchphp_path;

	function InsertSearchForm() {

		global $wpdb, $tmkm_amazon_settings, $tmkm_plugin_directory, $tmkm_amazon_search_php;

		$associatesid = $tmkm_amazon_settings['associatesid'];
        $this->searchphp_path = $tmkm_plugin_directory . $tmkm_amazon_search_php;
        $this->searchphp_path .= '?AID=' . $associatesid;

		?>
		<div id="wptmkmamazon" class="postbox if-js-closed">
		<h3>wp-tmkm-amazon</h3>
		<div class="inside">
			<iframe id="uploading" frameborder="0" src="<?php echo $this->searchphp_path; ?>">IFRAME による表示がサポートされている環境が必要です。</iframe>
		</div>
		</div>
		<?php 

	}
}

if(!function_exists('tmkm_amazon_view')) {
	function tmkm_amazon_view($Searchstring) {
		global $wpTmkmAmazonView;
		$wpTmkmAmazonView->tmkm_amazon_view($Searchstring);
		
	}
}

if(!function_exists('tmkm_amazon_list')) {
	function tmkm_amazon_list($orderby,$order) {
		global $wpTmkmAmazonList;
		$wpTmkmAmazonList->tmkm_amazon_List($orderby,$order);
		
	}
}

function add_tmkmamazon_stylesheet(){
	global $tmkm_plugin_directory;
	?>
	<style type="text/css">
		<link rel="stylesheet" href="<?php echo $tmkm_plugin_directory; ?>wp-tmkm-amazon/tmkm-amazon.css" type="text/css" media="screen" />
	</style>
	<?php
}

/******************************************************************************
 * WpTmkmAmazon WordPress Plugin Class & Funtcion Define
 *****************************************************************************/

$wpTmkmAmazonView = & new WpTmkmAmazonView();
$wpTmkmAmazonList = & new WpTmkmAmazonList();
$wpTmkmAmazonFind = & new WpTmkmAmazonFind();
$wpTmkmAmazonAdmin = & new WpTmkmAmazonAdmin();

add_action('wp_head', 'add_tmkmamazon_stylesheet');
add_action('admin_menu',		array(&$wpTmkmAmazonAdmin, 'tmkm_amazon_add_options')); 		// Insert the Admin panel.
if ( $_POST['action'] == 'save_options' ){
	add_action('admin_menu',	array(&$wpTmkmAmazonAdmin, 'tmkm_amazon_save_options'));
}

add_filter('the_content',		array(&$wpTmkmAmazonView, '_replacestrings'));
add_filter('edit_form_advanced',	array(&$wpTmkmAmazonFind, 'InsertSearchForm'));
add_filter('edit_page_form',		array(&$wpTmkmAmazonFind, 'InsertSearchForm'));


?>