<?php
/* ==================================================
 *   Ktai Content Shrinkage
   ================================================== */

global $KS_Shrinkage;
$KS_Shrinkage = new Ktai_Content_Shrinkage;

add_filter('attribute_escape', array($KS_Shrinkage, 'attribute_escape_filter'), 90, 2);
add_filter('the_title', array($KS_Shrinkage, 'shrink_title'), 90);
add_filter('the_content', array($KS_Shrinkage, 'shrink_content'), 90);
remove_filter('get_the_excerpt', 'wp_trim_excerpt');
add_filter('get_the_excerpt',  array($KS_Shrinkage, 'trim_excerpt'), 9);
add_filter('get_comment_text', array($KS_Shrinkage, 'shrink_content'), 90);
add_filter('post_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('page_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('attachment_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('year_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('month_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('day_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('category_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('list_cats', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('tag_link', array($KS_Shrinkage, 'strip_host'), 90);
add_filter('redirect_canonical', array($KS_Shrinkage, 'complete_url'), 10, 2);
add_filter('wp_generate_tag_cloud', array($KS_Shrinkage, 'shrink_tag_cloud'), 90, 3);
add_filter('split_page/ktai_style.php', array($KS_Shrinkage, 'add_url_inline_image'), 7);

define ('KS_THUMBNAIL_MAX_SIZE', 96);
define ('KS_THUMBNAIL_FILENAME', '.ktai');
define ('KS_SIZE_EXCEED_COLOR', '#808080');
// define ('KS_SHRINKAGE_DEBUG', true);

class Ktai_Content_Shrinkage {
	private $num_image;
	private $url;
	private $url_pat;
	private $wpurl;
	private $wpurl_pat;
	private $short_links;
	private $internal_pat;
	private $short_int_pat;
	private $host_pat;
	private $scheme_pat;
	private $leave_pat;
	private $mobile_pat;
	private $none_mobile_pat;
	static public $mobile_same_url = array(
		// Use same URL for PC and mobile
		'http://[-\w]+\.blog\d+\.fc2\.com/', 
		'http://(jugem|yaplog)\.jp/[-\w]+/', 
		'http://[-\w]+\.seesaa\.net/', 
		'http://blog\.goo\.ne\.jp/[-\w]+/', 
		'http://blogs\.dion\.ne\.jp/[-\w]+/',
		'http://[-\w]+\.blog\.so-net\.ne\.jp/',
		'http://[-\w]+\.paslog\.jp/',
		'http://[-\w]+\.vox\.com/',
		// Redirect mobile URL from PC
		'http://d\.hatena\.ne\.jp/[-\w]+/',
		'http://blog\.livedoor\.jp/[-\w]+/',
		'http://[-\w]+.(cocolog|air|moe|tea|txt|way)-nifty\.com/',
		'http://[-\w]+\.at\.webry\.info/',
		'http://[-\w]+\.spaces\.live\.com/',
		'http://plaza\.rakuten\.co\.jp/[-\w]+(/|$)',
//		'http://mixi\.jp/',
	);
	static public $none_mobile_url = array(
		'http://(www|support|app)\.cocolog-nifty\.com/',
	);

// ==================================================
public function __construct() {
	$this->num_image = 0;
	$this->url       = $this->strip_host(get_bloginfo('url') . '/');
	$this->url_pat   = '!^(' . preg_quote(get_bloginfo('url'), '!') . '/|' . preg_quote($this->url, '!') . ')!';
	$this->wpurl     = $this->strip_host(get_bloginfo('wpurl') . '/');
	$this->wpurl_pat = '!^(' . preg_quote(get_bloginfo('wpurl'), '!') . '/|' . preg_quote($this->wpurl, '!') . ')!';
	$this->short_links[0]  = $this->wpurl;
	$this->internal_pat[0] = '!^' . preg_quote(get_bloginfo('wpurl'), '!') . '/?!';
	if (get_bloginfo('url') && strcmp(get_bloginfo('url'), get_bloginfo('wpurl') !== 0)) {
		$this->short_links[]  = $this->url;
		$this->internal_pat[] = '!^' . preg_quote(get_bloginfo('url'), '!') . '/?!';
	}
	$this->short_int_pat = '!^(' . implode('|',  array_map('preg_quote', $this->short_links)) . ')!';
	if (preg_match('!^(https?://[^/]*)/?!', get_bloginfo('wpurl'), $host)) {
		$this->host_pat = '!^(/|' . preg_quote($host[1], '!') . '/)!';
	} else {
		$this->host_pat = '!^/!';
	}
	$leave_schemes = apply_filters('leave_scheme/ktai_style.php', array('tel:', 'tel-av:', 'vtel:', 'mailto:', 'device:', 'location:'));
	$leave_sites = preg_split('/\\s+/', ks_option('ks_treat_as_internal'), -1, PREG_SPLIT_NO_EMPTY);
	$this->scheme_pat = '!^(#|' . implode('|', $leave_schemes) . ')!';
	$this->leave_pat = '!^(#|' . implode('|', array_merge($leave_schemes, array_map('preg_quote', $leave_sites))) . ')!';
	$this->mobile_pat = '!^(' . implode('|', apply_filters('mobile_same_url/ktai_style.php', self::$mobile_same_url)) . ')!';
	$this->none_mobile_pat = '!^(' . implode('|', apply_filters('none_mobile_url/ktai_style.php', self::$none_mobile_url)) . ')!';
	return;
}

// ==================================================
public function get($key) {
	return isset($this->$key) ? $this->$key : NULL;
}

// ==================================================
public function added_image() {
	return ++$this->num_image;
}

// ==================================================
public function has_inline_images() {
	return $this->num_image;
}

/* ==================================================
 * @param	string  $safe_text
 * @param	string  $text
 * @return	string  $safe_text
 */
public function attribute_escape_filter($safe_text, $text) {
	return str_replace('&#038;', '&amp;', $safe_text);
}

/* ==================================================
 * @param	string  $url
 * @return	string  $url
 */
public function strip_host($url = '/') {
	return preg_replace('!^https?://[^/]*/?!', '/', $url);
}

/* ==================================================
 * @param	string  $url
 * @return	string  $url
 */
public function complete_url($redirect_url, $requested_url) {
	if (preg_match('!^://!', $redirect_url)) {
		$request = @parse_url($requested_url);
		$redirect_url = $request['scheme'] . $redirect_url;
	} elseif (preg_match('!^/!', $redirect_url) && preg_match('!^(https?://[^/]*)!', $requested_url, $request)) {
		$redirect_url = $request[1] . $redirect_url;
	}
	return $redirect_url;
}

/* ==================================================
 * @param	string  $title
 * @return	string  $title
 */
public function shrink_title($title) {
	$phrase[0]     = str_replace('%s', '', __('Protected: %s'));
	$phrase_pat[0] = '/^' . preg_quote($phrase[0]) . '/';
	$icon[0]       = '<img localsrc="279" alt="' . $phrase[0] . '" />';
	$phrase[1]     = str_replace('%s', '', __('Private: %s'));
	$phrase_pat[1] = '/^' . preg_quote($phrase[1]) . '/';
	$icon[1]       = '<img localsrc="501" alt="' . $phrase[1] . '" />';
	return preg_replace($phrase_pat, $icon, $title);
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function convert_links($content) {
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a ([^>]*?)>(.*?)</a>!', $content, $l, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$attr    = $l[1][0];
		$label   = $l[2][0];
		preg_match('/href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $h);
		$href      = $h[2];
		$replace   = $orig;
		$link_html = $label; // default is stripping links
		$is_ktai = preg_match('/class=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $class) && preg_match('/(^| )ktai( |$)/', $class[2]);
		if (preg_match('!<img [^>]*?src=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1[^>]*? ?/?>!', $label, $image)) {
			$src = $image[2];
			if (preg_match('!' . PLUGINDIR . '!', $src)) { // skip plug-in's icon
				continue; // leave links
			} elseif (preg_match($this->wpurl_pat, $href) && preg_match($this->wpurl_pat, $src)) { // both internal link
				$path = preg_replace($this->wpurl_pat, ABSPATH . '/', $href);
				if (! is_dir($path) && $imagesize = @filesize($path)) { // a thumbnail linked to original image
					$thumbnail = str_replace('<img ', '<img has_orig="true" ', $label); // inform existance of original to images_to_link()
					$link_html = $thumbnail . '<img src="' . $href . '" alt="' . sprintf(__('Original(%dKB)', 'ktai_style'), intval($imagesize / 1024)) . '" filesize="' . $imagesize . '"/>'; // pass filesize to images_to_link()
				} else { // internal link to other than images
					$link_html = $label . '(<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>)';
				}
			} elseif (preg_match($this->host_pat, $href) && preg_match($this->host_pat, $src) && $_SERVER['DOCUMENT_ROOT']) { // both in-host link
				$path = preg_replace($this->host_pat, $_SERVER['DOCUMENT_ROOT'] . '/', $href);
				if (! is_dir($path) && $imagesize = @filesize($path)) { // a thumbnail linked to original image
					$thumbnail = str_replace('<img ', '<img has_orig="true" ', $label); // inform existance of original to images_to_link()
					$link_html = $thumbnail . '<img src="' . $href . '" alt="' . sprintf(__('Original(%dKB)', 'ktai_style'), intval($imagesize / 1024)) . '" filesize="' . $imagesize . '"/>'; // pass filesize to images_to_link()
				} else { // internal link to other than images
					$link_html = $label . '(<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>)';
				}
			} else { // external link
				$link_html = $this->rewrite_link($href, __('Link Target', 'ktai_style'), $is_ktai);
				if (is_null($link_html)) {
					$link_html = '<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>';
				}
				$link_html = "{$label}($link_html)";
			}
		} else {
			$link_html = $this->rewrite_link($href, $label, $is_ktai);
		}
		$replace = apply_filters('convert_links/ktai_style.php', $link_html, $orig, $href, $label);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig)); // convert links
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param   string  $href
 * @param	string  $label
 * @param	boolean $is_ktai
 * @return	string  $link_html
 */
public function rewrite_link($href, $label, $is_ktai) {
	global $Ktai_Style;
	$clipped = preg_replace($this->internal_pat, $this->short_links, $href, 1, $is_internal);
	$leave_pat = ks_is_loggedin() ? $this->scheme_pat : $this->leave_pat;
	if ($is_internal) {
		$link_html = '<a href="' . $clipped . '">' . $label . '</a>';
	} elseif (preg_match($this->short_int_pat, $href) 
	       || preg_match($leave_pat, $href)) {
		$link_html = NULL; // leave links
	} else {
		$icon = '<img localsrc="337" alt="' . __('[for PC]', 'ktai_style') . '" />';
		$redir_link = '<a href="' . ks_plugin_url(FALSE) . 'redir.php?url=' . rawurlencode($href) . '">';
		$direct_link = '<a href="' . attribute_escape($href) . '">';
		$colored_label = '<font color="' . ks_option('ks_external_link_color') . '">' . $label . '</font></a>';
		if (ks_is_loggedin()) {
			$link_html = $icon . $redir_link . $colored_label;
		} elseif ($is_ktai || $this->has_mobile_sites($href)) {
			$link_html = $direct_link . $label . '</a>';
		} elseif ($Ktai_Style->is_ktai() == 'DoCoMo' 
		|| $Ktai_Style->is_ktai() == 'KDDI' 
		|| $Ktai_Style->is_ktai() == 'SoftBank') {
			$link_html = $icon . $redir_link . $colored_label;
		} else {
			$link_html = $icon . $direct_link . $colored_label;
		}
		$link_html = apply_filters('external_link/ktai_style.php', $link_html, $href, $label);
	}
	return $link_html;
}

// ==================================================
private function has_mobile_sites($url) {
	try {
		if (preg_match($this->none_mobile_pat, $url)) {
			return FALSE;
		}
		return preg_match($this->mobile_pat, $url);
	} catch (Exception $e)  {
		return FALSE;
		if (preg_match('!^(' . implode('|', self::$none_mobile_url) . ')!', $url)) {
			return FALSE;
		}
		return preg_match('!^(' . implode('|', self::$mobile_same_url) . ')!', $url);
	}
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function convert_images($content) {
	for ($offset = 0, $replace = 'X'; 
	     preg_match('!<img ([^>]*?)src=([\'"])([^\\\\]*?(\\\\.[^\\2\\\\]*?)*)\\2([^>]*?) ?/?>!', $content, $img, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $img[0][0];
		$offset  = $img[0][1];
		$q       = $img[2][0];
		$src     = $img[3][0];
		$attr    = $img[1][0] . $img[5][0];
		$replace = $orig;
		if (preg_match('/local$/', $img[1][0])) { // ezweb pict chars
			continue;
		}
		list($replace, $has_image) = $this->image_to_link($orig, $src, $q, $attr);
		$replace = apply_filters('image_to_link/ktai_style.php', $replace, $orig, $src);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig));
			if ($has_image) {
				$this->added_image();
			}
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param	string  $html
 * @param	string  $src
 * @param	string  $q
 * @param	string  $attr
 * @return	string  $replace
 * @return	boolean $has_image
 */
private function image_to_link($html, $src, $q, $attr) {
	global $Ktai_Style;
	$replace = $html;
	$has_image = FALSE;
	$has_class = preg_match('/class=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $class);
	if (preg_match('/alt=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $a)) {
		$alt = stripslashes($a[2]);
		if (empty($alt) && (! $has_class || ! preg_match('/(^| )(wp-image-\d+)( |$)/', $class[2]))) {
			$replace = ''; // hide images if the alt string is empty. 
			return array($replace, $has_image);
		}
	} else {
		$alt = NULL;
	}
	if (empty($alt)) {
		if (preg_match('/title=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $title)) {
			$alt = stripslashes($title[2]);
		} else {
			$alt = basename(parse_url($src, PHP_URL_PATH));
		}
	}
	if (preg_match('/(width|height)=(([\'"])1\\3|1\b)/', $attr)) {
		$replace = ''; // hide 1 pixel width/height images.
	} elseif ($has_class && preg_match('/(^| )(wp-smiley|ktai)( |$)/', $class[2])) {
		$short_src = preg_replace($this->host_pat, '/', $src);
		$replace = "<img src=$q$short_src$q alt=" . '"' . addslashes($alt) . '" class="' . $class[2] . '" />';
	} elseif (preg_match('!' . PLUGINDIR . '!', $src)) { // plug-in's icon or what
		$replace = "[$alt]";
	} elseif (preg_match('/filesize="(\d*)"/', $attr, $filesize)) { // original image for thumbnail passed by convert_links()
		$cache_size = $Ktai_Style->get('cache_size');
		if ($filesize[1] && $cache_size > 0 && $filesize[1] > $cache_size) {
			$replace = '<font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>]';
		} else {
			$replace = '<a href=' . "$q$src$q" . '>' . $alt . '</a>]';
		}
	} else { // normal image or thumbnail image
		list($img_path, $thumbpath, $thumburl) = array(NULL, NULL, NULL);
		if (preg_match($this->wpurl_pat, $src)) {
			list($img_path, $thumbpath, $thumburl) = $this->check_thumbnail($src, $this->wpurl_pat, ABSPATH, $this->wpurl);
		} elseif (preg_match($this->host_pat, $src) && $_SERVER['DOCUMENT_ROOT']) {
			list($img_path, $thumbpath, $thumburl) = $this->check_thumbnail($src, $this->host_pat, $_SERVER['DOCUMENT_ROOT'] . '/', '/');
		}
		if (defined('KS_SHRINKAGE_DEBUG') && is_array($thumbpath)) {
			$replace = '[[' . $thumbpath[0] . ']]';
		} elseif (ks_is_image_inline() && $thumbpath) {
			$replace = '<img src="' . $thumburl . '" alt="' . $alt . '" />';
			$replace .= preg_match('/has_orig="true"/', $attr) ? '[' : '';
			$has_image = TRUE;
		} else {
			$replace = '[<img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" />';
			if (! $img_path) { // link to a image of external sites
				$replace .= '<a href=' . "$q$src$q" . '>' . $alt . '</a>';
			} elseif (! is_dir($img_path) && $size = @filesize($img_path) && $size <= $Ktai_Style->get('cache_size')) { // link to the image
				$replace .= '<a href=' . "$q$src$q" . '>' . $alt . '</a>';
				$has_image = TRUE;
			} elseif ($thumbpath && $thumburl) { // link to a thumbnail
				$replace .= '<a href=' . "$q$thumburl$q" . '>' . $alt . '</a>';
				$has_image = TRUE;
			} else { // no link to images
				$replace .= '<font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>';
			}
			$replace .= preg_match('/has_orig="true"/', $attr) ? ' | ' : ']';
		}
	}
	return array($replace, $has_image);
}

/* ==================================================
 * @param	string  $img_src
 * @param	string  $url_pat
 * @param	string  $path_pre
 * @param	string  $short_url
 * @return	string  $img_path
 * @return	string  $thumbpath
 * @return	string  $thumburl
 */
private function check_thumbnail($img_src, $url_pat, $path_pre, $short_url) {
	$target = $img_path = preg_replace($url_pat, $path_pre, $img_src);
	$orig = preg_replace('!^(cropped-)?(.*?)(\.thumbnail|-\d+x\d+)(\.[^.]+)?$!', '$2$4', $img_path, 1, $count);
	if ($count && file_exists($orig)) {
		$target = $orig; // Use the original image to make a smaller thumbnail.
	}
	$thumbpath = preg_replace('!(cropped-)?(.*?)(\.thumbnail|-\d+x\d+)?(\.[^.]+)?$!', '$2' . KS_THUMBNAIL_FILENAME .'$4', $img_path, 1);
	if (! file_exists($thumbpath)) {
		$result = $this->create_thumbnail($target, $thumbpath);
	}
	if (is_string($result)) { // Error
        $thumbpath = array($result); // Error message
        $thumburl = NULL;
	} else {
		$thumburl = preg_replace('!^' . preg_quote($path_pre, '!') . '!', $short_url, $thumbpath);
	}
	return array($img_path, $thumbpath, $thumburl);
}

/* ==================================================
 * @param	string  $img_path
 * @param	string  $thumbpath
 * @return	string  $thumbpath
 */
private function create_thumbnail($img_path, $thumbpath) {
	try {
		if (empty($img_path)) {
			throw new Exception('No file name');
		}
		if (! file_exists($img_path)) {
			throw new Exception('No such a file:' . $img_path);
		}		
		$size = getimagesize($img_path);
		if (! $size) {
			throw new Exception('Cannot access to image:' . $img_path);
		}
		$width  = $size[0];
		$height = $size[1];
		$type   = $size[2];
		if ($width <= 0 || $height <= 0) {
			throw new Exception('Zero size image');
		}
		$result = TRUE;
		switch ($type) {
		case IMAGETYPE_GIF:
			$image = @imagecreatefromgif($img_path);
			$other_path = preg_replace('|\.gif$|i', '.png', $img_path);
			if ($image && ! file_exists($other_path)) {
				$result = @imagepng($image, $other_path);
			}
			break;
		case IMAGETYPE_PNG:
			$image = @imagecreatefrompng($img_path);
			$other_path = preg_replace('|\.png$|i', '.gif', $img_path);
			if ($image && ! file_exists($other_path)) {
				$result = @imagegif($image, $other_path);
			}
			break;
		case IMAGETYPE_JPEG:
			$image = @imagecreatefromjpeg($img_path);
			break;
        default:
            throw new Exception(sprintf('Can\'t handle image type "%1$s" of file: %2$s', $size['mime'], $img_path));
            break;
		}
		if (! $image) {
			throw new Exception('Invalid image file: ' . $img_path);
		}
		if (! $result) {
			throw new Exception('Cannot write PNG/GIF image: ' . $other_path);
		}

		if ($width <= KS_THUMBNAIL_MAX_SIZE && $height <= KS_THUMBNAIL_MAX_SIZE) { // No need to make thumbnail
			return $img_path;
		}
		if ($width > $height) {
			$image_ratio = $width / KS_THUMBNAIL_MAX_SIZE;
			$new_width  = KS_THUMBNAIL_MAX_SIZE;
			$new_height = $height / $image_ratio;
		} else {
			$image_ratio = $height / KS_THUMBNAIL_MAX_SIZE;
			$new_height = KS_THUMBNAIL_MAX_SIZE;
			$new_width = $width / $image_ratio;
		}
		$thumbnail = @imagecreatetruecolor($new_width, $new_height);
		if (! $thumbnail) {
			throw new Exception('Thumbnail creation failed');
		}
		if (function_exists('imageantialias')) {
			imageantialias($thumbnail, TRUE);
		}
		if (! imagecopyresampled($thumbnail, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height)) {
			throw new Exception('Resample failed');
		}
	
		// move the thumbnail to it's final destination
		$other_path = NULL;
		switch ($type) {
		case IMAGETYPE_GIF:
			$result = @imagegif($thumbnail, $thumbpath);
			if ($result) {
				$other_path = preg_replace('|\.gif$|i', '.png', $thumbpath);
				$result2 = @imagepng($thumbnail, $other_path);
			}
			break;
		case IMAGETYPE_PNG:
			$result = @imagepng($thumbnail, $thumbpath);
			if ($result) {
				$other_path = preg_replace('|\.png$|i', '.gif', $thumbpath);
				$result2 = @imagegif($thumbnail, $other_path);
			}
			break;
		case IMAGETYPE_JPEG:
		default:
			$result = @imagejpeg($thumbnail, $thumbpath);
			break;
		}
		imagedestroy($thumbnail);
		if (! $result || ! file_exists($thumbpath)) {
			throw new Exception('Thumbnail file not written');
		}
		chmod($thumbpath, 0646);
		if ($other_path && $result2) {
			chmod($other_path, 0646);
		}
		return NULL;
	} catch (Exception $e) {
		return $e->getMessage();
	}
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function shrink_content($content) {
	global $Ktai_Style;
	$content = preg_replace('!<del[^>]*>.*?</del>!s', '', $content);
	$content = preg_replace('!<(script|style)[^>]*>.*?</\\1>!s', '', $content);
	$content = $Ktai_Style->filter_tags($content);
	$content = $this->convert_links($content);
	$content = $this->convert_images($content);
	return $content;
}

/* ==================================================
 * @param	string  $text
 * @param	string  $text
 * Based on wp_trim_excerpt at formatting.php of WP 2.5
 */
function trim_excerpt($text) { // Fakes an excerpt if needed
	if ( '' == $text ) {
		global $Ktai_Style;
		$text = get_the_content('');
		$text = $Ktai_Style->filter_tags($text);
		$text = preg_replace('!<del[^>]*>.*?</del>!s', '', $text);
		$text = str_replace(']]>', ']]&gt;', $text);
		$text = strip_tags($text);
		$excerpt_length = 300;
		if (strlen($text) > $excerpt_length) {
			$text = mb_strcut($text, 0, $excerpt_length) . '[...]';
		}
	}
	return $text;
}

/* ==================================================
 * @param	string  $content
 * @param	array   $tags
 * @param	array   $args
 * @return	string  $content
 */
public function shrink_tag_cloud($content, $tags, $args) {
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1([^>]*?)>(.*?)</a>!', $content, $l, PREG_OFFSET_CAPTURE, $offset); 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$q       = $l[1][0];
		$href    = $l[2][0];
		$attr    = $l[4][0];
		$label   = $l[5][0];
		$replace = $orig;
		preg_match('/ style=([\'"])[^\\\\]*?(\\\\.[^\\1\\\\]*?)*\\1/', $attr, $style);
		$replace = '<a href=' . $q . $href . $q . $style[0] . '>' . $label . '</a>';
		$content = substr_replace($content, $replace, $offset, strlen($orig));
	}
	return $content;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function add_url_inline_image($buffer) {
	global $Ktai_Style;
	if ($Ktai_Style->ktai->get('image_inline_default') == $Ktai_Style->ktai->get('image_inline')) {
		return $buffer;
	}
	$value = ks_is_image_inline() ? 'inline' : 'link';
	$wpcontent_pat = preg_replace('/\)!$/', ')wp-content/!', $this->wpurl_pat);
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a ([^>]*?)href=([\'"])([^\\\\]*?(\\\\.[^\\2\\\\]*?)*)\\2([^>]*?)>!', $buffer, $l, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$q       = $l[2][0];
		$href    = $l[3][0];
		$href    = _quoted_remove_query_arg('img', $href);
		$attr1   = $l[1][0];
		$attr2   = $l[5][0];
		$replace = $orig;
		if (! preg_match($this->url_pat, $href) || preg_match($wpcontent_pat, $href) || preg_match('/id="inline"/', $attr1 . $attr2)) {
			continue;
		}
		$href .= (strpos($href, '?') === FALSE ? '?' : '&amp;' ) . "img=$value";
		$replace = "<a {$attr1}href=$q$href$q$attr2>"; 
		$buffer = substr_replace($buffer, $replace, $offset, strlen($orig)); // convert links		
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function strip_styles_scripts($buffer) {
	$buffer = preg_replace('|<style[^.]*>.*?</style>|s', '', $buffer);
	$buffer = preg_replace('|<script[^.]*>.*?</script>|s', '', $buffer);
	$buffer = preg_replace('|<!--.*?-->|', '', $buffer);
	return $buffer;
}

// ===== End of class ====================
}
?>