<?php
/* ==================================================
 *   Retrieve messages from external mailbox
   ================================================== */

require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';

header('Content-Type: text/html; charset=' . get_bloginfo('charset'));
if (! class_exists('Ktai_Entry')) {
	header("HTTP/1.0 501 Not Implemented");
?>
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HTML><HEAD>
<TITLE>501 Not Implemented</TITLE>
</HEAD><BODY>
<H1>Not Implemented</H1>
The plugin is not activated.
</BODY></HTML>
<?php
	exit;
}

global $Ktai_Entry;
$mail = new Ktai_Entry_Retrieve($Ktai_Entry);
require_once dirname(__FILE__) . '/post.php';
require_once dirname(__FILE__) . '/class-pop3.php';
$count = $mail->connect();
if ($count) {
	$mail->retrieve($count);
}
exit;

/* ==================================================
 *   Ktai_Entry_Retrieve class
   ================================================== */

class Ktai_Entry_Retrieve {
	private $parent;
	private $return_javascript;
	private $post;
	private $pop3;

// ==================================================
public function __construct($parent) {
	$this->parent = $parent;
	$this->return_javascript = FALSE;

	if (! isset($_SERVER['HTTP_HOST'])) {
		return;
	}
	if (! isset($_GET['_wpnonce'])) {
		$this->return_javascript = TRUE;
		header('Content-Type: text/javascript; charset=UTF-8');
		if (! $this->check_interval()) {
			exit;
		}
		echo "/* \n";
	} elseif (! $this->verify_nonce($_GET['_wpnonce'], 'ktai-entry-retrieve')) {
		$this->http_error(400, 'Your request could not be understood by the server due to malformed syntax.');
		// exit;
	}
}

/* ==================================================
 * @param	none
 * @return	boolean  $succeeded
 */
public function check_interval() {
	$last_checked = get_option('ke_last_checked');
	$interval     = apply_filters('retrieve_interval/ktai_entry.php', $this->parent->get_option('ke_retrieve_interval'));
	if ($interval < 1 || $last_checked < 0 || $interval * 60 > (time() - $last_checked)) {
		return FALSE;
	}
	update_option('ke_last_checked', time());
	return TRUE;
}

// ==================================================
public function connect() {
	$server_url   = get_option('mailserver_url');
	$server_port  = get_option('mailserver_port');
	$server_login = get_option('mailserver_login');
	$server_pass  = get_option('mailserver_pass');

	// Do nothing if default value
	if (empty($server_url) || $server_url == 'mail.example.com'
		|| $server_port <= 0
		|| empty($server_login) || $server_login == 'login@example.com'
		|| $server_pass == 'password'
		) {
		$this->http_error(502, 'The POP3 config is not valid.');
		// exit;
	}

	$this->post = new Ktai_Entry_Post('pop3');
	$this->pop3 = new POP3();
	$this->pop3->ALLOWAPOP = $this->post->get_option('ke_use_apop');
	if (! $this->pop3->connect($server_url, $server_port)) {
		$this->http_error(502, $this->pop3->ERROR);
	}
	if ($this->post->get_option('ke_use_apop')) {
		$count = $this->pop3->apop($server_login, $server_pass);
	} else {
		$count = $this->pop3->login($server_login, $server_pass);
	}

	if (FALSE === $count || $count < 0) {
		$error = $this->pop3->ERROR;
		$this->pop3->quit();
		$this->http_error(502, $error);
		// exit;
	} elseif (0 == $count) {
		$this->pop3->quit();
		$this->display("There doesn't seem to be any new mail.");
		return $count;
	}
	$this->display("***************************\nThere is $count message(s).");
	return $count;
}

// ==================================================
public function retrieve($count) {
	for ($i=1; $i <= $count; $i++) :
		$lines = $this->pop3->get($i);
		$contents = $this->post->parse(str_replace("\r\n", "\n", implode('', $lines)));
		if (is_ktai_error($contents)) {
			$this->display("Error at #$i: " . $contents->getMessage());
			continue;
		}
		$result = $this->post->insert($contents);
		if (is_ktai_error($result)) {
			$this->display("Error at #$i: " . $result->getMessage());
			continue;
		}
		if (! $this->pop3->delete($i)) {
			$error = $this->pop3->ERROR;
			$this->pop3->reset();
			$this->display("Can't delete message #$i: $error");
			break;
		} else {
			$this->display("Mission complete, message '$i' deleted.");
		}
	endfor;

	$this->pop3->quit();
	if ($this->return_javascript) {
		echo "*/\n";
	}
	return;
}

/* ==================================================
 * @param	string     $nonce
 * @param	string|int $action
 * @return	boolean    $result
 * based on wp_verify_nonce at wp-includes/pluggable.php at WP 2.5
 */
private function verify_nonce($nonce, $action = -1) {
	$i = ceil(time() / 43200);
	// Nonce generated 0-12 hours ago
	if ( substr(wp_hash($i . $action), -12, 10) == $nonce )
		return 1;
	// Nonce generated 12-24 hours ago
	if ( substr(wp_hash(($i - 1) . $action), -12, 10) == $nonce )
		return 2;
	// Invalid nonce
	return false;
}

/* ==================================================
 * @param	string   $message
 * @return	none
 */
private function display($message) {
	$this->parent->logging($message);
	if ($this->return_javascript) {
		$message = str_replace('*/', '* /', $message);
		echo mb_convert_encoding($message, 'UTF-8', get_bloginfo('charset')) . "\n";
	} else {
		echo str_replace("\n", '<br />', wp_specialchars($message)) . '<br />';
	}
	return;
}

/* ==================================================
 * @param	int      $code
 * @param	string   $message
 * @return	none
 */
public function http_error($code, $message) {
	if ($this->return_javascript) {
		echo "*/\n";
		exit ($code);
	}
	$this->parent->http_error($code, $message);
	// exit;
}

// ===== End of class ====================
}
?>