<?php
/* ==================================================
 *   Retrieve messages from external mailbox
   ================================================== */

require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';

header('Content-Type: text/html; charset=' . get_bloginfo('charset'));
if (! class_exists('Ktai_Entry')) {
	header("HTTP/1.0 501 Not Implemented");
?>
<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<HTML><HEAD>
<TITLE>501 Not Implemented</TITLE>
</HEAD><BODY>
<H1>Not Implemented</H1>
The plugin is not activated.
</BODY></HTML>
<?php
	exit;
}

global $Ktai_Entry;
$Retrieve = new Ktai_Entry_Retrieve($Ktai_Entry);

/* ==================================================
 *   Ktai_Entry_Retrieve class
   ================================================== */

class Ktai_Entry_Retrieve {
	private $parent;

// ==================================================
public function __construct($parent) {
	$this->parent = $parent;

	if (isset($_SERVER['HTTP_HOST']) 
	&& (! isset($_GET['_wpnonce']) 
	 || ! $this->verify_nonce($_GET['_wpnonce'], 'ktai-entry-retrieve'))) {
		$this->parent->http_error(400, 'Your request could not be understood by the server due to malformed syntax.');
		// exit;
	}

	$server_url   = get_option('mailserver_url');
	$server_port  = get_option('mailserver_port');
	$server_login = get_option('mailserver_login');
	$server_pass  = get_option('mailserver_pass');

	// Do nothing if default value
	if (empty($server_url) || $server_url == 'mail.example.com'
		|| $server_port <= 0
		|| empty($server_login) || $server_login == 'login@example.com'
		|| $server_pass == 'password'
		) {
		$this->parent->http_error(502, 'The POP3 config is not valid.');
		// exit;
	}

	require_once dirname(__FILE__) . '/post.php';
	$post = new Ktai_Entry_Post('pop3');
	require_once dirname(__FILE__) . '/class-pop3.php';
	$pop3 = new POP3();
	$pop3->ALLOWAPOP = $post->get_option('ke_use_apop');
	if (! $pop3->connect($server_url, $server_port)) {
		$this->parent->http_error(502, $pop3->ERROR);
	}
	if ($post->get_option('ke_use_apop')) {
		$count = $pop3->apop($server_login, $server_pass);
	} else {
		$count = $pop3->login($server_login, $server_pass);
	}

	if (FALSE === $count) {
		$error = $pop3->ERROR;
		$pop3->quit();
		$this->parent->http_error(502, $error);
	} elseif (0 == $count) {
		$pop3->quit();
		$this->display("There doesn't seem to be any new mail.");
		return;
	}

	$this->display("***************************\nThere is $count message(s).");
	for ($i=1; $i <= $count; $i++) :
		$lines = $pop3->get($i);
		$contents = $post->parse(str_replace("\r\n", "\n", implode('', $lines)));
		if (is_ktai_error($contents)) {
			$this->display("Error at #$i: " . $contents->getMessage());
			continue;
		}
		$result = $post->insert($contents);
		if (is_ktai_error($result)) {
			$this->display("Error at #$i: " . $result->getMessage());
			continue;
		}
		if (! $pop3->delete($i)) {
			$error = $pop3->ERROR;
			$pop3->reset();
			$this->parent->http_error(502, $error);
		} else {
			$this->display("Mission complete, message '$i' deleted.");
		}
	endfor;

	$pop3->quit();
	return;
}

/* ==================================================
 * @param	string     $nonce
 * @param	string|int $action
 * @return	boolean    $result
 * based on wp_verify_nonce at wp-includes/pluggable.php at WP 2.5
 */
private function verify_nonce($nonce, $action = -1) {
	$i = ceil(time() / 43200);
	// Nonce generated 0-12 hours ago
	if ( substr(wp_hash($i . $action), -12, 10) == $nonce )
		return 1;
	// Nonce generated 12-24 hours ago
	if ( substr(wp_hash(($i - 1) . $action), -12, 10) == $nonce )
		return 2;
	// Invalid nonce
	return false;
}

/* ==================================================
 * @param	string   $message
 */
private function display($message) {
	$this->parent->logging($message);
	echo str_replace("\n", '<br />', $message) . '<br />';
	return;
}

// ===== End of class ====================
}
?>