<?php

/* ==================================================
 *   Ktai_Entry_Post class
   ================================================== */

// ----- Settings -------------------------
define('KE_SET_CATEGORY',        'CAT:');
define('KE_ADD_CATEGORY',        'CAT+');
define('KE_CHANGE_CATEGORY',     'CAT>');
define('KE_ADD_CHANGE_CATEGORY', 'CAT+>');
define('KE_SET_TAGS',            'TAG:');
define('KE_ROTATE_IMAGE',        'ROT:');
define('KE_DELIM_STR',           '-- ');

define('KE_IMAGES_HEADER', '<div class="photo">');
define('KE_IMAGES_FOOTER', "</div>\n");
define('KE_TEXT_HEADER', '<p>');
define('KE_TEXT_FOOTER', "</p>\n<div class=\"photo-end\"> </div>");

// ----- Remove filters of Change Max Thumbnail Length (http://www.yuriko.net/arc/2008/03/27d)
if (defined('MY_THUMBNAIL_MAX_SIDE_LENGTH')) {
	remove_filter('wp_thumbnail_max_side_length', array('Change_Thumb_Max_Length', 'decide_length'));
	remove_filter('wp_thumbnail_max_side_length', 'change_thumb_max_length', 10, 3);
}

/* ----- CSS code for style.css -----
.photo {
	padding-right:6px;
	float:left;
	line-height:110%;
	font-size:0.85em;
	text-indent:0;
}
.photo img {
	background:white;
	margin:0 4px 4px 0;
	padding:3px;
	border:1px solid #999;
}
.photo-end {
	clear:left;
}
---------- */
// ----- End of settings

/* ==================================================
 *   Ktai_Entry_Post class
   ================================================== */

class Ktai_Entry_Post extends Ktai_Entry {
	private $type;

/* ==================================================
 * @param	string   $type
 * @return	object   $this
 */
public function __construct ($type = 'pop3') {
	$this->type = $type;
	
	$level = error_reporting(2037);
	require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-admin/admin-functions.php';
	if (! include_once 'Mail/mimeDecode.php') { // try to use PEAR in the server.
		require_once dirname(__FILE__) . '/Mail_mimeDecode.php'; // If not, use local version
	}
	error_reporting($level);

	add_filter('wp_thumbnail_max_side_length', create_function('$size,$id,$file', 'return ' . intval($this->get_option('ke_thumb_size')) . ';'), 10, 3);
	add_filter('wp_create_thumbnail', create_function('$path', 'chmod($path, 0666); return $path;'), 10);
	
	global $allowedposttags, $allowedtags;
	if (! defined('CUSTOM_TAGS')) {
		define('CUSTOM_TAGS', true);
	}
	if (! CUSTOM_TAGS) {
		$allowedposttags = array (
			'address' => array (), 
			'a' => array ('href' => array (), 'title' => array (), 'rel' => array (), 'rev' => array (), 'name' => array ()), 
			'abbr' => array ('title' => array ()), 
			'acronym' => array ('title' => array ()), 'b' => array (), 'big' => array (), 
			'blockquote' => array ('cite' => array ()), 
			'br' => array ('class' => array ()), 
			'button' => array ('disabled' => array (), 'name' => array (), 'type' => array (), 'value' => array ()), 
			'caption' => array ('align' => array ()), 
			'code' => array (), 
			'col' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'span' => array (), 'valign' => array (), 'width' => array ()), 
			'del' => array ('datetime' => array ()), 
			'dd' => array (), 
			'div' => array ('align' => array (), 'class' => array()), 
			'dl' => array (), 
			'dt' => array (), 
			'em' => array (), 
			'fieldset' => array (), 
			'font' => array ('color' => array (), 'face' => array (), 'size' => array ()), 
			'form' => array ('action' => array (), 'accept' => array (), 'accept-charset' => array (), 'enctype' => array (), 'method' => array (), 'name' => array (), 'target' => array ()), 
			'h1' => array ('align' => array ()), 
			'h2' => array ('align' => array ()), 
			'h3' => array ('align' => array ()), 
			'h4' => array ('align' => array ()), 
			'h5' => array ('align' => array ()), 
			'h6' => array ('align' => array ()), 
			'hr' => array ('align' => array (), 'noshade' => array (), 'size' => array (), 'width' => array ()), 
			'i' => array (), 
			'img' => array ('alt' => array (), 'align' => array (), 'border' => array (), 'class' => array(), 'height' => array (), 'hspace' => array (), 'localsrc' => array (), 'longdesc' => array (), 'vspace' => array (), 'src' => array (), 'width' => array ()), 
			'ins' => array ('datetime' => array (), 'cite' => array ()), 
			'kbd' => array (), 
			'label' => array ('for' => array ()), 
			'legend' => array ('align' => array ()), 
			'li' => array (), 
			'p' => array ('align' => array (), 'class' => array()), 
			'pre' => array ('width' => array ()), 
			'q' => array ('cite' => array ()), 
			's' => array (), 
			'strike' => array (), 
			'strong' => array (), 
			'sub' => array (), 
			'sup' => array (), 
			'table' => array ('align' => array (), 'bgcolor' => array (), 'border' => array (), 'cellpadding' => array (), 'cellspacing' => array (), 'rules' => array (), 'summary' => array (), 'width' => array ()), 
			'tbody' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 
			'td' => array ('abbr' => array (), 'align' => array (), 'axis' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'colspan' => array (), 'headers' => array (), 'height' => array (), 'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 'valign' => array (), 'width' => array ()), 
			'textarea' => array ('cols' => array (), 'rows' => array (), 'disabled' => array (), 'name' => array (), 'readonly' => array ()), 
			'tfoot' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 
			'th' => array ('abbr' => array (), 'align' => array (), 'axis' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'colspan' => array (), 'headers' => array (), 'height' => array (), 'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 'valign' => array (), 'width' => array ()), 
			'thead' => array ('align' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 
			'title' => array (), 
			'tr' => array ('align' => array (), 'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 'valign' => array ()), 
			'tt' => array (), 
			'u' => array (), 
			'ul' => array (), 
			'ol' => array (), 
			'var' => array () 
		);

		$allowedtags = array ('a' => array ('href' => array (), 'title' => array ()), 'abbr' => array ('title' => array ()), 'acronym' => array ('title' => array ()), 'b' => array (), 'blockquote' => array ('cite' => array ()),
			//	'br' => array(),
		'code' => array (),
			//	'del' => array('datetime' => array()),
			//	'dd' => array(),
			//	'dl' => array(),
			//	'dt' => array(),
		'em' => array (), 'i' => array (),
			//	'ins' => array('datetime' => array(), 'cite' => array()),
			//	'li' => array(),
			//	'ol' => array(),
			//	'p' => array(),
			//	'q' => array(),
		'div' => array ('align' => array (), 'class' => array()), 
		'img' => array ('alt' => array (), 'align' => array (), 'border' => array (), 'class' => array(), 'height' => array (), 'hspace' => array (), 'localsrc' => array (), 'longdesc' => array (), 'vspace' => array (), 'src' => array (), 'width' => array ()),
		'p' => array ('align' => array (), 'class' => array()), 
 		'strike' => array (), 'strong' => array (),
			//	'sub' => array(),
			//	'sup' => array(),
			//	'u' => array(),
			//	'ul' => array(),
		);
	}
}

/* ==================================================
 * @param	string   $message
 * @param	int      $error
 * @return	nonne
 */
private function error($message, $error = 100) {
	$this->debug_print($message);
	if ($this->type == 'pop3') {
		return $message;
	} else {
		echo $message;
		exit($error);
	}
}

/* ==================================================
 * @param	string   $input
 * @return	array    $contents
 */
public function parse($input) {
	global $allowedposttags, $allowedtags;

	$structure = $this->decode_message($input);
	if (is_email($this->get_option('ke_posting_addr'))) {
		$recipients = $this->read_recipients($structure);
		if (! in_array($this->get_option('ke_posting_addr'), $recipients)) {
			return $this->error("Error: Invalid recipient address.\n", 100);
		}
	}
	$from = $this->read_sender($structure);
	if (! $from) {
		return $this->error("Error: No sender address found.\n", 100);
	}
	$post_author = $this->validate_address($from);
	if (! $post_author) {
		return $this->error('Error: Sender address is not registered: ' . $from . "\n", 100);
	}
	$user = set_current_user($post_author);
	if (current_user_can('publish_posts')) {
		$post_status    = 'publish';
	} elseif (version_compare($this->get_wp_version(), 2.3, '>=')) {
		$post_status    = 'pending';
	} else {
		$post_status    = 'draft';
	}
	$time_difference = get_option('gmt_offset');
	$post_time_gmt = strtotime(trim($structure->headers['date']));
	if (! $post_time_gmt) {
		return $this->error('Error: There is no Date: field.' . "\n", 100);
	} elseif ($this->check_duplication($post_time_gmt)) {
		return $this->error('Error: The mail at "' . $structure->headers['date'] . '" was already posted.' . "\n", 100);
	}

	$contents = $this->get_mime_parts($structure);
	$contents->from            = $from;
	$contents->post_time_gmt   = $post_time_gmt;
	$contents->post_time_local = $post_time_gmt + ($time_difference * 3600);
	$post_title    = xmlrpc_getposttitle($content_text);
	if (! $post_title) {
		$subject = mb_convert_encoding($structure->headers['subject'], get_option('blog_charset'), 'auto');
		$post_title = trim(str_replace(get_option('subjectprefix'), '', $subject));
	}
	$contents->post_title  = $post_title;
	$contents->post_author = $post_author;
	$contents->post_status = $post_status;
	return $contents;
}

/* ==================================================
 * @param	array    $contents
 * @return	none
 * based on wp-mail.php of WordPress 2.0.5
 */
public function insert($contents) {
	global $wpdb;
	$post = get_default_post_to_edit();
	$this->chop_signature($contents);
	$post_category  = $this->decide_category($contents);
	$tags_input     = $this->decide_keywords($contents);
	$rotations      = $this->decide_rotations($contents);
	$post_date      = gmdate('Y-m-d H:i:s', $contents->post_time_local);
	$post_date_gmt  = gmdate('Y-m-d H:i:s', $contents->post_time_gmt);
	$post_name      = gmdate('His', $contents->post_time_local);
	$post_title     = $contents->post_title;
	$post_author    = $contents->post_author;
	$post_status    = $contents->post_status;
	$comment_status = $post->comment_status;
	$ping_status    = $post->ping_status;
	$post_content   = apply_filters('phone_content', $contents->text);

	$post_data = compact('post_title', 'post_name', 'post_date', 'post_date_gmt', 'post_author', 'post_category', 'tags_input', 'post_status', 'comment_status', 'ping_status', 'post_content');
	$post_data = add_magic_quotes($post_data);
	if (defined('KE_DEBUG') && $this->type == 'pop3') {
		$poster_info = get_userdata($post_author);
		print "From    : {$contents->from}\n";
		print "Author  : {$poster_info->user_nicename} (ID: " . $post_data['post_author'] . ")\n";
		print "Date    : " . $post_data['post_date'] . "\n";
		print "Date GMT: " . $post_data['post_date_gmt'] . "\n";
		print "Category: " . implode(', ', array_map('get_catname', $post_data['post_category'])) . "\n";
		print "Title   : ". $post_data['post_title'] . "\n";
		print "------------------------------\n" . $post_data['post_content'] . "\n------------------------------\n";
		return $this->error('', 99);
	}

	$post_ID = wp_insert_post($post_data);
	if (! $post_ID) {
		return $this->error("we couldn't post, for whatever reason.\n", 100);
	}

	if (count($contents->images))  {
		$image_ids = $this->upload_images($contents, $rotations, $post_ID);
		$post = get_post($post_ID);
		$content = $this->images_to_html($post->post_content, $image_ids);
		$content = apply_filters('phone_content', $content);
		$post_data['ID'] = $post_ID;
		$post_data['post_content'] = $wpdb->escape($content);
		wp_update_post($post_data);
	}

	do_action('publish_phone', $post_ID);
	return 0;
}

/* ==================================================
 * @param	string   $message
 * @return	object   $structure
 */
private function decode_message($message) {
	$params['include_bodies'] = true;
	$params['decode_bodies']  = true;
	$params['decode_headers'] = true;
	$params['input'] = $message;
	$structure = Mail_mimeDecode::decode($params);
	return $structure;
}

/* ==================================================
 * @param	string   $field
 * @return	array    $addresses
 */
private function pickup_rfc2822_address($field) {
	$addresses = array();
	$quoted    = array();
	// ----- save quoted text -----
	while (1) {
		preg_match('/(^|[^\\\\])("([^\\\\"]|\\\\.)*")/', $field, $m);
		if (! $m[2]) {
			break;
		}
		$field = preg_replace("/(^|[^\\\\])$m[2]/", "$1\376\376\376" . count($quoted) . "\376\376\376", $field, 1);
		$quoted[] = $m[2];
	}
	// ---- remove comments -----
	$field = preg_replace('/\([^)]*[^\\\\]\)/', '', $field);
	// ----- remove group name -----
	$field = preg_replace('/[-\w ]+:([^;]*);/', '$1', $field);
	// ----- split into each address -----
	foreach (explode(',', $field) as $a) {
		$a = str_replace(' ', '', $a);
		preg_match('/<([^>]*)>/', $a, $m);
		if ($m[1]) {
			$a = $m[1];
		}
		// ----- restore quoted text -----
		$a = preg_replace('/\376\376\376(\d+)\376\376\376/e', '$quoted[$1]', $a);
		// ----- got address -----
		if ($a) {
			$addresses[] = $a;
		}
	}
	return $addresses;
}

/* ==================================================
 * @param	object   $structure
 * @return	string   $sender
 */
private function read_sender($structure) {
	$senders = $this->pickup_rfc2822_address(trim($structure->headers['from']));
	$sender = $senders[0];
	if (! $sender) {
		$senders = $this->pickup_rfc2822_address($_ENV['SENDER']);
		$sender = $senders[0];
	}
	return $sender;
}

/* ==================================================
 * @param	object   $structure
 * @return	array    $recipients
 */
private function read_recipients($structure) {
	$recipients = $this->pickup_rfc2822_address(trim($structure->headers['to'])) 
	            + $this->pickup_rfc2822_address(trim($structure->headers['cc']));
	return $recipients;
}

/* ==================================================
 * @param	string   $sender
 * @return	int      $user_id
 */
private function validate_address($sender) {
	global $wpdb;
	$email4sql = $wpdb->escape($sender);
	$result = $wpdb->get_var("SELECT ID FROM {$wpdb->users} WHERE user_email = '$email4sql' LIMIT 1");
	if (! $result) {
		return NULL;
	}
	return $result;
}

/* ==================================================
 * @param	string   $post_time_gmt
 * @return	int      $ID
 */
private function check_duplication($post_time_gmt) {
	global $wpdb;
	$time4sql = gmdate('Y-m-d H:i:s', $post_time_gmt);
	$result = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_date_gmt = '$time4sql' LIMIT 1");
	return $result;
}

/* ==================================================
 * @param	object   $part
 * @return	array    $contents
 */
private function get_mime_parts($part) {
	$contents = new stdClass;
	$contents->text = '';
	$contents->images = array();
	switch (strtolower($part->ctype_primary)) {
		case 'multipart':
			foreach ($part->parts as $p) {
				$part_content = $this->get_mime_parts($p);
				$contents->text .= $part_content->text;
				$contents->images = array_merge($contents->images, $part_content->images);
			}
			break;
		case 'text':
			if ($part->ctype_secondary == 'plain') {
				$text = trim($part->body);
			} elseif ($part->ctype_secondary == 'html') {
				$text = trim(strip_tags($part->body));
			}
			$contents->text .= mb_convert_encoding($text, get_option('blog_charset'), 'auto');
			break;
		case 'image':
			$name = $part->d_parameters['filename'] ? $part->d_parameters['filename'] : $part->ctype_parameters['name'];
			$contents->images[] = array($name, $part->ctype_secondary, $part->body);
			break;
	}		
	return $contents;
}

/* ==================================================
 * @param	string   $mime_type
 * @return	int      $type
 */
private function mimetype2imagetype ($mime_type) {
	switch('image/' . $mime_type) {
	case image_type_to_mime_type(IMAGETYPE_GIF):
		$type = IMAGETYPE_GIF;
		break;
	case image_type_to_mime_type(IMAGETYPE_JPEG):
		$type = MAGETYPE_JPEG;
		break;
	case image_type_to_mime_type(IMAGETYPE_PNG):
		$type = IMAGETYPE_PNG;
		break;
	case image_type_to_mime_type(IMAGETYPE_PSD):
		$type = IMAGETYPE_PSD;
		break;
	case image_type_to_mime_type(IMAGETYPE_BMP):
		$type = IMAGETYPE_BMP;
		break;
	case image_type_to_mime_type(IMAGETYPE_JP2):
		$type = IMAGETYPE_JP2;
		break;
	case image_type_to_mime_type(IMAGETYPE_BMP):
		$type = IMAGETYPE_BMP;
		break;
	case image_type_to_mime_type(IMAGETYPE_IFF):
		$type = IMAGETYPE_IFF;
		break;
	case image_type_to_mime_type(IMAGETYPE_WBMP):
		$type = IMAGETYPE_WBMP;
		break;
	case image_type_to_mime_type(IMAGETYPE_XBM):
		$type = IMAGETYPE_XBM;
		break;
	default:
		$type = 0;
	}
	return $type;
}

/* ==================================================
 * @param	array    $contents
 * @return	array    $categories
 */
private function decide_category(&$contents) {
	$categories = array();
	if (preg_match('/^' . preg_quote(KE_SET_CATEGORY) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '\r?\n/m', '', $contents->text, 1);
		$categories = $this->cat_name2id($m[1]);
	} elseif (preg_match('/^' . preg_quote(KE_ADD_CATEGORY) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '\r?\n/m', '', $contents->text, 1);
		$categories = $this->cat_name2id($m[1]);
		array_unshift($categories, get_option('default_email_category'));
	}
	if (preg_match('/^(' . preg_quote(KE_CHANGE_CATEGORY, '/') . '|(' . preg_quote(KE_ADD_CHANGE_CATEGORY, '/') . '))(.*)$/m', $contents->text, $m)) {
		$contents->text = preg_replace('/^' . preg_quote($m[0], '/') . '\r?\n/m', '', $contents->text, 1);
		$cats = $this->cat_name2id($m[3]);
		$cat_change = $cats[0];
		$categories = array_merge($categories, $cats);
		if ($m[2]) {
			array_unshift($categories, get_option('default_email_category'));
		}
	} 
	if (count($categories) < 1) {
		$categories[] = get_option('default_email_category');
	}
	return $categories;
}

/* ==================================================
 * @param	string   $cat_names
 * @return	array    $categories
 */
private function cat_name2id($cat_names) {
	$categories = array();
	foreach (explode(',', $cat_names) as $c) {
		$c = trim($c);
		if (is_numeric($c)) {
			$c = intval($c);
		} else {
			$c = get_cat_ID($c);
		}
		if ($c) {
			$categories[] = $c;
		}
	}
	return $categories;
}

/* ==================================================
 * @param	array    $contents
 * @return	string   $keywords
 */
private function decide_keywords(&$contents) {
	$keywords = '';
	if (preg_match('/^' . preg_quote(KE_SET_TAGS) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '\r?\n/m', '', $contents->text, 1);
		$keywords = $m[1];
	}
	return $keywords;
}

/* ==================================================
 * @param	array    $contents
 * @return	array    $rotations
 */
private function decide_rotations(&$contents) {
	if (preg_match('/^' . preg_quote(KE_ROTATE_IMAGE) . '(.*)$/m', $contents->text, $m) ) {
		$contents->text = preg_replace('/^' . preg_quote($m[0]) . '\r?\n/m', '', $contents->text, 1);
		$rotations = $this->parse_rotation(strtoupper($m[1]), count($contents->images));
	} else {
		$rotations = $this->parse_rotation('', count($contents->images));
	}
	return $rotations;
}

/* ==================================================
 * @param	string   $rotations
 * @param	int      $num_images
 * @return	array    $rotations
 */
private function parse_rotation($rot_desc, $num_images) {
	if ($num_images < 1) {
		return NULL;
	}
	// ----- Single 'L' or 'R' means rotating all image to the same direction.
	if ($rot_desc == 'L' || $rot_desc == 'R' || $rot_desc == 'N') {
		$rotations = array_fill(0, $num_images, $rot_desc);
	// ----- Continuous of 'N', 'L', or 'R' string means rotating each image to such direction.
	} elseif (preg_match('/^[NLR]+$/', $rot_desc)) {
		$rotations = str_split($rot_desc) + array_fill(0, $num_images, 'N');
	// ----- Number and 'L'/'R' means to rotate the numbered images to the desired direction.
	} elseif (preg_match('/^(\d+[LR])+/', $rot_desc)) {
		$rotations = array_fill(0, $num_images, 'N');
		preg_match_all('/(\d+)([LR])/', $rot_desc, $m, PREG_SET_ORDER);
		foreach ($m as $n) {
			$rotations[$n[1] -1] = $n[2];
		}
	// ----- Default is no rotation.
	} else {
		$rotations = array_fill(0, $num_images, 'N');
	}
	return $rotations;
}

/* ==================================================
 * @param	object   $contents
 * @return	none
 */
private function chop_signature(&$contents) {
	if (defined('KE_DELIM_STR')) {
		$text = $contents->text;
		$sig_match = strripos($text, "\n" . KE_DELIM_STR);
		if ($sig_match > 0) {
			$text = substr($text, 0, $sig_match);
		}
		$contents->text = $text;
	}
	return;
}

/* ==================================================
 * @param	object   $contents
 * @param	array    $rotations
 * @param	int      $post_id
 * @return	array    $image_ids
 * based on wp_handle_upload() at wp-admin/includes/file.php of WP 2.5
 */
private function upload_images($contents, $rotations, $post_id = 0) {
	if (count($contents->images) < 1) {
		return NULL;
	}
	$image_ids = array();
	foreach ($contents->images as $count => $img) {
		if ( ! ( ( $uploads = wp_upload_dir() ) && false === $uploads['error'] ) ) {
			$this->debug_print(@$uploads['error']);
			return;
		}
		$filename = $this->unique_filename($uploads['path'], $img[0]);
		$new_file = $uploads['path'] . "/$filename";
		$type = $this->mimetype2imagetype($img[1]);
		if (! $this->save_image($new_file, $type, $img[2],  @$rotations[$count])) {
			$this->debug_print(sprintf('The uploaded file could not be moved to %s.', $new_file));
			return;
		}

		$url = $uploads['url'] . "/$filename";
		$file = apply_filters('wp_handle_upload', array('file' => $new_file, 'url' => $url, 'type' => "image/{$img[1]}"));

		$url  = $file['url'];
		$type = $file['type'];
		$file = $file['file'];
		$title = preg_replace('/\.[^.]+$/', '', basename($file));
		$content = '';

		if ( function_exists('wp_read_image_metadata') 
		 && $image_meta = @wp_read_image_metadata($file) ) {
			if ( trim($image_meta['title']) )
				$title = $image_meta['title'];
			if ( trim($image_meta['caption']) )
				$content = $image_meta['caption'];
		}

		$attachment = array(
			'post_mime_type' => $type,
			'guid'           => $url,
			'post_parent'    => $post_id,
			'post_title'     => $title,
			'post_content'   => $content,
			'post_excerpt'   => ($content ? $content : basename($file)),
		);

		$id = wp_insert_attachment($attachment, $file, $post_id);
		if ((function_exists('is_wp_error') && is_wp_error($id)) || $id <= 0) {
			$this->debug_print(sprintf('Failed inserting attachment for post#%d: %s', $post_id,  $file));
		} else {
			if (function_exists('wp_generate_attachment_metadata')) {
				wp_update_attachment_metadata($id, wp_generate_attachment_metadata($id, $file));
			} else {
				$this->update_attachment_metadata($attachment, $id, $file);
			}
			$image_ids[] = $id;
		}
	}
	return $image_ids;
}


/* ==================================================
 * @param	string   $dir
 * @param	string   $filename
 * @param	string   $new_file
 */
// If $file is exists, change filename to $file_2, $file_3, ...
private function unique_filename($dir, $filename) {
	$parts = pathinfo($filename);
	$ext = $parts['extension'];
	$name = preg_replace("/\.{$ext}\$/", '', $parts['basename']);
	$name = preg_replace('/[^-_.~+a-zA-Z0-9]/', '', $name);
	$count = '';
	while (file_exists("$dir/$name$count.$ext")) {
		$count = $count ? preg_replace('/(\d+)/e', "intval('$1') + 1", $count) : "_2";
	}
	return "$name$count.$ext";
}

/* ==================================================
 * @param	string   $filepath
 * @param	int      $type
 * @param	string   $image_string
 * @param	string   $rotation
 * @return	boolean  $result
 */
private function save_image($filepath, $type, $image_string, $rotation) {
	$image  = imagecreatefromstring($image_string);
	$width  = imagesx($image);
	$height = imagesy($image);
	if ($rotation != 'L' && $rotation != 'R') {
		$fp = fopen($filepath, 'w');
		fwrite($fp, $image_string);
		fclose($fp);
		chmod($filepath, 0666);
	} else {
		$rotated = $this->rotate_image($image, $type, $rotation, $filepath);
		imagedestroy($rotated);
	}
	imagedestroy($image);
	return TRUE;
}

/* ==================================================
 * @param	resource $image
 * @param	int      $type
 * @param	string   $direction
 * @param	string   $filepath
 * @return	resource $rotated
 */
private function rotate_image($image, $type, $direction, $filepath) {	
	$angle = $direction == 'L' ? 90: 270;
	$rotated = imagerotate($image, $angle, 0);
	switch ($type) {
	case IMAGETYPE_GIF:
		$result = imagegif($rotated, $filepath);
		break;
	case IMAGETYPE_PNG:
		$result = imagepng($rotated, $filepath);
		break;
	case IMAGETYPE_JPEG:
	default:
		$result = imagejpeg($rotated, $filepath);
		break;
	}
	if (! $result || ! file_exists($filepath)) {
		return NULL;
	}
	chmod($filepath, 0666);
	return $rotated;
}

/* ==================================================
 * @param	object   $attachment
 * @param	int      $id
 * @param	string   $file
 * @return	object   $this
 * based on line 78-105 at inline-uploading.php of WP ME 2.0.11
 */
private function update_attachment_metadata($attachment, $id, $file) {
	if ( preg_match('!^image/!', $attachment['post_mime_type']) ) {
		// Generate the attachment's postmeta.
		$imagesize = getimagesize($file);
		$imagedata['width'] = $imagesize['0'];
		$imagedata['height'] = $imagesize['1'];
		list($uwidth, $uheight) = get_udims($imagedata['width'], $imagedata['height']);
		$imagedata['hwstring_small'] = "height='$uheight' width='$uwidth'";
		$imagedata['file'] = $file;

		add_post_meta($id, '_wp_attachment_metadata', $imagedata);

		$max_length = intval($this->get_option('ke_thumb_size'));
		if ($max_length < 10) {
			$max_length = 128;
		}
		if ( $imagedata['width'] * $imagedata['height'] < 3 * 1024 * 1024 ) {
			if ( $imagedata['width'] > $max_length 
			&& $imagedata['width'] >= $imagedata['height'] * 4 / 3 )
				$thumb = wp_create_thumbnail($file, $max_length);
			elseif ( $imagedata['height'] > $max_length )
				$thumb = wp_create_thumbnail($file, $max_length);

			if ( @file_exists($thumb) ) {
				chmod($thumb, 0666);
				$newdata = $imagedata;
				$newdata['thumb'] = basename($thumb);
				update_post_meta($id, '_wp_attachment_metadata', $newdata, $imagedata);
			} else {
				$error = $thumb;
			}
		}
	} else {
		add_post_meta($id, '_wp_attachment_metadata', array());
	}
}

/* ==================================================
 * @param	array    $html
 * @param	array    $image_ids
 * @return	string   $html
 */
private function images_to_html($content, $image_ids) {
	if (is_array($image_ids) && count($image_ids)) {
		$img = array();
		if (function_exists('wp_get_attachment_link')) {
			$link_func = 'wp_get_attachment_link';
			$size      = ($this->get_option('ke_thumb_size') == 'medium') ? 'medium' : 'thumbnail';
		} else {
			$link_func = 'get_the_attachment_link';
			$size      = FALSE;
		}
		foreach ($image_ids as $id) {
			if ($id) {
				$html = $link_func($id, $size);
				if (! preg_match('/href=(["\'])([^"\']*)\\1/', $html, $file)) {
					preg_match('/src=(["\'])([^"\']*)\\1/', $html, $file);
				}
				if (preg_match('/alt=(""|\'\')/', $html, $match)) {
					$html = str_replace($match[0], 'alt="' . basename($file[2]) . '"', $html);
				} elseif (! preg_match('/alt=/', $html)) {
					$html = str_replace('<img ', '<img alt="' . basename($file[2]) . '" ', $html);
				}
				$img[] = $html;
			}
		}
		$content = KE_IMAGES_HEADER . implode(' ', $img) . KE_IMAGES_FOOTER
		      . KE_TEXT_HEADER . $content . KE_TEXT_FOOTER;
	}
	return $content;
}

// ===== End of class ====================
}
?>