<?php
/*
Plugin Name: Hatena bookmark anywhere
Version: 0.1.2
Plugin URI: http://wppluginsj.sourceforge.jp/hatena-bookmark-anywhere/
Description: Hatena bookmark anywhere
Author: <a href="http://blog.masuidrive.jp/">masuidrive</a> & <a href="http://dogmap.jp/">wokamoto</a>
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 This plugin includes
 どこでもはてブ - Hatena bookmark anywhere
  http://blog.masuidrive.jp/index.php/category/hba/
  The MIT License
  Copyright (c) 2008 Yuichiro MASUI <masui@masuidrive.jp>
*/

class HateBuAnywhereController {
  var $plugin_name  = 'hatena-bookmark-anywhere';

  var $options_default = array(
        'limit'       => 100	// 表示する件数
       ,'style'       => true	// true でデフォルトスタイル false を設定するとCSSでスタイルの指定が可能
       ,'collapse'    => false	// true にすると、コメントの書いてないブクマを表示しない。指定しない場合は、表示件数を超えた場合のみコメントを表示しない
       ,'set_auto'    => true	// true にすると、本文記事の後に自動でセット
       ,'set_css'     => false	// true にすると、ヘッダ部にCSSを読込
       ,'css'         =>
         array(
            'body'    => 'font-size: 90%; font-family: "Arial", sans-serif; color: #000;'
           ,'any'     => 'margin: 0; padding: 0; text-align: left; font-weight: normal; font-family: "Arial", sans-serif;'
           ,'zero'    => 'background-color:#edf1fd; border-top:1px solid #5279e7; list-style-position: inside; margin:2px 0 0 0;padding: 8px 5px 12px 8px;'
           ,'ul'      => 'background-color:#edf1fd; border-top:1px solid #5279e7; list-style-position: inside; margin:2px 0 0 0;padding: 8px 5px 12px 8px;'
           ,'li'      => 'list-style-type: circle; padding: 1px 0;'
           ,'user'    => 'color: #00e; text-decoration: underline; margin: 0 2px;'
           ,'tags'    => 'font-size: 90%; color: #66c; margin: 0 4px 0 2px;'
           ,'tags_a'  => 'text-decoration: none; color: #66c;'
           ,'go'      => 'font-size: 90%; color: #66c; text-decoration: none;'
         )
       ,'css_id'      => 'hatena_bookmark_anywhere'
       ,'load'        =>
         array(
            'single'  => true
           ,'page'    => true
         )
      );

  var $js_file      = 'js/hatena-bookmark-anywhere-0-1.js';
  var $js_ver       = '0.1';

  var $options,$option_name;
  var $note,$error;
  var $admin_option,$admin_action;

  /*
  * Constructor
  */
  function HateBuAnywhereController() {
    $this->note = '';
    $this->error = 0;

    $this->options = get_option($this->plugin_name." Options");
    $this->initOptions();

    $this->admin_option = basename(__FILE__);
    $this->admin_action = get_settings('siteurl')."/wp-admin/admin.php?page=".$this->admin_option;
    $this->option_name  = $this->plugin_name." Options";
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function initOptions() {
    if (!is_array($this->options)) $this->options = array();
    if (!isset($this->options['plugin_uri'])) $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
    if (!isset($this->options['limit']))      $this->options['limit']      = $this->options_default['limit'];
    if (!isset($this->options['style']))      $this->options['style']      = $this->options_default['style'];
    if (!isset($this->options['collapse']))   $this->options['collapse']   = $this->options_default['collapse'];
    if (!isset($this->options['set_auto']))   $this->options['set_auto']   = $this->options_default['set_auto'];
    if (!isset($this->options['set_css']))    $this->options['set_css']    = $this->options_default['set_css'];
    if (!isset($this->options['css']))        $this->options['css']        = '';
    if (!isset($this->options['load']))       $this->options['load']       = $this->options_default['load'];
  }

  function updateOptions() {
    update_option($this->option_name, $this->options);
  }

  function deleteOptions() {
    delete_option($this->option_name);
    $this->options = array();
  }

  function isDisplay() {
    return (
            ($this->options['load']['single'] && is_single())
         || ($this->options['load']['page'] && is_page())
           );
  }

  // regist script
  function addScripts() {
    if ($this->isDisplay()) {
      wp_enqueue_script($this->plugin_name, $this->options['plugin_uri'].'/'.$this->js_file, array(), $this->js_ver);
    }
  }

  function addHead() {
    if (!($this->options['set_css'] && is_array($this->options['css']))) return;

    if ($this->isDisplay()) {
      $wk_tmpl = "#".$this->options_default['css_id']." %s{%s}\n";
      $out  = "<style type=\"text/css\">\n";
      $out .= sprintf($wk_tmpl, "", $this->options['css']['body']);
      $out .= sprintf($wk_tmpl, "* ", $this->options['css']['any']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_zero ", $this->options['css']['zero']);
      $out .= sprintf($wk_tmpl, "ul ", $this->options['css']['ul']);
      $out .= sprintf($wk_tmpl, "ul li ", $this->options['css']['li']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_user ", $this->options['css']['user']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_tags ", $this->options['css']['tags']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_tags a ", $this->options['css']['tags_a']);
      $out .= sprintf($wk_tmpl, ".hatena_bookmark_anywhere_go ", $this->options['css']['go']);
      $out .= "</style>\n";

      echo $out;
    }
  }

  function addFooter() {
    if ($this->isDisplay()) {
     // パーセントエンコーディングを大文字に変換
     $url  = get_permalink();
     if (preg_match('/(%[0-9a-f]{2}?)+/', $url)) {
      $url  = preg_replace_callback('/(%[0-9a-f]{2}?)+/', create_function('$matches','return strtoupper($matches[0]);'), $url);
     }

     $out  = "<script type=\"text/javascript\">/*<![CDATA[*/\n";
     $out .= "var hatena_bookmark_anywhere_limit = ".$this->options['limit'].";\n";
     $out .= "var hatena_bookmark_anywhere_style = ".($this->options['style']?"true":"false").";\n";
     if ($this->options['collapse']) {$out .= "var hatena_bookmark_anywhere_collapse = true;\n";}
     $out .= "var hatena_bookmark_anywhere_url = '".$url."';\n";
     $out .= "/*]]>*/</script>\n";
     echo $out;
    }
  }

  function addContent($content) {
    if (!$this->options['set_auto']) return $content;

    if ($this->isDisplay()) {
      $content .= "<div id=\"".$this->options_default['css_id']."\"></div>\n";
    }
    return $content;
  }

  function addAdminMenu() {
    add_options_page(__('Hatena bookmark anywhere', 'hatena-bookmark-anywhere'), __('Hatena bookmark anywhere', 'hatena-bookmark-anywhere'), 9, $this->admin_option, array($this,'optionPage'));
  }

  function optionPage() {
    if(isset($_POST['ap_options_update'])) {
      // options update

      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      if (is_numeric($_POST['hatena_bookmark_anywhere_limit'])) {
        $this->options['limit']    = $_POST['hatena_bookmark_anywhere_limit'];
      }
      $this->options['set_auto']   = ($_POST['hatena_bookmark_anywhere_auto']=='1'?true:false);
      $this->options['load']['single'] = ($_POST['hatena_bookmark_anywhere_single']=='1'?true:false);
      $this->options['load']['page']   = ($_POST['hatena_bookmark_anywhere_page']=='1'?true:false);
      $this->options['style']      = ($_POST['hatena_bookmark_anywhere_style']=='1'?true:false);
      $this->options['collapse']   = ($_POST['hatena_bookmark_anywhere_collapse']=='1'?true:false);
      $this->options['set_css']    = ($_POST['hatena_bookmark_anywhere_style']!='1'&&$_POST['hatena_bookmark_anywhere_css']=='1'?true:false);
      if ($this->options['set_css']) {
        $this->options['css'] = 
         array(
            'body'    => $_POST['css_body']
           ,'any'     => $_POST['css_any']
           ,'zero'    => $_POST['css_zero']
           ,'ul'      => $_POST['css_ul']
           ,'li'      => $_POST['css_li']
           ,'user'    => $_POST['css_user']
           ,'tags'    => $_POST['css_tags']
           ,'tags_a'  => $_POST['css_tags_a']
           ,'go'      => $_POST['css_go']
         );
      }
      $_POST = '';

      // Done!
      $this->updateOptions();
      $this->note .= "<strong>".__('Done!', 'hatena-bookmark-anywhere')."</strong>";

    } elseif(isset($_POST['ap_options_delete'])) {
      // options delete

      // Done!
      $this->deleteOptions();
      $this->initOptions();
      $this->note .= "<strong>".__('Done!', 'hatena-bookmark-anywhere')."</strong>";
    }

    $out  = '';

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('Hatena bookmark anywhere Options', 'hatena-bookmark-anywhere')."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";

    $out .= "<table>\n";

    // Limit
    $out .= "<tr>";
    $out .= "<td><strong>".__('Limit', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"hatena_bookmark_anywhere_limit\" id=\"hatena_bookmark_anywhere_limit\" size=\"10\" value=\"".$this->options['limit']."\" /></td>";
    $out .= "</tr>\n";

    // Display
    $out .= "<tr>";
    $out .= "<td><strong>".__('Display', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"checkbox\" name=\"hatena_bookmark_anywhere_auto\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['set_auto']?' checked':'')." />".__('Displays automatically', 'hatena-bookmark-anywhere')."</td>";
    $out .= "</tr>\n";

    // JavaScript Load
    $out .= "<tr>";
    $out .= "<td><strong>".__('Load', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td>";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_single\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['load']['single']?' checked':'')." />".__('Single Post')."&nbsp;";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_page\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['load']['page']?' checked':'')." />".__('Page Template');
    $out .= "</td>";
    $out .= "</tr>\n";

    // Style
    $out .= "<tr>";
    $out .= "<td><strong>".__('Style', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td>";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_style\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['style']?' checked':'')." onclick=\"javascript:document.getElementById('hatena-bookmark-anywhere_css_check').style.display=(!this.checked?'block':'none');\" />".__('Default Style', 'hatena-bookmark-anywhere')."<br />";

    // CSS
    $wk_css_options = $this->options['css'];
    if (!is_array($wk_css_options)) {$wk_css_options = $this->options_default['css'];}
    $out .= "<span id=\"hatena-bookmark-anywhere_css_check\" style=\"display:".(!$this->options['style']?'block':'none').";\">";
    $out .= "<input type=\"checkbox\" name=\"hatena_bookmark_anywhere_css\" id=\"hatena_bookmark_anywhere_css\" value=\"1\" style=\"margin-right:0.5em\" ".(!$this->options['style'] && $this->options['set_css']?' checked':'')." onclick=\"javascript:document.getElementById('hatena-bookmark-anywhere_css_options').style.display=(this.checked?'block':'none');\" />".__('CSS is set from the plugin', 'hatena-bookmark-anywhere')."<br />";
    $out .= "</span>";

    $out .= "<div id=\"hatena-bookmark-anywhere_css_options\" style=\"display:".(!$this->options['style'] && $this->options['set_css']?'block':'none').";\">";
    $out .= "<table>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Background', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_body\" id=\"css_body\" size=\"100\" value=\"".$wk_css_options['body']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Any', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_any\" id=\"css_any\" size=\"100\" value=\"".$wk_css_options['any']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Zero', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_zero\" id=\"css_zero\" size=\"100\" value=\"".$wk_css_options['zero']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('List (ul)', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_ul\" id=\"css_ul\" size=\"100\" value=\"".$wk_css_options['ul']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('List (li)', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_li\" id=\"css_li\" size=\"100\" value=\"".$wk_css_options['li']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('User', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_user\" id=\"css_user\" size=\"100\" value=\"".$wk_css_options['user']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Tags', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_tags\" id=\"css_tags\" size=\"100\" value=\"".$wk_css_options['tags']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Tags (link)', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_tags_a\" id=\"css_tags_a\" size=\"100\" value=\"".$wk_css_options['tags_a']."\" /></td>";
    $out .= "</tr>";
    $out .= "<tr>";
    $out .= "<td><strong>".__('Go', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"text\" name=\"css_go\" id=\"css_go\" size=\"100\" value=\"".$wk_css_options['go']."\" /></td>";
    $out .= "</tr>";
    $out .= "</table>";
    $out .= "</div>";
    unset($wk_css_options);

    $out .= "</td>";
    $out .= "</tr>\n";

    // Collapse
    $out .= "<tr>";
    $out .= "<td><strong>".__('Collapse', 'hatena-bookmark-anywhere')."</strong></td>";
    $out .= "<td><input type=\"checkbox\" name=\"hatena_bookmark_anywhere_collapse\" value=\"1\" style=\"margin-right:0.5em\" ".($this->options['collapse']?' checked':'')." />".__('No display where the comment is not written', 'hatena-bookmark-anywhere')."</td>";
    $out .= "</tr>\n";

    $out .= "</table>";

    // Add Update Button
    $out .= "<input type=\"submit\" name=\"ap_options_update\" value=\"".__('Update Options', 'hatena-bookmark-anywhere')."\" class=\"button\" style=\"font-size:11px;\" />";
    $out .= "</form></div>\n";

    // Add Options
    $out .= "<div class=\"wrap\">\n";
    $out .= "<h2>".__('Uninstall', 'hatena-bookmark-anywhere')."</h2><br />\n";
    $out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";

    // Delete Button
    $out .= "<input type=\"submit\" name=\"ap_options_delete\" value=\"".__('Delete Options', 'hatena-bookmark-anywhere')."\" class=\"button\" style=\"font-size:11px;\" />";
    $out .= "</form></div>\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = "<div id=\"message\" class=\"updated fade\"><p>".$this->note."</p></div>\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

}//class

load_plugin_textdomain('hatena-bookmark-anywhere','wp-content/plugins/'.basename(dirname(__FILE__)));

$HateBuAnywhere = new HateBuAnywhereController();

add_action('admin_menu', array(&$HateBuAnywhere,'addAdminMenu'));

add_action('wp_print_scripts', array(&$HateBuAnywhere,'addScripts'));
add_action('wp_head', array(&$HateBuAnywhere,'addHead'));
add_action('wp_footer', array(&$HateBuAnywhere,'addFooter'));
add_filter('the_content', array(&$HateBuAnywhere,'addContent'), 9999);

unset($HateBuAnywhere);
?>