<?php
/*
Plugin Name: Hatena bookmark anywhere
Version: 0.1.1
Plugin URI: http://wppluginsj.sourceforge.jp/hatena-bookmark-anywhere/
Description: Hatena bookmark anywhere
Author: <a href="http://blog.masuidrive.jp/">masuidrive</a> & <a href="http://dogmap.jp/">wokamoto</a>
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

 This plugin includes
 どこでもはてブ - Hatena bookmark anywhere
  http://blog.masuidrive.jp/index.php/category/hba/
  The MIT License
  Copyright (c) 2008 Yuichiro MASUI <masui@masuidrive.jp>
*/

class HateBuAnywhereController {
  var $plugin_name  = 'hatena-bookmark-anywhere';

  var $options_default = array(
        'limit'       => 100	// 表示する件数
       ,'style'       => '1'	// '1' でデフォルトスタイル '0' を設定するとCSSでスタイルの指定が可能
       ,'collapse'    => '1'	// '1' にすると、コメントの書いてないブクマを表示しない。指定しない場合は、表示件数を超えた場合のみコメントを表示しない
       ,'url'         => ''
      );

  var $js_file      = 'hatena-bookmark-anywhere-0-1.js';
  var $js_ver       = '0.1';

  var $options = array();
  var $note,$error;

  /*
  * Constructor
  */
  function HateBuAnywhereController() {
    $this->note = '';
    $this->error = 0;

    $wkoptions = get_option($this->plugin_name." Options");
    if (!is_array($wkoptions)) {
      $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $this->options['limit']      = $this->options_default['limit'];
      $this->options['style']      = $this->options_default['style'];
      $this->options['collapse']   = $this->options_default['collapse'];
      $this->update_options();
    } else {
      $this->options = $wkoptions;
    }
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function update_options() {
    update_option($this->plugin_name." Options", $this->options);
  }

  // regist script
  function addScripts() {
    if (is_single()) {
      wp_enqueue_script($this->plugin_name, $this->options['plugin_uri'].'/js/'.$this->js_file, array(), $this->js_ver);
    }
  }

  function addFooter() {
    if (is_single()) {
     $url  = get_permalink();
     if (preg_match('/(%[0-9a-f]{2}?)+/', $url)) {
      // パーセントエンコーディングを大文字に変換
      $url  = preg_replace_callback('/(%[0-9a-f]{2}?)+/', create_function('$matches','return strtoupper($matches[0]);'), $url);
     }

     $out  = "<script type=\"text/javascript\">/*<![CDATA[*/\n";
     $out .= "var hatena_bookmark_anywhere_limit = ".$this->options['limit'].";\n";
     $out .= "var hatena_bookmark_anywhere_style = ".($this->options['style']!='1'?"false":"true").";\n";
     $out .= "var hatena_bookmark_anywhere_collapse = ".($this->options['collapse']!='1'?"false":"true").";\n";
     $out .= "var hatena_bookmark_anywhere_url = '".$url."';\n";
     $out .= "/*]]>*/</script>\n";
     echo $out;
    }
  }

  function addContent($content) {
    if (is_single()) {
     $content .= "<div id=\"hatena_bookmark_anywhere\"></div>\n";
    }
    return $content;
  }

  function addAdminMenu() {
    add_options_page(__('Hatena bookmark anywhere', 'hatena-bookmark-anywhere'), __('Hatena bookmark anywhere', 'hatena-bookmark-anywhere'), 9, basename(__FILE__), array($this,'optionPage'));
  }

  function optionPage() {
    // options update
    if(isset($_POST['ap_options_update'])) {
      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      if (is_numeric($_POST['hatena_bookmark_anywhere_limit'])) {
        $this->options['limit']      = $_POST['hatena_bookmark_anywhere_limit'];
      }
      $this->options['style']      = ($_POST['hatena_bookmark_anywhere_style']!='1'?'0':'1');
      $this->options['collapse']   = ($_POST['hatena_bookmark_anywhere_collapse']!='1'?'0':'1');
      $_POST = '';

      // Done!
      $this->update_options();
      $this->note .= __('<strong>Done!</strong>', 'hatena-bookmark-anywhere');
    }

    $out  = '';

    // Add Options
    $out .= '<div class="wrap">'."\n";
    $out .= '<h2>'.__('Hatena bookmark anywhere Options', 'hatena-bookmark-anywhere').'</h2><br />'."\n";
    $out .= '<form method="post" id="update_options" action="'.$_SERVER['REQUEST_URI'].'">'."\n";

    $out .= '<table>'."\n";

    // Limit
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Limit', 'hatena-bookmark-anywhere').'</strong></td>';
    $out .= '<td><input type="text" name="hatena_bookmark_anywhere_limit" id="hatena_bookmark_anywhere_limit" size="10" value="'.$this->options['limit'].'" /></td>';
    $out .= '</tr>'."\n";

    // Style
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Style', 'hatena-bookmark-anywhere').'</strong></td>';
    $out .= '<td><input type="checkbox" name="hatena_bookmark_anywhere_style" value="1" style="margin-right:0.5em" '.($this->options['style']=='1'?' checked':'').' />'.__('Default Style', 'hatena-bookmark-anywhere').'</td>';
    $out .= '</tr>'."\n";

    // Collapse
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Collapse', 'hatena-bookmark-anywhere').'</strong></td>';
    $out .= '<td><input type="checkbox" name="hatena_bookmark_anywhere_collapse" value="1" style="margin-right:0.5em" '.($this->options['collapse']=='1'?' checked':'').' />'.__('No display where the comment is not written', 'hatena-bookmark-anywhere').'</td>';
    $out .= '</tr>'."\n";

    $out .= '</table>'."\n";

    // Add Update Button
    $out .= '<div style="text-align:right"><input type="submit" name="ap_options_update" value="'.__('Update Options', 'hatena-bookmark-anywhere').'" class="button" style="font-size:11px;" /></div>';
    $out .= '</form></div>'."\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

}//class

load_plugin_textdomain('hatena-bookmark-anywhere','wp-content/plugins/'.basename(dirname(__FILE__)));

$HateBuAnywhere = new HateBuAnywhereController();

add_action('admin_menu', array(&$HateBuAnywhere,'addAdminMenu'));

add_action('wp_print_scripts', array(&$HateBuAnywhere,'addScripts'));
add_action('wp_footer', array(&$HateBuAnywhere,'addFooter'));
add_filter('the_content', array(&$HateBuAnywhere,'addContent'), 9999);

unset($HateBuAnywhere);
?>