<?php
/* これは文字化け防止のための日本語文字列です。
   このソースファイルは UTF-8 で保存されています。
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with UTF-8. */
/*
Plugin Name: JSeries Notifier
Plugin URI: http://wppluginsj.sourceforge.jp/jseries-notifier/
Description: Notify updates of plugins which is supplied as WordPress Plugins/JSeries
Author: IKEDA Yuriko
Version: 0.80
Author URI: http://www.yuriko.net/cat/wordpress
*/

/*  Copyright (c) 2007 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define ('JSERIES_SITE_HOST', 'sourceforge.jp');
define ('JSERIES_SITE_PATH', '/projects/wppluginsj/');
define ('JN_RETRIVE_INTERNAL', 86400);

$JS_Notifier = new JSeries_Notifier;

add_action('load-plugins.php', array($JS_Notifier, 'check_updates'));
add_action('after_plugin_row', array($JS_Notifier, 'plugin_update_row'));

/* ==================================================
 *   JSeries_Notifier class
   ================================================== */

class JSeries_Notifier {
	var $versions;

// ==================================================
// public 
function JSeries_Notifier() {
/*
	$versions = $this->pickup_versions($html);
	print_r($versions);
 */
}

/* ==================================================
 * @param	none
 * @return	array  $versions
 * based on wp_update_plugins() at wp-admin/includes/update.php of WP 2.3.1
 */
// public 
function check_updates() {
	$plugins = get_plugins();
	$current = get_option( 'jseries_plugins' );
	$versions = array();

	$new_option = '';
	$new_option->last_checked = time();

	$plugin_changed = false;
	foreach ( $plugins as $file => $p ) {
		$versions[$p['Name']] = $p['Version'];
		$new_option->checked[ $file ] = $p['Version'];

		if ( ! isset( $current->checked[ $file ] ) ) {
			$plugin_changed = true;
			continue;
		}

		if ( $current->checked[ $file ] != $p['Version'] )
			$plugin_changed = true;
	}
	$this->versions = $versions;

	if (
		isset( $current->last_checked ) &&
		JN_RETRIVE_INTERNAL > ( time() - $current->last_checked ) &&
		! $plugin_changed
	) {
		return false;
	}
	
	$html = $this->retrive_latest_versions();
	if ($html) {
		$response = $this->pickup_versions($html);
		if ( $response ) {
			$new_option->response = $response;
		}
	}
	update_option('jseries_plugins', $new_option);

}

/* ==================================================
 * @param	none
 * @return	mix     $response
 * based on wp_update_plugins() at wp-admin/includes/update.php of WP 2.3.1
 */
// private 
function retrive_latest_versions() {
	global $wp_version;
	if (! function_exists('fsockopen')) {
		return false;
	}

	$http_request  = 'GET ' . JSERIES_SITE_PATH . " HTTP/1.0\r\n";
	$http_request .= 'Host: ' . JSERIES_SITE_HOST . "\r\n";
	$http_request .= 'User-Agent: WordPress/' . $wp_version . '; ' . get_bloginfo('url') . "\r\n";
	$http_request .= "\r\n";

	$html = '';
	if ( false != ( $fs = @fsockopen( JSERIES_SITE_HOST, 80, $errno, $errstr, 3) ) && is_resource($fs) ) {
		fwrite($fs, $http_request);

		while (! feof($fs)) {
			$html .= fgets($fs, 1160); // One TCP-IP packet
		}
		fclose($fs);
		$html = explode("\r\n\r\n", $html, 2);
		$html = mb_convert_encoding($html[1], 'UTF-8', 'EUC-JP');
	}
/*
	$html = file_get_contents(dirname(__FILE__) . '/wppluginsj.htm');
	$html = mb_convert_encoding($html, 'UTF-8', 'EUC-JP');
*/
	return $html;
}

/* ==================================================
 * @param	string  $html
 * @return	mix     $response
 */
// private 
function pickup_versions($html) {
	if (empty($html)) {
		return NULL;
	}
	$pos = strpos($html, '最新リリース情報</FONT></TH></TR>', 0);
	if ($pos === FALSE) {
		return NULL;
	}
	$response = array();
	if (preg_match_all('!<TR bgcolor="#[0-9a-fA-F]+">\s*<TD bgcolor="#[0-9a-fA-F]+"><a href="(' . JSERIES_SITE_PATH . 'files/\?release_id=\d+#\d+)">([^<]*?)</a></TD>\s*<TD bgcolor="#[0-9a-fA-F]+"><a href="' . JSERIES_SITE_PATH . 'files/\?release_id=\d+#\d+">([^<]*?)</a></TD>!', $html, $plugins, PREG_SET_ORDER, $pos)) {
		foreach ($plugins as $p) {
			if (isset($this->versions[$p[2]]) && version_compare($this->versions[$p[2]], $p[3], '<')) {
				$response[$p[2]]->url = 'http://' . JSERIES_SITE_HOST . $p[1];
				$response[$p[2]]->new_version = $p[3];
			}
		}
	}
	return $response;
}

/* ==================================================
 * @param	string  $file
 * @return	none
 * based on wp_plugin_update_row() at wp-admin/includes/update.php of WP 2.3.1
 */
// public  
function plugin_update_row($file) {
	global $plugin_data;
	$current = get_option( 'jseries_plugins' );
	if (! isset( $current->response[$plugin_data['Name']])) {
		return false;
	}
	$r = $current->response[$plugin_data['Name']];

	echo "<tr><td colspan='5' class='plugin-update'>";
	printf( __('There is a new version of %s available. <a href="%s">Download version %s here</a>.'), $plugin_data['Name'], attribute_escape($r->url), attribute_escape($r->new_version));
	echo "</td></tr>";
}

// ===== End of class ====================
}
?>