<?php
/* ==================================================
 *   Ktai Template Tags
   ================================================== */

add_filter('the_title', '_shrink_title', 90);
add_filter('the_content', '_shrink_content', 90);
add_filter('get_comment_text', '_shrink_content', 90);
add_filter('post_link', '_strip_host', 90);
add_filter('page_link', '_strip_host', 90);
add_filter('attachment_link', '_strip_host', 90);
add_filter('year_link', '_strip_host', 90);
add_filter('month_link', '_strip_host', 90);
add_filter('day_link', '_strip_host', 90);
add_filter('category_link', '_strip_host', 90);
add_filter('tag_link', '_strip_host', 90);
add_filter('wp_generate_tag_cloud', '_shrink_tag_cloud', 90, 3);

define (KS_SIZE_EXCEED_COLOR, '#808080');

/* ==================================================
 * @param	string  $url
 * @return	string  $url
 */
function _strip_host($url = '/') {
	return preg_replace('!^https?://[^/]*/?!', '/', $url);
}

/* ==================================================
 * @param	string  $title
 * @return	string  $title
 */
function _shrink_title($title) {
	$protected_phrase = str_replace('%s', '', __('Protected: %s'));
	return preg_replace('/' . preg_quote($protected_phrase, '/') . '/', '<img localsrc="279" alt="' . $protected_phrase . '" />', $title);
}

/* ==================================================
 * @param   string  $href
 * @param	string  $desc
 * @param   array   $internal
 * @param   array   $short_links
 * @param   string  $leave_pat
 * @return	string  $link_html
 */
function _rewrite_link($href, $desc, $short_links, $internal_pat, $short_int_pat, $leave_pat) {
	global $Ktai_Style;
	$clipped = preg_replace($internal_pat, $short_links, $href, 1, $is_internal);
	if ($is_internal) {
		$link_html = '<a href="' . $clipped . '">' . $desc . '</a>';
	} elseif (preg_match($short_int_pat, $href) || (preg_match($leave_pat, $href) && ! ks_is_loggedin())) {
		$link_html = NULL; // leave links
	} elseif (defined('KS_DELETE_EXTERNAL_LINKS')) {
		$link_html = $desc; // strip links
	} else {
		$icon_desc = '<img localsrc="337" alt="' . __('[for PC]', 'ktai_style') . '" /><font color="' . ks_option('ks_external_link_color') . '">' . $desc . '</font></a>';
		if ($Ktai_Style->is_ktai() == 'DoCoMo' || $Ktai_Style->is_ktai() == 'KDDI' || $Ktai_Style->is_ktai() == 'SoftBank' || ks_is_loggedin()) {
			$link_html = '<a href="' . ks_plugin_url(FALSE) . 'redir.php?url=' . $href . '">' . $icon_desc;
		} else {
			$link_html = '<a href="' . $href . '">' . $icon_desc;
		}
		$link_html = apply_filters('external_link/ktai_style.php', $link_html, $href, $desc);
	}
	return $link_html;
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
function _convert_links($content) {
	$short_wpurl = _strip_host(get_bloginfo('wpurl') . '/');
	$short_links[0] = $short_wpurl;
	$internal_pat[0] = '!^' . preg_quote(get_bloginfo('wpurl'), '!') . '/?!';
	$wp_urls = '!^(' . preg_quote(get_bloginfo('wpurl'), '!') . '/|' . preg_quote($short_wpurl, '!') . ')!';
	if (get_bloginfo('url') && strcmp(get_bloginfo('url'), get_bloginfo('wpurl') !== 0)) {
		$short_url = _strip_host(get_bloginfo('url') . '/');
		$short_links[] = $short_url;
		$internal_pat[] = '!^' . preg_quote(get_bloginfo('url'), '!') . '/?!';
	}
	$short_int_pat = '!^(' . implode('|',  array_map('preg_quote', $short_links)) . ')!';
	$leave_schemes = apply_filters('leave_scheme/ktai_style.php', array('#', 'tel:', 'tel-av:', 'vtel:', 'mailto:', 'device:', 'location:'));
	$leave_sites = preg_split('/\\s+/', ks_option('ks_treat_as_internal'), -1, PREG_SPLIT_NO_EMPTY);
	$leave_pat = '!^(' . implode('|', array_merge($leave_schemes, array_map('preg_quote', $leave_sites))) . ')!';
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a ([^>]*?)>(.*?)</a>!', $content, $l, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$desc    = $l[2][0];
		preg_match('/href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $l[1][0], $h);
		$href      = $h[2];
		$replace   = $orig;
		$link_html = $desc; // default is stripping links
		if (preg_match('!<img [^>]*?src=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1[^>]*? ?/?>!', $desc, $image)) {
			if (preg_match('!' . PLUGINDIR . '!', $image[2])) { // skip plug-in's icon
				continue; // leave links
			} elseif (preg_match($wp_urls, $href) && preg_match($wp_urls, $image[2])) { // both internal link
				$path = preg_replace($wp_urls, ABSPATH . '/', $href);
				if (! is_dir($path) && $imagesize = @filesize($path)) { // a thumbnail linked to original image
					$thumbnail = str_replace('<img ', '<img has_orig="true" ', $desc); // inform existance of original to _images_to_link()
					$link_html = $thumbnail . '<img src="' . $href . '" alt="' . sprintf(__('Original(%dKB)', 'ktai_style'), intval($imagesize / 1024)) . '" filesize="' . $imagesize . '"/>'; // pass filesize to _images_to_link()
				} else { // internal link to other than images
					$link_html = $desc . '(<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>)';
				}
			} else { // external link
				$link_html = _rewrite_link($href, __('Link Target', 'ktai_style'), $short_links, $internal_pat, $short_int_pat, $leave_pat);
				if (is_null($link_html)) {
					$link_html = '<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>';
				}
				$link_html = "{$desc}($link_html)";
			}
		} else {
			$link_html = _rewrite_link($href, $desc, $short_links, $internal_pat, $short_int_pat, $leave_pat);
		}
		$replace = apply_filters('convert_links/ktai_style.php', $link_html, $orig, $href, $desc);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig)); // convert links
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param	string  $html
 * @param	string  $src
 * @param	string  $q
 * @param	string  $attr
 * @param   array   $wp_urls
 * @return	string  $replace
 */
function _convert_image($html, $src, $q, $attr, $wp_urls) {
	global $Ktai_Style;
	$replace = $html;
	if (preg_match('/alt=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $a)) {
		if (empty($a[2])) { // hide images if the alt string is empty. 
			$replace = '';
			return $replace;
		}
		$alt = stripslashes($a[2]);
	} else {
		$alt = basename(parse_url($src, PHP_URL_PATH));
	}
	if (preg_match('/(width|height)=(([\'"])1\\3|1\b)/', $attr)) { // hide 1 pixel width/height images. 
		$replace = '';
	} elseif (preg_match('/class=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/', $attr, $class) && preg_match('/\\b(wp-smiley|ktai)\\b/', $class[2])) {
		$replace = '<img src=' . $q . _strip_host($src) . $q . ' alt="' . addslashes($alt) . '" class="' . $class[2] . '" />';
	} elseif (preg_match('!' . PLUGINDIR . '!', $src)) { // plug-in's icon or what
		$replace = "[$alt]";
	} elseif (preg_match('/filesize="(\d*)"/', $attr, $filesize)) { // original image for thumbnail passed by _convert_links()
		$cache_size = $Ktai_Style->get('cache_size');
		if ($filesize[1] && $cache_size > 0 && $filesize[1] > $cache_size) {
			$replace = '<font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>]';
		} else {
			$replace = '<a href=' . "$q$src$q" . '>' . $alt . '</a>]';
		}
	} else { // normal image or thumbnail image
		$replace = '[<a href=' . "$q$src$q" . '><img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" />' . $alt . '</a>';
		if (preg_match($wp_urls, $src)) {
			$path = preg_replace($wp_urls, ABSPATH . '/', $src);
			if (! is_dir($path) && @filesize($path) > $Ktai_Style->get('cache_size')) {
				$replace = '[<img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" /><font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>';
			}
		}
		$replace .= preg_match('/has_orig="true"/', $attr) ? ' | ' : ']';
	}
	return $replace;
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
function _images_to_link($content) {
	$short_wpurl = _strip_host(get_bloginfo('wpurl') . '/');
	$wp_urls = '!^(' . preg_quote(get_bloginfo('wpurl'), '!') . '/|' . preg_quote($short_wpurl, '!') . ')!';
	for ($offset = 0, $replace = 'X'; 
	     preg_match('!<img ([^>]*?)src=([\'"])([^\\\\]*?(\\\\.[^\\2\\\\]*?)*)\\2([^>]*?) ?/?>!', $content, $img, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $img[0][0];
		$offset  = $img[0][1];
		$q       = $img[2][0];
		$src     = $img[3][0];
		$attr    = $img[1][0] . $img[5][0];
		$replace = $orig;
		if (preg_match('/local$/', $img[1][0])) { // ezweb pict chars
			continue;
		}
		$replace = apply_filters('image_to_link/ktai_style.php', _convert_image($orig, $src, $q, $attr, $wp_urls), $orig, $src);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig));
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
function _shrink_content($content) {
	if (defined('CSS_CLASS_FOR_LOCATION')) { // Delete URL of Ktai Location
		$content = preg_replace('!\s*<div class="' . CSS_CLASS_FOR_LOCATION . '">.*?</div>!s', '', $content);
	}
	global $Ktai_Style;
	$content = $Ktai_Style->filter_tags($content);
	$content = preg_replace('!<del[^>]*>.*?</del>!s', '', $content);
	$content = _convert_links($content);
	$content = _images_to_link($content);
	return $content;
}

/* ==================================================
 * @param	string  $content
 * @param	array   $tags
 * @param	array   $args
 * @return	string  $html
 */
function _shrink_tag_cloud($content, $tags, $args) {
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1([^>]*?)>(.*?)</a>!', $content, $l, PREG_OFFSET_CAPTURE, $offset); 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$q       = $l[1][0];
		$href    = $l[2][0];
		$attr    = $l[4][0];
		$desc    = $l[5][0];
		$replace = $orig;
		preg_match('/ style=([\'"])[^\\\\]*?(\\\\.[^\\1\\\\]*?)*\\1/', $attr, $style);
		$replace = '<a href=' . $q . $href . $q . $style[0] . '>' . $desc . '</a>';
		$content = substr_replace($content, $replace, $offset, strlen($orig));
	}
	return $content;
}

/* ==================================================
 * @param	none
 * @return	boolean $password_is_ok
 */
function _confirmed_post_password() {
	global $post;
	if (empty($post->post_password)) {
		return TRUE;
	}
	return (stripslashes($_POST['post_password']) == $post->post_password);
}

/* ==================================================
 * @param	string  $link
 * @param	string  $icon
 * @param	string  $desc
 * @param	string  $post_password
 * @return	string  $output
 */
function _internal_link($link, $accesskey, $icon, $desc, $post_password) {
	if (strlen($accesskey) == 1 && strpos('123456789*#', $accesskey) !== FALSE) { 
		$accesskey_html = ' accesskey="' . $accesskey . '"';
	} else {
		$accesskey_html = '';
	}
	if ($post_password && _confirmed_post_password()) {
		$param_html = '';
		$query = parse_url($link, PHP_URL_QUERY);
		if ($query) {
			$param_html = '<input type="hidden" name="urlquery" value="' . htmlspecialchars($query, ENT_QUOTES) . '" />';
		}
		$html  = '<form method="post" action="' . attribute_escape($link) . '">' . $param_html . '<input type="hidden" name="post_password" value="' . htmlspecialchars($post_password, ENT_QUOTES) . '" />' . $icon . '<label' . $accesskey_html . '><input type="submit" name="submit" value="' . $desc . '" /></label></form>';
	} else {
		$html = '<a href="' . attribute_escape($link) . '"' . $accesskey_html . '>' . $icon . $desc . '</a>';
	}
	return $html;
}

/* ==================================================
 * @param	int     $more_link_text
 * @param	int     $stripteaser
 * @param	int     $more_file
 * @return	string  $output
 * based on get_the_content() at wp-includes/post-template.php of WP 2.2.3
 */
function _get_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
	global $id, $post, $more, $single, $page, $pages, $numpages;
	global $pagenow;
	$output = '';

	$need_password = ks_check_password();
	if ($need_password) {
		return $need_password;
	}

	if ( $more_file != '' )
		$file = $more_file;
	else
		$file = $pagenow; //$_SERVER['PHP_SELF'];

	if ( $page > count($pages) ) // if the requested page doesn't exist
		$page = count($pages); // give them the highest numbered page that DOES exist

	$content = $pages[$page-1];
	if ( preg_match('/<!--more(.*?)?-->/', $content, $matches) ) {
		$content = explode($matches[0], $content, 2);
		if ( !empty($matches[1]) && !empty($more_link_text) )
			$more_link_text = strip_tags(wp_kses_no_null(trim($matches[1])));
	} else {
		$content = array($content);
	}
	if ( (false !== strpos($post->post_content, '<!--noteaser-->') && ((!$multipage) || ($page==1))) )
		$stripteaser = 1;
	$teaser = $content[0];
	if ( ($more) && ($stripteaser) )
		$teaser = '';
	$output .= $teaser;
	if ( count($content) > 1 ) {
		if ( $more ) {
			$output .= '<span id="more-'.$id.'"></span>'.$content[1];
		} else {
			$output = balanceTags($output);
			if ( ! empty($more_link_text) )
				$output .= ' <a href="'. get_permalink() . "#more-$id\">$more_link_text</a>";
		}
	}

	return $output;
}

/* ==================================================
 * @param	none
 * @return	boolean $is_front
 */
function ks_is_front() {
	global $paged;
	return (is_home() && intval($paged) < 2);
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comments_list
 */
function ks_is_comments_list() {
	if (isset($_GET['view']) && $_GET['view'] == 'co_list') {
		return TRUE;
	} elseif (isset($_POST['view']) && $_POST['view'] == 'co_list') {
		return TRUE;
	}
	return FALSE;	
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comment_post
 */
function ks_is_comment_post() {
	if (isset($_GET['view']) && $_GET['view'] == 'co_post') {
		return TRUE;
	} elseif (isset($_POST['view']) && $_POST['view'] == 'co_post') {
		return TRUE;
	}
	return FALSE;	
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comments
 */
function ks_is_comments() {
	return (ks_is_comments_list() || ks_is_comment_post());
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_header() {
	global $Ktai_Style;
	$Ktai_Style->get_header();
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_footer() {
	global $Ktai_Style;
	$Ktai_Style->get_footer();
	return;
}

/* ==================================================
 * @param	none
 * @return	string  $html
 */
function ks_blogurl($echo = TRUE) {
	$url = _strip_host(get_bloginfo('url') . '/');
	if ($echo) {
		echo $url;
	}
	return $url;
}

/* ==================================================
 * @param	none
 * @return	string  $html
 */
function ks_siteurl($echo = TRUE) {
	$url = _strip_host(get_bloginfo('wpurl') . '/');
	if ($echo) {
		echo $url;
	}
	return $url;
}

/* ==================================================
 * @param	none
 * @return	string  $html
 */
function ks_plugin_url($echo = TRUE) {
	global $Ktai_Style;
	$url = ks_siteurl(FALSE) . $Ktai_Style->get('plugin_dir');
	if ($echo) {
		echo $url;
	}
	return $url;
}

/* ==================================================
 * @param	none
 * @return	string  $html
 */
function ks_theme_url($echo = TRUE) {
	$url = get_template_directory_uri() . '/';
	if ($echo) {
		echo $url;
	}
	return $url;
}

/* ==================================================
 * @param	none
 * @return	string  $url
 */
function ks_admin_url($echo = TRUE) {
	global $Ktai_Style;
	$url = '';
	if (file_exists(dirname(__FILE__) . '/' . KS_ADMIN_DIR)) {
		$url = ks_plugin_url(FALSE) . KS_ADMIN_DIR . '/';
		if ($echo) {
			echo $url;
		}
	}
	return $url;
}

/* ==================================================
 * @param	none
 * @return	string  $html
 */
function ks_login_link($before = ' | ', $after = '', $echo = TRUE) {
	$html = '';
	if (file_exists(dirname(__FILE__) . '/' . KS_ADMIN_DIR)) {
		global $Ktai_Style;
		$html = $before . '<a href="' . ks_plugin_url(FALSE) . 'login.php">' . __('Login') . '</a>' . $after;
		if ($echo) {
			echo $html;
		}
	}
	return $html;
}

/* ==================================================
 * @param	none
 * @return	string  $url
 */
function ks_get_logout_url() {
	if (ks_admin_url(FALSE)) {
		require_once dirname(__FILE__) . '/' . KS_ADMIN_DIR . '/class.php';
		$url = ks_plugin_url(FALSE) . 'login.php?action=logout&' . KS_SESSION_NAME . '=' . Ktai_Style_Admin::get_sid();
	} else { // Logged in from normal login form
		$url = get_bloginfo('wpurl') . 'wp-login.php?action=logout';
	}
	return $url;
}

/* ==================================================
 * @param	none
 * @return	boolean $is_loggedin
 */
function ks_is_loggedin() {
	$user = wp_get_current_user();
	return $user->ID;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_session_id_form() {
	if (ks_admin_url(FALSE)) {
		require_once dirname(__FILE__) . '/' . KS_ADMIN_DIR . '/class.php';
		$sid = Ktai_Style_Admin::get_sid();
		if ($sid) {
			echo '<input type="hidden" name="' . KS_SESSION_NAME . '" value="' . htmlspecialchars($sid, ENT_QUOTES) . '" />';
		}
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_get_wp_version() {
	$version = get_bloginfo('version');
	if (! is_numeric($version)) {
		$version = preg_replace('/[^.0-9]/', '', $version);
	}
	return $version;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_term_name() {
	global $Ktai_Style;
	echo wp_specialchars($Ktai_Style->get('term_name'));
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_use_appl_xhtml() {
	global $Ktai_Style;
	if ($Ktai_Style->is_ktai() == 'DoCoMo'   && $Ktai_Style->get('type') == 'FOMA'
	 || $Ktai_Style->is_ktai() == 'KDDI'     && $Ktai_Style->get('type') == 'WAP2.0'
	 || $Ktai_Style->is_ktai() == 'WILLCOM' ) {
		$Ktai_Style->ktai->set('mime_type', 'application/xhtml+xml');
?><html xmlns="http://www.w3.org/1999/xhtml"><?php
	} elseif ($Ktai_Style->is_ktai() == 'SoftBank' && $Ktai_Style->get('type') == '3G') {
		$Ktai_Style->ktai->set('mime_type', 'application/xhtml+xml');
?><html><?php
	} else {
?><html><?php
	}	
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_force_text_html() {
	global $Ktai_Style;
	$Ktai_Style->ktai->set('mime_type', 'text/html');
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_mimetype() {
	global $Ktai_Style;
	echo wp_specialchars($Ktai_Style->get('mime_type'));
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_charset() {
	global $Ktai_Style;
	echo wp_specialchars($Ktai_Style->get('iana_charset'));
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_fix_encoding_form() {
?>
<input type="hidden" name="charset_detect" value="<?php _e('Encoding discriminant strings to avoid charset mis-understanding', 'ktai_style'); ?>" />
<?php
}

/* ==================================================
 * @param	none
 * @return	string  $charset
 */
function ks_detect_encoding() {
	return Ktai_Style::detect_encoding(@$_POST['charset_detect']);
}

/* ==================================================
 * @param	string  $key
 * @param	string  $charset
 * @return	string  $value
 */
function ks_mb_get_form($key, $charset = NULL) {
	if (empty($charset)) {
		$charset = ks_detect_encoding();
	}
	return mb_convert_encoding(@$_POST[$key], get_bloginfo('charset'), $charset);
}

/* ==================================================
 * @param	none
 * @return	boolean is_required_term_id
 */
function ks_is_required_term_id() {
	global $Ktai_Style;
	return (! ks_is_loggedin() && ks_option('ks_require_term_id') 
	&& ($Ktai_Style->is_ktai() == 'DoCoMo' || $Ktai_Style->is_ktai() == 'KDDI' || $Ktai_Style->is_ktai() == 'SoftBank'));
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_require_term_id_form($action, $method = 'post') {
	global $Ktai_Style;
	if (! ks_is_loggedin() && ks_option('ks_require_term_id') && $Ktai_Style->is_ktai() == 'DoCoMo') {
		if ($Ktai_Style->get('type') == 'FOMA') {
			$utn = ' utn="utn"';
		} else {
			$utn = ' utn';
		}
	} else {
		$utn = '';
	}
	if (strcasecmp($method, 'post') !== 0) {
		$method = 'get';
	}
	echo '<form method="' . $method . '" action="' . attribute_escape($action) . '"' . $utn . '>';
}

/* ==================================================
 * @param	string  $value
 * @return	none
 */
function ks_inline_error_submit($value = NULL) {
	global $post;
	if ($post->post_password) {
		echo '<input type="hidden" name="post_password" value="' . htmlspecialchars($post->post_password, ENT_QUOTES) . '" />';
	}
	if (empty($value)) {
		$value = __('Say It!');
	}
	echo '<input type="submit" name="inline" value="' . attribute_escape($value) . '" />';
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_title() {
	$title = wp_title('', FALSE); 
	if (empty($title)) {
		$title = get_bloginfo('name');
	}
	echo $title;
	return $title;
}

/* ==================================================
 * @param	int     $more_link_text
 * @param	int     $stripteaser
 * @param	int     $more_file
 * @return	none
 * based on the_content() at wp-includes/post-template.php of WP 2.2.3
 */
function ks_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
	$content = _get_content($more_link_text, $stripteaser, $more_file);
	$content = apply_filters('the_content', $content);
	$content = str_replace(']]>', ']]&gt;', $content);
	echo $content;
}

/* ==================================================
 * @param	none
 * @return	none
 * based on get_the_content and get_the_password_form() at wp-includes/post-template.php of WP 2.2.3
 */
function ks_check_password($message = '') {
	if (empty($message)) {
		$message = __("This post is password protected. To view it please enter your password below:");
	}
	if (_confirmed_post_password()) {
		return NULL;
	} else {
		$form = '<form method="post" action="' . $_SERVER['REQUEST_URI'] . '"><p>' . $message . '</p><p><input name="post_password" type="password" size="20" />';
		if (ks_is_comments_list()) {
			$form .= '<input type="hidden" name="view" value="co_list" />';
		} elseif (ks_is_comment_post()) {
			$form .= '<input type="hidden" name="view" value="co_post" />';
		}
		$query = parse_url($_SERVER['REQUEST_URI'], PHP_URL_QUERY);
		if (empty($query) && isset($_POST['urlquery'])) {
			$query = $_POST['urlquery'];
		}
		if ($query) {
			$form .= '<input type="hidden" name="urlquery" value="' . htmlspecialchars($query, ENT_QUOTES) . '" />';
		}
		$form .= '<input type="submit" name="Submit" value="' . __("Submit") . '" /></p></form>';
		return $form;
	}
}

/* ==================================================
 * @param	string  $year
 * @param	string  $mon_date
 * @param	string  $time
 * @return	none
 */
function _time($timestamp, $year = NULL, $mon_date = NULL, $time = NULL) {
	$year     = ! is_null($year)     ? $year     : ks_option('ks_year_format');
	$mon_date = ! is_null($mon_date) ? $mon_date : ks_option('ks_month_date_format');
	$time     = ! is_null($time)     ? $time     : ks_option('ks_time_format');
	if (date('Y', $timestamp) != date('Y')) {
		$output = date($year . ' ' . $time, $timestamp);
	} elseif (date('m-d', $timestamp) != date('m-d')) {
		$output = date($mon_date . ' ' . $time, $timestamp);
	} else {
		$output = date($time, $timestamp);
	}
	echo $output;
	return;
}

/* ==================================================
 * @param	string  $year
 * @param	string  $mon_date
 * @param	string  $time
 * @return	none
 */
function ks_time($year = NULL, $mon_date = NULL, $time = NULL) {
	_time(get_post_time(), $year, $mon_date, $time);
	return;
}

/* ==================================================
 * @param	string  $year
 * @param	string  $mon_date
 * @param	string  $time
 * @return	none
 */
function ks_mod_time($year = NULL, $mon_date = NULL, $time = NULL) {
	_time(get_the_modified_time('U'), $year, $mon_date, $time);
	return;
}

/* ==================================================
 * @param	string  $year
 * @param	string  $mon_date
 * @param	string  $time
 * @return	none
 */
function ks_comment_datetime($year = NULL, $mon_date = NULL, $time = NULL) {
	_time(get_comment_time('U'), $year, $mon_date, $time);
	return;
}

/* ==================================================
 * @param	int     $count
 * @param	int     $max
 * @param	string  $link
 * @return	none
 */
function ks_ordered_link($count, $max = 10, $link, $desc = NULL) {
	if ($max <= 0 || $max > 10) {
		$max = 10;
	}
	$accesskey = '';
	if (is_numeric($count)) {
		if ($count > 0 && $count <= $max) {
			if ($count != 10) {
				$accesskey = ' accesskey="' . intval($count) . '"';
				$num = intval(179 + $count);
			} else {
				$accesskey = ' accesskey="0"';
				$num = 325;
			}
			$output = '<img localsrc="' . $num . '" alt="' . $count . '." />';
		} else { 
			$output = __('[]', 'ktai_style');
		}
	} else {
		$output = '';
	}
	if ($link) {
		$output = '<a href="' . htmlspecialchars($link, ENT_QUOTES) . '"' . $accesskey . '>' . $output;
	}
	if (! is_null($desc)) {
		$output .= $desc;
		if ($link) {
			$output .= '</a>';
		}
	}
	echo $output;
}

/* ==================================================
 * @param	int     $i
 * @param	string  $accesskey
 * @param	string  $desc
 * @param	string  $post_status
 * @param	string  $post_password
 * @return	string  $output
 * based on wp_link_pages() at wp-includes/post-template.php at WP 2.2.3
 */
function _page_link($i, $accesskey, $desc, $post_status, $post_password) {
	if ($i == 1) {
		$output = _internal_link(get_permalink(), $accesskey, '', $desc, $post_password);
	} elseif ('' == get_option('permalink_structure') || 'draft' == $post_status) {
		$output = _internal_link(get_permalink() . '&amp;page=' . $i, $accesskey, '', $desc, $post_password);
	} else {
		$output = _internal_link(trailingslashit(get_permalink()) . user_trailingslashit($i, 'single_paged'), $accesskey, '', $desc, $post_password);
	}
	return $output;
}

/* ==================================================
 * @param	mix     $arg
 * @return	string  $output
 * based on wp_link_pages() at wp-includes/post-template.php at WP 2.2.3
 */
function ks_link_pages($args = '') {
	global $post;

	if (is_array($args)) {
		$r = &$args;
	} else {
		parse_str($args, $r);
	}
	$defaults = array('before' => '<p>' . __('Pages:'), 'after' => '</p>', 'next_or_number' => 'number', 'nextpagelink' => __('Next page'),
			'previouspagelink' => __('Previous page'), 'pagelink' => '%', 'more_file' => '', 'echo' => 1);
	$r = array_merge($defaults, $r);
	extract($r, EXTR_SKIP);

	global $id, $page, $numpages, $multipage, $more, $pagenow;
	if (! $multipage || ! _confirmed_post_password()) {
		return;
	}
	if ($more_file != '') {
		$file = $more_file;
	} else {
		$file = $pagenow;
	}

	$output = '';
	if ( 'number' == $next_or_number ) {
		for ( $i = 1; $i < ($numpages+1); $i = $i + 1 ) {
			$j = str_replace('%',"$i",$pagelink);
			$output .= ' ';
			if ( ($i != $page) || ((!$more) && ($page==1)) ) {
				$output .= _page_link($i, $j, $j, $post->post_status, $post->post_password);
			}
		}
	} elseif ($more) {
		$i = $page - 1;
		if ($i > 0) {
			$output .= _page_link($i, '*', $previouspagelink, $post->post_status, $post->post_password);
		}
		$i = $page + 1;
		if ($i <= $numpages) {
			$output .= _page_link($i, '#', $nextpagelink, $post->post_status, $post->post_password);
		}
	}

	if ($output) {
		$output = $before . $output . $after;
	}

	if ($echo) {
		echo $output;
	}
	return $output;
}
/* ==================================================
 * @param	string  $before
 * @param	string  $after
 * @return	none
 */
function ks_pagenum($before = ' (', $after = ')') {
	global $paged, $wp_query;
	if (! $paged) {
		$paged = 1;
	}
	$max_page = $wp_query->max_num_pages;
	if ($wp_query->max_num_pages > 1) {
		echo "$before$paged/$max_page$after";
	}
}

/* ==================================================
 * @param	string  $format
 * @param	string  $link
 * @param	boolean $in_same_cat
 * @param	string  $excluded_categories
 * @return	none
 * based on previous_post_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_previous_post_link($format='<img localsrc="7" alt="&laquo;">*.%link', $link='%title', $in_same_cat = false, $excluded_categories = '') {

	if ( is_attachment() )
		$post = & get_post($GLOBALS['post']->post_parent);
	else
		$post = get_previous_post($in_same_cat, $excluded_categories);

	if ( !$post )
		return;

	$title = apply_filters('the_title', $post->post_title, $post);
	$string = '<a href="'.get_permalink($post->ID).'" accesskey="*">';
	$link = str_replace('%title', $title, $link);
	$link = $pre . $string . $link . '</a>';

	$format = str_replace('%link', $link, $format);

	echo $format;
}

/* ==================================================
 * @param	string  $format
 * @param	string  $link
 * @param	boolean $in_same_cat
 * @param	string  $excluded_categories
 * @return	none
 * based on next_post_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_next_post_link($format='#.%link<img localsrc="8" alt="&raquo;">', $link='%title', $in_same_cat = false, $excluded_categories = '') {
	$post = get_next_post($in_same_cat, $excluded_categories);

	if ( !$post )
		return;

	$title = apply_filters('the_title', $post->post_title, $post);
	$string = '<a href="'.get_permalink($post->ID).'" accesskey="#">';
	$link = str_replace('%title', $title, $link);
	$link = $string . $link . '</a>';
	$format = str_replace('%link', $link, $format);

	echo $format;
}

/* ==================================================
 * @param	string  $label
 * @return	none
 * based on previous_posts_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_previous_posts_link($label = NULL) {
	$label = ! is_null($label) ? $label : ('<img localsrc="7" alt="&laquo;">' . __('*.Prev', 'ktai_style'));
	global $paged;
	if ( (!is_single())	&& ($paged > 1) ) {
		echo '<a href="' . _strip_host(clean_url(get_previous_posts_page_link()));
		echo '" accesskey="*">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $label) .'</a>';
	}
}

/* ==================================================
 * @param	string  $label
 * @param	int     $max_page
 * @return	none
 * based on next_posts_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_next_posts_link($label = NULL, $max_page = 0) {
	$label = ! is_null($label) ? $label : (__('#.Next', 'ktai_style') . '<img localsrc="8" alt="&raquo;">');
	global $paged, $wpdb, $wp_query;
	if ( !$max_page ) {
		$max_page = $wp_query->max_num_pages;
	}
	if ( !$paged )
		$paged = 1;
	$nextpage = intval($paged) + 1;
	if ( (! is_single()) && (empty($paged) || $nextpage <= $max_page) ) {
		echo '<a href="' . _strip_host(clean_url(get_next_posts_page_link($max_page))) . '" accesskey="#">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $label) .'</a>';
	}
}

/* ==================================================
 * @param	string  $sep
 * @param	string  $before
 * @param	string  $after
 * @return	none
 * based on posts_nav_link() at wp-includes/link-template of WP 2.2.3
 */
function ks_posts_nav_link($sep = ' | ', $before = '', $after = '') {
	if (is_singular()) {
		return;
	}
	global $wp_query;
	$max_num_pages = $wp_query->max_num_pages;
	$paged = get_query_var('paged');

	//only have sep if there's both prev and next results
	if ($paged < 2 || $paged >= $max_num_pages) {
		$sep = '';
	}

	if ( $max_num_pages > 1 ) {
		echo $before;
		ks_previous_posts_link();
		echo preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $sep);
		ks_next_posts_link();
		echo $after;
	}
	return;
}

/* ==================================================
 * @param	int     $num
 * @param	string  $first
 * @param	string  $last
 * @return	none
 */
function ks_posts_nav_multi($num = 3, $first = NULL, $last = NULL) {
	if ($num < 0 || $num > 9) { 
		$num = 3;
	}
	$first = ! is_null($first) ? $first : __('First', 'ktai_style');
	$last  = ! is_null($last)  ? $last  : __('Last', 'ktai_style');
	global $wp_query;
	if (is_singular()) {
		return;
	}
	$max_num_pages = $wp_query->max_num_pages;
	if ( $max_num_pages <= 1 ) {
		return;
	}
	$paged = intval(get_query_var('paged'));
	if ($paged < 1) {
		$paged = 1;
	}
	$output = '';
	if ($paged - $num > 1) {
		$output .= '<a href="' . _strip_host(clean_url(get_pagenum_link(1))) . '">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $first) .'</a>...';
	}
	for ($count = $paged - $num ; $count <= $paged + $num ; $count++) {
		if ($count < 1) {
			continue;
		} elseif ($count > $max_num_pages) {
			break;
		} elseif ($count == $paged -1) {
			$output .= ' <a href="' . _strip_host(clean_url(get_pagenum_link($count))) . '" accesskey="*">'. $count .'</a>';
		} elseif ($count == $paged) {
			$output .= " [$count]";
		} elseif ($count == $paged +1) {
			$output .= ' <a href="' . _strip_host(clean_url(get_pagenum_link($count))) . '" accesskey="#">'. $count .'</a>';
		} else {
			$output .= ' <a href="' . _strip_host(clean_url(get_pagenum_link($count))) . '">'. $count .'</a>';
		}
	}
	if ($paged + $num < $max_num_pages) {
		$output .= '...<a href="' . _strip_host(clean_url(get_pagenum_link($max_num_pages))) . '">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $last) .'</a>';
	}
	echo $output;
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_posts_nav_dropdown() {
	if (is_singular()) {
		return;
	}
	global $wp_query, $Ktai_Style;
	$max_num_pages = $wp_query->max_num_pages;
	if ($max_num_pages <= 1) {
		return;
	}
	$paged = intval(get_query_var('paged'));
	if ($paged < 1) {
		$paged = 1;
	}
	$link = get_pagenum_link($paged);
	$query = parse_url($link, PHP_URL_QUERY);
	if ($query) {
		parse_str($query, $params);
		unset($params['paged']);
		unset($params['kp']);
		$form_html = '';
		foreach($params as $k => $v) {
			$form_html .= '<input type="hidden" name="' . htmlspecialchars($k) . '" value="' . htmlspecialchars($v) . '" />';
		}
	} else {
		$link = preg_replace('!/page/\d+!', '', $link);
		$form_html = '';
	}
	$output = '<form method="get" action="' . htmlspecialchars(parse_url($link, PHP_URL_PATH)) . '">' . $form_html . '<select name="paged">';
	for ($count = 1; $count <= $max_num_pages ; $count++) {
		$output .= '<option value="' . $count . ($count == $paged ? '" selected="selected' : '') . '">' . $count . '</option>';
	}
	$output .= '</select><input type="submit" value="' . __('Move to page', 'ktai_style') . '" /></form>';
	if (! $Ktai_Style->ktai || ! ($size = $Ktai_Style->get('page_size')) || $size - 300 >= strlen($output)) {
		echo $output;
	}
	return;
}

/* ==================================================
 * @param	int     $id
 * @return	string  $address
 */
function ks_get_comments_list_link($id = 0) {
	$address = get_permalink($id);
	$address .= (strpos($address, '?') === FALSE ? '?' : '&' ) . 'view=co_list';
	return $address;
}

/* ==================================================
 * @param	string  $icon
 * @param	string  $zero
 * @param	string  $one
 * @param	string  $more
 * @return	string  $output
 * based on comments_popup_link() at wp-includes/comment-template.php of WP 2.2.3
 */
function ks_comments_link($icon = NULL, $zero = NULL, $one = NULL, $more = NULL, $none = NULL, $sec = NULL, $accesskey = NULL) {
	global $id, $post, $wpdb;
	if (is_page() ) {
		return;
	}
	$icon = ! is_null($icon) ? $icon : '<img localsrc="86" alt="" />';
	$zero = ! is_null($zero) ? $zero : __('No comments', 'ktai_style');
	$one  = ! is_null($one)  ? $one  : __('One comment', 'ktai_style');
	$more = ! is_null($more) ? $more : __('% comments', 'ktai_style');
	$none = ! is_null($none) ? $none : '<img localsrc="61" alt="' . __('X ', 'ktai_style') . '" />' . __('Comments off', 'ktai_style');
	$sec  = ! is_null($sec)  ? $sec  : __('View comments (Need password)', 'ktai_style');
	$number = get_comments_number($id);
	if ( 0 == $number && 'closed' == $post->comment_status && 'closed' == $post->ping_status ) {
		echo $icon . $none;
		return;
	}

	$co_addr = ks_get_comments_list_link();
	if (_confirmed_post_password()) {
		if ($number == 0) {
			echo $icon . $zero;
		} else {
			ob_start();
			comments_number($zero, $one, $more);
			$co_num = ob_get_contents();
			ob_end_clean();
			echo _internal_link($co_addr, $accesskey, $icon, $co_num, $post->post_password);
		}
	} else {
		if (strlen($accesskey) == 1 && strpos('123456789*#', $accesskey) !== FALSE) {
			$accesskey_html = ' accesskey="' . $accesskey . '"';
		} else {
			$accesskey_html = '';
		}
		echo $icon . '<a href="' . htmlspecialchars($co_addr, ENT_QUOTES) . '"' . $accesskey_html . '>' . $sec . '</a>';
	}
	return;
}

/* ==================================================
 * @param	int     $id
 * @return	string  $address
 * based on comments_popup_link() at wp-includes/comment-template.php of WP 2.2.3
 */
function ks_comments_post_url($id = 0) {
	$address = get_permalink($id);
	$address .= (strpos($address, '?') === FALSE ? '?' : '&' ) . 'view=co_post';
	return $address;
}

/* ==================================================
 * @param	string  $desc
 * @param	string  $before
 * @param	string  $after
 * @return	none
 * based on comments_popup_link() at wp-includes/comment-template.php of WP 2.2.3
 */
function ks_comments_post_link($desc = NULL, $before = '', $after = '', $icon = '<img localsrc="149" alt="" />', $accesskey = NULL) {
	if (comments_open()) {
		$desc = ! is_null($desc) ? $desc : __('Post comments', 'ktai_style');
		$co_post = ks_comments_post_url();
		global $post;
		$post_pass = _confirmed_post_password() ? $post->post_password : NULL;
		echo $before . _internal_link($co_post, $accesskey, $icon, $desc, $post_pass) . $after;
	}
}

/* ==================================================
 * @param	string  $icon
 * @param	stromg  $desc
 * @return	none
 */
function ks_back_to_post($icon = NULL, $desc = NULL) {
	$icon = ! is_null($icon) ? $icon : ('<img localsrc="64" alt="' . __('&lt;-', 'ktai_style') . '" />');
	$desc = ! is_null($desc) ? $desc : __('Back to the post', 'ktai_style');
	global $post;
	echo _internal_link(get_permalink(), '*', $icon, $desc, $post->post_password);
	return;
}

/* ==================================================
 * @param	int     $num
 * @param	string  $type
 * @return	array   $sorted
 */
function ks_get_recent_comments($num = 20, $type = '') {
	global $wpdb, $comment;
	if (! is_numeric($num) || $num <= 0) {
		$num = 20;
	} else {
		$num = intval($num);
	}
	if ($type == 'comment') {
		$refine = "AND comment_type = ''";
	} elseif ($type == 'trackback+pingback') {
		$refine = "AND (comment_type = 'trackback' OR comment_type = 'pingback')";
	} elseif ($type == 'trackback') {
		$refine = "AND comment_type = 'trackback'";
	} elseif ($type == 'pingback') {
		$refine = "AND comment_type = 'pingback'";
	} else {
		$refine = '';
	}
	$comments = $wpdb->get_results( "SELECT * FROM $wpdb->comments WHERE comment_approved = '1' $refine ORDER BY comment_date DESC LIMIT $num" );
	if (count($comments) <= 0) {
		return NULL;
	}
	$sorted = array();
	foreach ($comments as $c) {
		$post_id = $c->comment_post_ID;
		if (! isset($sorted[$post_id])) {
			$sorted[$post_id][] = get_post($post_id);
		}
		$sorted[$post_id][] = $c;
	}
	return $sorted;
}

/* ==================================================
 * @param	string  $separator
 * @return	none
 */
function ks_category($separator = ', ') {
	$categories = get_the_category();
	if (count($categories)) {
		$cat_links = array();
		foreach ($categories as $c) {
			$cat_links[] = '<a href="' . get_category_link($c->cat_ID) . '">' . attribute_escape($c->cat_name) . '</a>';
		}
		echo implode($separator, $cat_links);
	}
	return;
}

/* ==================================================
 * @param	string  $separator
 * @return	none
 */
function ks_tags($before = '', $after = '', $separator = ', ') {
	if (! function_exists('get_the_tags')) {
		return NULL;
	}
	$tags = get_the_tags();
	if ($tags) {
		$tag_links = array();
		foreach ($tags as $t) {
			$tag_links[] = '<a href="' . get_tag_link($t->term_id) . '">' . attribute_escape($t->name) . '</a>';
		}
		echo $before . implode($separator, $tag_links) . $after;
	}
	return;
}

/* ==================================================
 * @param	mix     $args
 * @return	none
 * baased on wp_tag_cloud() at category-template.php of WP 2.3.1
 */
function ks_tag_cloud($args = '') {
	if (! function_exists('get_tags')) {
		return NULL;
	}
	$defaults = array(
		'number' => 45, 'format' => 'flat', 'orderby' => 'name',
		 'order' => 'ASC', 'exclude' => '', 'include' => ''
	);
	$args = wp_parse_args( $args, $defaults );
	$tags = get_tags( array_merge($args, array('orderby' => 'count', 'order' => 'DESC')) ); // Always query top tags

	if (empty($tags)) {
		return;
	}
	$return = _generate_tag_cloud($tags, $args);
	if (is_wp_error($return)) {
		return false;
	} else {
		echo apply_filters( 'wp_tag_cloud', $return, $args );
	}
}

/* ==================================================
 * @param	array   $tags
 * @param	mix     $args
 * @return	none
 * baased on wp__generate_tag_cloud at category-template.php of WP 2.3.1
 */
function _generate_tag_cloud($tags, $args = '') {
	global $wp_rewrite, $Ktai_Style;
	$defaults = array(
		'smallest' => 1, 'largest' => 6, 'unit' => '', 'number' => 45,
		'format' => 'flat', 'orderby' => 'name', 'order' => 'ASC'
	);
	$args = wp_parse_args( $args, $defaults );
	extract($args);

	if (! $tags) {
		return;
	}
	$counts = $tag_links = array();
	foreach ( (array) $tags as $tag ) {
		$counts[$tag->name] = $tag->count;
		$tag_links[$tag->name] = get_tag_link( $tag->term_id );
		if ( is_wp_error( $tag_links[$tag->name] ) )
			return $tag_links[$tag->name];
		$tag_ids[$tag->name] = $tag->term_id;
	}

	$min_count = min($counts);
	$spread = max($counts) - $min_count;
	if ($spread <= 0) {
		$spread = 1;
	}
	$font_spread = $largest - $smallest;
	if ($font_spread <= 0) {
		$font_spread = 1;
	}
	$font_step = $font_spread / $spread;

	if ('name' == $orderby) {
		uksort($counts, 'strnatcasecmp');
	} else {
		asort($counts);
	}
	if ('DESC' == $order) {
		$counts = array_reverse($counts, true);
	}
	$a = array();

	foreach ($counts as $tag => $count) {
		$tag_id = $tag_ids[$tag];
		$tag_link = clean_url($tag_links[$tag]);
		$tag = str_replace(' ', '&nbsp;', attribute_escape( $tag ));
		$a[] = '<font size="' . ($smallest + (($count - $min_count) * $font_step)) . '"><a href="' . $tag_link . '">' . $tag . '</a></font>';
	}

	switch ( $format ) :
	case 'array' :
		$return = &$a;
		break;
	case 'list' :
		$return = '<ul><li>' . implode('</li><li>', $a) . '</li></ul>';
		break;
	default :
		$return = implode(' ', $a);
		break;
	endswitch;

	return $return;
}

/* ==================================================
 * @param	mix     $args
 * @return	none
 */
function ks_get_archives($args = '') {
	global $Ktai_Style;
	ob_start();
	wp_get_archives($args);
	$output = ob_get_contents();
	ob_end_clean();
	$output = $Ktai_Style->filter_tags($output);
	$output = preg_replace('/ ?(\d+) ?/', '\\1' , $output);
	$output = str_replace('&nbsp;', ' ' , $output);
	$short_url = _strip_host(get_bloginfo('url') . '/');
	$output = preg_replace('!href=([\'"])' . preg_quote(get_bloginfo('url'), '!') . '/?!', 'href=$1' . $short_url, $output); //": fix for SubEthaEdit syntax formatting
	echo $output;
	return;
}

/* ==================================================
 * @param	mix     $args
 * @return	none
 */
function ks_list_bookmarks($args = '') {
	global $Ktai_Style;
	if (is_array($args)) {
		$r = &$args;
	} else {
		parse_str($args, $r);
	}
	$r = array_merge(array('echo' => 0), $r);
	$output = wp_list_bookmarks($r);
	$output = $Ktai_Style->filter_tags($output);
	$output = preg_replace('/ ?(\d+) ?/', '\\1' , $output);
	$output = str_replace('&nbsp;', ' ' , $output);
	echo $output;
	return;
}

/* ==================================================
 * @param	string  $sep
 * @param	string  $before
 * @param	string  $after
 * @return	none
 */
function ks_pages_menu($sep = ' | ', $before = '', $after = '') {
	$r = array('depth' => 0, 'child_of' => 0, 'exclude' => '', 'authors' => '', 'sort_column' => 'menu_order, ID');
	$pages = get_pages($r);
	$menu = array();
	if (count($pages)) {
		foreach ($pages as $p) {
			$menu[] = '<a href="' . _strip_host(get_page_link($p->ID)) . '">' . attribute_escape($p->post_title) . '</a>';
		}
		echo $before . implode($sep, $menu) . $after;
	}
	return;
}

/* ==================================================
 * @param	string  $before
 * @param	string  $after
 * @return	none
 */
function ks_switch_pc_view($before = ' (', $after = ')') {
	global $Ktai_Style;
	$Ktai_Style->switch_pc_view($before, $after);
}
?>