<?php
/*
Plugin Name: WP-lightpop
Version: 0.3.6
Plugin URI: http://wppluginsj.sourceforge.jp/wp-lightpop/
Description: Add overlay images and videos (and more) to Your Wordpress site.
Author: wokamoto
Author URI: http://dogmap.jp/

 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html
*/

class LightPopController {
  var $plugin_name  = 'wp-lightpop';

  var $jquery_js    = 'jquery-1.2.2.min.js';
  var $jquery_ver   = '1.2.2';

  var $lightpop_js  = 'jquery.lightpop-0.3.6.min.js';
  var $lightpop_ver = '0.3.6';

  var $js_type = array(
        0 => 'jQuery'
       ,1 => 'jQuery.noConflict'
      );

  var $frame_type = array(
        0 => array('Border')
       ,1 => array('Default box',          'images/box0.gif', 'images/box0_l.gif', 'images/box0_r.gif', '#FFF', 17)
       ,2 => array('Emboss',               'images/box1.gif', 'images/box1_l.gif', 'images/box1_r.gif', '#FFF',  6)
       ,3 => array('Drop shadow',          'images/box2.gif', 'images/box2_l.gif', 'images/box2_r.gif', '#FFF',  6)
       ,4 => array('Shadow in the inside', 'images/box3.gif', 'images/box3_l.gif', 'images/box3_r.gif', '#FFF',  6)
       ,5 => array('Double shadow',        'images/box4.gif', 'images/box4_l.gif', 'images/box4_r.gif', '#FFF',  9)
       ,6 => array('Detainment of corner', 'images/box5.gif', 'images/box5_l.gif', 'images/box5_r.gif', '#FFF', 16)
       ,9 => array('Original design')
      );

  var $options_default = array(
        'overlayBgColor'       => "#000"
       ,'overlayOpacity'       => 0.7
       ,'contentFrameType'     => 0
       ,'contentBorder'        => "none"
       ,'contentBgColor'       => "#FFF"
       ,'imageLoading'         => "images/lightpop-ico-loading.gif"
       ,'imageBtnPrev'         => "images/lightpop-btn-prev.gif"
       ,'imageBtnNext'         => "images/lightpop-btn-next.gif"
       ,'imageBtnClose'        => "images/lightpop-btn-close.gif"
       ,'imageBlank'           => "images/lightpop-blank.gif"
       ,'imageBox'             => "images/lightpop-box.gif"
       ,'imageBorderL'         => "images/lightpop-border-l.gif"
       ,'imageBorderR'         => "images/lightpop-border-r.gif"
       ,'containerBorderSize'  => 10
       ,'boxBorderSize'        => 6
       ,'containerResizeSpeed' => 400
       ,'txtImage'             => "Image"
       ,'txtOf'                => "of"
       ,'keyToClose'           => "c"
       ,'keyToPrev'            => "p"
       ,'keyToNext'            => "n"
       ,'flvplayer'            => "flvplayer.swf"
       ,'iconAdd'              => 0
       ,'iconPath'             => "images/"
      );

  var $options = array();
  var $note,$error;

  /*
  * Constructor
  */
  function LightPopController() {
    $this->note = '';
    $this->error = 0;

    $wkoptions = get_option($this->plugin_name." Options");
    if (!is_array($wkoptions)) {
      $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $plugin_root = preg_replace('/^https?:\/\/[^\/]*/i' , '', $this->options['plugin_uri']);

      $this->options['js_type']              = strtolower($this->js_type[0]);
//      $this->options['load_framework']       = 0;
      $this->options['targetCSS']            = "a[@href$=.jpg], a[@href$=.gif], a[@href$=.png], a[@href$=.JPG], a[@href$=.GIF], a[@href$=.PNG]"."\n"."a[@href^=http://www.youtube.com/watch], a[@href^=http://jp.youtube.com/watch]";

      $this->options['overlayBgColor']       = $this->options_default['overlayBgColor'];
      $this->options['overlayOpacity']       = $this->options_default['overlayOpacity'];
      $this->options['contentFrameType']     = $this->options_default['contentFrameType'];
      $this->options['contentBorder']        = $this->options_default['contentBorder'];
      $this->options['contentBgColor']       = $this->options_default['contentBgColor'];
      $this->options['imageLoading']         = $plugin_root."/".$this->options_default['imageLoading'];
      $this->options['imageBtnPrev']         = $plugin_root."/".$this->options_default['imageBtnPrev'];
      $this->options['imageBtnNext']         = $plugin_root."/".$this->options_default['imageBtnNext'];
      $this->options['imageBtnClose']        = $plugin_root."/".$this->options_default['imageBtnClose'];
      $this->options['imageBlank']           = $plugin_root."/".$this->options_default['imageBlank'];
      $this->options['imageBox']             = $plugin_root."/".$this->options_default['imageBox'];
      $this->options['imageBorderL']         = $plugin_root."/".$this->options_default['imageBorderL'];
      $this->options['imageBorderR']         = $plugin_root."/".$this->options_default['imageBorderR'];
      $this->options['boxBorderSize']        = $this->options_default['boxBorderSize'];
      $this->options['containerBorderSize']  = $this->options_default['containerBorderSize'];
      $this->options['containerResizeSpeed'] = $this->options_default['containerResizeSpeed'];
      $this->options['txtImage']             = $this->options_default['txtImage'];
      $this->options['txtOf']                = $this->options_default['txtOf'];
      $this->options['keyToClose']           = $this->options_default['keyToClose'];
      $this->options['keyToPrev']            = $this->options_default['keyToPrev'];
      $this->options['keyToNext']            = $this->options_default['keyToNext'];
      if (file_exists('../videopop_plus/'.$this->options_default['flvplayer'])) {
       $this->options['flvplayer']            = filetrailingslashit(get_settings('siteurl')).'wp-content/plugins/videopop_plus/'.$this->options_default['flvplayer'];
      } else {
       $this->options['flvplayer']            = $plugin_root."/".$this->options_default['flvplayer'];
      }
      $this->options['iconAdd']              = $this->options_default['iconAdd'];
      $this->options['iconPath']             = $plugin_root."/".$this->options_default['iconPath'];
      $this->options['lightpop_option']      = $this->getLightpopOption();

      $this->update_options();
    } else {
      $this->options = $wkoptions;
    }
  }

  function getLightpopOption() {
    $plugin_root = preg_replace('/^https?:\/\/[^\/]*/i' , '', $this->options['plugin_uri']);
    return '{'
      .'imageLoading:"'.$this->options['imageLoading'].'",'
      .'imageBtnPrev:"'.$this->options['imageBtnPrev'].'",'
      .'imageBtnNext:"'.$this->options['imageBtnNext'].'",'
      .'imageBtnClose:"'.$this->options['imageBtnClose'].'",'
      .'imageBlank:"'.$this->options['imageBlank'].'",'
      .($this->options['contentFrameType'] != $this->options_default['contentFrameType'] ? 'contentFrameType:"'.($this->options['contentFrameType'] == 0 ? 'border' : 'box').'",' : '')
      .($this->options['contentFrameType'] == 0 && $this->options['overlayBgColor'] != $this->options_default['overlayBgColor'] ? 'overlayBgColor:"'.$this->options['overlayBgColor'].'",' : '')
      .($this->options['contentFrameType'] == 0 && $this->options['contentBorder'] != $this->options_default['contentBorder'] ? 'contentBorder:"'.$this->options['contentBorder'].'",' : '')
      .($this->options['contentFrameType'] != 0 && $this->options['contentFrameType'] != 9 ? 'overlayBgColor:"'.$this->frame_type[$this->options['contentFrameType']][4].'",boxBorderSize:'.$this->frame_type[$this->options['contentFrameType']][5].',imageBox:"'.$plugin_root."/".$this->frame_type[$this->options['contentFrameType']][1].'",imageBorderL:"'.$plugin_root."/".$this->frame_type[$this->options['contentFrameType']][2].'",imageBorderR:"'.$plugin_root."/".$this->frame_type[$this->options['contentFrameType']][3].'",' : '')
      .($this->options['contentFrameType'] == 9 ? 'overlayBgColor:"'.$this->options['overlayBgColor'].'",boxBorderSize:'.$this->options['boxBorderSize'].',imageBox:"'.$this->options['imageBox'].'",imageBorderL:"'.$this->options['imageBorderL'].'",imageBorderR:"'.$this->options['imageBorderR'].'",' : '')
      .($this->options['overlayOpacity'] != $this->options_default['overlayOpacity'] ? 'overlayOpacity:'.$this->options['overlayOpacity'].',' : '')
      .($this->options['contentBgColor'] != $this->options_default['contentBgColor'] ? 'contentBgColor:"'.$this->options['contentBgColor'].'",' : '')
      .($this->options['containerBorderSize'] != $this->options_default['containerBorderSize'] ? 'containerBorderSize:'.$this->options['containerBorderSize'].',' : '')
      .($this->options['containerResizeSpeed'] != $this->options_default['containerResizeSpeed'] ? 'containerResizeSpeed:'.$this->options['containerResizeSpeed'].',' : '')
      .($this->options['txtImage'] != $this->options_default['txtImage'] ? 'txtImage:"'.$this->options['txtImage'].'",' : '')
      .($this->options['txtOf'] != $this->options_default['txtOf'] ? 'txtOf:"'.$this->options['txtOf'].'",' : '')
      .($this->options['keyToClose'] != $this->options_default['keyToClose'] ? 'keyToClose:"'.$this->options['keyToClose'].'",' : '')
      .($this->options['keyToPrev'] != $this->options_default['keyToPrev'] ? 'keyToPrev:"'.$this->options['keyToPrev'].'",' : '')
      .($this->options['keyToNext'] != $this->options_default['keyToNext'] ? 'keyToNext:"'.$this->options['keyToNext'].'",' : '')
      .($this->options['iconAdd'] == 1 ? 'iconAdd:true,iconImage:"'.$this->options['iconPath'].'icon-image.png",iconVideo:"'.$this->options['iconPath'].'icon-video.png",iconYouTube:"'.$this->options['iconPath'].'icon-youtube.png",iconMetacafe:"'.$this->options['iconPath'].'icon-metacafe.png",iconLiveLeak:"'.$this->options['iconPath'].'icon-liveleak.png",iconGoogleVideo:"'.$this->options['iconPath'].'icon-googlevideo.png",iconifilm:"'.$this->options['iconPath'].'icon-ifilm.png",iconDailymotion:"'.$this->options['iconPath'].'icon-dailymotion.png",iconContents:"'.$this->options['iconPath'].'icon-html.png",' : 'iconAdd:false,')
      .'flvplayer:"'.$this->options['flvplayer'].'"'
      .'}';
  }

  /*
  * Handles Add/strips slashes to the given array
  */
  function stripArray($array) {
    if(is_array($array)) {
      // If already slashed, strip.
      foreach($array as $key => $value) {$slashed_array[$key] = stripslashes($value);}
    } else {
      return $array;
    }
    return $slashed_array;
  }

  function update_options() {
    update_option($this->plugin_name." Options", $this->options);
  }

  // regist script
  function re_regist_script( $handle, $src = '', $deps = false, $ver = false ) {
    global $wp_scripts;
    if ( !is_a($wp_scripts, 'WP_Scripts') ) $wp_scripts = new WP_Scripts();
    if ( isset($wp_scripts->scripts[$handle]) ) {
      if ( $wp_scripts->scripts[$handle]->ver < $ver ) {
        if ($src  != '')     $wp_scripts->scripts[$handle]->src  = $src;
        if (is_array($deps)) $wp_scripts->scripts[$handle]->deps = $deps;
        if ($ver  != false)  $wp_scripts->scripts[$handle]->ver  = $ver;
      }
    } else {
      if (!is_array($deps)) $deps = array();
      $wp_scripts->add( $handle, $src, $deps, $ver );
    }
  }

  function enqueueScript() {
    if (!is_admin()) {
      $this->re_regist_script('jquery', $this->options['plugin_uri'].'/js/'.$this->jquery_js, false, $this->jquery_ver);
      wp_enqueue_script('jquery.lightpop', $this->options['plugin_uri'].'/js/'.$this->lightpop_js, array('jquery'), $this->lightpop_ver);
    }
  }

  function addHeadJs() {
    $out  = '';
//    if ($this->options['load_framework'] == '1') {
//      $out .= '<script type="text/javascript" src="'.$this->options['plugin_uri'].'/js/'.$this->jquery_js.'"></script>'."\n";
//    }
    if ($this->options['js_type'] == strtolower($this->js_type[1])) {
      $out .= '<script type="text/javascript">jQuery.noConflict();</script>'."\n";
    }

    echo $out;
  }

  function addLightPopJs() {
//    $out  = '<script type="text/javascript" src="'.$this->options['plugin_uri'].'/js/'.$this->lightpop_js.'"></script>'."\n";

    if (!isset($this->options['lightpop_option'])) {
      $this->options['lightpop_option'] = $this->getLightpopOption();
      $this->update_options();
    }

    $jQuery = ($this->options['js_type'] == strtolower($this->js_type[0]) ? '$' : 'jQuery');
    $out .= '<script type="text/javascript">';
    $out .= $jQuery.'(function(){';
    $out .= 'var l='.$this->options['lightpop_option'].';';
    foreach(preg_split('/[\n\r]/',$this->options['targetCSS']) as $value) {
     if (trim($value) != '') {$out .= $jQuery.'("'.trim($value).'").lightpop(l);';}
    }
    $out .= '});';
    $out .= '</script>'."\n";

    echo $out;
  }

  function addAdminMenu() {
    add_options_page(__('LightPop', 'wp-lightpop'), __('LightPop', 'wp-lightpop'), 9, basename(__FILE__), array($this,'optionPage'));
  }

  function optionPage() {
    // options update
    if(isset($_POST['ap_options_update'])) {
      // strip slashes array
      $_POST = $this->stripArray($_POST);

      // get options
      $this->options['js_type'] = strtolower($this->js_type[$_POST['js_type']]);
//      $this->options['load_framework'] = $_POST['load_framework'];
      $this->options['targetCSS'] = $_POST['ap_targetCSS'];
      $this->options['overlayBgColor'] = $_POST['ap_overlayBgColor'];
      $this->options['overlayOpacity'] = $_POST['ap_overlayOpacity'];
      $this->options['contentFrameType'] = $_POST['ap_contentFrameType'];
      $this->options['contentBorder'] = $_POST['ap_contentBorder'];
      $this->options['contentBgColor'] = $_POST['ap_contentBgColor'];
      $this->options['imageLoading'] = $_POST['ap_imageLoading'];
      $this->options['imageBtnPrev'] = $_POST['ap_imageBtnPrev'];
      $this->options['imageBtnNext'] = $_POST['ap_imageBtnNext'];
      $this->options['imageBtnClose'] = $_POST['ap_imageBtnClose'];
      $this->options['imageBlank'] = $_POST['ap_imageBlank'];
      $this->options['boxBorderSize'] = $_POST['ap_boxBorderSize'];
      $this->options['imageBox'] = $_POST['ap_imageBox'];
      $this->options['imageBorderL'] = $_POST['ap_imageBorderL'];
      $this->options['imageBorderR'] = $_POST['ap_imageBorderR'];
      $this->options['containerBorderSize'] = $_POST['ap_containerBorderSize'];
      $this->options['containerResizeSpeed'] = $_POST['ap_containerResizeSpeed'];
      $this->options['txtImage'] = $_POST['ap_txtImage'];
      $this->options['txtOf'] = $_POST['ap_txtOf'];
      $this->options['keyToClose'] = $_POST['ap_keyToClose'];
      $this->options['keyToPrev'] = $_POST['ap_keyToPrev'];
      $this->options['keyToNext'] = $_POST['ap_keyToNext'];
      $this->options['flvplayer'] = $_POST['ap_flvplayer'];
      $this->options['iconAdd'] = $_POST['ap_iconAdd'];
      $this->options['iconPath'] = $_POST['ap_iconPath'];
      $this->options['plugin_uri'] = trailingslashit(get_settings('siteurl')).'wp-content/plugins/'.basename(dirname(__FILE__));
      $this->options['lightpop_option'] = $this->getLightpopOption();
      $_POST = '';

      // Done!
      $this->update_options();
      $this->note .= __('<strong>Done!</strong>', 'wp-lightpop');
    }

    $out  = '';

    // Add Options
    $out .= '<div class="wrap">'."\n";
    $out .= '<h2>'.__('WP-LightPop Options', 'wp-lightpop').'</h2><br />'."\n";
    $out .= '<form method="post" id="update_options" action="'.$_SERVER['REQUEST_URI'].'">'."\n";

    $out .= '<table>'."\n";

    // Choose Javascript Framework
    $out .= '<tr>';
    $out .= '<td><strong>'.__('jQuery Type', 'wp-lightpop').'</strong></td>';
    $out .= '<td>';
    $out .= '<select name="js_type">';
    for ($i = 0; $i < sizeof($this->js_type); $i++) {
      $out .= '<option value="'.$i.'"'.($this->options['js_type'] == strtolower($this->js_type[$i]) ? ' selected="selected"' : '').'>'.__($this->js_type[$i], 'wp-lightpop').'</option>';
    }
    $out .= '</select>';
//    $out .= '&nbsp;<input type="checkbox" name="load_framework" value="1" style="margin-right:0.5em" '.($this->options['load_framework']==1?' checked':'').' />'.__('Add Header', 'wp-lightpop');
    $out .= '</td>';
    $out .= '</tr>'."\n";

    // Target CSS
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Target Element', 'wp-lightpop').'</strong></td>';
    $out .= '<td><textarea name="ap_targetCSS" cols="100" rows="5">'.$this->options['targetCSS'].'</textarea></td>';
    $out .= '</tr>'."\n";

    // Choose Frame type
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Frame type', 'wp-lightpop').'</strong></td>';
    $out .= '<td>';
    $out .= '<select name="ap_contentFrameType" onchange="javascript:if(this.value==9){document.getElementById(\'lightpop-box-options\').style.display=\'block\'}else{document.getElementById(\'lightpop-box-options\').style.display=\'none\';}">';
    foreach($this->frame_type as $key => $value) {
      $out .= '<option value="'.$key.'"'.($this->options['contentFrameType'] == $key ? ' selected="selected"' : '').'>'.__($value[0], 'wp-lightpop').'</option>';
    }
    $out .= '</select>';
    $out .= '<div id="lightpop-box-options"'.($this->options['contentFrameType'] != 9 ? ' style="display:none"' : '').'><br /><table>';
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Border Size', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_boxBorderSize" id="ap_boxBorderSize" size="10" value="'.$this->options['boxBorderSize'].'" /></td>';
    $out .= '</tr>';
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Box Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBox" id="ap_imageBox" size="75" value="'.$this->options['imageBox'].'" /></td>';
    $out .= '</tr>';
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Border left Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBorderL" id="ap_imageBorderL" size="75" value="'.$this->options['imageBorderL'].'" /></td>';
    $out .= '</tr>';
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Border right Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBorderR" id="ap_imageBorderR" size="75" value="'.$this->options['imageBorderR'].'" /></td>';
    $out .= '</tr>';
    $out .= '</table></div>';
    $out .= '</td>';
    $out .= '</tr>'."\n";

    // icon add
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Link icon', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="checkbox" name="ap_iconAdd" value="1" style="margin-right:0.5em" '.($this->options['iconAdd']==1?' checked':'').' />'.__('Before link', 'wp-lightpop').'</td>';
    $out .= '</tr>'."\n";

    $out .= '</table>'."\n";

    // more options
    $out .= '<a href="#" onclick="javascript:document.getElementById(\'lightpop-more-options\').style.display=\'block\';this.style.display=\'none\';return false;">'.__('More options', 'wp-lightpop').'</a><br />'."\n";

    $out .= '<div id="lightpop-more-options" style="display:none"><table>'."\n";

    // overlay
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Overlay', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Background color', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_overlayBgColor" id="ap_overlayBgColor" size="10" value="'.$this->options['overlayBgColor'].'" /></td>';
    $out .= '</tr>'."\n";

    $out .= '<tr>';
    $out .= '<td></td>';
    $out .= '<td><strong>'.__('Opacity', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_overlayOpacity" size="5" value="'.$this->options['overlayOpacity'].'" /></td>';
    $out .= '</tr>'."\n";

    // content border
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Content', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Border CSS', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_contentBorder" size="75" value="'.$this->options['contentBorder'].'" /></td>';
    $out .= '</tr>'."\n";

    // Container
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Container', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Border size', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_containerBorderSize" size="5" value="'.$this->options['containerBorderSize'].'" /></td>';
    $out .= '</tr>'."\n";

    $out .= '<tr>';
    $out .= '<td></td>';
    $out .= '<td><strong>'.__('Resize speed', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_containerResizeSpeed" size="5" value="'.$this->options['containerResizeSpeed'].'" /></td>';
    $out .= '</tr>'."\n";

    $out .= '<tr>';
    $out .= '<td></td>';
    $out .= '<td><strong>'.__('Background color', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_contentBgColor" size=10 value="'.$this->options['contentBgColor'].'" /></td>';
    $out .= '</tr>'."\n";

    // Prev button image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Prev button', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBtnPrev" size="75" value="'.$this->options['imageBtnPrev'].'" /></td>';
    $out .= '</tr>'."\n";

    // Next button image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Next button', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBtnNext" size="75" value="'.$this->options['imageBtnNext'].'" /></td>';
    $out .= '</tr>'."\n";

    // Close button image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Close button', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBtnClose" size="75" value="'.$this->options['imageBtnClose'].'" /></td>';
    $out .= '</tr>'."\n";

    // Loading image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Loading', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageLoading" size="75" value="'.$this->options['imageLoading'].'" /></td>';
    $out .= '</tr>'."\n";

    // Blank image
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Blank', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_imageBlank" size="75" value="'.$this->options['imageBlank'].'" /></td>';
    $out .= '</tr>'."\n";

    // Navigation text
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Navigation', 'wp-lightpop').'</strong></td>';
//    $out .= '<td><strong>'.__('Default text', 'wp-lightpop').'</strong></td>';
//    $out .= '<td><input type="text" name="ap_txtImage" size="10" value="'.$this->options['txtImage'].'" /></td>';
//    $out .= '</tr>'."\n";
//
//    $out .= '<tr>';
//    $out .= '<td></td>';
    $out .= '<td><strong>'.__('text of', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_txtOf" size="5" value="'.$this->options['txtOf'].'" /></td>';
    $out .= '</tr>'."\n";

    // Key navigation
    $out .= '<tr>';
    $out .= '<td><strong>'.__('Key bind', 'wp-lightpop').'</strong></td>';
    $out .= '<td><strong>'.__('to Prev', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_keyToPrev" size="5" value="'.$this->options['keyToPrev'].'" /></td>';
    $out .= '</tr>'."\n";

    $out .= '<tr>';
    $out .= '<td></td>';
    $out .= '<td><strong>'.__('to Next', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_keyToNext" size="5" value="'.$this->options['keyToNext'].'" /></td>';
    $out .= '</tr>'."\n";

    $out .= '<tr>';
    $out .= '<td></td>';
    $out .= '<td><strong>'.__('to Close', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_keyToClose" size="5" value="'.$this->options['keyToClose'].'" /></td>';
    $out .= '</tr>'."\n";

//    // icon path
//    $out .= '<tr>';
//    $out .= '<td><strong>'.__('Link icon', 'wp-lightpop').'</strong></td>';
//    $out .= '<td><strong>'.__('Image path', 'wp-lightpop').'</strong></td>';
//    $out .= '<td><input type="text" name="ap_iconPath" size="75" value="'.$this->options['iconPath'].'" /></td>';
//    $out .= '</tr>'."\n";

    // flvplayer
    $out .= '<tr>';
    $out .= '<td colspan=2><strong>'.__('FLV player path', 'wp-lightpop').'</strong></td>';
    $out .= '<td><input type="text" name="ap_flvplayer" size="75" value="'.$this->options['flvplayer'].'" /></td>';
    $out .= '</tr>'."\n";

    $out .= '</table></div>'."\n";

    // more options
    $out .= '<input type="hidden" name="ap_iconPath" value="'.$this->options['iconPath'].'" />';
    $out .= '<input type="hidden" name="ap_txtImage" value="'.$this->options['txtImage'].'" />';

    // Add Update Button
    $out .= '<div style="text-align:right"><input type="submit" name="ap_options_update" value="'.__('Update Options', 'wp-lightpop').'" class="button" style="font-size:11px;" /></div>';
    $out .= '</form></div>'."\n";

    // Note snuff
    if(!empty($this->note)) {$this->note  = '<div id="message" class="updated fade"><p>'.$this->note.'</p></div>'."\n";}

    // If any error, dont display body
    if($this->error>0) {$out = '';}

    // Output
    echo $this->note."\n";
    echo $out."\n";
  }

}//class

load_plugin_textdomain('wp-lightpop','wp-content/plugins/wp-lightpop');

$wpLightPop = new LightPopController();

add_action('admin_menu', array(&$wpLightPop,'addAdminMenu'));

$wpLightPop->enqueueScript();
add_action('wp_head',array(&$wpLightPop,'addHeadJs'));
add_action('wp_footer',array(&$wpLightPop,'addLightPopJs'),100);

unset($wpLightPop);
?>