/**
 * jQuery lightpop plugin
 * This jQuery plugin was inspired on jQuery lightBox plugin by Leandro Vieira Pinho (http://leandrovieira.com/projects/jquery/lightpop/)
 * @name jquery.lightpop-0.2.3.js
 * @author wokamoto - http://dogmap.jp
 * @version 0.2.3
 * @date December 25, 2007
 * @category jQuery plugin
 * @copyright (c) 2007 wokamoto (dogmap.jp)
 * @license  Released under the GPL license (http://www.gnu.org/copyleft/gpl.html)
 * @example http://dogmap.jp/lightpop_sample/sample.html
 */
(function(jQuery){
jQuery.fn.lightpop = function(settings){
 settings = jQuery.extend({
   overlayBgColor:	'#000'
  ,overlayOpacity:	0.8
  ,contentFrameType:	'border'
  ,contentBorder:	'none'
  ,boxBorderSize:	17
  ,containerBorderSize:	10
  ,containerResizeSpeed:400
  ,contentBgColor:	'#FFF'
  ,imageBox:		'images/lightpop-box.gif'
  ,imageBorderL:	'images/lightpop-border-l.gif'
  ,imageBorderR:	'images/lightpop-border-r.gif'
  ,imageLoading:	'images/lightpop-ico-loading.gif'
  ,imageBtnPrev:	'images/lightpop-btn-prev.gif'
  ,imageBtnNext:	'images/lightpop-btn-next.gif'
  ,imageBtnClose:	'images/lightpop-btn-close.gif'
  ,imageBlank:		'images/lightpop-blank.gif'
  ,txtImage:		'Image'
  ,txtOf:		'of'
  ,keyToClose:		'c'
  ,keyToPrev:		'p'
  ,keyToNext:		'n'
  ,flvplayer:		'flvplayer.swf'
  ,iconAdd:		true
  ,iconImage:		'images/icon-image.png'
  ,iconVideo:		'images/icon-video.png'
  ,iconContents:	'images/icon-html.png'
  ,iconYouTube:		'images/icon-youtube.png'
  ,iconMetacafe:	'images/icon-metacafe.png'
  ,iconLiveLeak:	'images/icon-liveleak.png'
  ,iconGoogleVideo:	'images/icon-googlevideo.png'
  ,iconifilm:		'images/icon-ifilm.png'
 }, settings);
 var frameBorder = (settings.contentFrameType.toLowerCase() == 'border');

 var fileTypes = new Array(
  {
   type: 'Image'
  ,match: function(strUrl){return (strUrl.match(/\.(jpe?g|gif|png|bmp)[\?]?.*$/i) != null);}
  ,set: function(contentNo){
    image_load(contentInfo[contentNo].href, (function(n){return function(){
     var arrSizes = get_sizes_from_str(this.src);
     if (arrSizes == null) {arrSizes = new Array(this.width, this.height);}
     contentInfo[n] = jQuery.extend(contentInfo[n], {content:'<img src="' + this.src.replace(/\?.*$/, '') + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" />', width:arrSizes[0], height:arrSizes[1], later:(jQuery.browser.msie ? 250 : 100)});
     set_content_to_view(n);
     this.onload = function(){};
    }}).call(this, contentNo));
   }
  ,preload: function(contentNo){
    image_load(contentInfo[contentNo].href, (function(n){return function(){
     var arrSizes = get_sizes_from_str(this.src);
     if (arrSizes == null) {arrSizes = new Array(this.width, this.height);}
     contentInfo[n] = jQuery.extend(contentInfo[n], {content:'<img src="' + this.src.replace(/\?.*$/, '') + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" />', width:arrSizes[0], height:arrSizes[1], later:(jQuery.browser.msie ? 250 : 100)});
     this.onload = function(){};
    }}).call(this, contentNo));
   }
  ,icon: settings.iconImage
  }
 ,{
   type: 'Video'
  ,match: function(strUrl){return (strUrl.match(/\.(flv|swf|rm|mov|3gp|mp4|asf|avi|mpg|wmv)[\?]?.*$/i) != null);}
  ,set: function(contentNo){
    contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'v'));
    set_content_to_view(contentNo);
   }
  ,preload: function(contentNo){contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'v'));}
  ,icon: settings.iconVideo
  }
 ,{
   type: 'YouTube'
  ,match: function(strUrl){return (strUrl.match(/youtube\.com\/watch/i) != null);}
  ,set: function(contentNo){
    contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'y'));
    set_content_to_view(contentNo);
   }
  ,preload: function(contentNo){contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'y'));}
  ,icon: settings.iconYouTube
  }
 ,{
   type: 'metacafe'
  ,match: function(strUrl){return (strUrl.match(/metacafe\.com\/watch/i) != null);}
  ,set: function(contentNo){
    contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'm'));
    set_content_to_view(contentNo);
   }
  ,preload: function(contentNo){contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'm'));}
  ,icon: settings.iconMetacafe
  }
 ,{
   type: 'LiveLeak'
  ,match: function(strUrl){return (strUrl.match(/liveleak\.com\/view/i) != null);}
  ,set: function(contentNo){
    contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'l'));
    set_content_to_view(contentNo);
   }
  ,preload: function(contentNo){contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'l'));}
  ,icon: settings.iconLiveLeak
  }
 ,{
   type: 'GoogleVideo'
  ,match: function(strUrl){return (strUrl.match(/video\.google\.com\/videoplay/i) != null);}
  ,set: function(contentNo){
    contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'g'));
    set_content_to_view(contentNo);
   }
  ,preload: function(contentNo){contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'g'));}
  ,icon: settings.iconGoogleVideo
  }
 ,{
   type: 'SPIKE Powerd By IFILM'
  ,match: function(strUrl){return (strUrl.match(/ifilm\.com\/video/i) != null);}
  ,set: function(contentNo){
    contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'i'));
    set_content_to_view(contentNo);
   }
  ,preload: function(contentNo){contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], get_video_info(contentNo, 'i'));}
  ,icon: settings.iconifilm
  }
 ,{
   type: 'Contents'
  ,match: function(strUrl){return (strUrl.match(window.location.host) != null);}
  ,set: function(contentNo){
    jQuery.get(contentInfo[contentNo].href, function(responseText, status){
     var arrSizes = get_sizes_from_str(contentInfo[contentNo].href);
     if (arrSizes == null) {
      var arrPageSizes = get_page_sizes();
      arrSizes = new Array(Math.round(arrPageSizes[0] / 4), Math.round(arrPageSizes[1] / 4));
     }
     var strSrc = '<div width="' + arrSizes[0] + '" height="' + arrSizes[1] + '">' + responseText.replace(/[\r\n]/g, '').replace(/.*<body.*?>(.*?)<\/body>.*$/, '$1').replace(/<script.*?>.*<\/script>/g, '') + '</div>';
     contentInfo[contentNo] = jQuery.extend(contentInfo[contentNo], {content:strSrc, width:arrSizes[0], height:arrSizes[1], later:500});
     set_content_to_view(contentNo);
    });
   }
  ,content_css: {'text-align':'left', 'line-height':'1.2em'}
  ,icon: settings.iconContents
  }
 );

 var contentInfo = new Array();

 var initialize = function(jQueryObj){
  // image preload
  image_load(settings.imageBtnPrev,  function(){settings.imageBtnPrevWidth  = this.width; this.onload = function(){};});
  image_load(settings.imageBtnNext,  function(){settings.imageBtnNextWidth  = this.width; this.onload = function(){};});
  image_load(settings.imageBtnClose, function(){settings.imageBtnCloseWidth = this.width; this.onload = function(){};});
  if (!frameBorder) {
   image_load(settings.imageBox);
   image_load(settings.imageBorderL);
   image_load(settings.imageBorderR);
  }

  // get matched object
  var domMatchedObj = new Array();
  var intImage = 0;
  contentInfo.length = 0;
  jQueryObj.filter('a').each(function() {
   if (this.getAttribute('href').match(/^https?:/i) == null && window.location.protocol.match(/^https?:/i)) {
    if (this.getAttribute('href').match(/^\//i) == null) {
     this.setAttribute('href', window.location.href.replace(/^(.*\/).*$/i, '$1') + this.getAttribute('href').replace(/^\/?(.*)$/i, '$1'));
    } else {
     this.setAttribute('href', window.location.protocol + '//' + window.location.hostname + '/' + this.getAttribute('href'));
    }
   }
   for (var optindex = 0; optindex < fileTypes.length; optindex++) {
    if (fileTypes[optindex].match(this.getAttribute('href'))) {
     // set icons to link
     if (settings.iconAdd && fileTypes[optindex].icon && jQuery(this).children('img').length == 0) {
      jQuery(this).css({background:'transparent url(' + fileTypes[optindex].icon + ') no-repeat scroll 1px 0pt', 'padding-left':'20px'});
     }
     // content info
     contentInfo.push({
      index: optindex,
      type:  (fileTypes[optindex].type ? fileTypes[optindex].type : settings.txtImage),
      href:  this.getAttribute('href'),
      title: (this.getAttribute('title') != null ? this.getAttribute('title') : this.innerHTML.replace(/<[^>]*>/ig, ''))
     });
     // bind click event
     jQuery(this).unbind('click').click((function(i){return function(){start_lightpop(i); return false;}}).call(this, intImage));
     domMatchedObj.push(this);
     intImage++;
     break;
    }
   }
  });
  return new jQuery(domMatchedObj);
 };

 var start_lightpop = function(intClickedContent){
  // hide embed, object, select element
  jQuery('embed, object, select').css({visibility:'hidden'});

  // set interface
  if (frameBorder) {
   jQuery('body').append(jQuery('<div id="jquery-overlay"></div><div id="jquery-lightpop"><div id="lightpop-container"><div id="lightpop-container-content-box"><div id="lightpop-container-content"><div id="lightpop-content"></div><div style="" id="lightpop-nav"><a href="#" id="lightpop-nav-btnPrev"></a><a href="#" id="lightpop-nav-btnNext"></a></div><div id="lightpop-loading"><a href="#" id="lightpop-loading-link"><img src="'+settings.imageLoading+'"></a></div></div></div><div id="lightpop-container-content-data-box"><div id="lightpop-container-content-data"><div id="lightpop-content-details"><div id="lightpop-content-details-caption"></div><div id="lightpop-content-details-currentNumber"></div></div><div id="lightpop-secNav"><a href="#" id="lightpop-secNav-btnClose"><img src="'+settings.imageBtnClose+'"></a></div></div></div></div></div>').hide());
  } else {
   jQuery('body').append(jQuery('<div id="jquery-overlay"></div><div id="jquery-lightpop"><div id="lightpop-container"><div id="lightpop-container-hd"><div id="lightpop-container-hdc"></div></div><div id="lightpop-container-bd"><div id="lightpop-container-bdc"><div id="lightpop-container-content-box"><div id="lightpop-container-content"><div id="lightpop-content"></div></div></div><div id="lightpop-container-content-data-box"><div id="lightpop-container-content-data"><div id="lightpop-content-details"><div id="lightpop-content-details-caption"></div><div id="lightpop-content-details-currentNumber"></div></div><div id="lightpop-secNav"><a href="#" id="lightpop-secNav-btnClose"><img src="'+settings.imageBtnClose+'"></a></div></div></div></div></div><div id="lightpop-container-ft"><div id="lightpop-container-ftc"></div></div><div style="" id="lightpop-nav"><a href="#" id="lightpop-nav-btnPrev"></a><a href="#" id="lightpop-nav-btnNext"></a></div><div id="lightpop-loading"><a href="#" id="lightpop-loading-link"><img src="'+settings.imageLoading+'"></a></div></div></div>').hide());
   settings.contentBorder = 'none';
  }

  // set interface CSS
  var arrPageSizes  = get_page_sizes();
  var arrPageScroll = get_page_scroll();

  // overlay
  jQuery('#jquery-overlay').css({position:'absolute', top:0, left:0, 'z-index':90, 'background-color':settings.overlayBgColor, opacity:settings.overlayOpacity, width:arrPageSizes[0], height:arrPageSizes[1]});
  jQuery('#jquery-lightpop').css({position:'absolute', top:arrPageScroll[1] + Math.round(arrPageSizes[3] / 10), left:arrPageScroll[0], width:'100%', 'z-index':100, 'text-align':'center', 'line-height':0, border:'none'});
  jQuery('#jquery-lightpop a img').css({border:'none'});

  // container & navigation
  jQuery('#lightpop-container').css({position:'relative', width:'250px', height:'250px', margin:'0 auto', border:'none'});
  jQuery('#lightpop-container-content-box').css({width:'250px', height:'250px', margin:'0 auto', overflow:'hidden'});
  jQuery('#lightpop-container-content-data-box').css({font:'10px Verdana, Helvetica, sans-serif', 'background-color':'transparent', 'line-height':'1.4em', width:'100%', margin:'0 auto', padding:'0 ' + settings.containerBorderSize + 'px 0', overflow:'hidden'});
  jQuery('#lightpop-nav').css({position:'absolute', top:0, left:0, height:'10px', width:'100%', padding:0, margin:'0 auto', 'z-index':10});
  jQuery('#lightpop-nav a').css({outline:'none'});
  jQuery('#lightpop-nav-btnPrev').css({display:'block', width:settings.imageBtnPrevWidth, left:0, height:'100%', zoom:1, 'float':'left'});
  jQuery('#lightpop-nav-btnNext').css({display:'block', width:settings.imageBtnNextWidth, right:0, height:'100%', zoom:1, 'float':'right'});
  if (frameBorder) {
   jQuery('#lightpop-container').css({'background-color':'transparent', overflow:'hidden'});
   jQuery('#lightpop-container-content').css({padding:settings.containerBorderSize});
   jQuery('#lightpop-container-content-box').css({position:'relative', 'background-color':'transparent'});
   jQuery('#lightpop-container-content-data-box').css({position:'absolute', bottom:0});
  } else {
   jQuery('#lightpop-container').css({'background-color':settings.contentBgColor});
   jQuery('#lightpop-container-content').css({'background-color':settings.contentBgColor});
   jQuery('#lightpop-container-content-box').css({'background-color':settings.contentBgColor, padding:settings.containerBorderSize});
   jQuery('#lightpop-nav-btnPrev, #lightpop-nav-btnNext').css({margin:'0 ' + settings.containerBorderSize + 'px'});
   jQuery('#lightpop-container-hd').css({position:'relative', height:settings.boxBorderSize, background:'transparent url(' + settings.imageBox + ') left top no-repeat', top:0, 'z-index':10}).hide();
   jQuery('#lightpop-container-hdc').css({position:'relative', height:settings.boxBorderSize, background:'transparent url(' + settings.imageBox + ') right top no-repeat', 'margin-left':settings.boxBorderSize, top:0, 'z-index':10}).hide();
   jQuery('#lightpop-container-bd').css({position:'relative', background:settings.contentBgColor + ' url(' + settings.imageBorderL + ') left top repeat-y', 'z-index':10}).hide();
   jQuery('#lightpop-container-bdc').css({position:'relative', background:'transparent url(' + settings.imageBorderR + ') right top repeat-y', 'z-index':10}).hide();
   jQuery('#lightpop-container-ft').css({position:'relative', height:settings.boxBorderSize, background:'transparent url(' + settings.imageBox + ') left bottom no-repeat', bottom:0, 'z-index':10}).hide();
   jQuery('#lightpop-container-ftc').css({position:'relative', height:settings.boxBorderSize, background:'transparent url(' + settings.imageBox + ') right bottom no-repeat', 'margin-left':settings.boxBorderSize, bottom:0, 'z-index':10}).hide();
  }
  jQuery('#lightpop-loading').css({position:'absolute', top:'40%', left:0, height:'25%', width:'100%', 'text-align':'center', 'line-height':0});

  // content data
  jQuery('#lightpop-container-content-data').css({position:'relative', padding:'0 ' + settings.containerBorderSize + 'px', color:'#666', left:0, bottom:0});
  jQuery('#lightpop-content-details').css({width:'70%', 'float':'left', 'text-align':'left'});
  jQuery('#lightpop-content-details-caption').css({'float':'left', 'font-weight':'bold'});
  jQuery('#lightpop-content-details-currentNumber').css({'float':'left', clear:'left', 'padding-bottom':'1.0em'});
  jQuery('#lightpop-secNav-btnClose').css({width:settings.imageBtnCloseWidth, 'float':'right', 'padding-bottom':'0.7em'});

  // show interface
  jQuery('#jquery-overlay').fadeIn(settings.containerResizeSpeed, function(){
   jQuery('#jquery-lightpop').show();
   jQuery(this).click(finish_lightpop);
  });
  jQuery('#lightpop-loading-link, #lightpop-secNav-btnClose').click(function(){finish_lightpop(); return false;});
  window_resize(true);

  // set content
  set_content(intClickedContent);
 };

 // set content
 var set_content = function(contentNo){
  jQuery('#lightpop-nav, #lightpop-nav-btnPrev, #lightpop-nav-btnNext').hide();
  jQuery('#lightpop-content').hide().children().remove();
  jQuery('#lightpop-loading').css({height:'25%'}).show();

  if (frameBorder) {
   jQuery('#lightpop-container').css({width:'100%', height:'100%', 'background-color':'transparent', border:'none'}).show();
   jQuery('#lightpop-content-details, #lightpop-content-details-caption, #lightpop-content-details-currentNumber, #lightpop-secNav-btnClose').css({visibility:'hidden'}).show();
   jQuery('#lightpop-container-content-box').css({'background-color':settings.contentBgColor, 'border-top':settings.contentBorder, 'border-left':settings.contentBorder, 'border-right':settings.contentBorder}).show();
   jQuery('#lightpop-container-content-data-box').css({position:'static', 'background-color':settings.contentBgColor, 'border-bottom':settings.contentBorder, 'border-left':settings.contentBorder, 'border-right':settings.contentBorder}).show().slideUp('fast',function(){
    jQuery(this).css({'background-color':'transparent', border:'none'});
    jQuery('#lightpop-container-content-box').css({'border':settings.contentBorder});
    jQuery('#lightpop-content-details, #lightpop-content-details-caption, #lightpop-content-details-currentNumber, #lightpop-secNav-btnClose').css({visibility:'visible'}).hide();
    set_content_to_view(contentNo);
   });
  } else {
   jQuery('#lightpop-container').show();
   set_box_css(false);
   jQuery('#lightpop-container-content-box').show();
   if(jQuery.browser.safari){jQuery('#lightpop-container-content-data-box').height('auto');}
   jQuery('#lightpop-container-content-data-box').show().slideUp('fast',function(){
    jQuery('#lightpop-container-content-box').css({width:'auto', height:'auto'});
    jQuery('#lightpop-content-details, #lightpop-content-details-caption, #lightpop-content-details-currentNumber, #lightpop-secNav-btnClose').hide();
    set_content_to_view(contentNo);
   });
  }
 };

 var set_content_to_view = function(contentNo){
  if (contentInfo[contentNo].content) {
   jQuery('#lightpop-content').append(jQuery(contentInfo[contentNo].content));
   setTimeout(function(){show_container(contentNo);}, contentInfo[contentNo].later);
  } else {
   fileTypes[contentInfo[contentNo].index].set(contentNo);
  }
 };

 // show container
 var show_container = function(contentNo){
  var intWidth  = contentInfo[contentNo].width  + (settings.containerBorderSize * 2);
  var intHeight = contentInfo[contentNo].height + (settings.containerBorderSize * 2);

  if (frameBorder) {
   jQuery('#lightpop-container').css({height:intHeight + 10});
   jQuery('#lightpop-container-content-box').animate({width:intWidth, height:intHeight}, settings.containerResizeSpeed, function(){
    jQuery(this).css({'background-color':'transparent', border:'none'});
    jQuery('#lightpop-loading').css({height:intHeight});
    jQuery('#lightpop-container').css({width:intWidth, height:intHeight, 'background-color':settings.contentBgColor, border:settings.contentBorder});
    show_content(contentNo, intWidth, intHeight);
   });
  } else {
   intWidth  += (settings.boxBorderSize * 2);
   jQuery('#lightpop-container').animate({width:intWidth, height:intHeight}, settings.containerResizeSpeed, function(){
    jQuery('#lightpop-loading').css({height:intHeight});
    show_content(contentNo, intWidth, intHeight);
   });
  }
 };

 // show content
 var show_content = function(contentNo, intWidth, intHeight){
  jQuery('#lightpop-content').css({width:contentInfo[contentNo].width, height:contentInfo[contentNo].height});
  if (!frameBorder) {jQuery('#lightpop-container-content-box').css({width:contentInfo[contentNo].width, height:contentInfo[contentNo].height});}
  jQuery('#lightpop-container-content-data-box').css({width:contentInfo[contentNo].width});
  if (fileTypes[contentInfo[contentNo].index].content_css) {jQuery('#lightpop-content').children().css(fileTypes[contentInfo[contentNo].index].content_css);}

  // set content data
  jQuery('#lightpop-content-details-caption').html(contentInfo[contentNo].title);
  jQuery('#lightpop-content-details-currentNumber').html(contentInfo[contentNo].type + (contentInfo.length > 1 ? ' ' + (contentNo + 1) + ' ' + settings.txtOf + ' ' + contentInfo.length : ''));
  jQuery('#lightpop-container-content-data-box').show(function(){
   jQuery('#lightpop-content-details, #lightpop-secNav-btnClose').css({visibility:'hidden'}).show();
   var intDataboxHeight = (!jQuery.browser.safari ? jQuery(this).height() : this.scrollHeight);
   intDataboxHeight = (intDataboxHeight < 30 ? 30 : intDataboxHeight) + settings.containerBorderSize;
   intHeight += intDataboxHeight;
   jQuery('#lightpop-container').animate({width:intWidth, height:intHeight}, 'fast', function(){
    if (!frameBorder && jQuery.browser.safari) {jQuery('#lightpop-container-content-data-box').height(intDataboxHeight);}
    jQuery('#lightpop-content-details, #lightpop-content-details-caption, #lightpop-content-details-currentNumber, #lightpop-secNav-btnClose').css({visibility:'visible'}).show();
    jQuery('#lightpop-loading').hide();
    if (contentInfo[contentNo].content.match(/<object.*>/i)) {
     jQuery('#lightpop-content').show();
    } else {
     jQuery('#lightpop-container').css({'background-color':settings.contentBgColor});
     jQuery('#lightpop-container-content, #lightpop-container-content-box').css({'background-color':'transparent'});
     jQuery('#lightpop-content').fadeIn();
    }
    if (!frameBorder) {set_box_css(true);}
   });
  });

  set_navigation(contentNo, intWidth, intHeight);
  preload_contents(contentNo);
 };

 // set navigation
 var set_navigation = function(contentNo, intWidth, intHeight){
  jQuery('#lightpop-nav').css({width:intWidth}).show(function(){
   jQuery('#lightpop-nav-btnPrev, #lightpop-nav-btnNext').css({height:Math.round(intHeight / 3), background:'transparent url(' + settings.imageBlank + ') no-repeat'}).unbind();
   if(contentNo != 0){
    jQuery('#lightpop-nav-btnPrev').hover(
     function(){jQuery(this).css({background:'url(' + settings.imageBtnPrev + ') left 30% no-repeat'});},
     function(){jQuery(this).css({background:'transparent url(' + settings.imageBlank + ') no-repeat'});}
    ).show().click((function(i){return function(){set_content(i); return false;}}).call(this, contentNo - 1));
   }
   if(contentNo != (contentInfo.length - 1)){
    jQuery('#lightpop-nav-btnNext').hover(
     function(){jQuery(this).css({background:'url(' + settings.imageBtnNext + ') right 30% no-repeat'});},
     function(){jQuery(this).css({background:'transparent url(' + settings.imageBlank + ') no-repeat'});}
    ).show().click((function(i){return function(){set_content(i); return false;}}).call(this, contentNo + 1));
   }
   keyboard_navigation(true, contentNo);
  });
 };

 // preload contents
 var preload_contents = function(contentNo){
  if((contentInfo.length - 1) > contentNo){
   if(fileTypes[contentInfo[contentNo + 1].index].preload && contentInfo[contentNo + 1].content == null){
    fileTypes[contentInfo[contentNo + 1].index].preload(contentNo + 1);
   }
  }
  if(contentNo > 0){
   if(fileTypes[contentInfo[contentNo - 1].index].preload && contentInfo[contentNo - 1].content == null){
    fileTypes[contentInfo[contentNo - 1].index].preload(contentNo - 1);
   }
  }
 };

 var image_load = function(src, callback){
  var objImageLoader = new Image();
  if (callback) {objImageLoader.onload = callback;}
  objImageLoader.src = src;
  return objImageLoader;
 }

 // get content information
 var get_sizes_from_str = function(strText){
  var intWidth = 0, intHeight = 0;
  var arrText = strText.toLowerCase().replace(/[\r\n]/g,'').replace(/["']/g,'').match(/(width|height)=([0-9]+)/ig);
  if (arrText) {
   jQuery.each(arrText, function(){
    if (this.match(/^width=[0-9]+$/i))  {intWidth  = Number(this.replace(/^width=([0-9]+)$/, '$1'));}
    if (this.match(/^height=[0-9]+$/i)) {intHeight = Number(this.replace(/^height=([0-9]+)$/,'$1'));}
   });
  }
  if(intWidth == 0 || intHeight == 0){
   return null;
  } else {
   return new Array(intWidth, intHeight);
  }
 };

 var get_flash_src = function(url, width, height, param) {
  param = jQuery.extend({movie: url, wmode: 'transparent'}, param);
  var strSrc = '<object data="' + url + '" type="application/x-shockwave-flash" width="' + width + '" height="' + height + '" wmode="' + param.wmode + '">';
  jQuery.each(param, function(key){strSrc += '<param name="' + key + '" value="' + this + '" />';})
  strSrc += '</object>';
  return strSrc;
 };

 var get_video_info = function(contentNo, fileType) {
  var arrSizes, vid, strUrl, strSrc, intLater;
  arrSizes = get_sizes_from_str(contentInfo[contentNo].href);
  strUrl = contentInfo[contentNo].href.replace(/&.*$/i,'');
  switch(fileType){
   case 'y':
    if (arrSizes == null) {arrSizes = new Array(425, 355);}
    vid    = strUrl.replace(/^http.*youtube.*watch.*?v=(.*)$/i, '$1');
    strUrl = 'http://www.youtube.com/v/' + vid;
    strSrc = get_flash_src(strUrl, arrSizes[0], arrSizes[1]);
    intLater = 1000;
    break;
   case 'm':
    if (arrSizes == null) {arrSizes = new Array(400, 345);}
    vid    = strUrl.replace(/\?.*$/, '').replace(/\/$/i,'').replace(/^http.*metacafe.*watch\/(.*)$/i, '$1');
    strUrl = 'http://www.metacafe.com/fplayer/' + vid + '.swf';
    strSrc = get_flash_src(strUrl, arrSizes[0], arrSizes[1]);
    intLater = 1500;
    break;
   case 'l':
    if (arrSizes == null) {arrSizes = new Array(450, 370);}
    vid    = strUrl.replace(/^http.*liveleak.*view.*?i=(.*)$/i, '$1');
    strUrl = 'http://www.liveleak.com/player.swf?autostart=false&token=' + vid;
    strSrc = get_flash_src(strUrl, arrSizes[0], arrSizes[1], {quality:"high"});
    intLater = 1500;
    break;
   case 'g':
    if (arrSizes == null) {arrSizes = new Array(400, 326);}
    vid    = strUrl.replace(/^http.*video\.google\.com\/videoplay.*docid=(.*)$/i, '$1');
    strUrl = 'http://video.google.com/googleplayer.swf?docId=' + vid + '&#038;hl=en';
    strSrc = get_flash_src(strUrl, arrSizes[0], arrSizes[1], {flashvars:''});
    intLater = 1500;
    break;
   case 'i':
    if (arrSizes == null) {arrSizes = new Array(448, 365);}
    vid    = strUrl.replace(/\?.*$/, '').replace(/\/$/i,'').replace(/^http.*www\.ifilm\.com.*video\/(.*)$/i, '$1');
    strUrl = 'http://www.ifilm.com/efp';
    strSrc = get_flash_src(strUrl, arrSizes[0], arrSizes[1], {flashvars:'flvbaseclip=' + vid + '&', quality:"high", bgcolor:'000000'});
    intLater = 1500;
    break;
   case 'v':
    if (arrSizes == null) {arrSizes = new Array(320, 240);}
    strUrl = strUrl.replace(/\?.*$/, '');
    switch(strUrl.match(/\.(flv|swf|rm|mov|3gp|mp4|asf|avi|mpg|wmv)$/i)[1]){
     case 'flv':
      strUrl = settings.flvplayer + '?file=' + strUrl;
     case 'swf':
      strSrc = get_flash_src(strUrl, arrSizes[0], arrSizes[1], {quality:"high", bgcolor:"#000"});
      break;
     case 'rm':
      strSrc = '<object classid="clsid:cfcdaa03-8be4-11cf-b84b-0020afbbccfa" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '"><param name="src" value="' + strUrl + '" /><param name="autostart" value="true" /><param name="controls" value="imagewindow,controlpanel" /><embed src="' + strUrl + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" autostart="true" controls="imagewindow,controlpanel" type="audio/x-pn-realaudio-plugin"></embed></object>';
      break;
     case 'mov':
     case 'mp4':
     case '3gp':
      arrSizes[1] += 20;
      strSrc = '<object classid="clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B" codebase="http://www.apple.com/qtactivex/qtplugin.cab" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '"><param name="src" value="' + strUrl + '" /><param name="href" value="' + strUrl + '" /><param name="controller" value="true" /><param name="pluginspage" value="http://www.apple.com/quicktime/download/" /><param name="autoplay" value="true" /><param name="bgcolor" value="000000" /><embed src="' + strUrl + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" bgcolor="000000" autoplay="true" controller="true" src="' + strUrl + '" type="video/quicktime" pluginspage="http://www.apple.com/quicktime/download/"></embed></object>';
      break;
     default:
      arrSizes[1] += 20;
      strSrc = '<object classid="clsid:6BF52A52-394A-11d3-B153-00C04F79FAA6" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" type="application/x-oleobject"><param name="url" value="' + strUrl + '" /><param name="autostart" value="true" /><param name="uiMode" value="full" /><embed src="' + strUrl + '" width="' + arrSizes[0] + '" height="' + arrSizes[1] + '" autostart="true" uiMode="full" type="application/x-mplayer2" pluginspage="http://www.microsoft.com/windows/mediaplayer/"></embed></object>';
      break;
    }
    intLater = 1000;
    break;
   default:
    arrSizes = new Array(null,null);
    strSrc   = null;
    intLater = 0;
    break;
  }
  return {content:strSrc, width:arrSizes[0], height:arrSizes[1], later:intLater};
 }

 // set box css
 var set_box_css = function(enable) {
  if (enable) {
   jQuery('#lightpop-container-hd').css({background:'transparent url(' + settings.imageBox + ') left top no-repeat'}).show();
   jQuery('#lightpop-container-hdc').css({background:'transparent url(' + settings.imageBox + ') right top no-repeat'}).show();
   jQuery('#lightpop-container-bd').css({background:settings.contentBgColor + ' url(' + settings.imageBorderL + ') left top repeat-y'}).show();
   jQuery('#lightpop-container-bdc').css({background:'transparent url(' + settings.imageBorderR + ') right top repeat-y'}).show();
   jQuery('#lightpop-container-ft').css({background:'transparent url(' + settings.imageBox + ') left bottom no-repeat'}).show();
   jQuery('#lightpop-container-ftc').css({background:'transparent url(' + settings.imageBox + ') right bottom no-repeat'}).show();
  } else {
   jQuery('#lightpop-container-hd, #lightpop-container-hdc, #lightpop-container-bd, #lightpop-container-bdc, #lightpop-container-ft, #lightpop-container-ftc').css({background:'transparent'});
  }
 };

 // set keydown event
 var keyboard_navigation = function(enable, contentNo){
  jQuery(document).unbind('keydown');
  if (enable) {
   jQuery(document).keydown(function(objEvent){
    var key,keycode,escapeKey;
    if(objEvent == null){
     keycode = event.keyCode;
     escapeKey = 27;
    } else {
     keycode = objEvent.keyCode;
     escapeKey = objEvent.DOM_VK_ESCAPE;
    }
    key = String.fromCharCode(keycode).toLowerCase();
    if ((key == settings.keyToClose) || (key == 'x') || (keycode == escapeKey)) {
     finish_lightpop();
    } else if ((key == settings.keyToPrev) || (keycode == 37)) {
     if(contentNo != 0){set_content(contentNo - 1);}
    } else if ((key == settings.keyToNext) || (keycode == 39)) {
     if(contentNo != (contentInfo.length - 1)){set_content(contentNo + 1);}
    }
   });
  }
 };

 // set window resize event
 var window_resize = function(enable){
  jQuery(window).unbind('resize');
  if (enable) {
   jQuery(window).resize(function(){
    var arrPageSizes  = get_page_sizes();
    var arrPageScroll = get_page_scroll();
    jQuery('#jquery-overlay').css({width:arrPageSizes[0], height:arrPageSizes[1]});
    jQuery('#jquery-lightpop').css({top:arrPageScroll[1] + Math.round(arrPageSizes[3] / 10), left:arrPageScroll[0]});
   });
  }
 };

 var get_page_sizes = function(){
  var xScroll,yScroll;
  if (window.innerHeight && window.scrollMaxY) {
   xScroll = window.innerWidth  + window.scrollMaxX;
   yScroll = window.innerHeight + window.scrollMaxY;
  } else if (document.body.scrollHeight > document.body.offsetHeight) {
   xScroll = document.body.scrollWidth;
   yScroll = document.body.scrollHeight;
  } else {
   xScroll = document.body.offsetWidth;
   yScroll = document.body.offsetHeight;
  }
  var windowWidth, windowHeight, pageHeight, pageWidth;
  if (self.innerHeight) {
   if(document.documentElement.clientWidth){
    windowWidth = document.documentElement.clientWidth;
   } else {
    windowWidth = self.innerWidth;
   }
   windowHeight = self.innerHeight;
  } else if (document.documentElement && document.documentElement.clientHeight) {
   windowWidth  = document.documentElement.clientWidth;
   windowHeight = document.documentElement.clientHeight;
  } else if (document.body) {
   windowWidth  = document.body.clientWidth;
   windowHeight = document.body.clientHeight;
  }
  pageWidth  = (xScroll < windowWidth  ? xScroll : windowWidth);
  pageHeight = (yScroll < windowHeight ? windowHeight : yScroll);
  return new Array(pageWidth, pageHeight, windowWidth, windowHeight);
 };

 var get_page_scroll = function(){
  var xScroll, yScroll;
  if(self.pageYOffset){
   yScroll = self.pageYOffset;
   xScroll = self.pageXOffset;
  }else if(document.documentElement && document.documentElement.scrollTop){
   yScroll = document.documentElement.scrollTop;
   xScroll = document.documentElement.scrollLeft;
  }else if(document.body){
   yScroll = document.body.scrollTop;
   xScroll = document.body.scrollLeft;
  }
  return new Array(xScroll, yScroll);
 };

 var finish_lightpop = function(){
  jQuery('object',jQuery('#jquery-lightpop')).css({visibility:'hidden'}).remove();
  jQuery('#jquery-lightpop').slideUp(function(){
   jQuery(this).remove();
   jQuery('#jquery-overlay').fadeOut(function(){jQuery(this).remove();});
   // show embed, object, select element
   jQuery('embed, object, select').css({visibility:'visible'});
  });
  keyboard_navigation(false);
  window_resize(false);
 };

 return initialize(this);
};})(jQuery);
