<?php

/* ==================================================
 *   Ktai_Services class
   ================================================== */

define ('KS_DEFAULT_CHARSET', 'SJIS');
define ('KS_MAX_PAGE_NUM', 1000);

class Ktai_Services {
	protected $user_agent;
	protected $operator   = 'Unknown';
	protected $type       = 'N/A';
	protected $term_name  = 'N/A';
	protected $term_ID    = '';
	protected $sub_ID     = '';
	protected $page_size  = 50000;
	protected $cache_size = 524288;
	protected $charset    = 'SJIS-win';
	protected $mime_type  = 'text/html';
	protected $preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN" "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">';
	protected $allowedtags;

/* ==================================================
 * @param	none
 * @return	object  $ktai
 */
public function factory() {
	$ktai = NULL;
	$ua = $_SERVER['HTTP_USER_AGENT'];
	if (preg_match('!^DoCoMo/1!', $ua)) {
		require_once dirname(__FILE__) . '/i-mode.php';
		$ktai = new Ktai_Service_imode_mova($ua);
	} elseif (preg_match('!^DoCoMo/2!', $ua)) {
		require_once dirname(__FILE__) . '/i-mode.php';
		$ktai = new Ktai_Service_imode_FOMA($ua);
	} elseif (preg_match('!^J-PHONE/!', $ua)) {
		require_once dirname(__FILE__) . '/softbank.php';
		$ktai = new Ktai_Service_Softbank_PDC($ua);
	} elseif (preg_match('!^(Vodafone/|MOT-[CV]|SoftBank/)!', $ua)) {
		require_once dirname(__FILE__) . '/softbank.php';
		$ktai = new Ktai_Service_Softbank_3G($ua);
	} elseif (preg_match('/(DDIPOCKET|WILLCOM);/', $ua)) {
		require_once dirname(__FILE__) . '/willcom.php';
		$ktai = new Ktai_Service_WILLCOM($ua);
	} elseif (preg_match('/^(KDDI-|UP\.Browser)/',$ua)) {
		require_once dirname(__FILE__) . '/ezweb.php';
		$ktai = new Ktai_Service_EZweb($ua);
	} elseif (preg_match('/(Nokia\\d+|Opera Mini|Windows CE;|\(PSP \(PlayStation Portable\);|\bNitro\) Opera)/', $ua)) {
		$ktai = new Ktai_Service_Other($ua);
	}
	return $ktai;
}

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	require_once dirname(__FILE__) . '/kses.php';
	$this->allowedtags = Ktai_HTML_Filter::$allowedtags;
}

/* ==================================================
 * @param	string $key
 * @return	mix    $value
 */
public function get($key) {
	switch ($key) {
	case 'charset':
		return ($this ? $this->charset : KS_DEFAULT_CHARSET);
	case 'iana_charset':
		$charset = ($this ? $this->charset : KS_DEFAULT_CHARSET);
		$charset = preg_replace('/^SJIS(-win)?$/', 'Shift_JIS', $charset);
		$charset = preg_replace('/^eucJP(-win)?$/', 'EUC-JP', $charset);
		return $charset;
	case 'preamble':
		return str_replace('__CHARSET__', $this->get('iana_charset'), $this->preamble);
	case 'term_name':
		return ($this->term_name ? $this->term_name : 'Unknown');
	default:
		return isset($this->$key) ? $this->$key : NULL;
	}
}

/* ==================================================
 * @param	string  $key
 * @param	mix     $value
 * @return	mix     $value
 */
public function set($key, $value = NULL) {
	if (is_null($value)) {
		unset($this->$key);
	} else {
		$this->$key = $value;
	}
	return $value;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('/\r?\n/', "\n", $buffer);
	$buffer = preg_replace('!<(p|div)( (id|class|align)=([\'"])[-_ a-zA-Z0-9]+\\4)*>\s*</\\1>\s*!', '', $buffer); //"
	$buffer = preg_replace('!/>\s*!', '/>', $buffer);
	$buffer = preg_replace('!\s*</!', '</', $buffer);
	$buffer = preg_replace('!\s*<(ul|/li|/option)>\s*<(ul|li|option)!', '<$1><$2', $buffer);
	$buffer = preg_replace('!<(dl|/?dt|/?dd|select)([^>]*)>\s*<(dt|dd|option)!', '<$1$2><$3', $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function replace_smiley($buffer, $smiles = NULL) {
	if ($smiles && preg_match_all('!<img src=([\'"])[^>]*?/([-_.a-zA-Z0-9]+)\\1( alt=([\'"])[^\\\\]*?(\\\\.[^\\\\]*?)*\\4)? class=([\'"])([^\\\\]*?(\\\\.[^\\\\]*?)*)\\6 ?/?>!', $buffer, $images, PREG_SET_ORDER)) {
		foreach($images as $i) {
			if (preg_match('/\bwp-smiley\b/', $i[7]) && ! preg_match('/\bktai\b/', $i[7])) {
				$buffer = str_replace($i[0], $smiles[$i[2]], $buffer);
			}
		}
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $message
 * @return	string  $message
 */
private function encode_message($message) {
	return mb_convert_encoding(__($message, 'ktai_style'), $this->get('charset'), 'UTF-8');
}

/* ==================================================
 * @param	none
 * @return	int     $page_num
 */
private function get_split_page_navi($num, $rest, $post_password) {
	$link = htmlspecialchars(preg_replace('/kp=\d+$/', 'kp=', $_SERVER['REQUEST_URI'], 1, $count));
	if (! $count) {
		$link .= (strpos($link, '?') === FALSE) ? '?kp=': '&amp;kp=';
	}
	$html = '<div align="center">' . $this->encode_message('Splitting the page for mobile: ');
	$del_accesskey = '';
	if ($num == 2) {
		$html .= _internal_link(preg_replace('/(\?|&(amp;)?)kp=/', '', $link), '*', '', $this->encode_message('*.Prev'), $post_password) . ' | ';
		$del_accesskey .= '*';
	} elseif ($num >= 3) {
		$html .= _internal_link($link . intval($num -1), '*', '', $this->encode_message('*.Prev'), $post_password) . ' | ';
		$del_accesskey .= '*';
	}
	$html .= sprintf($this->encode_message('page %d'), intval($num));
	if ($rest) {
		$html .= ' | ' . _internal_link($link . intval($num +1), '#', '', $this->encode_message('#.Next'), $post_password);
		$del_accesskey .= '#';
	}
	$html .= '</div>';
	return array($html, $del_accesskey);
}

/* ==================================================
 * @param	string  $buffer
 * @param	int     $page_num
 * @return	string  $paged_content
 */
public function split_page($buffer, $page_num) {
	if ($page_num > KS_MAX_PAGE_NUM) {
		$page_num = KS_MAX_PAGE_NUM;
	} elseif ($page_num < 1) {
		$page_num = 1;
	}

	if (! preg_match('/<!--start paging-->/', $buffer)) {
		$buffer = preg_replace('/(<body[^>]*>)/', "$1\n<!--start paging-->", $buffer);
	}
	if (! preg_match('/<!--end paging-->/', $buffer)) {
		if (preg_match('!<hr [^/>]*/>\s*<a name="tail"!', $buffer)) {
			$buffer = preg_replace('!(<hr [^/>]*/>\s*<a name="tail")!', "<!--end paging-->\n\\1", $buffer);
		} else {
			$buffer = preg_replace('!(</body>)!', "<!--end paging-->\n$1", $buffer);
		}
	}

	list($header, $buffer) = preg_split('/<!--start paging-->\n*/', $buffer, 2);
	list($buffer, $footer) = preg_split('/\n*<!--end paging-->/', $buffer, 2);
	$buffer = preg_replace('!>[ \t]*\n+[ \t]*<!', '><', $buffer);
	if (preg_match('/<input type="hidden" name="post_password" value="(.*?)"/', $buffer, $match)) {
		$post_password = $match[1];
	} else {
		$post_password = '';
	}
	list($navi, $del_accesskey) = $this->get_split_page_navi(101,TRUE, $post_password);
	$page_size = $this->page_size - strlen("$header$navi<hr /><hr />$navi$footer") - 32; // 32-byte is space for adding tags by force_balance_tags()
	if ($page_size < 256) { // too mall
		$header = preg_replace('/(<body[^>]*>)/', '$1<!--start paging-->', $header);
		list($header, $move2body) = explode('<!--start paging-->', $header, 2);
		$buffer = $move2body . $buffer . $footer;
		$footer = '';
		$page_size = $this->page_size - strlen("$header$navi<hr /><hr />$navi$footer") - 32;
	}

	$start_tags = '';
	$terminator = '<!--' . md5(uniqid()) . '-->';
	$marker = 0;
	$buffer_length = strlen($buffer);
	for ($count = 0 ; $count < $page_num ; $count++) {
		$fragment = mb_strcut($buffer, $marker, $page_size, $this->charset);
		if (preg_match('/<[^>]*$/', $fragment, $uncomplete_tag)) {
			$fragment = preg_replace('/' . preg_quote($uncomplete_tag[0], '/') . '$/', '', $fragment);
		}
		if (preg_match('/&#?[a-zA-Z0-9]*?$/', $fragment, $uncomplete_entity)) {
			$fragment = preg_replace('/' . preg_quote($uncomplete_entity[0], '/') . '$/', '', $fragment);
		}
		$fragment_w_start_tags = $fragment;
		while (preg_match('!(<[^/]>|<[^/][^>]*[^/]>)([^<]*?)$!', $fragment, $only_start_tag) && (preg_match('/^\s*$/', $only_start_tag[2]) || strlen($only_start_tag[2]) < 32)) {
			$fragment = preg_replace('/' . preg_quote($only_start_tag[0], '/') . '$/', '', $fragment);
		}
		if (preg_match('/^\s*$/', $fragment)) { // keep back if the fragment is empty
			$fragment = $fragment_w_start_tags;
		}

		$form_start = strrpos($fragment, '<form ');
		$form_end   = strrpos($fragment, '</form>');
		if ($form_start > 0 && $form_end === FALSE) {
			$fragment = substr($fragment, 0, $form_start);
		}

		$balanced = force_balance_tags($start_tags . $fragment . $terminator);
		preg_match('/' . $terminator . '(.*)$/', $balanced, $added_html);
		if (preg_match_all('!</([^<>]*)>!', $added_html[1], $added_tags)) {
			$start_tags = '<' . implode('><', array_reverse($added_tags[1])) . '>';
		} else {
			$start_tags = '';
		}
		$marker += strlen($fragment);
		if ($marker >= $buffer_length /* || preg_match('/^\s*<[^>]+>\s*$/', mb_strcut($buffer, $marker, 0, $this->charset)) */ ) {
			$count++;
			break;
		}
	}

	if (strlen($fragment) < $buffer_length) {
		$balanced = str_replace($terminator, '', $balanced);
		list($navi, $del_accesskey) = $this->get_split_page_navi($count, ($marker +1 < $buffer_length), $post_password);
		if ($del_accesskey) {
			$balanced = preg_replace('/(<(a|label) [^>]*?) accesskey="[' . $del_accesskey . ']">/', '$1>', $balanced);
		}
		return "$header$navi<hr />$balanced<hr />$navi$footer";
	} else {
		return "$header$buffer$footer";
	}
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	if ($this->mime_type == 'application/xhtml+xml') {
		if (preg_match('!</head>\s*<body bgcolor="(.*?)" text="(.*?)" link="(.*)" vlink="(.*?)">!', $buffer, $colors)) {
			if ($colors[1] || $colors[2]) {
				$style = 'body {' . ($colors[2] ? 'color:' . $colors[2] . ';' : '') . ($colors[1] ? 'background-color:' . $colors[1] . ';' : '') . '} ';
			}
			if ($colors[3]) {
				$style .= 'a,a:link {color:' . $colors[3] . ';} ';
			}
			if ($colors[4]) {
				$style .= 'a:visited {color:' . $colors[4] . ';} ';
			}
			if ($style) {
				$buffer = str_replace($colors[0], '<style>' . $style . '</style></head><body>', $buffer);
			}
		}
		$buffer = preg_replace('/<a name=/', '<a id=', $buffer);
		$buffer = preg_replace('/<div align="(.*?)"/', '<div style="text-align:$1;"', $buffer);
		$buffer = $this->horizontal_rule_to_style($buffer);
		$buffer = $this->font_to_style($buffer);
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function horizontal_rule_to_style($buffer) {
	$buffer = preg_replace('/<hr color="(#[0-9A-Fa-f]+|[a-zA-Z]+)"( width="(.*?)")?/e', '\'<hr style="background-color:$1;border:1px solid $1;\' . ("$2" ? \'width:$3;"\' : \'"\')', $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
protected function font_to_style($buffer) {
	if (preg_match_all('!<font([^<>]*)>(.*?)</font>!', $buffer, $fonts, PREG_SET_ORDER)) {
		foreach($fonts as $f) {
			$style = '';
			if (preg_match_all('/(\w+)=([\'"])([^\\\\]*?(\\\\.[^\\\\]*?)*)\\2/', $f[1], $attr, PREG_SET_ORDER)) {
				foreach($attr as $a) {
					switch ($a[1]) {
					case 'size':
						switch ($a[3]) {
						case '+1':
							$style .= 'font-size:larger;';
							break;
						case '-1':
							$style .= 'font-size:smaller;';
							break;
						case '1':
							$style .= 'font-size:x-small;';
							break;
						case '2':
							$style .= 'font-size:small;';
							break;
						case '4':
							$style .= 'font-size:large;';
							break;
						case '5':
							$style .= 'font-size:x-large;';
							break;
						case '6':
						case '7':
							$style .= 'font-size:xx-large;';
							break;
						}
						break;
					default:
						$style .= $a[1] . ':' . $a[3] . ';';
					}
				}
			}
			if ($style) {
				$style = ' style="' . $style . '"';
			}
			$buffer = preg_replace('!' . preg_quote($f[0], '!') . '!', "<span$style>{$f[2]}</span>", $buffer, 1);
		}
	}
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Other class
   ================================================== */

class Ktai_Service_Other extends Ktai_Services {
	static public $dcm_smartphones = array(
		'DCM06' => 'htcZ',
	);

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->user_agent = $user_agent;
	if (preg_match('!Windows CE; (.*)$!', $user_agent, $specs)) {
		if (preg_match('!^[^/]*/([^;]*)!', $specs[1], $term_name)) {
			$this->term_name = $term_name[1];
		} elseif (preg_match('/IEMobile [\d.]*\) (\w+)/', $specs[1], $term_name)) {
			$this->term_name = $term_name[1];
		} elseif (preg_match('/DCM\d+/', $specs[1], $term_name)) {
			$this->term_name = self::$dcm_smartphones[$term_name[0]];
		}
	}
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function convert_char($buffer) {
	$buffer = preg_replace('!<img localsrc="[^"\\\\]*?(\\\\.[^"\\\\]*)*"( alt="([^"\\\\]*?(\\\\.[^"\\\\]*)*)")? ?/?>!', '$3', $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = $this->horizontal_rule_to_style($buffer);
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}
?>
