<?php

/* ==================================================
 *   Ktai_Style_PrefPane class
   ================================================== */

class Ktai_Style_PrefPane {
	private $nonce = -1;

/* ==================================================
 * @param	none
 * @return	none
 */
public function add_page() {
	add_options_page('Ktai Style Configuration', __('Mobile Output', 'ktai_style'), 'manage_options', basename(__FILE__), array($this, 'option_page'));
	if ( !function_exists('wp_nonce_field') ) {
		$this->nonce = -1;
	} else {
		$this->nonce = 'ktai-style-config';
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function option_page() {
	global $user_identity, $Ktai_Style;

	if (isset($_POST['update_option'])) {
		check_admin_referer($this->nonce);
		$this->upate_options();
	}
	if ($Ktai_Style->get_option('ks_separate_comments')) {
		$separate_comments[0] = '';
		$separate_comments[1] = ' checked="checked"';
	} else {
		$separate_comments[0] = ' checked="checked"';
		$separate_comments[1] = '';
	}
	$theme               = $Ktai_Style->get_option('ks_theme');
	$treat_as_internal   = $Ktai_Style->get_option('ks_treat_as_internal');
	$date_color          = $Ktai_Style->get_option('ks_date_color');
	$author_color        = $Ktai_Style->get_option('ks_author_color');
	$comment_type_color  = $Ktai_Style->get_option('ks_comment_type_color');
	$external_link_color = $Ktai_Style->get_option('ks_external_link_color');
	$year_format         = $Ktai_Style->get_option('ks_year_format');
	$month_date_format   = $Ktai_Style->get_option('ks_month_date_format');
	$time_format         = $Ktai_Style->get_option('ks_time_format');
?>
<div class="wrap">
<h2><?php _e('Ktai Style Options', 'ktai_style'); ?></h2>
<form method="post">
<?php $this->make_nonce_field($this->nonce); ?>
<div class="submit">
<input type="hidden" name="action" value="update" />
<input type="submit" name="update_option" value="<?php _e('Update Options &raquo;'); ?>" />
</div>
<fieldset name="theme" class="options">
<legend><?php _e('Theme', 'ktai_style'); ?></legend>
<dl>
<dt><label for="common_theme"><?php _e('Theme for mobile', 'ktai_style'); ?></label></dt>
<dd><select name="common_theme" id="common_theme">
<?php foreach($Ktai_Style->installed_themes() as $t) {
	$current = (strcmp($t, $theme) === 0) ? ' selected="selected"' : '';
	echo '<option value="' . attribute_escape($t) . '"' . $current . '>' . attribute_escape($t) . '</option>';
} ?>
</select></dd>
</dl>
</fieldset>
<p><?php _e('Note: Settings below may not be reflected with other than standard theme (default, compact).', 'ktai_style'); ?></p>
<fieldset name="design" class="options">
<legend><?php _e('Behavior', 'ktai_style'); ?></legend>
<table class="optiontable"><tbody>
<tr>
<th><label for="separate_comments"><?php _e('Comments and Trackbacks/Pingbacks', 'ktai_style'); ?></label></th> 
<td>
  <label><input type="radio" name="separate_comments" id="separate_comments" value="1"<?php echo $separate_comments[0]; ?> /> <?php _e('Mix them at each posts and/or recent comments.', 'ktai_style'); ?></label><br />
  <label><input type="radio" name="separate_comments" id="separate_comments" value="2"<?php echo $separate_comments[1]; ?> /> <?php _e('Separate comments and trackbacks.', 'ktai_style'); ?></label>
</td>
</tr><tr>
<th><label for="treat_as_internal"><?php _e('Websites to link directly', 'ktai_style'); ?></label></th>
<td><textarea name="treat_as_internal" id="treat_as_internal" cols="60" rows="2"><?php echo $treat_as_internal; ?></textarea><br /><?php _e('(Not using full browsers/redirect pages for these sites; space separated)', 'ktai_style'); ?></td>
</tr>
</tbody></table>
</fieldset>
<script type="text/javascript">
function change_sample(field, target) {
	var color = field.value;
	if (color.match("^(#[0-9a-fA-F]{6}|[a-z]+)$")) {
		document.getElementById(target).style.color = color;
	}
}
</script>
<fieldset name="colors" class="options">
<legend><?php _e('Text Color', 'ktai_style'); ?></legend>
<p><?php _e('Note: To revert values to default, just empty of the field.', 'ktai_style'); ?></p>
<table class="optiontable"><thead>
<tr><th><?php _e('Target', 'ktai_style'); ?></th><td><?php _e('#rrggbb as hex format', 'ktai_style'); ?></td><td><?php _e('Color sample', 'ktai_style'); ?></td></tr>
</thead><tbody>
<tr>
<th><label for="date_color"><?php _e('Date/time for post titles', 'ktai_style'); ?></label></th>
<td><input type="text" value="<?php echo attribute_escape($date_color); ?>" name="date_color" id="date_color" onkeyup='change_sample(this, "date_color_sample")' /></td>
<td id="date_color_sample" style="color:<?php echo attribute_escape($date_color); ?>;"><?php echo date('Y-m-d H:i'); ?></td>
</tr><tr>
<th><label for="author_color"><?php _e('Author, Date with a post content', 'ktai_style'); ?></label></th>
<td><input type="text" value="<?php echo attribute_escape($author_color); ?>" name="author_color" id="author_color" onkeyup='change_sample(this, "author_color_sample")' /></td>
<td id="author_color_sample" style="color:<?php echo attribute_escape($author_color); ?>;"><?php echo wp_specialchars($user_identity); ?></td>
</tr><tr>
<th><label for="comment_type_color"><?php _e('Comment types', 'ktai_style'); ?></label></th>
<td><input type="text" value="<?php echo attribute_escape($comment_type_color); ?>" name="comment_type_color" id="comment_type_color" onkeyup='change_sample(this, "comment_type_color_sample")' /></td>
<td id="comment_type_color_sample" style="color:<?php echo attribute_escape($comment_type_color); ?>;"><?php echo __('Comment'), '/', __('Trackback'), '/', __('Pingback'); ?></td>
</tr><tr>
<th><label for="external_link_color"><?php _e('Link text for external websites', 'ktai_style'); ?></label></th>
<td><input type="text" value="<?php echo attribute_escape($external_link_color); ?>" name="external_link_color" id="external_link_color"  onkeyup='change_sample(this, "external_link_color_sample")' /></td>
<td id="external_link_color_sample" style="color:<?php echo attribute_escape($external_link_color); ?>;">http://wppluginsj.sourceforge.jp/</td>
</tr>
</tbody></table>
<p><?php _e('Note: To configure background color/normal text color/hyperlink color/visited link color, edit &lt;body&gt; element at themes/*/header.php', 'ktai_style'); ?> <a href="templates.php?file=<?php echo str_replace('%2F', '/', $Ktai_Style->get('plugin_dir') . "themes/$theme/header.php"); ?>"><?php _e('&raquo; Edit', 'ktai_style'); ?></a></p>
</fieldset>
<fieldset name="date_format" class="options">
<legend><?php _e('Date format of posts/comments', 'ktai_style'); ?></legend>
<table class="optiontable"><tbody>
<tr>
<th><label for="year_format"><?php _e('In case of displaying year, month, date<br />(for last year and before)', 'ktai_style'); ?></label></th>
<td><input type="text" value="<?php echo $year_format ?>" name="year_format" id="year_format" /></td>
</tr><tr>
<th><label for="month_date_format"><?php _e('In case of displaying month, date only<br />(for this year)', 'ktai_style'); ?></label></th>
<td><input type="text" value="<?php echo $month_date_format ?>" name="month_date_format" id="month_date_format" /></td>
</tr><tr>
<th><label for="time_format"><?php _e('Time', 'ktai_style'); ?></label></th>
<td><input type="text" value="<?php echo $time_format ?>" name="time_format" id="time_format" /></td>
</tr>
</tbody></table>
<p><?php _e('Note: About date format, refer to <a href="http://codex.wordpress.org/Formatting_Date_and_Time">Codex</a> or <a href="http://www.php.net/date">date() function manual</a> of PHP.', 'ktai_style'); ?></p>
</fieldset>
<div class="submit">
<input type="hidden" name="action" value="update" />
<input type="submit" name="update_option" value="<?php _e('Update Options &raquo;'); ?>" />
</div>
</form>
</div>
<?php
} 

/* ==================================================
 * @param	mix   $action
 * @return	none
 */
private function make_nonce_field($action = -1) {
	if ( !function_exists('wp_nonce_field') ) {
		return;
	} else {
		return wp_nonce_field($action);
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
private function upate_options() {
	if (! empty($_POST['common_theme']) && preg_match('/^[-_.+a-zA-Z0-9]+$/', $_POST['common_theme'])) {
		if (file_exists(dirname(__FILE__) . '/themes/' . $_POST['common_theme'] . '/index.php')) {
			update_option('ks_theme', $_POST['common_theme']);
		}
	}
if (defined('KS_KEEP_OLD_PREFS')) {
		delete_option('ks_title_only');
		delete_option('ks_external_link');
}
	if (! empty($_POST['separate_comments'])) {
		if (is_numeric($_POST['separate_comments'])) {
			update_option('ks_separate_comments', ($_POST['separate_comments'] == 2));
		}
if (defined('KS_KEEP_OLD_PREFS')) {
		if (get_option('ks_separate_recent_comments')) {
			delete_option('ks_separate_recent_comments');
		}
}
	} else {
		delete_option('ks_separate_comments');
if (defined('KS_KEEP_OLD_PREFS')) {
		delete_option('ks_separate_recent_comments');
}
	}

	if (! empty($_POST['treat_as_internal'])) {
		$sites = preg_split('/\\s+/', $_POST['treat_as_internal'], -1, PREG_SPLIT_NO_EMPTY);
		$sites = array_map('clean_url', $sites);
		$sites = preg_replace('#/$#', '', $sites);
		$sites_join = implode(' ', $sites);
		if (! preg_match('/^\\s*$/', $sites_join)) {
			update_option('ks_treat_as_internal', $sites_join);
		} else {
			delete_option('ks_treat_as_internal');
		}
	} else {
		delete_option('ks_treat_as_internal');
	}

	if (! empty($_POST['author_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['author_color'])) {
			update_option('ks_author_color', $_POST['author_color']);
		}
	} else {
		delete_option('ks_author_color');
	}

	if (! empty($_POST['date_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['date_color'])) {
			update_option('ks_date_color', $_POST['date_color']);
		}
	} else {
		delete_option('ks_date_color');
	}

	if (! empty($_POST['comment_type_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['comment_type_color'])) {
			update_option('ks_comment_type_color', $_POST['comment_type_color']);
		}
	} else {
		delete_option('ks_comment_type_color');
	}

	if (! empty($_POST['external_link_color'])) {
		if (preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['external_link_color'])) {
			update_option('ks_external_link_color', $_POST['external_link_color']);
		}
	} else {
		delete_option('ks_external_link_color');
	}

	if (! empty($_POST['year_format'])) {
		if (preg_match('/[Yyo]/', $_POST['year_format']) && preg_match('/[mnMF]/', $_POST['year_format']) && preg_match('/[djz]/', $_POST['year_format'])) {
			update_option('ks_year_format', $_POST['year_format']);
		}
	} else {
		delete_option('ks_year_format');
	}

	if (! empty($_POST['month_date_format'])) {
		if (preg_match('/[mnMF]/', $_POST['month_date_format']) && preg_match('/[djz]/', $_POST['month_date_format'])) {
			update_option('ks_month_date_format', $_POST['month_date_format']);
		}
	} else {
		delete_option('ks_month_date_format');
	}

	if (! empty($_POST['time_format'])) {
		if (preg_match('/[BgGhH]/', $_POST['time_format'])) {
			update_option('ks_time_format', $_POST['time_format']);
		}
	} else {
		delete_option('ks_time_format');
	}
?>
<div class="updated fade"><p><strong><?php _e('Options saved.'); ?></strong></p></div>
<?php
	return;
}

// ===== End of class ====================
}
?>