<?php
/* ==================================================
 *   Ktai Admin Post Form
 *   based on wp-admin/edit-form.php of WP 2.3
   ================================================== */

global $Ktai_Style, $KS_Admin;
if (! isset($checked_cats)) {
	$checked_cats = array();
}
?>
<form method="post" action="post.php"><input type="hidden" name="<?php echo KS_SESSION_NAME; ?>" value="<?php $KS_Admin->the_sid() ?>" /><input type="hidden" name="charset_detect" value="<?php _e('Encoding discriminant strings to avoid charset mis-understanding', 'ktai_style'); ?>" />
<?php
list($cat_ids, $cat_names) = KS_Admin_Edit_Form::read_nested_categories(NULL, $checked_cats);
if (0 == $post_ID) {
	$form_action = 'post';
	$temp_ID = -1 * time(); // don't change this formula without looking at wp_write_post()
	$form_extra = '<input type="hidden" name="temp_ID" value="' . $temp_ID . '" />';
	wp_nonce_field('add-post');
	if (! $cat_ids) {
		$cat_ids[]   = get_option('default_category');
		$cat_names[] = wp_specialchars(apply_filters('the_category', get_the_category_by_ID(get_option('default_category'))));
	}
} else {
	$form_action = 'editpost';
	$form_extra = '<input type="hidden" name="post_ID" value="' . intval($post_ID) . '" />';
	wp_nonce_field('update-post_' .  $post_ID);
}
$form_prevstatus = '<input type="hidden" name="prev_status" value="' . attribute_escape( $post->post_status ) . '" />';
$saveasdraft = '<input name="save" type="submit" value="' . attribute_escape( __('Save and Continue Editing') ) . '" />';
if (empty($post->post_status)) $post->post_status = 'draft';
?>
<input type="hidden" name="action" value="<?php echo $form_action ?>" />
<input type="hidden" name="originalaction" value="<?php echo $form_action ?>" />
<input type="hidden" id="post_type" name="post_type" value="post" />
<?php echo $form_extra ?>
<div><?php _e('Title') ?><br />
<input type="text" name="post_title" size="30" value="<?php echo attribute_escape($post->post_title); ?>" /><br />
<?php _e('Categories') ?><br />
<input type="hidden" name="post_cats" value="<?php echo implode(',', $cat_ids); ?>" /><font color="green"><?php echo implode(', ', $cat_names); ?></font><input type="submit" name="selcats" value="<?php _e('Change', 'ktai_style'); ?>" /><br />
<?php _e('Post') ?><br />
<textarea rows="8" cols="100%" name="content"><?php echo attribute_escape($post->post_content); ?></textarea><br />
<?php if (function_exists('get_tags_to_edit')) {
	_e('Tags'); ?>
<br /><input name="tags_input" value="<?php echo get_tags_to_edit( $post_ID ); ?>" size="48" /><br />
<?php } ?>
<?php echo $saveasdraft; ?>
<input type="submit" name="submit" value="<?php _e('Save'); ?>" />
<?php
if ( !in_array( $post->post_status, array('publish', 'future') ) || 0 == $post_ID ) {
	if ( current_user_can('publish_posts') ) : ?>
<input type="submit" name="publish" value="<?php _e('Publish') ?>" />
<?php endif;
}
?>
<input name="referredby" type="hidden" value="<?php
if ($post_referredby) {
	echo attribute_escape($post_referredby);
} elseif (url_to_postid($KS_Admin->get_referer()) == $post_ID) {
	echo 'redo';
} else {
	echo clean_url(stripslashes($KS_Admin->get_referer()));
}
?>" />
<?php if ('edit' == $action) {
	$delete_nonce = wp_create_nonce('delete-post_' . $post_ID); ?>
<br /><input type="submit" name="deletepost" value="<?php echo ( 'draft' == $post->post_status ) ? __('Delete this draft') : __('Delete this post'); ?>" />
<?php } ?>
</div></form>
<?php 

/* ==================================================
 *   KS_Admin_Edit_Form class
   ================================================== */

class KS_Admin_Edit_Form {

/* ==================================================
 * @param	array  $catetegories
 * @return	array  $checked
 * @return	array  $names
 */
public function read_nested_categories($catetegories = NULL, $checked = array()) {
	if (is_null($catetegories)) {
		$catetegories = get_nested_categories();
	}
	$ids   = array();
	$names = array();
	foreach($catetegories as $c) {
		if ((empty($checked) && $c['checked']) || ($checked && in_array($c['cat_ID'], $checked))) {
			$ids[] = intval($c['cat_ID']);
			$names[] = wp_specialchars(apply_filters('the_category', $c['cat_name']));
		}
		if ($c['children']) {
			list($i, $n) = self::read_nested_categories($c['children'], $checked);
			$ids   = array_merge($ids, $i);
			$names = array_merge($names, $n);
		}
	}
	return array($ids, $names);
}

// ===== End of class ====================
}
?>