<?php
/* ͕h~̂߂̓{ꕶłB
   ̃\[Xt@C Shift_JIS ŕۑĂ܂B
   Above is a Japanese strings to avoid charset mis-understanding.
   This source file is saved with Shift_JIS. */

/* ==================================================
 *   Ktai_Service_Softbank class
   ================================================== */

class Ktai_Service_Softbank extends Ktai_Services {

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function replace_smiley($buffer) {
	$smiles = array(
		'icon_smile.gif'     => '$Gv',
		'icon_biggrin.gif'   => '$P5',
		'icon_sad.gif'       => '$P!',
		'icon_surprised.gif' => '$P$',
		'icon_eek.gif'       => '$P0',
		'icon_confused.gif'  => '$P\'', //' #syntax highlighting fix
		'icon_cool.gif'      => '$F4',
		'icon_mad.gif'       => '$P6',
		'icon_razz.gif'      => '$P)',
		'icon_neutral.gif'   => '$P"',
		'icon_wink.gif'      => '$P%',
		'icon_lol.gif'       => '$P)',
		'icon_redface.gif'   => '$P-',
		'icon_cry.gif'       => '$P1',
		'icon_evil.gif'      => '$P6',
		'icon_twisted.gif'   => '$P6',
		'icon_rolleyes.gif'  => '$P7',
		'icon_exclaim.gif'   => '$GA',
		'icon_question.gif'  => '$G@',
		'icon_idea.gif'      => '$E/',
		'icon_arrow.gif'     => '$FT',
		'icon_mrgreen.gif'   => '$Gv',
	);
	return parent::replace_smiley($buffer, $smiles);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 * Reference: http://developers.softbankmobile.co.jp/dp/tool_dl/web/picword_top.php
 *            http://www.au.kddi.com/ezfactory/tec/spec/3.html
 */
public function convert_char($buffer) {
	$chars = array (
		'1'   => '$Fr', // warning (!)
		'2'   => '$OW', // exclamation (!)
		'3'   => '$OV', // question (?)
		'4'   => 'Q',        // question (Q)
		'5'   => '$F[', // left triangle
		'6'   => '$FZ', // right triangle
		'7'   => '$F]', // double left triangle
		'8'   => '$F\\', // double right triangle
		'15'  => '$Gl', // moon (3days)
		'16'  => '$E]', // thunder
		'25'  => '$GF', // watch (3 o'clock)
		'29'  => '$FR', // up arrow
		'30'  => '$FS', // down arrow
		'32'  => '',  // down triangle
		'33'  => '',  // up triangle
		'34'  => '',  // double down triangle
		'35'  => '',  // double up triangle
		'42'  => '$FW', // up-left arrow
		'43'  => '$FX', // down-right arrow
		'44'  => '$Gj', // sun
		'45'  => '$G6', // baseball
		'46'  => '$GF', // clock
		'48'  => '$OE', // bell (chapel)
		'50'  => '$G"', // face (female)
		'51'  => '$GB', // heart
		'52'  => '$Gd', // bar (martini)
		'53'  => '$E0', // four-leaf clover
		'54'  => '$QW', // trade mark (TM)
		'55'  => '$OS', // multiply (cross)
		'56'  => '$O!', // note
		'61'  => '$OS', // cross
		'63'  => '$FT', // right arrow
		'64'  => '$FU', // left arrow
		'65'  => '$Ge', // magcup (tea room)
		'68'  => '$Gv', // smile
		'69'  => '$OO', // star
		'70'  => '$FV', // up-right arrow
		'71'  => '$FY', // down-left arrow
		'72'  => '$GT', // jewelry
		'74'  => '$Gr', // dog
		'75'  => '$OU', // star
		'76'  => '$ON', // spark
		'77'  => '$E/', // lamp
		'80'  => '$G!', // face (male)
		'81'  => '$Fn', // copyright mark
		'82'  => '$Fo', // registered mark
		'83'  => '$E>', // briefcase
		'85'  => '$G)', // telephone (fixed)
		'86'  => '$O!', // pop up memo
		'88'  => '',    // up triangle
		'89'  => '',    // down triangle
		'94'  => '$G(', // camera
		'95'  => '$Gk', // rain
		'96'  => '$PK', // american football
		'97'  => '$Eh', // book
		'98'  => '$EW', // keep out sign
		'99'  => '$En', // traffic signal
		'100' => '$Eh', // book
		'101' => '$Eh', // book
		'102' => '$Eh', // book
		'103' => '$O!', // document
		'104' => '$O3', // scissors
		'105' => '$O!', // daily calender
		'106' => '$EE', // ticket
		'107' => '$Gi', // cloud
		'108' => '$E#', // mail envelope
		'109' => '$EO', // money
		'110' => '$G]', // movie/video camera
		'111' => '$Q\'', // handheld video camera ' #syntax highlighting fix
		'112' => '$GV', // home
		'113' => '$O$', // flower (tulip)
		'116' => '$F1', // glasses / eye
		'118' => '', // next item /return mark
		'119' => '$E4', // magnifier (search)
		'120' => '$G_', // key
		'124' => '$E^', // shoe (high-heel)
		'125' => '$Ez', // sedan (car)
		'140' => '$FP', // leftside finger
		'141' => '$FQ', // rightside finger
		'143' => '$O!', // clip
		'144' => '$E2', // present box
		'146' => '$Gc', // knife and fork
		'149' => '$O!', // pen
		'151' => '$E#', // envelope
		'152' => '$E6', // spanner / hammer
		'155' => '$G)', // telephone (handset)
		'156' => '$GX', // factory
		'161' => '$G*', // mobile phone
		'168' => '$G=', // air plane
		'169' => '$EU', // boat (ship)
		'172' => '$G>', // electric train
		'176' => '$O.', // smoking
		'177' => '$F(', // no smoking
		'178' => '$F*', // wheel chair
		'179' => '$F)', // beginner driver mark
		'180' => '$F<', // one
		'181' => '$F=', // two
		'182' => '$F>', // three
		'183' => '$F?', // four
		'184' => '$F@', // five
		'185' => '$FA', // six
		'186' => '$FB', // seven
		'187' => '$FC', // eight
		'188' => '$FD', // nine
		'190' => '$Pc', // storm
		'191' => '$Gh', // snowball
		'192' => '$F_', // Aries (Ram)
		'193' => '$F`', // Taurus (Bull)
		'194' => '$Fa', // Gemini (Twins)
		'195' => '$Fb', // Cancer (Crab)
		'196' => '$Fc', // Leo (Lion)
		'197' => '$Fd', // Virgo (Virgin)
		'198' => '$Fe', // Libra (Scales)
		'199' => '$Ff', // Scorpius (Scorpion)
		'200' => '$Fg', // Sagittarius (Archer)
		'201' => '$Fh', // Capricornus (Goat)
		'202' => '$Fi', // Aquarius (Water Bearer)
		'203' => '$Fj', // Pisces (Fishes)
		'204' => '$Fk', // Ophiuchus (Serpent Bearer)
		'205' => '$Et', // Automatic Teller Machine
		'206' => '$Ev', // convenience store
		'207' => '$Eq', // toilet
		'208' => '$Eo', // parking
		'209' => '$Ep', // bus stop
		'210' => '$Ek', // location simble (parabola antenna)
		'211' => '$F"', // port (anchor)
		'212' => '$Em', // bank
		'213' => '$GZ', // gas station
		'215' => '$EV', // bicycle
		'216' => '$Ey', // bus
		'217' => '$G?', // shinkansen (bullet train)
		'218' => '$E5', // marathon
		'219' => '$G8', // football (soccer)
		'220' => '$G5', // tennis
		'221' => '$G3', // snow board
		'222' => '$ER', // checker flag
		'223' => '$ED', // amusement park
		'224' => '$EC', // spa
		'226' => '$OD', // movie (clapper board)
		'227' => '$Pk', // night scene
		'233' => '$EO', // doller bag
		'234' => '$GS', // christmas tree
		'235' => '$GP', // cherry blossom
		'239' => '$Gf', // short cake
		'244' => '$Ob', // onigiri (rise ball)
		'245' => '$E@', // hamberger (fast food)
		'251' => '$Go', // cat
		'257' => '$Gv', // laugh face
		'258' => '$Gy', // angry face
		'259' => '$Gw', // sad face
		'260' => '$Gx', // tired face
		'261' => '$E', // Sleepy (Zzz)
		'262' => '$OT', // angry
		'263' => '$E(', // tear
		'264' => '$E%', // bleah
		'265' => '$GC', // heart break
		'266' => '$OG', // double hearts
		'268' => '$O1', // bomb
		'273' => '$G#', // kiss mark
		'278' => '$F$', // flower circle
		'279' => '$O5', // secret
		'281' => '$G-', // punch
		'282' => '$OP', // dashing
		'287' => '$P@', // ok hand sign
		'288' => '$EJ', // TV set
		'289' => '$G\\', // microphone (kara-oke)
		'290' => '$EO', // wallet
		'291' => '$OF', // musical note
		'294' => '$O*', // music
		'295' => '$O<', // rouge
		'299' => '$F6', // free
		'300' => '$EF', // CD/DVD
		'303' => '$F3', // updated
		'305' => '[]',  // fog
		'306' => '$G4', // golf
		'307' => '$PJ', // basket ball
		'309' => '$Q"', // art
		'310' => '$Q#', // performance
		'311' => '$Q&', // event (circus)
		'312' => '$O4', // ribbon
		'313' => '$Ok', // birthday
		'314' => '$F.', // spade mark (cards)
		'315' => '$F-', // diamond mark (cards)
		'316' => '$F/', // pam mark (cards)
		'317' => '$P9', // eyes
		'318' => '$P;', // ear
		'319' => '$G1', // scissors (hands)
		'320' => '$G2', // paper (hands)
		'321' => '$Gl', // new moon
		'322' => '$Gl', // eclipsed moon
		'323' => '$Gl', // half moon
		'324' => '[CL]', // clear button
		'325' => '$FE', // zero
		'326' => '$Fm',  // ok
		'327' => '$Gx', // very tired face
		'333' => '$O`', // ramen (donburi)
		'334' => '$F2', // new
		'337' => '$G,', // personal computer
		'339' => '$GR', // rose
		'340' => '$GW', // church
		'341' => '$PT', // subway
		'342' => '$G[', // Mt.Fuji
		'343' => '$O*', // music
		'354' => '$E.', // crown
		'358' => '$E8', // read leaves
		'375' => '$Es', // post office
		'376' => '$Eu', // hospital
		'377' => '$Ew', // school
		'378' => '$Ex', // hotel
		'379' => '$F"', // ship
		'380' => '$F\'', // prohibited for U-18 ' #syntax highlighting fix
		'381' => '$F+', // anntena mark
		'382' => '$F4', // cool
		'383' => '$FG', // discount mark
		'384' => '$FH', // service mark
		'385' => '$FI', // ID mark
		'386' => '$FJ', // full mark
		'387' => '$FK', // vacant mark
		'388' => '$FL', // reserved mark
		'389' => '$FM', // in-business mark
		'390' => '$FN', // upside finger
		'391' => '$FO', // downside finger
		'393' => '$Fp', // manner mode
		'394' => '$Fq', // power off
		'395' => '$O!', // make a memo
		'400' => '$O+', // tokkkuri,ochoko
		'401' => '$Gg', // beer (cheers)
		'410' => '$O?', // hair salon
		'414' => '$F,', // heart mark (cards)
		'421' => '$G3', // ski
		'422' => '$OR', // oval
		'423' => '$OX', // green tea
		'424' => '$OY', // bread
		'434' => '$Oe', // apple
		'715' => '$QB', // fish
		'728' => '$QV', // foot print
		'729' => '$G\'', // shoe '
		'803' => '$OH', // swing heart
		'804' => '$QC', // chick
		'805' => '', // jeans
		'806' => '$OI', // love letter
		'810' => '$P^', // tidal wave
		'811' => '$Pg', // twin leave
		'812' => '$Pa', // snail
		'817' => '$G0', // rock (hands)
		'\\d+' => '',   // (catch all)
	);
	$pat = preg_replace('/^(.*)$/', '!<img localsrc="$1"( alt="[^"\\\\\\\\]*?(\\\\\\\\.[^"\\\\\\\\]*)*")? ?/?>!', array_keys($chars));
	$buffer = preg_replace($pat, $chars, $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = preg_replace('!$!', '', $buffer);
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_PDC class
   ================================================== */

class Ktai_Service_Softbank_PDC extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->operator   = 'SoftBank';
	$this->type       = 'PDC';
	$this->user_agent = $user_agent;
	preg_match('!^J-PHONE/\d\.\d+/([-_.a-zA-Z0-9]+)/?(SN([-_.a-zA-Z0-9]*))? ?!', $user_agent, $specs);
	$this->term_name  = @$_SERVER['HTTP_X_JPHONE_MSNAME'];
	$this->term_name  = $this->term_name ? $this->term_name : $specs[1];
	$this->term_ID    = @$specs[3];
	$this->sub_ID     = @$_SERVER['HTTP_X_JPHONE_UID'];
	$this->page_size  = 6000;
	$this->cache_size = isset($specs[2]) ? 12288 : 6144;
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	$this->preamble   = '';
	return;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_pre_split($buffer) {
	$buffer = preg_replace('!<h([1-6])(.*?)</h\\1>!', '<p$2</p>', $buffer);
	return parent::shrink_pre_split($buffer);
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function shrink_post_split($buffer) {
	$buffer = preg_replace('!\s*</(li|dt|dd|)>\s*!', '', $buffer);
	$buffer = preg_replace('!<([-~_= a-zA-Z0-9%.,:;\'"#*/+]+?) ?/>!', '<$1>', $buffer); //"
	return parent::shrink_post_split($buffer);
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Service_Softbank_3G class
   ================================================== */

class Ktai_Service_Softbank_3G extends Ktai_Service_Softbank {

/* ==================================================
 * @param	string  $user_agent
 * @return	object  $this
 */
public function __construct($user_agent) {
	parent::__construct($user_agent);
	$this->operator   = 'SoftBank';
	$this->type       = '3G';
	$this->user_agent = $user_agent;
	preg_match('!^(Vodafone|SoftBank)/\d\.\d+/([-_.a-zA-Z0-9]+)/[-_.a-zA-Z0-9]+/(SN([-_.a-zA-Z0-9]*))? !', $user_agent, $specs);
	$this->term_name  = @$_SERVER['HTTP_X_JPHONE_MSNAME'];
	$this->term_name  = $this->term_name ? $this->term_name : $specs[2];
	$this->term_ID    = $specs[4];
	$this->sub_ID     = @$_SERVER['HTTP_X_JPHONE_UID'];
	$this->page_size  = 10000;
	$this->cache_size = 102400;
	$this->charset    = 'SJIS-win';
	$this->mime_type  = 'text/html';
	$this->preamble   = '<?xml version="1.0" encoding="__CHARSET__"?>
<!DOCTYPE html PUBLIC "-//J-PHONE//DTD XHTML Basic 1.0 Plus//EN" "xhtml-basic10-plus.dtd">';
	return;
}

// ===== End of class ====================
}
?>
