<?php
/*
Plugin Name: Ktai Style
Plugin URI: http://wppluginsj.sourceforge.jp/ktai_style/
Description: Provides lightweight pages for mobile phones.
Author: IKEDA Yuriko
Version: 0.94
Author URI: http://www.yuriko.net/cat/wordpress
*/

/*  Copyright (c) 2007 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define ('KS_VERSION' , '0.94');
$Ktai_Style = new Ktai_Style;

/* ==================================================
 * @param	none
 * @return	boolean $is_mobile
 */
if (! function_exists('is_mobile') && ! file_exists(dirname(dirname(__FILE__)) . '/wphone')) :
function is_mobile() {
	global $Ktai_Style;
	return $Ktai_Style->is_mobile();
}
elseif (! function_exists('is_ktai')) :
function is_ktai() {
	global $Ktai_Style;
	return $Ktai_Style->is_mobile();
}
endif;

/* ==================================================
 *   Ktai_Style class
   ================================================== */

class Ktai_Style {
	private $plugin_dir;
	private $template_dir;
	public  $ktai;

/* ==================================================
 * @param	none
 * @return	object  $this
 */
public function __construct() {
	$this->set_plugin_dir();
	load_plugin_textdomain('ktai_style', $this->plugin_dir);
	require_once dirname(__FILE__) . '/services.php';
	require_once dirname(__FILE__) . '/prefpane.php';
	$this->ktai = Ktai_Services::factory();
	$admin_dir = dirname(__FILE__) . '/admin';
	if ($this->ktai) {
		add_action('template_redirect', array($this, 'output'), 9);
		remove_action('wp_head', 'rsd_link');
		remove_action('wp_head', 'locale_stylesheet');
		remove_action('wp_head', 'wp_print_scripts');
		if (file_exists($admin_dir)) {
			require_once $admin_dir . '/pluggable-override.php';
			require_once $admin_dir . '/class.php';
			add_action('wp_authenticate', array('Ktai_Style_Admin', 'ktai_login'));
		}
		if (isset($_GET['ks'])) {
			$_GET['s'] = mb_convert_encoding($_GET['ks'], get_bloginfo('charset'), $this->detect_encoding(@$_GET['Submit']));
		}
	} else {
		$KS_Config = new Ktai_Style_PrefPane;
		add_action('admin_menu',  array($KS_Config, 'add_page'));
		if (isset($_GET['activate']) && $_GET['activate'] == 'true' && file_exists($admin_dir)) {
			require $admin_dir . '/install.php';
		}
	}
	return;
}

/* ==================================================
 * @param	string  $key
 * @return	boolean $charset
 */
public function get($key) {
	switch ($key) {
	case 'plugin_dir':
		return $this->plugin_dir;
	case 'template_dir':
		return $this->template_dir;
	default:
		if (! $this->ktai) {
			return Ktai_Services::get($key);
		}
		return $this->ktai->get($key);
	}
}

/* ==================================================
 * @param	none
 * @return	boolean $is_mobile
 */
public function is_mobile() {
	if (! $this->ktai) {
		return FALSE;
	}
	return $this->ktai->get('operator');
}

/* ==================================================
 * @param	none
 * @return	none
 */
private function set_plugin_dir() {
	$this->plugin_dir = preg_replace('!^.*' . PLUGINDIR . '!' , PLUGINDIR, dirname(__FILE__));
	if (DIRECTORY_SEPARATOR == '\\') {
		$this->plugin_dir = str_replace('\\', '/', $this->plugin_dir);
	}
	if (! preg_match('!^' . PLUGINDIR . '!', $this->plugin_dir)) {
		$this->plugin_dir = PLUGINDIR . '/ktai_style';
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function output() {
	if (is_robots() || is_feed() || is_trackback()) {
		return;
	}
	if (! $template = $this->load_template()) {
		$this->ks_die(__('Can\'t display pages. Bacause mobile phone templates are collapsed.', 'ktai_style'));
	}

	add_filter('comments_template', array($this, 'comments_template'), 90);
	add_filter('wp_list_categories', array($this, 'filter_tags'), 90);
	add_filter('wp_list_pages', array($this, 'filter_tags'), 90);
	require_once dirname(__FILE__) . '/tags.php';
	$charset      = $this->ktai->get('charset');
	$iana_charset = $this->ktai->get('iana_charset');
	$buffer = $this->ktai->get('preamble') . "\n";
	ob_start();
	include $template;
	$buffer .= ob_get_contents();
	ob_end_clean();
	$buffer = mb_convert_encoding($buffer, $charset, get_bloginfo('charset'));
	$buffer = $this->ktai->shrink_pre_split($buffer);
	$buffer = $this->ktai->replace_smiley($buffer);
	$buffer = $this->ktai->convert_char($buffer);
	$buffer = $this->ktai->split_page($buffer, $this->get_page_num());
	$buffer = $this->ktai->shrink_post_split($buffer);
	header ("Content-Type: text/html; charset=$iana_charset");
	echo $buffer;
	exit;
}

/* ==================================================
 * @param	string  $input
 * @return	string  $charset
 */
public function detect_encoding($input) {
	if (empty($input)) {
		$charset = 'auto';
	} else {
		$charset = mb_detect_encoding($input, array('JIS', 'UTF-8', 'SJIS', 'EUC-JP'));
		if (! $charset) {
			$charset = 'auto';
		}
	}
	return $charset;
}

/* ==================================================
 * @param	none
 * @return	string  $template
 * based on wp-includes/template-loader.php of WP 2.2.3
 */
private function load_template() {
	$this->template_dir = dirname(__FILE__) . '/templates/';
	if ( is_404() && $template = $this->query_template('404')) {
		return $template;
	} elseif (isset($_GET['menu'])) {
		if ($_GET['menu'] == 'months' && $template = $this->query_template('menu_months')) {
			return $template;
		} elseif ($_GET['menu'] == 'cats' && $template = $this->query_template('menu_cats')) {
			return $template;
		} elseif ($_GET['menu'] == 'links' && $template = $this->query_template('menu_links')) {
			return $template;
		} elseif ($_GET['menu'] == 'pages' && $template = $this->query_template('menu_pages')) {
			return $template;
		} elseif ($_GET['menu'] == 'comments' && $template = $this->query_template('menu_comments')) {
			return $template;
		}
	} elseif (is_search() && $template = $this->query_template('search')) {
		return $template;
	} elseif (is_home() && $template = $this->get_home_template()) {
		return $template;
	} elseif (is_attachment() && $template = $this->get_attachment_template()) {
		return $template;
	} elseif (is_single() && $template = $this->query_template('single')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_page() && $template = $this->query_template('page')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_category() && $template = $this->get_category_template()) {
		return $template;
	} elseif (is_author() && $template = $this->query_template('author')) {
		return $template;
	} elseif (is_date() && $template = $this->query_template('date')) {
		return $template;
	} elseif (is_archive() && $template = $this->query_template('archive')) {
		return $template;
	} elseif (is_paged() && $template = $this->query_template('paged')) {
		return $template;
	} elseif (file_exists($this->template_dir . 'index.php')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $this->template_dir . 'index.php';
	}
	return NULL;
}

/* ==================================================
 * @param	string  $type
 * @return	string  $template
 * based on get_query_template() at wp-includes/theme.php of WP 2.2.3
 */
private function query_template($type) {
	$template = '';
	if (file_exists($this->template_dir . "{$type}.php")) {
		$template = $this->template_dir . "{$type}.php";
	}
	return apply_filters("{$type}_template", $template);
}

/* ==================================================
 * @param	none
 * @return	string  $template
 * based on get_category_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_category_template() {
	$template = '';
	if (file_exists($this->template_dir . 'category-' . get_query_var('cat') . '.php')) {
		$template = $this->template_dir . 'category-' . get_query_var('cat') . '.php';
	} elseif (file_exists($this->template_dir . 'category.php')) {
		$template = $this->template_dir . 'category.php';
	}
	return apply_filters('category_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 * based on get_home_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_home_template() {
	$template = '';
	if (file_exists($this->template_dir . 'home.php')) {
		$template = $this->template_dir . 'home.php';
	} elseif (file_exists($this->template_dir . 'index.php')) {
		$template = $this->template_dir . 'index.php';
	}
	return apply_filters('home_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string  $template
 * based on get_attachment_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_attachment_template() {
	global $posts;
	$type = explode('/', $posts[0]->post_mime_type);
	if ( $template =  $this->query_template($type[0]) )
		return $template;
	elseif ( $template =  $this->query_template($type[1]) )
		return $template;
	elseif ( $template =  $this->query_template("$type[0]_$type[1]") )
		return $template;
	else
		return $this->query_template('attachment');
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_header() {
	do_action('get_header');
	if (file_exists($this->template_dir . 'header.php')) {
		load_template($this->template_dir . 'header.php');
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_footer() {
	do_action('get_footer');
	if (file_exists($this->template_dir . 'footer.php')) {
		load_template($this->template_dir . 'footer.php');
	}
	return;
}

/* ==================================================
 * @param	string  $path
 * @return	string  $path
 */
function comments_template($path) {
	return str_replace(TEMPLATEPATH . '/', $this->template_dir, $path);
}

/* ==================================================
 * @param	none
 * @return	int    $page_num
 */
private function get_page_num() {
	$page_num = 0;
	if (isset($_GET['kp']) && is_numeric($_GET['kp'])) {
		$page_num = intval($_GET['kp']);
	} elseif (isset($_POST['kp']) && is_numeric($_POST['kp'])) {
		$page_num = intval($_POST['kp']);
	}
	return $page_num;
}

/* ==================================================
 * @param	string  $html
 * @return	string  $html
 */
public function filter_tags($html) {
	$html = Ktai_HTML_Filter::kses($html, $this->get('allowedtags'));
	return $html;
}

/* ==================================================
 * @param	string  $message
 * @param	string  $title
 * @param	boolean $show_back_link
 * @return	none
 * based on wp_die() at wp-includes/functions() of WP 2.2.3
 */
public function ks_die($message, $title = '', $show_back_link = TRUE) {
	global $Ktai_Style, $KS_Admin;

	if ( function_exists( 'is_wp_error' ) && is_wp_error( $message ) ) {
		if ( empty($title) ) {
			$error_data = $message->get_error_data();
			if ( is_array($error_data) && isset($error_data['title']) )
				$title = $error_data['title'];
		}
		$errors = $message->get_error_messages();
		switch ( count($errors) ) :
		case 0 :
			$message = '';
			break;
		case 1 :
			$message = "<p>{$errors[0]}</p>";
			break;
		default :
			$message = "<ul><li>" . join( "</li><li>", $errors ) . "</li></ul>";
			break;
		endswitch;
	} elseif ( is_string($message) ) {
		$message = "<p>$message</p>";
	}
	if ($show_back_link && $KS_Admin && $referer = $KS_Admin->get_referer()) {
		$message .= sprintf(__('Back to <a href="%s">the previous page</a>.', 'ktai_style'), attribute_escape($referer));
	}

	switch ($Ktai_Style->is_mobile()) {
	case 'DoCoMo':
		$logo_ext = 'gif';
		break;
	default:
		$logo_ext = 'png';
		break;
	}
	if (! did_action('admin_head') ) :
		if ($Ktai_Style->ktai) {
			$charset      = $Ktai_Style->ktai->get('charset');
			$iana_charset = $Ktai_Style->ktai->get('iana_charset');
		} else {
			$charset      = Ktai_Services::get('charset');
			$iana_charset = Ktai_Services::get('iana_charset');
		}
		header ("Content-Type: text/html; charset=$iana_charset");

		if (empty($title)) {
			$title = mb_convert_encoding(__('WordPress &rsaquo; Error'), $charset, get_bloginfo('charset'));
		}
		echo '<?xml version="1.0" encoding="' . $iana_charset .'" ?>' . "\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN" "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $iana_charset; ?>" />
<title><?php echo $title ?></title>
</head>
<body>
<?php endif; ?>
<div><h1 id="logo"><img alt="WordPress" src="<?php echo preg_replace('!^https?://[^/]*/?!', '/', get_bloginfo('wpurl') . '/') . $Ktai_Style->get('plugin_dir') . '/wplogo.' . $logo_ext; ?>" /></h1></div>
<?php echo mb_convert_encoding($message, $charset, get_bloginfo('charset')); ?>
</body>
</html>
<?php
	exit();
}

// ===== End of class ====================
}
?>