<?php
/* ==================================================
 *   Ktai Admin Process Posts
 *   based on wp-admin/post.php of WP 2.3
   ================================================== */

require_once dirname(__FILE__) . '/admin.php';
$parent_file = 'edit.php';
$Page = new KS_Admin_Posts();
wp_reset_vars(array('action', 'posts'));

if (isset($_POST['deletepost'])) {
	$action = 'delete';
} elseif (isset($_POST['selcats'])) {
	$action = 'selcats';
}
switch ($action) {
case 'post':
	$parent_file = 'post-new.php';
	$submenu_file = 'post-new.php';
	check_admin_referer('add-post');
	$post_ID = 'post' == $action ? $KS_Admin->write_post() : $KS_Admin->edit_post();
	// Redirect.
	if (!empty($_POST['mode'])) {
		$location = 'post-new.php';
	} else {
		$location = "post-new.php?posted=$post_ID";
	}
	if (isset($_POST['save'])) {
		$location = "post.php?action=edit&post=$post_ID";
	}
	if (empty($post_ID)) {
		$location = 'post-new.php';
	}
	$KS_Admin->redirect($location);
	exit();
	break;
case 'edit':
	$title = __('Edit');
	$editing = true;
	$post_ID = (int) $_GET['post'];
	$post = $Page->get_post($post_ID);
	include dirname(__FILE__) . '/admin-header.php';
	$checked_cats = array();
	include dirname(__FILE__) . '/edit-form.php';
	$referer = $KS_Admin->get_referer();
	if ($referer) {
		echo '<div><img localsrc="64" alt="' . __('&lt;-', 'ktai_style') . '" />' . sprintf(__('Back to <a href="%s">the previous page</a>.', 'ktai_style'), attribute_escape($referer)) . '</div>';
	}
	break;
case 'editpost':
	$post_ID = (int) $_POST['post_ID'];
	check_admin_referer('update-post_' . $post_ID);
	$post_ID = $KS_Admin->edit_post();
	if ( 'post' == $_POST['originalaction'] ) {
		if (! empty($_POST['mode'])) {
			$location = 'post-new.php';
		} else {
			$location = "post-new.php?posted=$post_ID";
		}
		if ( isset($_POST['save']) )
			$location = "post.php?action=edit&post=$post_ID";
	} else {
		$referredby = '';
		if (!empty($_POST['referredby'])) {
			$referredby = preg_replace('|https?://[^/]+|i', '', $_POST['referredby']);
		}
		$referer = preg_replace('|https?://[^/]+|i', '', $KS_Admin->get_referer());
		if ($_POST['save']) {
			$location = "post.php?action=edit&post=$post_ID";
		} elseif (!empty($referredby) && $referredby != $referer) {
			$location = $_POST['referredby'];
			if ( $_POST['referredby'] == 'redo' )
				$location = get_permalink( $post_ID );
		} else {
			$location = 'post-new.php';
		}
	}
	$KS_Admin->redirect($location); // Send user on their way while we keep working
	exit();
	break;
case 'delete':
	$post_id = (isset($_GET['post'])) ? intval($_GET['post']) : intval($_POST['post_ID']);
	check_admin_referer('delete-post_' . $post_id);
	$post = & get_post($post_id);
	if (! current_user_can('delete_post', $post_id)) {
		Ktai_Style::ks_die(__('You are not allowed to delete this post.'));
	}
	if ( $post->post_type == 'attachment' ) {
		if (! wp_delete_attachment($post_id)) {
			Ktai_Style::ks_die(__('Error in deleting...'));
		}
	} else {
		if (! wp_delete_post($post_id)) {
			Ktai_Style::ks_die(__('Error in deleting...'));
		}
	}
	$sendback = $KS_Admin->get_referer();
	if (strpos($sendback, 'post.php') !== false) {
		$sendback = ks_admin_url(FALSE) . 'post-new.php';
	}
	$sendback = preg_replace('|[^a-z0-9-~+_.?#=&;,/:]|i', '', $sendback);
	$KS_Admin->redirect($sendback);
	exit();
	break;
case 'selcats':
	global $post_ID;
	if ($_POST['originalaction'] == 'editpost') {
		$post_ID = (int) $_POST['post_ID'];
	 	if ($post_ID < 1) {
			Ktai_Style::ks_die(__("You attempted to edit a post that doesn't exist. Perhaps it was deleted?"));
		}
		check_admin_referer('update-post_' . $post_ID);
	} else {
		$post_ID = 0;
		check_admin_referer('add-post');
	}
	foreach (array('post_ID', 'post_cats', 'originalaction', 'referredby') as $k) {
		if (isset($_POST[$k])) {
			$KS_Admin->set_data($k, $_POST[$k]);
		}
	}
	$charset = Ktai_Style::detect_encoding($_POST['charset_detect']);
	$KS_Admin->set_data('post_title', mb_convert_encoding($_POST['post_title'], get_bloginfo('charset'), $charset));
	$KS_Admin->set_data('post_content', mb_convert_encoding($_POST['content'], get_bloginfo('charset'), $charset));
	$title = __('Select Category', 'ktai_style');
	include dirname(__FILE__) . '/admin-header.php';?>
<form action="post.php" method="post">
<input type="hidden" name="<?php echo KS_SESSION_NAME; ?>" value="<?php $KS_Admin->the_sid() ?>" />
<input type="hidden" name="action" value="changecats" />
<?php wp_nonce_field('select-cats_' . $post_ID);
$KS_Admin->checkbox_categories(array_map('intval', explode(',', $_POST['post_cats']))); ?>
<input type="submit" name="cancel" value="<?php _e('Cancel', 'ktai_style'); ?>" />
<input type="submit" value="<?php _e('Set Category', 'ktai_style'); ?>" />
</form>
<?php
	break;
case 'changecats':
	global $post_ID;
	if ($KS_Admin->get_data('originalaction') == 'editpost') {
		$title = __('Edit');
		$action = 'edit';
		$post_ID = intval($KS_Admin->get_data('post_ID'));
		$post = $Page->get_post($post_ID);
	} else {
		$parent_file = 'post-new.php';
		$title = __('Create New Post');
		$post_ID = 0;
		$post = get_default_post_to_edit();
	}
	check_admin_referer('select-cats_' . $post_ID);
	$post->post_title = $KS_Admin->get_data('post_title');
	$post->post_content = $KS_Admin->get_data('post_content');
	$post_referredby = $KS_Admin->get_data('referredby');
	$checked_cats = array();
	if (! isset($_POST['cancel'])) {
		if (is_array($_POST['cat']) && count($_POST['cat']) >= 1) {
			foreach ($_POST['cat'] as $c) {
				$checked_cats[] = intval($c);
			}
		} else {
			$checked_cats[] = get_option('default_category');
		}
	} else {
		$checked_cats = explode(',', $KS_Admin->get_data('post_cats'));
	}
	include dirname(__FILE__) . '/admin-header.php';
	include dirname(__FILE__) . '/edit-form.php';
	if ($KS_Admin->get_data('originalaction') == 'editpost') {
		$referer = $post_referredby;
		if ($referer && $post_referredby != 'redo') {
			echo '<div><img localsrc="64" alt="' . __('&lt;-', 'ktai_style') . '" />' . sprintf(__('Back to <a href="%s">the previous page</a>.', 'ktai_style'), attribute_escape($referer)) . '</div>';
		}
	}
	break;
default:
	$KS_Admin->redirect('edit.php');
	exit();
	break;
} // end switch
include dirname(__FILE__) . '/admin-footer.php'; 
exit;

/* ==================================================
 *   KS_Admin_Posts class
   ================================================== */

class KS_Admin_Posts {

// ==================================================
public function get_post($post_ID) {
	$post = get_post($post_ID);
	if (empty($post->ID)) {
		Ktai_Style::ks_die(__("You attempted to edit a post that doesn't exist. Perhaps it was deleted?"));
	}
	if ('page' == $post->post_type) {
		Ktai_Style::ks_die(__('Ktai Style is not available for page editing.', 'ktai_style'));
	}
	$post = get_post_to_edit($post_ID);
	if (! current_user_can('edit_post', $post_ID) ) {
		Ktai_Style::ks_die(__('You are not allowed to edit this post.'));
	}
	return $post;
}

// ===== End of class ====================
}
?>