<?php
/* ==================================================
 *   Ktai Template Tags
     version 0.90
   ================================================== */

add_filter('the_title', '_shrink_title', 90);
add_filter('the_content', '_shrink_content', 90);
add_filter('get_comment_text', '_shrink_content', 90);
add_filter('post_link', '_strip_host', 90);
add_filter('wp_list_pages', '_strip_properties', 90);
add_filter('wp_list_categories', '_strip_properties', 90);
add_filter('comments_template', '_comments_template', 90);

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_option($name) {
	return Ktai_Style_Config::get_option($name);
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_header() {
	Ktai_Style::get_header();
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_footer() {
	Ktai_Style::get_footer();
	return;
}

/* ==================================================
 * @param	string  $permalink
 * @return	string  $permalink
 */
function _strip_host($permalink = '') {
	return preg_replace('!^https?://[^/]*/?!', '/', $permalink);
}

/* ==================================================
 * @param	string $title
 * @param	string $before
 * @param	string $after
 * @return	string $title
 */
function _shrink_title($title, $before = '', $after = '') {
	$protected_phrase = str_replace('%s', '', __('Protected: %s'));
	return preg_replace('/^' . preg_quote("$before$protected_phrase", '/') . '/', $before . '<img localsrc="279" alt="' . $protected_phrase . '" />', $title);
}

/* ==================================================
 * @param	string  $output
 * @return	string  $output
 */
function _strip_properties($output) {
	$short_url = _strip_host(get_bloginfo('url') . '/');
	$output = preg_replace('!href=([\'"])' . preg_quote(get_bloginfo('url'), '!') . '/?!', 'href=\\1' . $short_url, $output);
	$output = preg_replace('!(<[^<]*?)( (title|rel|class|id)=([\'"])([^\\4\\\\]|\\\\\\4)*?\\4)+!', '\\1', $output);
	return $output;
}

/* ==================================================
 * @param	string $content
 * @return	string $content
 */
function _strip_links($content) {
	$short_url   = _strip_host(get_bloginfo('url') . '/');
	$short_wpurl = _strip_host(get_bloginfo('wpurl') . '/');
	$internal = array('!^' . preg_quote(get_bloginfo('url'), '!') . '/?!', 
	                  '!^' . preg_quote(get_bloginfo('wpurl'), '!') . '/?!');
	$short_links = array($short_url, $short_wpurl);
	$leave = array_merge($short_links, preg_split('/\\s+/', ks_option('ks_treat_as_internal'), -1, PREG_SPLIT_NO_EMPTY));
	$leave_pat = '!^(#|tel:|mailto:|' . implode('|', array_map('preg_quote', $leave)) . ')!';
	if (preg_match_all('!<a ([^>]*?)>(.*?)</a>!', $content, $links, PREG_SET_ORDER)) {
		foreach ($links as $l) {
			if (preg_match('!^<img([^>]*?) ?/?>!', $l[2], $image)) { // a thumbnail linked to original image
				if (! preg_match('#' . PLUGINDIR . '#', $image[1])) { // skip plug-in's icon
					$content = str_replace($l[0], $l[2], $content);
				}
			} else {
				preg_match('/href=([\'"])(([^\\1\\\\]|\\\\\\1)*?)\\1/', $l[1], $href);
				$clipped = preg_replace($internal, $short_links, $href[2], 1, $is_internal);
				if ($is_internal) {
					$content = str_replace($l[0], '<a href="' . $clipped . '">' . $l[2] . '</a>', $content);
				} elseif (! preg_match($leave_pat, $href[2])) {
					if (! ks_option('ks_external_link') || is_mobile() == 'DoCoMo' || is_mobile() == 'SoftBank') {
						$content = str_replace($l[0], $l[2], $content);
					} elseif (is_mobile() == 'KDDI') {
						$content = str_replace($l[0], '<a href="device:pcsiteviewer?url=' . $href[2] . '"><img localsrc="337" alt="[PC]" /><font color="' . ks_option('ks_external_link_color') . '">' . $l[2] . '</font></a>', $content);
					} else { // WILLCOM, Other
						$content = str_replace($l[0], '<a href="' . $href[2] . '"><img localsrc="337" alt="[PC]" /><font color="' . ks_option('ks_external_link_color') . '">' . $l[2] . '</font></a>', $content);
					}
				}
			}
		}
	}
	return $content;
}

/* ==================================================
 * @param	string $content
 * @return	string $content
 */
function _images_to_link($content) {
	if (preg_match_all('!<img ([^>]*?)src=([\'"])(([^\\2\\\\]|\\\\\\2)*?)\\2([^>]*?) ?/?>!', $content, $images, PREG_SET_ORDER)) {
		foreach($images as $i) {
			if (preg_match('/local/', $i[1])) { // pict chars
				continue;
			}
			if (preg_match('/alt=([\'"])(([^\\1\\\\]|\\\\\\1)*?)\\1/', $i[1] . $i[5], $a)) {
				$alt = $a[2];
			} else {
				$alt = basename($i[3]);
			}
			if (preg_match('/class=([\'"])(([^\\1\\\\]|\\\\\\1)*?)\\1/', $i[1] . $i[5], $c) && preg_match('/\\b(wp-smiley|ktai)\\b/', $c[2])) {
				$content = str_replace($i[0], '<img src=' . $i[2] . _strip_host($i[3]) . $i[2] . ' alt="' . $alt . '" class="' . $c[2] . '" />', $content);
			} elseif (preg_match('#' . PLUGINDIR . '#', $i[3])) { // plug-in's icon or what
				$content = str_replace($i[0], "[$alt]", $content);
			} else {
				$content = str_replace($i[0], '[<a href=' . $i[2] . $i[3] . $i[2] . '><img localsrc="94" alt="IMAGE:">' . $alt . '</a>]', $content);
			}
		}
	}
	return $content;
}

/* ==================================================
 * @param	string $content
 * @return	string $content
 */
function _shrink_content($content) {
	$content = _strip_links($content);
	$content = preg_replace('!<(script|style)>.*?</\\1>\\s*!s', '', $content);
	if (defined('CSS_CLASS_FOR_LOCATION')) { // Delete URL of Ktai Location
		$content = preg_replace('!\\s*<div class="' . CSS_CLASS_FOR_LOCATION . '">.*?</div>!s', '', $content);
	}
	$content = _images_to_link($content);
	return $content;
}

/* ==================================================
 * @param	none
 * @return	boolean $password_is_ok
 */
function _confirmed_post_password() {
	global $post;
	if (empty($post->post_password)) {
		return TRUE;
	}
	return (stripslashes($_POST['post_password']) == $post->post_password);
}

/* ==================================================
 * @param	string  $link
 * @param   string  $icon
 * @param   string  $desc
 * @param   string  $post_password
 * @return	string  $output
 */
function _internal_link($link, $accesskey, $icon, $desc, $post_password) {
	if (strlen($accesskey) == 1 && strpos('123456789*#', $accesskey) !== FALSE) { 
		$accesskey_html = ' accesskey="' . $accesskey . '"';
	} else {
		$accesskey_html = '';
	}
	if ($post_password && _confirmed_post_password()) {
		$param_html = '';
		if (preg_match('/[?&]view=(co_list|co_post)/', $link, $param)) {
			$param_html .= '<input type="hidden" name="view" value="' . $param[1] . '" />';
		}
		if (preg_match('/[?&]kp=(\d+)/', $link, $param)) {
			$param_html .= '<input type="hidden" name="kp" value="' . $param[1] . '" />';
		}
		return '<form method="post" action="' . _strip_host($link) . '">' . $icon . $param_html . '<input type="hidden" name="post_password" value="' . htmlspecialchars($post_password, ENT_QUOTES) . '" /><label' . $accesskey_html . '><input type="submit" name="submit" value="' . $desc . '"></label></form>';
	} else {
		return '<a href="' . _strip_host($link) . '"' . $accesskey_html . '>' . $icon . $desc . '</a>';
	}
}

/* ==================================================
 * @param	int    $more_link_text
 * @param   int    $stripteaser
 * @param   int    $more_file
 * @return	string $output
 * based on get_the_content() at wp-includes/post-template.php of WP 2.2.3
 */
function _get_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
	global $id, $post, $more, $single, $withcomments, $page, $pages, $multipage, $numpages;
	global $pagenow;
	$output = '';

	$need_password = ks_check_password();
	if ($need_password) {
		return $need_password;
	}

	if ( $more_file != '' )
		$file = $more_file;
	else
		$file = $pagenow; //$_SERVER['PHP_SELF'];

	if ( $page > count($pages) ) // if the requested page doesn't exist
		$page = count($pages); // give them the highest numbered page that DOES exist

	$content = $pages[$page-1];
	if ( preg_match('/<!--more(.*?)?-->/', $content, $matches) ) {
		$content = explode($matches[0], $content, 2);
		if ( !empty($matches[1]) && !empty($more_link_text) )
			$more_link_text = strip_tags(wp_kses_no_null(trim($matches[1])));
	} else {
		$content = array($content);
	}
	if ( (false !== strpos($post->post_content, '<!--noteaser-->') && ((!$multipage) || ($page==1))) )
		$stripteaser = 1;
	$teaser = $content[0];
	if ( ($more) && ($stripteaser) )
		$teaser = '';
	$output .= $teaser;
	if ( count($content) > 1 ) {
		if ( $more ) {
			$output .= '<span id="more-'.$id.'"></span>'.$content[1];
		} else {
			$output = balanceTags($output);
			if ( ! empty($more_link_text) )
				$output .= ' <a href="'. get_permalink() . "#more-$id\">$more_link_text</a>";
		}
	}

	return $output;
}

/* ==================================================
 * @param	string  $path
 * @return	string  $path
 */
function _comments_template($path) {
	return str_replace(TEMPLATEPATH . '/', Ktai_Style::$template_dir, $path);
}

/* ==================================================
 * @param	none
 * @return	boolean $is_front
 */
function ks_is_front() {
	global $paged;
	return (is_home() && intval($paged) < 2);
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comments_list
 */
function ks_is_comments_list() {
	if (isset($_GET['view']) && $_GET['view'] == 'co_list') {
		return TRUE;
	} elseif (isset($_POST['view']) && $_POST['view'] == 'co_list') {
		return TRUE;
	}
	return FALSE;	
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comment_post
 */
function ks_is_comment_post() {
	if (isset($_GET['view']) && $_GET['view'] == 'co_post') {
		return TRUE;
	} elseif (isset($_POST['view']) && $_POST['view'] == 'co_post') {
		return TRUE;
	}
	return FALSE;	
}

/* ==================================================
 * @param	none
 * @return	boolean $is_comments
 */
function ks_is_comments() {
	return (ks_is_comments_list() || ks_is_comment_post());
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_blogurl() {
	echo _strip_host(get_bloginfo('url') . '/');
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_siteurl() {
	echo _strip_host(get_bloginfo('wpurl') . '/');
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_plugin_dir() {
	echo ks_siteurl() . Ktai_Style::$plugin_dir;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_title() {
	$title = wp_title('', FALSE); 
	if (empty($title)) {
		$title = get_bloginfo('name');
	}
	echo $title;
	return $title;
}

/* ==================================================
 * @param	int    $more_link_text
 * @param   int    $stripteaser
 * @param   int    $more_file
 * @return	none
 * based on the_content() at wp-includes/post-template.php of WP 2.2.3
 */
function ks_content($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
	$content = _get_content($more_link_text, $stripteaser, $more_file);
	$content = apply_filters('the_content', $content);
	$content = str_replace(']]>', ']]&gt;', $content);
	echo $content;
}

/* ==================================================
 * @param	none
 * @return	none
 * based on get_the_content and get_the_password_form() at wp-includes/post-template.php of WP 2.2.3
 */
function ks_check_password($message = '') {
	if (empty($message)) {
		$message = __("This post is password protected. To view it please enter your password below:");
	}
	if (_confirmed_post_password()) {
		return NULL;
	} else {
		$form = '<form method="post" action=""><p>' . $message . '</p><p><input name="post_password" type="password" size="20" />';
		if (ks_is_comments_list()) {
			$form .= '<input type="hidden" name="view" value="co_list" />';
		} elseif (ks_is_comment_post()) {
			$form .= '<input type="hidden" name="view" value="co_post" />';
		}
		$form .= '<input type="submit" name="Submit" value="' . __("Submit") . '" /></p></form>';
		return $form;
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_time($year = NULL, $mon_date = NULL, $time = NULL) {
	$year     = ! is_null($year)     ? $year     : ks_option('ks_year_format');
	$mon_date = ! is_null($mon_date) ? $mon_date : ks_option('ks_month_date_format');
	$time     = ! is_null($time)     ? $time     : ks_option('ks_time_format');
	$post_time = get_post_time();
	if (date('Y', $post_time) != date('Y')) {
		the_time($year . ' ' . $time);
	} elseif (date('m-d', $post_time) != date('m-d')) {
		the_time($mon_date . ' ' . $time);
	} else {
		the_time($time);
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
function ks_comment_datetime($year = NULL, $mon_date = NULL, $time = NULL) {
	$year     = ! is_null($year)     ? $year     : ks_option('ks_year_format');
	$mon_date = ! is_null($mon_date) ? $mon_date : ks_option('ks_month_date_format');
	$time     = ! is_null($time)     ? $time     : ks_option('ks_time_format');
	$post_time = get_comment_time('U');
	if (date('Y', $post_time) != date('Y')) {
		comment_time($year . ' ' . $time);
	} elseif (date('m-d', $post_time) != date('m-d')) {
		comment_time($mon_date . ' ' . $time);
	} else {
		comment_time($time);
	}
	return;
}


/* ==================================================
 * @param	int    $count
 * @param   int    $max
 * @param   string $link
 * @return	none
 */
function ks_orderd_link($count, $max = 9, $link) {
	if ($max <= 0 || $max > 9) {
		$max = 9;
	}
	$accesskey = '';
	if (is_numeric($count)) {
		if ($count > 0 && $count <= $max) {
			$accesskey = ' accesskey="' . intval($count) . '"';
			$num = intval(179 + $count);
			$output = '<img localsrc="' . $num . '" alt="' . $count . '." />';
		} else { 
			$output = __('[]', 'ktai_style');
		}
	} else {
		$output = '';
	}
	echo '<a href="' . $link . '"' . $accesskey . '>' . $output;
}

/* ==================================================
 * @param	int    $arg
 * @return	string $html
 * based on wp_link_pages() at wp-includes/post-template.php at WP 2.2.3
 */
function _page_link($i, $accesskey, $desc, $post_status, $post_password) {
	if ($i == 1) {
		$html = _internal_link(get_permalink(), $accesskey, '', $desc, $post_password);
	} elseif ('' == get_option('permalink_structure') || 'draft' == $post_status) {
		$html = _internal_link(get_permalink() . '&amp;page=' . $i, $accesskey, '', $desc, $post_password);
	} else {
		$html = _internal_link(trailingslashit(get_permalink()) . user_trailingslashit($i, 'single_paged'), $accesskey, '', $desc, $post_password);
	}
	return $html;
}

/* ==================================================
 * @param	int    $arg
 * @return	string $output
 * based on wp_link_pages() at wp-includes/post-template.php at WP 2.2.3
 */
function ks_link_pages($args = '') {
	global $post;

	if (is_array($args)) {
		$r = &$args;
	} else {
		parse_str($args, $r);
	}
	$defaults = array('before' => '<p>' . __('Pages:'), 'after' => '</p>', 'next_or_number' => 'number', 'nextpagelink' => __('Next page'),
			'previouspagelink' => __('Previous page'), 'pagelink' => '%', 'more_file' => '', 'echo' => 1);
	$r = array_merge($defaults, $r);
	extract($r, EXTR_SKIP);

	global $id, $page, $numpages, $multipage, $more, $pagenow;
	if (! $multipage || ! _confirmed_post_password()) {
		return;
	}
	if ($more_file != '') {
		$file = $more_file;
	} else {
		$file = $pagenow;
	}

	$output = '';
	if ( 'number' == $next_or_number ) {
		for ( $i = 1; $i < ($numpages+1); $i = $i + 1 ) {
			$j = str_replace('%',"$i",$pagelink);
			$output .= ' ';
			if ( ($i != $page) || ((!$more) && ($page==1)) ) {
				$output .= _page_link($i, $j, $j, $post->post_status, $post->post_password);
			}
		}
	} elseif ($more) {
		$i = $page - 1;
		if ($i > 0) {
			$output .= _page_link($i, '*', $previouspagelink, $post->post_status, $post->post_password);
		}
		$i = $page + 1;
		if ($i <= $numpages) {
			$output .= _page_link($i, '#', $nextpagelink, $post->post_status, $post->post_password);
		}
	}

	if ($output) {
		$output = $before . $output . $after;
	}

	if ($echo) {
		echo $output;
	}
	return $output;
}
/* ==================================================
 * @param	string $before
 * @param	string $after
 * @return	none
 */
function ks_pagenum($before = ' (', $after = ')') {
	global $paged, $wp_query;
	if (! $paged) {
		$paged = 1;
	}
	$max_page = $wp_query->max_num_pages;
	if ($wp_query->max_num_pages > 1) {
		echo "$before$paged/$max_page$after";
	}
}

/* ==================================================
 * @param	string  $format
 * @param	string  $link
 * @param	boolean $in_same_cat
 * @param	string  $excluded_categories
 * @return	none
 * based on previous_post_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_previous_post_link($format='<img localsrc="7" alt="&laquo;">*.%link', $link='%title', $in_same_cat = false, $excluded_categories = '') {

	if ( is_attachment() )
		$post = & get_post($GLOBALS['post']->post_parent);
	else
		$post = get_previous_post($in_same_cat, $excluded_categories);

	if ( !$post )
		return;

	$title = apply_filters('the_title', $post->post_title, $post);
	$string = '<a href="'.get_permalink($post->ID).'" accesskey="*">';
	$link = str_replace('%title', $title, $link);
	$link = $pre . $string . $link . '</a>';

	$format = str_replace('%link', $link, $format);

	echo $format;
}

/* ==================================================
 * @param	string  $format
 * @param	string  $link
 * @param	boolean $in_same_cat
 * @param	string  $excluded_categories
 * @return	none
 * based on next_post_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_next_post_link($format='#.%link<img localsrc="8" alt="&raquo;">', $link='%title', $in_same_cat = false, $excluded_categories = '') {
	$post = get_next_post($in_same_cat, $excluded_categories);

	if ( !$post )
		return;

	$title = apply_filters('the_title', $post->post_title, $post);
	$string = '<a href="'.get_permalink($post->ID).'" accesskey="#">';
	$link = str_replace('%title', $title, $link);
	$link = $string . $link . '</a>';
	$format = str_replace('%link', $link, $format);

	echo $format;
}

/* ==================================================
 * @param	string  $label
 * @return	none
 * based on previous_posts_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_previous_posts_link($label = NULL) {
	$label = ! is_null($label) ? $label : ('<img localsrc="7" alt="&laquo;">' . __('*.Prev', 'ktai_style'));
	global $paged;
	if ( (!is_single())	&& ($paged > 1) ) {
		echo '<a href="' . _strip_host(clean_url(get_previous_posts_page_link()));
		echo '" accesskey="*">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $label) .'</a>';
	}
}

/* ==================================================
 * @param	string  $label
 * @param   int     $max_page
 * @return	none
 * based on next_posts_link() at wp-includes/link-template.php of WP 2.2.3
 */
function ks_next_posts_link($label = NULL, $max_page = 0) {
	$label = ! is_null($label) ? $label : (__('#.Next', 'ktai_style') . '<img localsrc="8" alt="&raquo;">');
	global $paged, $wpdb, $wp_query;
	if ( !$max_page ) {
		$max_page = $wp_query->max_num_pages;
	}
	if ( !$paged )
		$paged = 1;
	$nextpage = intval($paged) + 1;
	if ( (! is_single()) && (empty($paged) || $nextpage <= $max_page) ) {
		echo '<a href="' . _strip_host(clean_url(get_next_posts_page_link($max_page))) . '" accesskey="#">'. preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $label) .'</a>';
	}
}

/* ==================================================
 * @param	string  $sep
 * @return	none
 * based on posts_nav_link() at wp-includes/link-template of WP 2.2.3
 */
function ks_posts_nav_link($sep = ' | ') {
	global $wp_query;
	if ( ! is_singular() ) {
		$max_num_pages = $wp_query->max_num_pages;
		$paged = get_query_var('paged');

		//only have sep if there's both prev and next results
		if ($paged < 2 || $paged >= $max_num_pages) {
			$sep = '';
		}

		if ( $max_num_pages > 1 ) {
			ks_previous_posts_link();
			echo preg_replace('/&([^#])(?![a-z]{1,8};)/', '&#038;$1', $sep);
			ks_next_posts_link();
		}
	}
}

/* ==================================================
 * @param	integer $post_id
 * @return	string  $address
 */
function ks_comments_list_link($id = 0) {
	$address = _strip_host(get_permalink($id));
	if (strpos($address, '?') === FALSE) {
		$address .= '?view=co_list';
	} else {
		$address .= '&view=co_list';
	}
	return $address;
}

/* ==================================================
 * @param	string $zero
 * @param	string $one
 * @param	string $more
 * @param	string $none
 * @return	string $output
 * based on comments_popup_link() at wp-includes/comment-template.php of WP 2.2.3
 */
function ks_comments_link($icon = '<img localsrc="86" alt="" />', $zero = NULL, $one = NULL, $more = NULL) {
	global $id, $post, $wpdb;
	if (is_page() ) {
		return;
	}
	$zero = ! is_null($zero) ? $zero : __('No comments', 'ktai_style');
	$one  = ! is_null($one)  ? $zero : __('One comment', 'ktai_style');
	$more = ! is_null($more) ? $zero : __('% comments', 'ktai_style');
	$number = get_comments_number($id);
	if ( 0 == $number && 'closed' == $post->comment_status && 'closed' == $post->ping_status ) {
		echo '<img localsrc="61" alt="' . __('X ', 'ktai_style') . '" />' . $none;
		return;
	}

	$co_addr = ks_comments_list_link();
	if (_confirmed_post_password()) {
		if ($number == 0) {
			echo $icon . $zero;
		} else {
			ob_start();
			comments_number($zero, $one, $more);
			$co_num = ob_get_contents();
			ob_end_clean();
			echo _internal_link($co_addr, '', $icon, $co_num, $post->post_password);
		}
	} else {
		echo $icon . '<a href="' . $co_addr . '">' . __('View comments (Need password)', 'ktai_style') . '</a>';
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	string $output
 * based on comments_popup_link() at wp-includes/comment-template.php of WP 2.2.3
 */
function ks_comments_post_link($desc = NULL, $before = '<img localsrc="149" alt="" />', $after = '') {
	if (comments_open()) {
		$desc = ! is_null($desc) ? $desc : __('Post comments', 'ktai_style');
		global $post;
		$co_post = _strip_host(get_permalink());
		if (strpos($co_post, '?') === FALSE) {
			$co_post .= '?view=co_post';
		} else {
			$co_post .= '&view=co_post';
		}
		$post_pass = _confirmed_post_password() ? $post->post_password : NULL;
		echo $before . _internal_link($co_post, '', '', $desc, $post_pass) . $after;
	}
}

/* ==================================================
 * @param	none
 * @return	string $output
 */
function ks_back_to_post($icon = NULL, $desc = NULL) {
	$icon = ! is_null($icon) ? $icon : ('<img localsrc="64" alt="' . __('&lt;-', 'ktai_style') . '" />');
	$desc = ! is_null($desc) ? $desc : __('Back to the post', 'ktai_style');
	global $post;
	echo _internal_link(get_permalink(), '*', $icon, $desc, $post->post_password);
	return;
}

/* ==================================================
 * @param	integer $num
 * @return	array   $sorted
 */
function ks_recent_comments($num = 20, $type = '') {
	global $wpdb, $comment;
	if (! is_numeric($num) || $num <= 0) {
		$num = 20;
	} else {
		$num = intval($num);
	}
	if ($type == 'comment') {
		$refine = "AND comment_type = ''";
	} elseif ($type == 'trackback+pingback') {
		$refine = "AND (comment_type = 'trackback' OR comment_type = 'pingback')";
	} elseif ($type == 'trackback') {
		$refine = "AND comment_type = 'trackback'";
	} elseif ($type == 'trackback+pingback') {
		$refine = "AND comment_type = 'pingback'";
	} else {
		$refine = '';
	}
	$comments = $wpdb->get_results( "SELECT * FROM $wpdb->comments WHERE comment_approved = '1' $refine ORDER BY comment_date DESC LIMIT $num" );
	if (count($comments) <= 0) {
		return NULL;
	}
	$sorted = array();
	foreach ($comments as $c) {
		$post_id = $c->comment_post_ID;
		if (! isset($sorted[$post_id])) {
			$sorted[$post_id][] = get_post($post_id);
		}
		$sorted[$post_id][] = $c;
	}
	return $sorted;
}

/* ==================================================
 * @param	string  $separator
 * @return	none
 */
function ks_category($separator = ', ') {
	$categories = get_the_category();
	if (count($categories)) {
		$cat_links = array();
		foreach ($categories as $c) {
			$cat_links[] = '<a href="' . get_category_link($c->cat_ID) . '">' . wp_specialchars($c->cat_name) . '</a>';
		}
		echo implode($separator, $cat_links);
	}
	return;
}

/* ==================================================
 * @param	string  $args
 * @return	none
 */
function ks_get_archives($args = '') {
	ob_start();
	wp_get_archives($args);
	$output = ob_get_contents();
	ob_end_clean();
	$output = preg_replace('/ ?(\d+) ?/', '\\1' , $output);
	$output = str_replace('&nbsp;', ' ' , $output);
	echo _strip_properties($output);
	return;
}

/* ==================================================
 * @param	string  $args
 * @return	none
 */
function ks_list_bookmarks($args = '') {
	if (is_array($args)) {
		$r = &$args;
	} else {
		parse_str($args, $r);
	}
	$r['echo'] = FALSE;
	echo _strip_properties(wp_list_bookmarks($r));
	return;
}

/* ==================================================
 * @param	string  $sep
 * @return	none
 */
function ks_pages_menu($sep = ' | ', $before = '', $after = '') {
	$r = array('depth' => 0, 'child_of' => 0, 'exclude' => '', 'authors' => '', 'sort_column' => 'menu_order, ID');
	$pages = get_pages($r);
	$menu = array();
	if (count($pages)) {
		foreach ($pages as $p) {
			$menu[] = '<a href="' . _strip_host(get_page_link($p->ID)) . '">' . wp_specialchars($p->post_title) . '</a>';
		}
		echo $before . implode($sep, $menu) . $after;
	}
	return;
}

?>
