<?php
/* これは文字化け防止のための日本語文字列です。
   Above is a Japanese strings to avoid charset mis-understanding.*/
/*
Plugin Name: Ktai Style
Plugin URI: http://wppluginsj.sourceforge.jp/ktai_style/
Description: Provides lightweight pages for mobile phones.
Author: IKEDA Yuriko
Version: 0.83
Author URI: http://www.yuriko.net/cat/wordpress
*/

/*  Copyright (c) 2007 yuriko

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//define ('KS_DEBUG', TRUE);

$Ktai_Style = new Ktai_Style;
$KS_Admin = new Ktai_Style_Admin;
add_action('admin_menu',  array($KS_Admin, 'add_page'));

/* ==================================================
 * @param	none
 * @return	boolean $is_mobile
 */
if (! function_exists('is_mobile')) :
function is_mobile() {
	global $Ktai_Style;
	return $Ktai_Style->is_mobile();
}
endif;

/* ==================================================
 *   Ktai_Style class
   ================================================== */

class Ktai_Style {
	static public $plugin_dir;
	static public $template_dir;
	private $ktai;

/* ==================================================
 * @param	none
 * @return	object
 */
public function __construct() {
	require dirname(__FILE__) . '/services.php';
	$this->set_plugin_dir();
	$this->ktai = Ktai_Services::factory(TRUE);
	if (! $this->ktai) {
		return;
	}
	
	add_action('template_redirect', array($this, 'output'), 9);
	if (isset($_GET['ks'])) {
		$_GET['s'] = mb_convert_encoding($_GET['ks'], get_bloginfo('charset'), 'auto');
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	boolean $is_mobile
 */
public function is_mobile() {
	return $this->ktai ? TRUE : FALSE;
}

/* ==================================================
 * @param	none
 * @return	none
 */
private function set_plugin_dir() {
	self::$plugin_dir = preg_replace('#^.*' . PLUGINDIR . '#' , PLUGINDIR, dirname(__FILE__));
	if (DIRECTORY_SEPARATOR == '\\') {
		self::$plugin_dir = str_replace('\\', '/', self::$plugin_dir);
	}
	if (! preg_match('#^' . PLUGINDIR . '#', self::$plugin_dir)) {
		self::$plugin_dir = PLUGINDIR . '/ktai_style';
	}
}

/* ==================================================
 * @param	none
 * @return	object
 */
public function output() {
	if (is_robots() || is_feed() || is_trackback()) {
		return;
	}
	if (! $template = $this->load_template()) {
		$this->ks_die('携帯電話向けテンプレートが壊れているため表示できません。');
	}
	require dirname(__FILE__) . '/tags.php';
	ob_start();
	include $template;
	$buffer = ob_get_contents();
	ob_end_clean();
	header ("Content-Type: text/html; charset=Shift_JIS");
	$buffer = mb_convert_encoding($buffer, 'SJIS-win', get_bloginfo('charset'));
	$buffer = $this->ktai->shrink($buffer);
	$buffer = $this->ktai->replace_smiley($buffer);
	$buffer = $this->ktai->convert_char($buffer);
	echo $buffer;
	exit;
}

/* ==================================================
 * @param	none
 * @return	string
 * based on wp-includes/template-loader.php of WP 2.2.3
 */
private function load_template() {
	self::$template_dir = dirname(__FILE__) . '/templates/';
	if ( is_404() && $template = $this->query_template('404')) {
		return $template;
	} elseif (isset($_GET['arc'])) {
		if ($_GET['arc'] == 'months' && $template = $this->query_template('arc_months')) {
			return $template;
		} elseif ($_GET['arc'] == 'cats' && $template = $this->query_template('arc_cats')) {
			return $template;
		} elseif ($_GET['arc'] == 'pages' && $template = $this->query_template('arc_pages')) {
			return $template;
		} elseif ($_GET['arc'] == 'comments' && $template = $this->query_template('arc_comments')) {
			return $template;
		}
	} elseif (is_search() && $template = $this->query_template('search')) {
		return $template;
	} elseif (is_home() && $template = $this->get_home_template()) {
		return $template;
	} elseif (is_attachment() && $template = $this->get_attachment_template()) {
		return $template;
	} elseif (is_single() && $template = $this->query_template('single')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_page() && $template = $this->query_template('page')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return $template;
	} elseif (is_category() && $template = $this->get_category_template()) {
		return $template;
	} elseif (is_author() && $template = $this->query_template('author')) {
		return $template;
	} elseif (is_date() && $template = $this->query_template('date')) {
		return $template;
	} elseif (is_archive() && $template = $this->query_template('archive')) {
		return $template;
	} elseif (is_paged() && $template = $this->query_template('paged')) {
		return $template;
	} elseif (file_exists(self::$template_dir . 'index.php')) {
		if (is_attachment()) {
			add_filter('the_content', 'prepend_attachment');
		}
		return self::$template_dir . 'index.php';
	}
	return NULL;
}

/* ==================================================
 * @param	string
 * @return	string
 * based on get_query_template() at wp-includes/theme.php of WP 2.2.3
 */
private function query_template($type) {
	$template = '';
	if (file_exists(self::$template_dir . "{$type}.php")) {
		$template = self::$template_dir . "{$type}.php";
	}
	return apply_filters("{$type}_template", $template);
}

/* ==================================================
 * @param	none
 * @return	string
 * based on get_category_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_category_template() {
	$template = '';
	if (file_exists(self::$template_dir . 'category-' . get_query_var('cat') . '.php')) {
		$template = self::$template_dir . 'category-' . get_query_var('cat') . '.php';
	} elseif (file_exists(self::$template_dir . 'category.php')) {
		$template = self::$template_dir . 'category.php';
	}
	return apply_filters('category_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 * based on get_home_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_home_template() {
	$template = '';
	if (file_exists(self::$template_dir . 'home.php')) {
		$template = self::$template_dir . 'home.php';
	} elseif (file_exists(self::$template_dir . 'index.php')) {
		$template = self::$template_dir . 'index.php';
	}
	return apply_filters('home_template', $template);
}

/* ==================================================
 * @param	none
 * @return	string
 * based on get_attachment_template() at wp-includes/theme.php of WP 2.2.3
 */
private function get_attachment_template() {
	global $posts;
	$type = explode('/', $posts[0]->post_mime_type);
	if ( $template =  $this->query_template($type[0]) )
		return $template;
	elseif ( $template =  $this->query_template($type[1]) )
		return $template;
	elseif ( $template =  $this->query_template("$type[0]_$type[1]") )
		return $template;
	else
		return $this->query_template('attachment');
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_header() {
	do_action('get_header');
	if (file_exists(self::$template_dir . 'header.php')) {
		load_template(self::$template_dir . 'header.php');
	}
	return;
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function get_footer() {
	do_action('get_footer');
	if (file_exists(self::$template_dir . 'footer.php')) {
		load_template(self::$template_dir . 'footer.php');
	}
	return;
}

/* ==================================================
 * @param	string $message
 * @param   string $title
 * @return	none
 * based on wp_die() at wp-includes/functions() of WP 2.2.3
 */
public function ks_die($message, $title = '') {
	if ( function_exists( 'is_wp_error' ) && is_wp_error( $message ) ) {
		if ( empty($title) ) {
			$error_data = $message->get_error_data();
			if ( is_array($error_data) && isset($error_data['title']) )
				$title = $error_data['title'];
		}
		$errors = $message->get_error_messages();
		switch ( count($errors) ) :
		case 0 :
			$message = '';
			break;
		case 1 :
			$message = "<p>{$errors[0]}</p>";
			break;
		default :
			$message = "<ul>\n\t\t<li>" . join( "</li>\n\t\t<li>", $errors ) . "</li>\n\t</ul>";
			break;
		endswitch;
	} elseif ( is_string($message) ) {
		$message = "<p>$message</p>";
	}

	if ( !did_action('admin_head') ) :
	header ("Content-Type: text/html; charset=Shift_JIS");

	if ( empty($title) )
		$title = mb_convert_encoding(__('WordPress &rsaquo; Error'), 'SJIS-win', get_bloginfo('charset'));

	echo '<?xml version="1.0" encoding="Shift_JIS" ?>' . "\n"; ?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML Basic 1.0//EN" "http://www.w3.org/TR/xhtml-basic/xhtml-basic10.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=Shift_JIS" />
<title><?php echo $title ?></title>
</head>
<body>
<?php endif; ?>
<div><h1 id="logo"><img alt="WordPress" src="<?php echo get_bloginfo('wpurl'); ?>/wp-admin/images/wordpress-logo.png" /></h1></div>
<?php echo mb_convert_encoding($message, 'SJIS-win', get_bloginfo('charset')); ?>
</body>
</html>
<?php
	die();
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Style_Admin class
   ================================================== */

class Ktai_Style_Admin {
	private $nonce = -1;

/* ==================================================
 * @param	string  $name
 * @return	mix     $value
 */
public function get_option($name) {
	$value = get_option($name);
	if ($value) {
		return $value;
	}
	switch ($name) {
	case 'ks_date_color':
		return '#00aa33';
	case 'ks_author_color':
		return '#888888';
	case 'ks_comment_type_color':
		return '#888888';
	case 'ks_year_format':
		return 'Y-m-d';
	case 'ks_month_date_format':
		return 'n/j';
	case 'ks_time_format':
		return 'H:i';
	default:
		return NULL;
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function add_page() {
	add_options_page('Ktai Style Configuration', '携帯表示', 'manage_options', basename(__FILE__), array($this, 'option_page'));
	if ( !function_exists('wp_nonce_field') ) {
		$this->nonce = -1;
	} else {
		$this->nonce = 'ktai-style-config';
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
public function option_page() {
	if (isset($_POST['update_option'])) {
		check_admin_referer($this->nonce);
		$this->upate_options();
	}
	if ($this->get_option('ks_title_only')) {
		$title_only[0] = '';
		$title_only[1] = ' checked="checked"';
	} else {
		$title_only[0] = ' checked="checked"';
		$title_only[1] = '';
	}
	if ($this->get_option('ks_separate_recent_comments')) {
		$sep_recent_comments[0] = '';
		$sep_recent_comments[1] = ' checked="checked"';
	} else {
		$sep_recent_comments[0] = ' checked="checked"';
		$sep_recent_comments[1] = '';
	}
	$date_color         = $this->get_option('ks_date_color');
	$author_color       = $this->get_option('ks_author_color');
	$comment_type_color = $this->get_option('ks_comment_type_color');
	$year_format        = $this->get_option('ks_year_format');
	$month_date_format  = $this->get_option('ks_month_date_format');
	$time_format        = $this->get_option('ks_time_format');
?>
<div class="wrap">
<h2>Ktai Style オプション</h2>
<form method="post">
<?php $this->make_nonce_field($this->nonce); ?>
<fieldset name="design" class="options">
<legend>デザイン</legend>
<dl>
<dt><label for="title_only">フロントページ・検索結果</label></dt>
  <dd>
    <label><input type="radio" name="title_only" id="title_only" value="1"<?php echo $title_only[0]; ?> /> 1番目の記事は本文を表示する</label>
    <label><input type="radio" name="title_only" id="title_only" value="2"<?php echo $title_only[1]; ?> /> すべてタイトル表示のみ</label>
  </dd>
<dt><label for="sep_recent_comments">最新のコメント一覧</label></dt> 
  <dd>
    <label><input type="radio" name="sep_recent_comments" id="sep_recent_comments" value="1"<?php echo $sep_recent_comments[0]; ?> /> コメントとトラックバック・ピンバックを混在させる</label>
    <label><input type="radio" name="sep_recent_comments" id="sep_recent_comments" value="2"<?php echo $sep_recent_comments[1]; ?> /> 分離する</label>
  </dd>
</dl>
</fieldset>
<fieldset name="colors" class="options">
<legend>文字色</legend>
<dl>
<dt><label for="date_color">記事タイトル一覧の横に表示する日付</label></dt>
<dd><input type="text" value="<?php echo $date_color ?>" name="date_color" id="date_color" /> (#rrggbb の16進表記)</dd>
<dt><label for="author_color">記事本文に表示する投稿者・日付</label></dt>
<dd><input type="text" value="<?php echo $author_color ?>" name="author_color" id="author_color" /> (#rrggbb の16進表記)</dd>
<dt><label for="author_color">コメント種別 (コメント／トラックバック／ピンバック)</label></dt>
<dd><input type="text" value="<?php echo $comment_type_color ?>" name="comment_type_color" id="comment_type_color" /> (#rrggbb の16進表記)</dd>
</dl>
<p>※背景色・通常の文字色・リンク色・訪問済みリンク色は、templates/header.php の &lt;body&gt; 要素の属性で設定してください。<br />
<a href="templates.php?file=<?php echo str_replace('%2F', '/', Ktai_Style::$plugin_dir . '/templates/header.php'); ?>">&raquo; 編集する</a></p>
</fieldset>
<fieldset name="date_format" class="options">
<legend>投稿・コメントの日付書式</legend>
<dl>
<dt><label for="year_format">年月日を表示する場合 (去年以前の日付)</label></dt>
<dd><input type="text" value="<?php echo $year_format ?>" name="year_format" id="year_format" /></dd>
<dt><label for="month_date_format">月日のみ表示の場合 (今年の日付)</label></dt>
<dd><input type="text" value="<?php echo $month_date_format ?>" name="month_date_format" id="month_date_format" /></dd>
<dt><label for="time_format">時刻</label></dt>
<dd><input type="text" value="<?php echo $time_format ?>" name="time_format" id="time_format" /></dd>
</dl>
<p>※フォーマットの書式は <a href="http://codex.wordpress.org/Formatting_Date_and_Time">Codex の説明</a> (英文) もしくは、PHP の <a href="http://jp2.php.net/date">date() 関数マニュアル</a>をご覧ください。</p>
</fieldset>
<div class="submit">
<input type="hidden" name="action" value="update" />
<input type="submit" name="update_option" value="<?php _e('Update Options &raquo;'); ?> &raquo;" />
</div>
</form>
</div>
<?php
} 

/* ==================================================
 * @param	mix   $action
 * @return	none
 */
private function make_nonce_field($action = -1) {
	if ( !function_exists('wp_nonce_field') ) {
		return;
	} else {
		return wp_nonce_field($action);
	}
}

/* ==================================================
 * @param	none
 * @return	none
 */
private function upate_options() {
	if (isset($_POST['title_only']) && is_numeric($_POST['title_only'])) {
		update_option('ks_title_only', ($_POST['title_only'] == 2));
	}
	if (isset($_POST['sep_recent_comments']) && is_numeric($_POST['sep_recent_comments'])) {
		update_option('ks_separate_recent_comments', ($_POST['sep_recent_comments'] == 2));
	}
	if (isset($_POST['author_color']) && preg_match('/^#[0-9a-fA-F]{6}$/', $_POST['author_color'])) {
		update_option('ks_author_color', $_POST['author_color']);
	}
	if (isset($_POST['date_color']) && preg_match('/^#[0-9a-fA-F]{6}/', $_POST['date_color'])) {
		update_option('ks_date_color', $_POST['date_color']);
	}
	if (isset($_POST['comment_type_color']) && preg_match('/^#[0-9a-fA-F]{6}/', $_POST['comment_type_color'])) {
		update_option('ks_comment_type_color', $_POST['comment_type_color']);
	}
	if (isset($_POST['year_format']) && preg_match('/[Yyo]/', $_POST['year_format']) && preg_match('/[mnMF]/', $_POST['year_format']) && preg_match('/[dDj]/', $_POST['year_format'])) {
		update_option('ks_year_format', $_POST['year_format']);
	}
	if (isset($_POST['month_date_format']) && preg_match('/[mnMF]/', $_POST['month_date_format']) && preg_match('/[dDj]/', $_POST['month_date_format'])) {
		update_option('ks_month_date_format', $_POST['month_date_format']);
	}
	if (isset($_POST['time_format']) && preg_match('/[BgGhH]/', $_POST['time_format'])) {
		update_option('ks_time_format', $_POST['time_format']);
	}
?>
<div class="updated fade"><p><strong><?php _e('Options saved.'); ?></strong></p></div>
<?php
	return;
}

// ===== End of class ====================
}

?>
